/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.dam;

import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import org.tigr.microarray.mev.cluster.gui.impl.GUIFactory;

public class DAMSearchDialog
extends JDialog {
    JTable table;
    String searchStr;
    int numSearchCols;
    int numRows;
    int numCols;
    int numClasses;
    Vector foundRowIndices;
    ButtonGroup searchButtonGroup;
    private ButtonGroup buttonGroup1;
    private JComboBox jComboBox1;
    private JLabel jLabel2;
    private JCheckBox matchCaseChkBox;
    private JRadioButton selectAllButton;
    private JRadioButton selectIncrButton;
    private JPanel buttonPanel;
    private JButton findButton;
    private JButton findNextButton;
    private JButton closeButton;
    private JPanel geneBarPanel;
    private JLabel geneBarContainerLabel;

    public DAMSearchDialog(Frame parent, JTable table, int numClasses, boolean modal) {
        super(parent, modal);
        this.table = table;
        this.numClasses = numClasses;
        this.numRows = table.getRowCount();
        this.numCols = table.getColumnCount();
        this.numSearchCols = this.numCols - (numClasses + 2);
        this.foundRowIndices = new Vector();
        this.initComponents();
        this.geneBarContainerLabel.setIcon(GUIFactory.getIcon("dialog_banner2.gif"));
        this.searchButtonGroup = new ButtonGroup();
        this.searchButtonGroup.add(this.selectAllButton);
        this.searchButtonGroup.add(this.selectIncrButton);
        this.setSize(250, 200);
        this.pack();
        this.jComboBox1.setMaximumRowCount(10);
        this.searchStr = null;
        this.jComboBox1.setEditable(true);
        this.jComboBox1.insertItemAt(new String(""), 0);
        this.findButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                DAMSearchDialog.this.findNextButton.setEnabled(false);
                DAMSearchDialog.this.runSearch();
                if (DAMSearchDialog.this.foundRowIndices.size() > 0 && DAMSearchDialog.this.selectIncrButton.isSelected()) {
                    DAMSearchDialog.this.findNextButton.setEnabled(true);
                } else {
                    DAMSearchDialog.this.findNextButton.setEnabled(false);
                }
            }
        });
        this.findNextButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                DAMSearchDialog.this.findNext();
            }
        });
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                DAMSearchDialog.this.foundRowIndices.removeAllElements();
                DAMSearchDialog.this.findNextButton.setEnabled(false);
                DAMSearchDialog.this.selectAllButton.setSelected(true);
                DAMSearchDialog.this.matchCaseChkBox.setSelected(true);
                DAMSearchDialog.this.setVisible(false);
            }
        });
        this.jComboBox1.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent fe) {
                DAMSearchDialog.this.findNextButton.setEnabled(false);
                DAMSearchDialog.this.findNextButton.repaint();
                DAMSearchDialog.this.foundRowIndices.removeAllElements();
            }

            @Override
            public void focusLost(FocusEvent fe) {
            }
        });
    }

    private boolean runSearch() {
        ListSelectionModel lsm = this.table.getSelectionModel();
        this.foundRowIndices = new Vector();
        boolean selectAll = this.selectAllButton.isSelected();
        boolean found = false;
        this.searchStr = (String)this.jComboBox1.getSelectedItem();
        if (this.searchStr == null || this.numSearchCols == 0 || this.searchStr.equals("")) {
            return found;
        }
        this.table.clearSelection();
        this.jComboBox1.insertItemAt(this.searchStr, 0);
        if (this.matchCaseChkBox.isSelected()) {
            block0: for (int row = 0; row < this.numRows; ++row) {
                for (int col = this.numClasses + 2; col < this.numCols; ++col) {
                    if (((String)this.table.getValueAt(row, col)).indexOf(this.searchStr) == -1) continue;
                    if (selectAll || !found) {
                        this.table.addRowSelectionInterval(row, row);
                        if (found) continue block0;
                        this.table.scrollRectToVisible(this.table.getCellRect(row, 0, true));
                        found = true;
                        continue block0;
                    }
                    this.foundRowIndices.add(new Integer(row));
                    continue block0;
                }
            }
        } else {
            String upperCaseStr = this.searchStr.toUpperCase();
            block2: for (int row = 0; row < this.numRows; ++row) {
                for (int col = this.numClasses + 2; col < this.numCols; ++col) {
                    if (((String)this.table.getValueAt(row, col)).toUpperCase().indexOf(upperCaseStr) == -1) continue;
                    if (selectAll || !found) {
                        this.table.addRowSelectionInterval(row, row);
                        if (found) continue block2;
                        this.table.scrollRectToVisible(this.table.getCellRect(row, 0, true));
                        found = true;
                        continue block2;
                    }
                    this.foundRowIndices.add(new Integer(row));
                    continue block2;
                }
            }
        }
        return found;
    }

    public void findNext() {
        if (this.foundRowIndices.isEmpty()) {
            return;
        }
        int row = (Integer)this.foundRowIndices.remove(0);
        this.table.clearSelection();
        this.table.addRowSelectionInterval(row, row);
        this.table.scrollRectToVisible(this.table.getCellRect(row, 0, true));
        if (this.foundRowIndices.size() == 0) {
            this.findNextButton.setEnabled(false);
        }
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.jComboBox1 = new JComboBox();
        this.jLabel2 = new JLabel();
        this.matchCaseChkBox = new JCheckBox();
        this.selectAllButton = new JRadioButton();
        this.selectIncrButton = new JRadioButton();
        this.buttonPanel = new JPanel();
        this.findButton = new JButton();
        this.findNextButton = new JButton();
        this.closeButton = new JButton();
        this.geneBarPanel = new JPanel();
        this.geneBarContainerLabel = new JLabel();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle("Search");
        this.setName("Search");
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                DAMSearchDialog.this.closeDialog(evt);
            }
        });
        this.jComboBox1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DAMSearchDialog.this.jComboBox1ActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 1;
        gridBagConstraints1.gridy = 1;
        gridBagConstraints1.gridwidth = 2;
        gridBagConstraints1.fill = 2;
        gridBagConstraints1.insets = new Insets(10, 10, 10, 10);
        this.getContentPane().add((Component)this.jComboBox1, gridBagConstraints1);
        this.jLabel2.setText("Find what:");
        this.jLabel2.setForeground(Color.black);
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.gridy = 1;
        gridBagConstraints1.insets = new Insets(10, 10, 10, 10);
        gridBagConstraints1.anchor = 13;
        this.getContentPane().add((Component)this.jLabel2, gridBagConstraints1);
        this.matchCaseChkBox.setText("Match Case");
        this.matchCaseChkBox.setFocusPainted(false);
        this.matchCaseChkBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DAMSearchDialog.this.matchCaseChkBoxActionPerformed(evt);
            }
        });
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 1;
        gridBagConstraints1.gridy = 3;
        gridBagConstraints1.insets = new Insets(0, 0, 0, 10);
        this.getContentPane().add((Component)this.matchCaseChkBox, gridBagConstraints1);
        this.selectAllButton.setToolTipText("Select all finds at once.");
        this.selectAllButton.setSelected(true);
        this.selectAllButton.setText("Select All Rows Found");
        this.selectAllButton.setFocusPainted(false);
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 2;
        gridBagConstraints1.gridy = 2;
        gridBagConstraints1.anchor = 17;
        this.getContentPane().add((Component)this.selectAllButton, gridBagConstraints1);
        this.selectIncrButton.setToolTipText("Move throgh finds sequentially.");
        this.selectIncrButton.setText("Select Incrementally");
        this.selectIncrButton.setFocusPainted(false);
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 2;
        gridBagConstraints1.gridy = 3;
        gridBagConstraints1.anchor = 17;
        this.getContentPane().add((Component)this.selectIncrButton, gridBagConstraints1);
        this.findButton.setText("Find");
        this.buttonPanel.add(this.findButton);
        this.findNextButton.setText("Find Next");
        this.findNextButton.setEnabled(false);
        this.buttonPanel.add(this.findNextButton);
        this.closeButton.setText("Close");
        this.buttonPanel.add(this.closeButton);
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 1;
        gridBagConstraints1.gridy = 4;
        gridBagConstraints1.gridwidth = 2;
        gridBagConstraints1.insets = new Insets(10, 0, 0, 0);
        this.getContentPane().add((Component)this.buttonPanel, gridBagConstraints1);
        this.geneBarContainerLabel.setToolTipText("The Institute for Genomic Research");
        this.geneBarContainerLabel.setIconTextGap(0);
        this.geneBarContainerLabel.setIcon(GUIFactory.getIcon("genebar2.gif"));
        this.geneBarPanel.add(this.geneBarContainerLabel);
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.gridy = 0;
        gridBagConstraints1.gridwidth = 3;
        gridBagConstraints1.fill = 2;
        gridBagConstraints1.anchor = 11;
        gridBagConstraints1.weightx = 1.0;
        this.getContentPane().add((Component)this.geneBarPanel, gridBagConstraints1);
        this.pack();
    }

    private void jComboBox1ActionPerformed(ActionEvent evt) {
        this.foundRowIndices.removeAllElements();
        this.findNextButton.setEnabled(false);
    }

    private void matchCaseChkBoxActionPerformed(ActionEvent evt) {
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
    }

    public static void main(String[] args) {
    }
}

