/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.dam;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.ItemSelectable;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.UIManager;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.AlgorithmDialog;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.DialogListener;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.SampleSelectionPanel;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.dialogHelpUtil.HelpWindow;

public class DAMProcessInitDialog
extends AlgorithmDialog {
    int result = 2;
    boolean skipGeneScreeningStep = false;
    boolean skipCrossValidationStep = false;
    private SampleSelectionPanel sampleSelectionPanel;
    private JPanel processPanel;
    private JPanel KPanel;
    private JRadioButton defKbutton;
    private JRadioButton calcKbutton;
    private JCheckBox skipGeneScreenBox;
    private JCheckBox skipCrossValBox;
    private ButtonGroup Kselection;

    public DAMProcessInitDialog(Frame parent, boolean modal) {
        super(parent, "DAM Process Initialization", modal);
        this.okButton.setText("Next");
        Listener listener = new Listener();
        this.initComponents(listener);
        this.setActionListeners(listener);
        this.pack();
        this.setResizable(false);
    }

    private void initComponents(Listener listener) {
        JPanel mainPanel = new JPanel(new GridBagLayout());
        mainPanel.setBackground(Color.white);
        this.setBackground(Color.lightGray);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                DAMProcessInitDialog.this.closeDialog(evt);
            }
        });
        this.processPanel = new JPanel(new GridBagLayout());
        this.processPanel.setBorder(new TitledBorder(new EtchedBorder(0), "DAM Process Selection", 0, 0, new Font("Dialog", 1, 12), Color.black));
        this.processPanel.setBackground(Color.white);
        this.skipGeneScreenBox = new JCheckBox("Skip Gene Screening step (ANOVA)");
        this.skipGeneScreenBox.setFocusPainted(false);
        this.skipGeneScreenBox.setBackground(Color.white);
        this.skipGeneScreenBox.setForeground(UIManager.getColor("Label.foreground"));
        this.skipGeneScreenBox.addItemListener(listener);
        GridBagConstraints gbc1 = new GridBagConstraints();
        gbc1.gridx = 0;
        gbc1.gridy = 0;
        gbc1.weightx = 1.0;
        gbc1.fill = 2;
        gbc1.insets = new Insets(0, 60, 0, 0);
        gbc1.fill = 1;
        gbc1.weightx = 1.0;
        this.processPanel.add((Component)this.skipGeneScreenBox, gbc1);
        this.skipCrossValBox = new JCheckBox("Skip Cross Validation step (LOOCV)");
        this.skipCrossValBox.setFocusPainted(false);
        this.skipCrossValBox.setBackground(Color.white);
        this.skipCrossValBox.setForeground(UIManager.getColor("Label.foreground"));
        this.skipCrossValBox.addItemListener(listener);
        gbc1 = new GridBagConstraints();
        gbc1.gridx = 0;
        gbc1.gridy = 1;
        gbc1.weightx = 1.0;
        gbc1.fill = 1;
        gbc1.insets = new Insets(0, 60, 0, 0);
        gbc1.weightx = 1.0;
        this.processPanel.add((Component)this.skipCrossValBox, gbc1);
        this.KPanel = new JPanel(new GridBagLayout());
        this.KPanel.setBorder(new TitledBorder(new EtchedBorder(0), "Determining K value", 0, 0, new Font("Dialog", 1, 12), Color.black));
        this.KPanel.setBackground(Color.white);
        this.Kselection = new ButtonGroup();
        this.defKbutton = new JRadioButton();
        this.calcKbutton = new JRadioButton();
        this.defKbutton.setToolTipText("Use default K = 3");
        this.defKbutton.setSelected(true);
        this.defKbutton.setText("Default");
        this.defKbutton.setBackground(Color.white);
        this.defKbutton.setForeground(UIManager.getColor("Label.foreground"));
        this.Kselection.add(this.defKbutton);
        this.defKbutton.setFocusPainted(false);
        GridBagConstraints gbc2 = new GridBagConstraints();
        gbc2.gridx = 0;
        gbc2.gridy = 0;
        gbc2.fill = 1;
        gbc2.insets = new Insets(0, 40, 0, 0);
        gbc2.weightx = 1.0;
        this.KPanel.add((Component)this.defKbutton, gbc2);
        this.calcKbutton.setToolTipText("Calculate optimum K from loaded data");
        this.calcKbutton.setText("Calculate");
        this.calcKbutton.setBackground(Color.white);
        this.calcKbutton.setForeground(UIManager.getColor("Label.foreground"));
        this.Kselection.add(this.calcKbutton);
        this.calcKbutton.setFocusPainted(false);
        gbc2 = new GridBagConstraints();
        gbc2.gridx = 1;
        gbc2.gridy = 0;
        gbc2.fill = 1;
        gbc2.insets = new Insets(0, 40, 0, 0);
        gbc2.weightx = 1.0;
        this.KPanel.add((Component)this.calcKbutton, gbc2);
        GridBagConstraints gbc3 = new GridBagConstraints();
        gbc3.gridx = 0;
        gbc3.gridy = 0;
        gbc3.weightx = 1.0;
        gbc3.fill = 2;
        gbc3.insets = new Insets(4, 0, 0, 0);
        mainPanel.add((Component)this.processPanel, gbc3);
        gbc3 = new GridBagConstraints();
        gbc3.gridx = 0;
        gbc3.gridy = 1;
        gbc3.weightx = 1.0;
        gbc3.fill = 2;
        gbc3.insets = new Insets(4, 0, 0, 0);
        mainPanel.add((Component)this.KPanel, gbc3);
        this.addContent(mainPanel);
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    public int showModal() {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((screenSize.width - this.getSize().width) / 2, (screenSize.height - this.getSize().height) / 2);
        this.show();
        return this.result;
    }

    public static void main(String[] args) {
        new DAMProcessInitDialog((Frame)new JFrame(), true).show();
        System.exit(0);
    }

    public boolean getSkipGeneSelectionValue() {
        return this.skipGeneScreenBox.isSelected();
    }

    public boolean getSkipLOOCVValue() {
        return this.skipCrossValBox.isSelected();
    }

    private class Listener
    extends DialogListener
    implements ItemListener {
        private Listener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String command = e.getActionCommand();
            if (command.equals("ok-command")) {
                DAMProcessInitDialog.this.result = 0;
                DAMProcessInitDialog.this.dispose();
            } else if (command.equals("cancel-command")) {
                DAMProcessInitDialog.this.result = 2;
                DAMProcessInitDialog.this.dispose();
            } else if (command.equals("reset-command")) {
                DAMProcessInitDialog.this.skipGeneScreeningStep = false;
                DAMProcessInitDialog.this.skipCrossValidationStep = false;
                DAMProcessInitDialog.this.skipGeneScreenBox.setSelected(false);
                DAMProcessInitDialog.this.skipCrossValBox.setSelected(false);
                DAMProcessInitDialog.this.defKbutton.setSelected(true);
            } else if (command.equals("info-command")) {
                HelpWindow.launchBrowser(DAMProcessInitDialog.this, "DAM Process Initialization Dialog");
            }
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            ItemSelectable source = e.getItemSelectable();
            if (source == DAMProcessInitDialog.this.skipGeneScreenBox) {
                DAMProcessInitDialog.this.skipGeneScreeningStep = DAMProcessInitDialog.this.skipGeneScreenBox.isSelected();
            } else if (source == DAMProcessInitDialog.this.skipCrossValBox) {
                DAMProcessInitDialog.this.skipCrossValidationStep = DAMProcessInitDialog.this.skipCrossValBox.isSelected();
            }
        }

        @Override
        public void windowClosing(WindowEvent e) {
            DAMProcessInitDialog.this.result = -1;
            DAMProcessInitDialog.this.dispose();
        }
    }
}

