/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.dam;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import org.tigr.microarray.mev.cluster.gui.impl.dam.DAMGUI;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.AlgorithmDialog;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.DialogListener;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.SampleSelectionPanel;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.dialogHelpUtil.HelpWindow;

public class DAMInitDialog
extends AlgorithmDialog {
    int result = 2;
    boolean skipGeneScreeningStep = false;
    boolean skipCrossValidationStep = false;
    private SampleSelectionPanel sampleSelectionPanel;
    private JPanel assessPanel;
    private JPanel classPanel;
    private JPanel paramPanel;
    private JPanel processPanel;
    private JPanel assessSelectionPanel;
    private JCheckBox geneScreenBox;
    private JCheckBox validationCheckBox;
    private JRadioButton A0button;
    private JRadioButton A1button;
    private JRadioButton A2button;
    private JRadioButton PDAbutton;
    private JRadioButton QDAbutton;
    private JTextField numClassesField;
    private JTextField kValueField;
    private JTextField alphaValueField;
    private ButtonGroup assessSelection;
    private ButtonGroup classSelection;
    private JLabel alphaValueLabel;
    private Listener listener = new Listener();

    public DAMInitDialog(Frame parent, boolean modal) {
        super(parent, "DAM Initialization", modal);
        this.initComponents();
        this.okButton.setText("Next");
        this.sampleSelectionPanel.setButtonText("Classify Genes", "Classify Experiments");
        this.sampleSelectionPanel.setClusterGenesSelected(true);
        this.setActionListeners(this.listener);
        this.pack();
        this.setResizable(false);
    }

    private void initComponents() {
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new GridBagLayout());
        mainPanel.setBackground(Color.white);
        this.assessPanel = new JPanel();
        this.paramPanel = new JPanel();
        this.assessSelectionPanel = new JPanel();
        this.A0button = new JRadioButton();
        this.A1button = new JRadioButton();
        this.A2button = new JRadioButton();
        this.setBackground(Color.lightGray);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                DAMInitDialog.this.closeDialog(evt);
            }
        });
        this.sampleSelectionPanel = new SampleSelectionPanel(Color.white, UIManager.getColor("Label.foreground"), true, "Classification Selection");
        GridBagConstraints gbc1 = new GridBagConstraints();
        gbc1.gridx = 0;
        gbc1.gridy = 0;
        gbc1.weightx = 1.0;
        gbc1.fill = 2;
        gbc1.insets = new Insets(4, 0, 0, 0);
        mainPanel.add((Component)this.sampleSelectionPanel, gbc1);
        this.processPanel = new JPanel(new GridBagLayout());
        this.processPanel.setBorder(new TitledBorder(new EtchedBorder(0), "Data Screening", 0, 0, new Font("Dialog", 1, 12), Color.black));
        this.processPanel.setBackground(Color.white);
        this.geneScreenBox = new JCheckBox("Enable Data Screening Step (ANOVA)", true);
        this.geneScreenBox.setHorizontalAlignment(0);
        this.geneScreenBox.setFocusPainted(false);
        this.geneScreenBox.setBackground(Color.white);
        this.geneScreenBox.setForeground(UIManager.getColor("Label.foreground"));
        this.geneScreenBox.setActionCommand("screen-data-command");
        this.geneScreenBox.addActionListener(this.listener);
        GridBagConstraints gbc5 = new GridBagConstraints();
        gbc5.gridx = 0;
        gbc5.gridy = 0;
        gbc5.insets = new Insets(0, 0, 10, 0);
        gbc5.fill = 1;
        gbc5.gridwidth = 2;
        gbc5.weightx = 1.0;
        this.processPanel.add((Component)this.geneScreenBox, gbc5);
        this.alphaValueLabel = new JLabel("Alpha Value");
        this.alphaValueLabel.setHorizontalAlignment(4);
        gbc5 = new GridBagConstraints();
        gbc5.gridx = 0;
        gbc5.gridy = 1;
        gbc5.fill = 1;
        gbc5.insets = new Insets(0, 0, 10, 0);
        gbc5.weightx = 1.0;
        this.processPanel.add((Component)this.alphaValueLabel, gbc5);
        this.alphaValueField = new JTextField("0.05", 8);
        this.alphaValueField.setHorizontalAlignment(2);
        gbc5 = new GridBagConstraints();
        gbc5.gridx = 1;
        gbc5.gridy = 1;
        gbc5.insets = new Insets(0, 0, 10, 40);
        gbc5.weightx = 1.0;
        this.processPanel.add((Component)this.alphaValueField, gbc5);
        gbc1 = new GridBagConstraints();
        gbc1.gridx = 0;
        gbc1.gridy = 1;
        gbc1.fill = 2;
        mainPanel.add((Component)this.processPanel, gbc1);
        this.classSelection = new ButtonGroup();
        this.classPanel = new JPanel();
        this.PDAbutton = new JRadioButton();
        this.QDAbutton = new JRadioButton();
        this.classPanel.setLayout(new GridBagLayout());
        this.classPanel.setBorder(new TitledBorder(new EtchedBorder(0), "Classification Algorithm Selection", 0, 0, new Font("Dialog", 1, 12), Color.black));
        this.classPanel.setBackground(Color.white);
        this.PDAbutton.setToolTipText("Polychotomous Discrimination Algorithm");
        this.PDAbutton.setSelected(true);
        this.PDAbutton.setText("PDA");
        this.PDAbutton.setBackground(Color.white);
        this.PDAbutton.setHorizontalAlignment(0);
        this.classSelection.add(this.PDAbutton);
        this.PDAbutton.setForeground(UIManager.getColor("Label.foreground"));
        this.PDAbutton.setFocusPainted(false);
        GridBagConstraints gbc3 = new GridBagConstraints();
        gbc3.gridx = 0;
        gbc3.gridy = 0;
        gbc3.fill = 1;
        gbc3.insets = new Insets(10, 0, 10, 0);
        gbc3.weightx = 1.0;
        this.classPanel.add((Component)this.PDAbutton, gbc3);
        this.QDAbutton.setToolTipText("Quadratic Discriminant Analysis Algorithm");
        this.QDAbutton.setText("QDA");
        this.QDAbutton.setBackground(Color.white);
        this.QDAbutton.setForeground(UIManager.getColor("Label.foreground"));
        this.QDAbutton.setHorizontalAlignment(0);
        this.classSelection.add(this.QDAbutton);
        this.QDAbutton.setFocusPainted(false);
        gbc3 = new GridBagConstraints();
        gbc3.gridx = 1;
        gbc3.gridy = 0;
        gbc3.fill = 1;
        gbc3.insets = new Insets(10, 0, 10, 0);
        gbc3.weightx = 1.0;
        this.classPanel.add((Component)this.QDAbutton, gbc3);
        gbc1 = new GridBagConstraints();
        gbc1.gridx = 0;
        gbc1.gridy = 2;
        gbc1.fill = 2;
        mainPanel.add((Component)this.classPanel, gbc1);
        this.paramPanel.setLayout(new GridBagLayout());
        this.paramPanel.setBorder(new TitledBorder(new EtchedBorder(0), "DAM Classification Parameters", 0, 0, new Font("Dialog", 1, 12), Color.black));
        this.paramPanel.setBackground(Color.white);
        JLabel numClassesLabel = new JLabel("Number of Classes");
        numClassesLabel.setHorizontalAlignment(4);
        this.paramPanel.add(numClassesLabel);
        GridBagConstraints gbc4 = new GridBagConstraints();
        gbc4.gridx = 0;
        gbc4.gridy = 0;
        gbc4.fill = 1;
        gbc4.insets = new Insets(0, 0, 0, 0);
        gbc4.weightx = 1.0;
        this.paramPanel.add((Component)numClassesLabel, gbc4);
        this.numClassesField = new JTextField("3", 8);
        this.paramPanel.add(this.numClassesField);
        gbc4 = new GridBagConstraints();
        gbc4.gridx = 1;
        gbc4.gridy = 0;
        gbc4.insets = new Insets(0, 0, 0, 40);
        gbc4.weightx = 1.0;
        this.paramPanel.add((Component)this.numClassesField, gbc4);
        JLabel kValueLabel = new JLabel("Number Of Components");
        kValueLabel.setHorizontalAlignment(4);
        gbc4 = new GridBagConstraints();
        gbc4.gridx = 0;
        gbc4.gridy = 1;
        gbc4.fill = 1;
        gbc4.insets = new Insets(10, 0, 10, 0);
        gbc4.weightx = 1.0;
        this.paramPanel.add((Component)kValueLabel, gbc4);
        this.kValueField = new JTextField("3", 8);
        this.kValueField.setHorizontalAlignment(2);
        gbc4 = new GridBagConstraints();
        gbc4.gridx = 1;
        gbc4.gridy = 1;
        gbc4.insets = new Insets(10, 0, 10, 40);
        gbc4.weightx = 1.0;
        this.paramPanel.add((Component)this.kValueField, gbc4);
        gbc1 = new GridBagConstraints();
        gbc1.gridx = 0;
        gbc1.gridy = 3;
        gbc1.fill = 2;
        mainPanel.add((Component)this.paramPanel, gbc1);
        this.assessSelection = new ButtonGroup();
        this.assessSelectionPanel.setLayout(new GridBagLayout());
        this.assessSelectionPanel.setBackground(Color.white);
        this.validationCheckBox = new JCheckBox("Enable Validation", false);
        this.validationCheckBox.setOpaque(true);
        this.validationCheckBox.setBackground(Color.white);
        this.validationCheckBox.setFocusPainted(false);
        this.validationCheckBox.setHorizontalAlignment(0);
        this.validationCheckBox.setActionCommand("validation-command");
        this.validationCheckBox.addActionListener(this.listener);
        this.assessSelectionPanel.add((Component)this.validationCheckBox, new GridBagConstraints(0, 0, 3, 1, 1.0, 1.0, 10, 1, new Insets(5, 0, 5, 0), 0, 0));
        this.A0button.setToolTipText("A0 Assessment Algorithm");
        this.A0button.setSelected(true);
        this.A0button.setEnabled(false);
        this.A0button.setText("A0");
        this.A0button.setBackground(Color.white);
        this.assessSelection.add(this.A0button);
        this.A0button.setForeground(UIManager.getColor("Label.foreground"));
        this.A0button.setFocusPainted(false);
        GridBagConstraints gbc2 = new GridBagConstraints();
        gbc2.gridx = 0;
        gbc2.gridy = 1;
        gbc2.fill = 1;
        gbc2.insets = new Insets(0, 40, 10, 0);
        gbc2.gridwidth = 1;
        gbc2.gridheight = 1;
        gbc2.weightx = 1.0;
        this.assessSelectionPanel.add((Component)this.A0button, gbc2);
        this.A1button.setToolTipText("A1 Assessment Algorithm");
        this.A1button.setText("A1");
        this.A1button.setEnabled(false);
        this.A1button.setBackground(Color.white);
        this.assessSelection.add(this.A1button);
        this.A1button.setForeground(UIManager.getColor("Label.foreground"));
        this.A1button.setFocusPainted(false);
        gbc2 = new GridBagConstraints();
        gbc2.gridx = 1;
        gbc2.gridy = 1;
        gbc2.fill = 1;
        gbc2.insets = new Insets(0, 30, 10, 0);
        gbc2.gridwidth = 1;
        gbc2.gridheight = 1;
        gbc2.weightx = 1.0;
        this.assessSelectionPanel.add((Component)this.A1button, gbc2);
        this.A2button.setToolTipText("A2 Assessment Algorithm");
        this.A2button.setText("A2");
        this.A2button.setEnabled(false);
        this.A2button.setBackground(Color.white);
        this.assessSelection.add(this.A2button);
        this.A2button.setForeground(UIManager.getColor("Label.foreground"));
        this.A2button.setFocusPainted(false);
        gbc2 = new GridBagConstraints();
        gbc2.gridx = 2;
        gbc2.gridy = 1;
        gbc2.fill = 1;
        gbc2.insets = new Insets(0, 30, 10, 0);
        gbc2.gridwidth = 1;
        gbc2.gridheight = 1;
        gbc2.weightx = 1.0;
        this.assessSelectionPanel.add((Component)this.A2button, gbc2);
        this.assessPanel.setLayout(new GridBagLayout());
        this.assessPanel.setBorder(new TitledBorder(new EtchedBorder(0), "Validation Selection", 0, 0, new Font("Dialog", 1, 12), Color.black));
        this.assessPanel.setBackground(Color.white);
        this.assessSelectionPanel.setBackground(Color.white);
        this.assessSelectionPanel.setForeground(UIManager.getColor("Label.foreground"));
        GridBagConstraints gbc6 = new GridBagConstraints();
        gbc6.gridx = 0;
        gbc6.gridy = 0;
        gbc6.fill = 1;
        gbc6.weightx = 1.0;
        this.assessPanel.add((Component)this.assessSelectionPanel, gbc6);
        gbc1 = new GridBagConstraints();
        gbc1.gridx = 0;
        gbc1.gridy = 4;
        gbc1.fill = 2;
        mainPanel.add((Component)this.assessPanel, gbc1);
        this.addContent(mainPanel);
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    public boolean isEvaluateGenesSelected() {
        return this.sampleSelectionPanel.isClusterGenesSelected();
    }

    public int getAssessmentSelection() {
        if (!this.validationCheckBox.isSelected()) {
            return DAMGUI.A3;
        }
        if (this.A2button.isSelected()) {
            return DAMGUI.A2;
        }
        if (this.A1button.isSelected()) {
            return DAMGUI.A1;
        }
        if (this.A0button.isSelected()) {
            return DAMGUI.A0;
        }
        return DAMGUI.A3;
    }

    public boolean isPDASelected() {
        return this.PDAbutton.isSelected();
    }

    public int getNumClasses() {
        String s = this.numClassesField.getText();
        return Integer.parseInt(s);
    }

    public int getKValue() {
        String s = this.kValueField.getText();
        return Integer.parseInt(s);
    }

    public double getAlphaValue() {
        String s = this.alphaValueField.getText();
        return Double.parseDouble(s);
    }

    public int showModal() {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((screenSize.width - this.getSize().width) / 2, (screenSize.height - this.getSize().height) / 2);
        this.show();
        return this.result;
    }

    public void resetControls() {
        this.geneScreenBox.setSelected(true);
        this.alphaValueLabel.setEnabled(true);
        this.alphaValueField.setEnabled(true);
        this.sampleSelectionPanel.setClusterGenesSelected(true);
        this.validationCheckBox.setSelected(false);
        this.A0button.setEnabled(false);
        this.A1button.setEnabled(false);
        this.A2button.setEnabled(false);
        this.PDAbutton.setSelected(true);
        this.numClassesField.setText("3");
        this.kValueField.setText("3");
        this.alphaValueField.setText("0.05");
        this.skipGeneScreeningStep = false;
        this.skipCrossValidationStep = false;
        this.geneScreenBox.setSelected(true);
    }

    public static void main(String[] args) {
        new DAMInitDialog((Frame)new JFrame(), true).show();
        System.exit(0);
    }

    public boolean getSkipGeneSelectionValue() {
        return !this.geneScreenBox.isSelected();
    }

    private class Listener
    extends DialogListener {
        private Listener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String command = e.getActionCommand();
            if (command.equals("ok-command")) {
                DAMInitDialog.this.result = 0;
                DAMInitDialog.this.dispose();
            } else if (command.equals("cancel-command")) {
                DAMInitDialog.this.result = 2;
                DAMInitDialog.this.dispose();
            } else if (command.equals("reset-command")) {
                DAMInitDialog.this.resetControls();
            } else if (command.equals("screen-data-command")) {
                DAMInitDialog.this.alphaValueField.setEnabled(DAMInitDialog.this.geneScreenBox.isSelected());
                DAMInitDialog.this.alphaValueLabel.setEnabled(DAMInitDialog.this.geneScreenBox.isSelected());
            } else if (command.equals("validation-command")) {
                DAMInitDialog.this.A0button.setEnabled(DAMInitDialog.this.validationCheckBox.isSelected());
                DAMInitDialog.this.A1button.setEnabled(DAMInitDialog.this.validationCheckBox.isSelected());
                DAMInitDialog.this.A2button.setEnabled(DAMInitDialog.this.validationCheckBox.isSelected());
            } else if (command.equals("info-command")) {
                HelpWindow.launchBrowser(DAMInitDialog.this, "DAM Initialization Dialog");
            }
        }

        @Override
        public void windowClosing(WindowEvent e) {
            DAMInitDialog.this.result = -1;
            DAMInitDialog.this.dispose();
        }
    }
}

