/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.dam;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.tree.DefaultMutableTreeNode;
import org.tigr.microarray.mev.cluster.Cluster;
import org.tigr.microarray.mev.cluster.NodeList;
import org.tigr.microarray.mev.cluster.algorithm.Algorithm;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmData;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmEvent;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmException;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmListener;
import org.tigr.microarray.mev.cluster.gui.Experiment;
import org.tigr.microarray.mev.cluster.gui.IClusterGUI;
import org.tigr.microarray.mev.cluster.gui.IData;
import org.tigr.microarray.mev.cluster.gui.IDistanceMenu;
import org.tigr.microarray.mev.cluster.gui.IFramework;
import org.tigr.microarray.mev.cluster.gui.IViewer;
import org.tigr.microarray.mev.cluster.gui.LeafInfo;
import org.tigr.microarray.mev.cluster.gui.helpers.CentroidUserObject;
import org.tigr.microarray.mev.cluster.gui.helpers.ClusterTableViewer;
import org.tigr.microarray.mev.cluster.gui.helpers.ExperimentClusterTableViewer;
import org.tigr.microarray.mev.cluster.gui.impl.dam.DAM3DViewer;
import org.tigr.microarray.mev.cluster.gui.impl.dam.DAMCentroidViewer;
import org.tigr.microarray.mev.cluster.gui.impl.dam.DAMCentroidsViewer;
import org.tigr.microarray.mev.cluster.gui.impl.dam.DAMClassificationEditor;
import org.tigr.microarray.mev.cluster.gui.impl.dam.DAMExperimentCentroidViewer;
import org.tigr.microarray.mev.cluster.gui.impl.dam.DAMExperimentCentroidsViewer;
import org.tigr.microarray.mev.cluster.gui.impl.dam.DAMExperimentClusterViewer;
import org.tigr.microarray.mev.cluster.gui.impl.dam.DAMExperimentViewer;
import org.tigr.microarray.mev.cluster.gui.impl.dam.DAMInfoViewer;
import org.tigr.microarray.mev.cluster.gui.impl.dam.DAMInitDialog;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.DialogListener;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.Logger;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.Progress;
import org.tigr.util.FloatMatrix;

public class DAMGUI
implements IClusterGUI {
    private Experiment experiment;
    private Experiment unusedExperiment;
    private Experiment usedExperiment;
    private Algorithm algorithm;
    private Progress progress;
    private IFramework framework;
    private float minDist;
    private float maxDist;
    private int num_genes;
    private int mode;
    public static int A0 = 0;
    public static int A1 = 1;
    public static int A2 = 2;
    public static int A3 = 3;
    private FloatMatrix matrix3D;
    private FloatMatrix matrixS;
    private Logger logger;
    private int algorithmSelection = 0;
    private int classificationSelection = 0;
    private boolean isPDA;
    private boolean preSelectGenes;
    private int numberOfClasses;
    private int kValue;
    private double alpha;
    private IData iData;
    DAMClassificationEditor damClassEditor;
    Vector[] classificationVector;
    int[] trainingIndices;
    int[] testIndices;
    int[] classes;
    int[] columns;
    int[] rows;
    int[] usedGeneIndices;
    int[] unusedGeneIndices;
    boolean classifyGenes = false;
    private int[][] clusters;
    private int[][] geneClusters;
    private FloatMatrix means;
    private FloatMatrix means_used;
    private FloatMatrix means_unused;
    private FloatMatrix variances;
    private FloatMatrix variances_used;
    private FloatMatrix variances_unused;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DefaultMutableTreeNode execute(IFramework framework) throws AlgorithmException {
        this.framework = framework;
        this.experiment = framework.getData().getExperiment();
        this.iData = framework.getData();
        Listener listener = new Listener();
        try {
            int i;
            int i2;
            DAMInitDialog damInitDialog = new DAMInitDialog(framework.getFrame(), true);
            if (damInitDialog.showModal() != 0) {
                DefaultMutableTreeNode defaultMutableTreeNode = null;
                return defaultMutableTreeNode;
            }
            this.classifyGenes = damInitDialog.isEvaluateGenesSelected();
            this.algorithmSelection = damInitDialog.getAssessmentSelection();
            this.isPDA = damInitDialog.isPDASelected();
            this.numberOfClasses = damInitDialog.getNumClasses();
            this.kValue = damInitDialog.getKValue();
            this.alpha = damInitDialog.getAlphaValue();
            this.preSelectGenes = !damInitDialog.getSkipGeneSelectionValue();
            DAMClassificationEditor damClassEditor = new DAMClassificationEditor(framework, this.classifyGenes, this.numberOfClasses);
            damClassEditor.setVisible(true);
            while (!damClassEditor.isNextPressed()) {
                if (!damClassEditor.isCancelPressed()) continue;
                DefaultMutableTreeNode defaultMutableTreeNode = null;
                return defaultMutableTreeNode;
            }
            AlgorithmData data = new AlgorithmData();
            boolean useGenes = damInitDialog.isEvaluateGenesSelected();
            if (useGenes) {
                this.mode = 1;
                data.addParam("dam-mode", "1");
            } else {
                this.mode = 3;
                data.addParam("dam-mode", "3");
            }
            this.classificationVector = damClassEditor.getClassification();
            this.trainingIndices = new int[this.classificationVector[0].size()];
            this.classes = new int[this.classificationVector[1].size()];
            this.testIndices = new int[this.classificationVector[2].size()];
            for (i2 = 0; i2 < this.trainingIndices.length; ++i2) {
                this.trainingIndices[i2] = (Integer)this.classificationVector[0].get(i2);
                this.classes[i2] = (Integer)this.classificationVector[1].get(i2);
            }
            for (i2 = 0; i2 < this.testIndices.length; ++i2) {
                this.testIndices[i2] = (Integer)this.classificationVector[2].get(i2);
            }
            this.algorithm = framework.getAlgorithmFactory().getAlgorithm("DAM");
            this.algorithm.addAlgorithmListener((AlgorithmListener)listener);
            this.logger = new Logger(framework.getFrame(), "DAM Log Window", listener);
            this.logger.show();
            this.logger.append("Starting DAM calculation\n");
            Experiment experiment = framework.getData().getExperiment();
            if (this.classifyGenes) {
                FloatMatrix temp = experiment.getMatrix().transpose();
                data.addMatrix("experiment", temp);
            } else {
                data.addMatrix("experiment", experiment.getMatrix());
            }
            data.addParam("distance-factor", String.valueOf(1.0f));
            IDistanceMenu menu = framework.getDistanceMenu();
            data.addParam("distance-absolute", String.valueOf(menu.isAbsoluteDistance()));
            data.addParam("algorithmSelection", String.valueOf(this.algorithmSelection));
            data.addParam("isPDA", String.valueOf(this.isPDA));
            data.addParam("preSelectGenes", String.valueOf(this.preSelectGenes));
            data.addParam("numberOfClasses", String.valueOf(this.numberOfClasses));
            data.addParam("kValue", String.valueOf(this.kValue));
            data.addParam("alpha", String.valueOf(this.alpha));
            data.addIntArray("trainingIndices", this.trainingIndices);
            data.addIntArray("classes", this.classes);
            data.addIntArray("testIndices", this.testIndices);
            int function = menu.getDistanceFunction();
            if (function == 0) {
                function = 3;
            }
            data.addParam("distance-function", String.valueOf(function));
            data.addParam("dam-mode", String.valueOf(this.mode));
            AlgorithmData result = null;
            DefaultMutableTreeNode node = null;
            long start = System.currentTimeMillis();
            switch (this.mode) {
                case 1: {
                    data.addParam("distance-function", String.valueOf(function));
                    result = this.algorithm.execute(data);
                    this.matrixS = result.getMatrix("S");
                    this.matrix3D = result.getMatrix("matrix3D");
                    this.usedGeneIndices = result.getIntArray("usedGeneIndices");
                    this.unusedGeneIndices = result.getIntArray("unusedGeneIndices");
                    node = new DefaultMutableTreeNode("DAM - genes");
                    break;
                }
                case 3: {
                    result = this.algorithm.execute(data);
                    this.matrixS = result.getMatrix("S");
                    this.matrix3D = result.getMatrix("matrix3D");
                    this.usedGeneIndices = result.getIntArray("usedGeneIndices");
                    this.unusedGeneIndices = result.getIntArray("unusedGeneIndices");
                    node = new DefaultMutableTreeNode("DAM - samples");
                    break;
                }
            }
            Cluster result_cluster = result.getCluster("cluster");
            NodeList nodeList = result_cluster.getNodeList();
            int k = this.numberOfClasses * 3;
            this.clusters = new int[k][];
            for (int i3 = 0; i3 < k; ++i3) {
                this.clusters[i3] = nodeList.getNode(i3).getFeaturesIndexes();
            }
            Cluster gene_cluster = result.getCluster("geneCluster");
            nodeList = gene_cluster.getNodeList();
            this.geneClusters = new int[2][];
            for (i = 0; i < 2; ++i) {
                this.geneClusters[i] = nodeList.getNode(i).getFeaturesIndexes();
            }
            this.means = result.getMatrix("clusters_means");
            this.variances = result.getMatrix("clusters_variances");
            this.means_used = result.getMatrix("clusters_means_used");
            this.variances_used = result.getMatrix("clusters_variances_used");
            this.means_unused = result.getMatrix("clusters_means_unused");
            this.variances_unused = result.getMatrix("clusters_variances_unused");
            this.columns = new int[experiment.getMatrix().getColumnDimension()];
            for (i = 0; i < this.columns.length; ++i) {
                this.columns[i] = i;
            }
            this.rows = new int[experiment.getMatrix().getRowDimension()];
            for (i = 0; i < this.rows.length; ++i) {
                this.rows[i] = i;
            }
            if (this.classifyGenes) {
                this.usedExperiment = new Experiment(experiment.getMatrix().getMatrix(this.rows, this.usedGeneIndices), this.usedGeneIndices, this.rows);
                this.unusedExperiment = new Experiment(experiment.getMatrix().getMatrix(this.rows, this.unusedGeneIndices), this.unusedGeneIndices, this.rows);
            } else {
                this.usedExperiment = new Experiment(experiment.getMatrix().getMatrix(this.usedGeneIndices, this.columns), this.columns, this.usedGeneIndices);
                this.unusedExperiment = new Experiment(experiment.getMatrix().getMatrix(this.unusedGeneIndices, this.columns), this.columns, this.unusedGeneIndices);
            }
            this.logger.append("Creating the result viewers\n");
            long time = System.currentTimeMillis() - start;
            if (this.algorithmSelection == A3) {
                this.addClassificationResultNodes(framework.getFrame(), node, time, menu.getFunctionName(function), experiment);
            } else {
                this.addValidationResultNodes(framework.getFrame(), node, time, menu.getFunctionName(function), experiment);
            }
            DefaultMutableTreeNode defaultMutableTreeNode = node;
            return defaultMutableTreeNode;
        }
        finally {
            if (this.algorithm != null) {
                this.algorithm.removeAlgorithmListener((AlgorithmListener)listener);
            }
            if (this.logger != null) {
                this.logger.dispose();
            }
        }
    }

    private void addClassificationResultNodes(Frame frame, DefaultMutableTreeNode node, long time, String function, Experiment experiment) {
        this.addExpressionImages(node);
        this.addCentroidViews(node);
        this.addTableViews(node);
        this.add3DViewNode(frame, node, experiment);
        this.addClusterInfo(node);
        this.addGeneralInfoNode(node, time, function);
    }

    private void addValidationResultNodes(Frame frame, DefaultMutableTreeNode node, long time, String function, Experiment experiment) {
        this.addExpressionImages(node);
        this.addCentroidViews(node);
        this.addTableViews(node);
        this.add3DViewNode(frame, node, experiment);
        this.addClusterInfo(node);
        this.addGeneralInfoNode(node, time, function);
    }

    private void addTableViews(DefaultMutableTreeNode root) {
        int i;
        DefaultMutableTreeNode node = new DefaultMutableTreeNode("Table views");
        DefaultMutableTreeNode[] nodeArray = new DefaultMutableTreeNode[3];
        nodeArray[0] = new DefaultMutableTreeNode("Classifiers");
        if (this.algorithmSelection != A3) {
            nodeArray[1] = new DefaultMutableTreeNode("Initial Classification");
            nodeArray[2] = new DefaultMutableTreeNode("Validation Classification");
        } else {
            nodeArray[1] = new DefaultMutableTreeNode("Classified");
            nodeArray[2] = new DefaultMutableTreeNode("Classifiers + Classified");
        }
        Object tabViewer = this.classifyGenes ? new ClusterTableViewer(this.experiment, this.clusters, this.iData) : new ExperimentClusterTableViewer(this.experiment, this.clusters, this.iData);
        for (i = 0; i < this.numberOfClasses; ++i) {
            nodeArray[0].add(new DefaultMutableTreeNode(new LeafInfo("Class " + String.valueOf(i + 1), (IViewer)tabViewer, (Object)new Integer(i))));
        }
        for (i = this.numberOfClasses; i < 2 * this.numberOfClasses; ++i) {
            nodeArray[1].add(new DefaultMutableTreeNode(new LeafInfo("Class " + String.valueOf(i + 1 - this.numberOfClasses), (IViewer)tabViewer, (Object)new Integer(i))));
        }
        for (i = 2 * this.numberOfClasses; i < 3 * this.numberOfClasses; ++i) {
            nodeArray[2].add(new DefaultMutableTreeNode(new LeafInfo("Class " + String.valueOf(i + 1 - 2 * this.numberOfClasses), (IViewer)tabViewer, (Object)new Integer(i))));
        }
        for (i = 0; i < nodeArray.length; ++i) {
            node.add(nodeArray[i]);
        }
        tabViewer = this.classifyGenes ? new ClusterTableViewer(this.experiment, this.clusters, this.iData) : new ExperimentClusterTableViewer(this.experiment, this.clusters, this.iData);
        if (this.preSelectGenes) {
            DefaultMutableTreeNode unusedNode;
            DefaultMutableTreeNode usedNode;
            if (this.classifyGenes) {
                ExperimentClusterTableViewer tabViewer1 = new ExperimentClusterTableViewer(this.experiment, this.geneClusters, this.iData);
                usedNode = new DefaultMutableTreeNode(new LeafInfo("Used Exp Table View", (IViewer)tabViewer1, (Object)new Integer(0)));
                unusedNode = new DefaultMutableTreeNode(new LeafInfo("Unused Exp Table View", (IViewer)tabViewer1, (Object)new Integer(1)));
            } else {
                ClusterTableViewer tabViewer1 = new ClusterTableViewer(this.experiment, this.geneClusters, this.iData);
                usedNode = new DefaultMutableTreeNode(new LeafInfo("Used Gene Table View", (IViewer)tabViewer1, (Object)new Integer(0)));
                unusedNode = new DefaultMutableTreeNode(new LeafInfo("Unused Gene Table View", (IViewer)tabViewer1, (Object)new Integer(1)));
            }
            node.add(usedNode);
            node.add(unusedNode);
        }
        root.add(node);
    }

    private void add3DViewNode(Frame frame, DefaultMutableTreeNode node, Experiment experiment) {
        if (this.matrix3D == null || this.matrix3D.getColumnDimension() < 3) {
            return;
        }
        DAM3DViewer dam3DViewer = this.mode == 1 ? new DAM3DViewer(frame, this.mode, this.matrix3D, experiment, true) : new DAM3DViewer(frame, this.mode, this.matrix3D, experiment, false);
        node.add(new DefaultMutableTreeNode(new LeafInfo("Gene Component 3D view", (IViewer)dam3DViewer, dam3DViewer.getJPopupMenu())));
    }

    private void addGeneralInfoNode(DefaultMutableTreeNode node, long time, String function) {
        DefaultMutableTreeNode gNode = new DefaultMutableTreeNode("General Information");
        if (this.matrixS != null) {
            gNode.add(new DefaultMutableTreeNode("Components: " + this.matrixS.getColumnDimension()));
        }
        gNode.add(new DefaultMutableTreeNode("Time: " + String.valueOf(time) + " ms"));
        gNode.add(new DefaultMutableTreeNode(function));
        node.add(gNode);
    }

    private void addCentroidViews(DefaultMutableTreeNode root) {
        DefaultMutableTreeNode centroidNode = new DefaultMutableTreeNode("Centroid Graphs");
        DefaultMutableTreeNode expressionNode = new DefaultMutableTreeNode("Expression Graphs");
        DefaultMutableTreeNode[] centroidNodeArray = new DefaultMutableTreeNode[3];
        DefaultMutableTreeNode[] expressionNodeArray = new DefaultMutableTreeNode[3];
        centroidNodeArray[0] = new DefaultMutableTreeNode("Classifiers");
        centroidNodeArray[1] = new DefaultMutableTreeNode("Classified");
        centroidNodeArray[2] = new DefaultMutableTreeNode("Classifiers + Classified");
        expressionNodeArray[0] = new DefaultMutableTreeNode("Classifiers");
        expressionNodeArray[1] = new DefaultMutableTreeNode("Classified");
        expressionNodeArray[2] = new DefaultMutableTreeNode("Classifiers + Classified");
        if (this.classifyGenes) {
            int i;
            DAMCentroidViewer centroidViewer = new DAMCentroidViewer(this.experiment, this.clusters);
            centroidViewer.setMeans(this.means.A);
            centroidViewer.setVariances(this.variances.A);
            for (i = 0; i < this.numberOfClasses; ++i) {
                centroidNodeArray[0].add(new DefaultMutableTreeNode(new LeafInfo("Class " + String.valueOf(i + 1), (IViewer)centroidViewer, (Object)new CentroidUserObject(i, 0))));
                expressionNodeArray[0].add(new DefaultMutableTreeNode(new LeafInfo("Class " + String.valueOf(i + 1), (IViewer)centroidViewer, (Object)new CentroidUserObject(i, 1))));
            }
            for (i = this.numberOfClasses; i < 2 * this.numberOfClasses; ++i) {
                centroidNodeArray[1].add(new DefaultMutableTreeNode(new LeafInfo("Class " + String.valueOf(i + 1 - this.numberOfClasses), (IViewer)centroidViewer, (Object)new CentroidUserObject(i, 0))));
                expressionNodeArray[1].add(new DefaultMutableTreeNode(new LeafInfo("Class " + String.valueOf(i + 1 - this.numberOfClasses), (IViewer)centroidViewer, (Object)new CentroidUserObject(i, 1))));
            }
            for (i = 2 * this.numberOfClasses; i < 3 * this.numberOfClasses; ++i) {
                centroidNodeArray[2].add(new DefaultMutableTreeNode(new LeafInfo("Class " + String.valueOf(i + 1 - 2 * this.numberOfClasses), (IViewer)centroidViewer, (Object)new CentroidUserObject(i, 0))));
                expressionNodeArray[2].add(new DefaultMutableTreeNode(new LeafInfo("Class " + String.valueOf(i + 1 - 2 * this.numberOfClasses), (IViewer)centroidViewer, (Object)new CentroidUserObject(i, 1))));
            }
            DAMCentroidsViewer centroidsViewer = new DAMCentroidsViewer(this.experiment, this.clusters);
            centroidsViewer.setMeans(this.means.A);
            centroidsViewer.setVariances(this.variances.A);
            for (int i2 = 0; i2 < centroidNodeArray.length; ++i2) {
                centroidNode.add(centroidNodeArray[i2]);
                expressionNode.add(expressionNodeArray[i2]);
            }
            DAMExperimentCentroidViewer expCentroidViewer = new DAMExperimentCentroidViewer(this.experiment, this.geneClusters);
            expCentroidViewer.setMeans(this.means_used.A);
            expCentroidViewer.setVariances(this.variances_used.A);
            if (this.preSelectGenes) {
                DefaultMutableTreeNode usedGeneCentroidNode = new DefaultMutableTreeNode(new LeafInfo("Used Exp Centroid Graph", (IViewer)expCentroidViewer, (Object)new CentroidUserObject(0, 0)));
                DefaultMutableTreeNode usedGeneExpressionNode = new DefaultMutableTreeNode(new LeafInfo("Used Exp Expression Graph ", (IViewer)expCentroidViewer, (Object)new CentroidUserObject(0, 1)));
                DefaultMutableTreeNode unusedGeneCentroidNode = new DefaultMutableTreeNode(new LeafInfo("Unused Exp Centroid Graph", (IViewer)expCentroidViewer, (Object)new CentroidUserObject(1, 0)));
                DefaultMutableTreeNode unusedGeneExpressionNode = new DefaultMutableTreeNode(new LeafInfo("Unused Exp Expression Graph ", (IViewer)expCentroidViewer, (Object)new CentroidUserObject(1, 1)));
                centroidNode.add(usedGeneCentroidNode);
                expressionNode.add(usedGeneExpressionNode);
                centroidNode.add(unusedGeneCentroidNode);
                expressionNode.add(unusedGeneExpressionNode);
            }
        } else {
            int i;
            DAMExperimentCentroidViewer expCentroidViewer = new DAMExperimentCentroidViewer(this.experiment, this.clusters);
            expCentroidViewer.setMeans(this.means.A);
            expCentroidViewer.setVariances(this.variances.A);
            for (i = 0; i < this.numberOfClasses; ++i) {
                centroidNodeArray[0].add(new DefaultMutableTreeNode(new LeafInfo("Class " + String.valueOf(i + 1), (IViewer)expCentroidViewer, (Object)new CentroidUserObject(i, 0))));
                expressionNodeArray[0].add(new DefaultMutableTreeNode(new LeafInfo("Class " + String.valueOf(i + 1), (IViewer)expCentroidViewer, (Object)new CentroidUserObject(i, 1))));
            }
            for (i = this.numberOfClasses; i < 2 * this.numberOfClasses; ++i) {
                centroidNodeArray[1].add(new DefaultMutableTreeNode(new LeafInfo("Class " + String.valueOf(i + 1 - this.numberOfClasses), (IViewer)expCentroidViewer, (Object)new CentroidUserObject(i, 0))));
                expressionNodeArray[1].add(new DefaultMutableTreeNode(new LeafInfo("Class " + String.valueOf(i + 1 - this.numberOfClasses), (IViewer)expCentroidViewer, (Object)new CentroidUserObject(i, 1))));
            }
            for (i = 2 * this.numberOfClasses; i < 3 * this.numberOfClasses; ++i) {
                centroidNodeArray[2].add(new DefaultMutableTreeNode(new LeafInfo("Class " + String.valueOf(i + 1 - 2 * this.numberOfClasses), (IViewer)expCentroidViewer, (Object)new CentroidUserObject(i, 0))));
                expressionNodeArray[2].add(new DefaultMutableTreeNode(new LeafInfo("Class " + String.valueOf(i + 1 - 2 * this.numberOfClasses), (IViewer)expCentroidViewer, (Object)new CentroidUserObject(i, 1))));
            }
            DAMExperimentCentroidsViewer expCentroidsViewer = new DAMExperimentCentroidsViewer(this.experiment, this.clusters);
            expCentroidsViewer.setMeans(this.means.A);
            expCentroidsViewer.setVariances(this.variances.A);
            for (int i3 = 0; i3 < centroidNodeArray.length; ++i3) {
                centroidNode.add(centroidNodeArray[i3]);
                expressionNode.add(expressionNodeArray[i3]);
            }
            DAMCentroidViewer geneCentroidViewer = new DAMCentroidViewer(this.experiment, this.geneClusters);
            geneCentroidViewer.setMeans(this.means_used.A);
            geneCentroidViewer.setVariances(this.variances_used.A);
            if (this.preSelectGenes) {
                DefaultMutableTreeNode usedGeneCentroidNode = new DefaultMutableTreeNode(new LeafInfo("Used Gene Centroid Graph", (IViewer)geneCentroidViewer, (Object)new CentroidUserObject(0, 0)));
                DefaultMutableTreeNode usedGeneExpressionNode = new DefaultMutableTreeNode(new LeafInfo("Used Gene Expression Graph ", (IViewer)geneCentroidViewer, (Object)new CentroidUserObject(0, 1)));
                DefaultMutableTreeNode unusedGeneCentroidNode = new DefaultMutableTreeNode(new LeafInfo("Unused Gene Centroid Graph", (IViewer)geneCentroidViewer, (Object)new CentroidUserObject(1, 0)));
                DefaultMutableTreeNode unusedGeneExpressionNode = new DefaultMutableTreeNode(new LeafInfo("Unused Gene Expression Graph ", (IViewer)geneCentroidViewer, (Object)new CentroidUserObject(1, 1)));
                centroidNode.add(usedGeneCentroidNode);
                expressionNode.add(usedGeneExpressionNode);
                centroidNode.add(unusedGeneCentroidNode);
                expressionNode.add(unusedGeneExpressionNode);
            }
        }
        root.add(centroidNode);
        root.add(expressionNode);
    }

    private void addClusterInfo(DefaultMutableTreeNode root) {
        DefaultMutableTreeNode node = new DefaultMutableTreeNode("Cluster Information");
        if (this.classifyGenes) {
            node.add(new DefaultMutableTreeNode(new LeafInfo("Genes in Classes (#,%)", (IViewer)new DAMInfoViewer(this.clusters, this.experiment.getNumberOfGenes(), this.numberOfClasses, this.usedGeneIndices.length, this.unusedGeneIndices.length, this.alpha, this.algorithmSelection, this.isPDA, this.preSelectGenes))));
        } else {
            node.add(new DefaultMutableTreeNode(new LeafInfo("Samples in Classes (#,%)", (IViewer)new DAMInfoViewer(this.clusters, this.experiment.getNumberOfSamples(), false, this.numberOfClasses, this.usedGeneIndices.length, this.unusedGeneIndices.length, this.alpha, this.algorithmSelection, this.isPDA, this.preSelectGenes))));
        }
        root.add(node);
    }

    private void addExpressionImages(DefaultMutableTreeNode root) {
        int i;
        DefaultMutableTreeNode node = new DefaultMutableTreeNode("Expression Images");
        DefaultMutableTreeNode[] nodeArray = new DefaultMutableTreeNode[]{new DefaultMutableTreeNode("Classifiers"), new DefaultMutableTreeNode("Classified"), new DefaultMutableTreeNode("Classifiers + Classified")};
        Object expViewer = this.classifyGenes ? new DAMExperimentViewer(this.experiment, this.clusters) : new DAMExperimentClusterViewer(this.experiment, this.clusters);
        for (i = 0; i < this.numberOfClasses; ++i) {
            nodeArray[0].add(new DefaultMutableTreeNode(new LeafInfo("Class " + String.valueOf(i + 1), (IViewer)expViewer, (Object)new Integer(i))));
        }
        for (i = this.numberOfClasses; i < 2 * this.numberOfClasses; ++i) {
            nodeArray[1].add(new DefaultMutableTreeNode(new LeafInfo("Class " + String.valueOf(i + 1 - this.numberOfClasses), (IViewer)expViewer, (Object)new Integer(i))));
        }
        for (i = 2 * this.numberOfClasses; i < 3 * this.numberOfClasses; ++i) {
            nodeArray[2].add(new DefaultMutableTreeNode(new LeafInfo("Class " + String.valueOf(i + 1 - 2 * this.numberOfClasses), (IViewer)expViewer, (Object)new Integer(i))));
        }
        for (i = 0; i < nodeArray.length; ++i) {
            node.add(nodeArray[i]);
        }
        DAMExperimentViewer unusedGeneExpViewer = new DAMExperimentViewer(this.unusedExperiment, null);
        DAMExperimentViewer usedGeneExpViewer = new DAMExperimentViewer(this.usedExperiment, null);
        if (this.preSelectGenes) {
            if (this.classifyGenes) {
                node.add(new DefaultMutableTreeNode(new LeafInfo("Used Exp Expression", (IViewer)usedGeneExpViewer)));
                node.add(new DefaultMutableTreeNode(new LeafInfo("Unused Exp Expression", (IViewer)unusedGeneExpViewer)));
            } else {
                node.add(new DefaultMutableTreeNode(new LeafInfo("Used Gene Expression", (IViewer)usedGeneExpViewer)));
                node.add(new DefaultMutableTreeNode(new LeafInfo("Unused Gene Expression", (IViewer)unusedGeneExpViewer)));
            }
        }
        root.add(node);
    }

    private class Listener
    extends DialogListener
    implements AlgorithmListener {
        private Listener() {
        }

        public void valueChanged(AlgorithmEvent event) {
            DAMGUI.this.logger.append(event.getDescription());
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String command = e.getActionCommand();
            if (command.equals("cancel-command")) {
                DAMGUI.this.algorithm.abort();
                DAMGUI.this.logger.dispose();
            }
        }

        @Override
        public void windowClosing(WindowEvent e) {
            DAMGUI.this.algorithm.abort();
            DAMGUI.this.logger.dispose();
        }
    }
}

