/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.dam;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import org.tigr.microarray.mev.cluster.gui.Experiment;
import org.tigr.microarray.mev.cluster.gui.IFramework;
import org.tigr.microarray.mev.cluster.gui.impl.dam.DAMClassificationEditor;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.AlgorithmDialog;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.HCLSelectionPanel;

public class DAMFirstDialog
extends AlgorithmDialog {
    boolean okPressed = false;
    JRadioButton genesButton;
    JRadioButton expsButton;
    JRadioButton createNewTrgSetButton;
    JRadioButton useExistTrgSetButton;
    JCheckBox useVarianceFilterBox;
    JCheckBox useCorrelFilterBox;
    JTextField numGenesField;
    JTextField pValueField;
    JTextField numClassesField;
    JTextField numNeighborsField;
    JTextField numPermsField;
    JLabel varLabel;
    JLabel corrLabel;
    JLabel numPermsLabel;
    HCLSelectionPanel hclOpsPanel;
    IFramework framework;
    Experiment experiment;
    DAMClassificationEditor damEditor;
    int numExps;
    int numGenes;

    public DAMFirstDialog(JFrame parentFrame, boolean modality, IFramework framework_1) {
        super(parentFrame, "DAM Classification", modality);
        this.okButton.setText("Next >");
        this.setBounds(0, 0, 550, 600);
        this.setBackground(Color.white);
        this.setDefaultCloseOperation(2);
        this.framework = framework_1;
        this.experiment = this.framework.getData().getExperiment();
        this.numExps = this.experiment.getNumberOfSamples();
        this.numGenes = this.experiment.getNumberOfGenes();
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(gridbag);
        this.useVarianceFilterBox = new JCheckBox("Use variance filter (if unchecked, use all genes)", false);
        this.useCorrelFilterBox = new JCheckBox("Use correlation filter", false);
        JPanel genesOrExpsPanel = new JPanel();
        genesOrExpsPanel.setBackground(Color.white);
        genesOrExpsPanel.setBorder(new TitledBorder("Classify genes or experiments"));
        GridBagLayout grid1 = new GridBagLayout();
        genesOrExpsPanel.setLayout(grid1);
        this.genesButton = new JRadioButton("Classify genes", true);
        this.genesButton.setBackground(Color.white);
        this.genesButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DAMFirstDialog.this.useVarianceFilterBox.setText("Use variance filter (if unchecked, use all genes)");
                DAMFirstDialog.this.varLabel.setText("          Use only the following number of highest-variance genes: ");
            }
        });
        this.expsButton = new JRadioButton("Classify experiments", false);
        this.expsButton.setBackground(Color.white);
        this.expsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DAMFirstDialog.this.useVarianceFilterBox.setText("Use variance filter (if unchecked, use all expts)");
                DAMFirstDialog.this.varLabel.setText("          Use only the following number of highest-variance expts: ");
            }
        });
        ButtonGroup genesOrExpsGroup = new ButtonGroup();
        genesOrExpsGroup.add(this.genesButton);
        genesOrExpsGroup.add(this.expsButton);
        this.buildConstraints(constraints, 0, 0, 1, 1, 50, 100);
        grid1.setConstraints(this.genesButton, constraints);
        genesOrExpsPanel.add(this.genesButton);
        this.buildConstraints(constraints, 1, 0, 1, 1, 50, 0);
        grid1.setConstraints(this.expsButton, constraints);
        genesOrExpsPanel.add(this.expsButton);
        this.buildConstraints(constraints, 0, 0, 1, 1, 100, 10);
        constraints.fill = 1;
        gridbag.setConstraints(genesOrExpsPanel, constraints);
        mainPanel.add(genesOrExpsPanel);
        constraints.fill = 0;
        JPanel variancePanel = new JPanel();
        variancePanel.setBackground(Color.white);
        variancePanel.setBorder(new TitledBorder("Variance filter"));
        GridBagLayout grid3 = new GridBagLayout();
        variancePanel.setLayout(grid3);
        this.useVarianceFilterBox.setBackground(Color.white);
        this.varLabel = new JLabel("          Use only the following number of highest-variance genes: ");
        this.varLabel.setEnabled(false);
        this.numGenesField = new JTextField("1000", 7);
        this.numGenesField.setEnabled(false);
        this.numGenesField.setBackground(Color.gray);
        this.useVarianceFilterBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                if (evt.getStateChange() == 2) {
                    DAMFirstDialog.this.varLabel.setEnabled(false);
                    DAMFirstDialog.this.numGenesField.setEnabled(false);
                    DAMFirstDialog.this.numGenesField.setBackground(Color.gray);
                } else {
                    DAMFirstDialog.this.varLabel.setEnabled(true);
                    DAMFirstDialog.this.numGenesField.setEnabled(true);
                    DAMFirstDialog.this.numGenesField.setBackground(Color.white);
                }
            }
        });
        constraints.anchor = 17;
        this.buildConstraints(constraints, 0, 0, 1, 1, 100, 50);
        grid3.setConstraints(this.useVarianceFilterBox, constraints);
        variancePanel.add(this.useVarianceFilterBox);
        this.buildConstraints(constraints, 0, 1, 1, 1, 70, 50);
        grid3.setConstraints(this.varLabel, constraints);
        variancePanel.add(this.varLabel);
        this.buildConstraints(constraints, 1, 1, 1, 1, 30, 0);
        grid3.setConstraints(this.numGenesField, constraints);
        variancePanel.add(this.numGenesField);
        this.buildConstraints(constraints, 0, 1, 1, 1, 100, 20);
        constraints.fill = 1;
        gridbag.setConstraints(variancePanel, constraints);
        mainPanel.add(variancePanel);
        constraints.fill = 0;
        JPanel correlPanel = new JPanel();
        correlPanel.setBackground(Color.white);
        correlPanel.setBorder(new TitledBorder("Correlation filter"));
        GridBagLayout grid2 = new GridBagLayout();
        correlPanel.setLayout(grid2);
        this.useCorrelFilterBox.setBackground(Color.white);
        this.corrLabel = new JLabel("          Cutoff p-value for correlation: ");
        this.corrLabel.setEnabled(false);
        this.numPermsLabel = new JLabel("          Number of permutations for correlation test: ");
        this.numPermsLabel.setEnabled(false);
        this.pValueField = new JTextField("0.01", 7);
        this.pValueField.setEnabled(false);
        this.pValueField.setBackground(Color.gray);
        this.numPermsField = new JTextField("1000", 7);
        this.numPermsField.setEnabled(false);
        this.numPermsField.setBackground(Color.gray);
        this.useCorrelFilterBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                if (evt.getStateChange() == 2) {
                    DAMFirstDialog.this.corrLabel.setEnabled(false);
                    DAMFirstDialog.this.numPermsLabel.setEnabled(false);
                    DAMFirstDialog.this.pValueField.setEnabled(false);
                    DAMFirstDialog.this.pValueField.setBackground(Color.gray);
                    DAMFirstDialog.this.numPermsField.setEnabled(false);
                    DAMFirstDialog.this.numPermsField.setBackground(Color.gray);
                } else {
                    DAMFirstDialog.this.corrLabel.setEnabled(true);
                    DAMFirstDialog.this.numPermsLabel.setEnabled(true);
                    DAMFirstDialog.this.pValueField.setEnabled(true);
                    DAMFirstDialog.this.pValueField.setBackground(Color.white);
                    DAMFirstDialog.this.numPermsField.setEnabled(true);
                    DAMFirstDialog.this.numPermsField.setBackground(Color.white);
                }
            }
        });
        this.buildConstraints(constraints, 0, 0, 1, 1, 100, 34);
        grid2.setConstraints(this.useCorrelFilterBox, constraints);
        correlPanel.add(this.useCorrelFilterBox);
        this.buildConstraints(constraints, 0, 1, 1, 1, 70, 33);
        grid2.setConstraints(this.corrLabel, constraints);
        correlPanel.add(this.corrLabel);
        this.buildConstraints(constraints, 1, 1, 1, 1, 30, 0);
        grid2.setConstraints(this.pValueField, constraints);
        correlPanel.add(this.pValueField);
        this.buildConstraints(constraints, 0, 2, 1, 1, 70, 33);
        grid2.setConstraints(this.numPermsLabel, constraints);
        correlPanel.add(this.numPermsLabel);
        this.buildConstraints(constraints, 1, 2, 1, 1, 30, 0);
        grid2.setConstraints(this.numPermsField, constraints);
        correlPanel.add(this.numPermsField);
        this.buildConstraints(constraints, 0, 2, 1, 1, 100, 20);
        constraints.fill = 1;
        gridbag.setConstraints(correlPanel, constraints);
        mainPanel.add(correlPanel);
        constraints.fill = 0;
        JPanel damParamPanel = new JPanel();
        damParamPanel.setBackground(Color.white);
        damParamPanel.setBorder(new TitledBorder("DAM classification parameters"));
        GridBagLayout grid4 = new GridBagLayout();
        damParamPanel.setLayout(grid4);
        JLabel numClassesLabel = new JLabel("          Number of classes");
        this.buildConstraints(constraints, 0, 0, 1, 1, 50, 50);
        grid4.setConstraints(numClassesLabel, constraints);
        damParamPanel.add(numClassesLabel);
        this.numClassesField = new JTextField("5", 7);
        this.buildConstraints(constraints, 1, 0, 1, 1, 50, 0);
        grid4.setConstraints(this.numClassesField, constraints);
        damParamPanel.add(this.numClassesField);
        JLabel numNeighborsLabel = new JLabel("          Number of neighbors");
        this.buildConstraints(constraints, 0, 1, 1, 1, 50, 50);
        grid4.setConstraints(numNeighborsLabel, constraints);
        damParamPanel.add(numNeighborsLabel);
        this.numNeighborsField = new JTextField("3", 7);
        this.buildConstraints(constraints, 1, 1, 1, 1, 50, 0);
        grid4.setConstraints(this.numNeighborsField, constraints);
        damParamPanel.add(this.numNeighborsField);
        this.buildConstraints(constraints, 0, 3, 1, 1, 100, 20);
        constraints.fill = 1;
        gridbag.setConstraints(damParamPanel, constraints);
        mainPanel.add(damParamPanel);
        constraints.fill = 0;
        JPanel makeTrainingSetPanel = new JPanel();
        makeTrainingSetPanel.setBackground(Color.white);
        makeTrainingSetPanel.setBorder(new TitledBorder("Create / import training set"));
        GridBagLayout grid5 = new GridBagLayout();
        makeTrainingSetPanel.setLayout(grid5);
        this.createNewTrgSetButton = new JRadioButton("Create new training set from data", true);
        this.createNewTrgSetButton.setBackground(Color.white);
        this.useExistTrgSetButton = new JRadioButton("Use previously created training set from file", false);
        this.useExistTrgSetButton.setBackground(Color.white);
        ButtonGroup newOrExisting = new ButtonGroup();
        newOrExisting.add(this.createNewTrgSetButton);
        newOrExisting.add(this.useExistTrgSetButton);
        this.buildConstraints(constraints, 0, 0, 1, 1, 100, 50);
        constraints.anchor = 10;
        grid5.setConstraints(this.createNewTrgSetButton, constraints);
        makeTrainingSetPanel.add(this.createNewTrgSetButton);
        this.buildConstraints(constraints, 0, 1, 1, 1, 0, 50);
        grid5.setConstraints(this.useExistTrgSetButton, constraints);
        makeTrainingSetPanel.add(this.useExistTrgSetButton);
        this.buildConstraints(constraints, 0, 4, 1, 1, 100, 20);
        constraints.anchor = 17;
        constraints.fill = 1;
        gridbag.setConstraints(makeTrainingSetPanel, constraints);
        mainPanel.add(makeTrainingSetPanel);
        constraints.fill = 0;
        this.hclOpsPanel = new HCLSelectionPanel();
        this.buildConstraints(constraints, 0, 5, 1, 1, 100, 10);
        constraints.fill = 1;
        gridbag.setConstraints(this.hclOpsPanel, constraints);
        mainPanel.add(this.hclOpsPanel);
        constraints.fill = 0;
        this.addContent(mainPanel);
        EventListener listener = new EventListener();
        this.setActionListeners(listener);
        this.addWindowListener(listener);
    }

    @Override
    public void setVisible(boolean visible) {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((screenSize.width - this.getSize().width) / 2, (screenSize.height - this.getSize().height) / 2);
        super.setVisible(visible);
    }

    void buildConstraints(GridBagConstraints gbc, int gx, int gy, int gw, int gh, int wx, int wy) {
        gbc.gridx = gx;
        gbc.gridy = gy;
        gbc.gridwidth = gw;
        gbc.gridheight = gh;
        gbc.weightx = wx;
        gbc.weighty = wy;
    }

    public boolean isOkPressed() {
        return this.okPressed;
    }

    public boolean drawTrees() {
        return this.hclOpsPanel.isHCLSelected();
    }

    public boolean classifyGenes() {
        return this.genesButton.isSelected();
    }

    public int getNumClasses() {
        String s = this.numClassesField.getText();
        return Integer.parseInt(s);
    }

    public boolean createNewTrgSet() {
        return this.createNewTrgSetButton.isSelected();
    }

    public boolean useVarianceFilter() {
        return this.useVarianceFilterBox.isSelected();
    }

    public int getNumVectors() {
        return Integer.parseInt(this.numGenesField.getText());
    }

    public boolean useCorrelFilter() {
        return this.useCorrelFilterBox.isSelected();
    }

    public double getCorrPValue() {
        return Double.parseDouble(this.pValueField.getText());
    }

    public int getNumPerms() {
        return Integer.parseInt(this.numPermsField.getText());
    }

    public int getNumNeighbors() {
        return Integer.parseInt(this.numNeighborsField.getText());
    }

    public class EventListener
    extends WindowAdapter
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent ae) {
            String command = ae.getActionCommand();
            if (command.equals("ok-command")) {
                try {
                    int val3;
                    if (DAMFirstDialog.this.useVarianceFilterBox.isSelected()) {
                        int val = new Integer(DAMFirstDialog.this.numGenesField.getText());
                        if (DAMFirstDialog.this.genesButton.isSelected()) {
                            if (val <= 0 || val > DAMFirstDialog.this.numGenes) {
                                JOptionPane.showMessageDialog(DAMFirstDialog.this, "Number of highest-variance genes must be > 0 and <= " + DAMFirstDialog.this.numGenes, "Error!", 2);
                                return;
                            }
                        } else if (val <= 0 || val > DAMFirstDialog.this.numExps) {
                            JOptionPane.showMessageDialog(DAMFirstDialog.this, "Number of highest-variance expts must be > 0 and <= " + DAMFirstDialog.this.numExps, "Error!", 2);
                            return;
                        }
                    }
                    if (DAMFirstDialog.this.useCorrelFilterBox.isSelected()) {
                        double val2 = new Double(DAMFirstDialog.this.pValueField.getText());
                        if (val2 < 0.0 || val2 > 1.0) {
                            JOptionPane.showMessageDialog(DAMFirstDialog.this, "Correlation p-value must be between 0 and 1", "Error!", 2);
                            return;
                        }
                        double validateNumPerms = new Double(DAMFirstDialog.this.numPermsField.getText());
                        if (validateNumPerms <= 0.0) {
                            JOptionPane.showMessageDialog(DAMFirstDialog.this, "Number of permutations must be > 0", "Error!", 2);
                            return;
                        }
                    }
                    if (((val3 = new Integer(DAMFirstDialog.this.numClassesField.getText()).intValue()) <= 0 || val3 >= DAMFirstDialog.this.numGenes) && DAMFirstDialog.this.genesButton.isSelected()) {
                        JOptionPane.showMessageDialog(DAMFirstDialog.this, "Number of classes must be > 0 and < " + DAMFirstDialog.this.numGenes, "Error!", 2);
                        return;
                    }
                    if ((val3 <= 0 || val3 >= DAMFirstDialog.this.numExps) && DAMFirstDialog.this.expsButton.isSelected()) {
                        JOptionPane.showMessageDialog(DAMFirstDialog.this, "Number of classes must be > 0 and < " + DAMFirstDialog.this.numExps, "Error!", 2);
                        return;
                    }
                    int val4 = new Integer(DAMFirstDialog.this.numNeighborsField.getText());
                    if (DAMFirstDialog.this.genesButton.isSelected()) {
                        if (val4 <= 0 || val4 > DAMFirstDialog.this.numGenes) {
                            JOptionPane.showMessageDialog(DAMFirstDialog.this, "Number of neighbors must be > 0 and <= " + DAMFirstDialog.this.numGenes, "Error!", 2);
                            return;
                        }
                    } else if (val4 <= 0 || val4 > DAMFirstDialog.this.numExps) {
                        JOptionPane.showMessageDialog(DAMFirstDialog.this, "Number of neighbors must be > 0 and <= " + DAMFirstDialog.this.numExps, "Error!", 2);
                        return;
                    }
                    DAMFirstDialog.this.okPressed = true;
                    DAMFirstDialog.this.dispose();
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(DAMFirstDialog.this, "Invalid format for at least one parameter", "Error!", 2);
                }
            } else if (command.equals("reset-command")) {
                DAMFirstDialog.this.okPressed = false;
                DAMFirstDialog.this.genesButton.setSelected(true);
                DAMFirstDialog.this.expsButton.setSelected(false);
                DAMFirstDialog.this.useVarianceFilterBox.setSelected(false);
                DAMFirstDialog.this.useCorrelFilterBox.setSelected(false);
                DAMFirstDialog.this.useVarianceFilterBox.setText("Use variance filter (if unchecked, use all genes)");
                DAMFirstDialog.this.varLabel.setText("          Use only the following number of highest-variance genes: ");
                DAMFirstDialog.this.numGenesField.setText("1000");
                DAMFirstDialog.this.pValueField.setText("0.01");
                DAMFirstDialog.this.numPermsField.setText("1000");
                DAMFirstDialog.this.numClassesField.setText("5");
                DAMFirstDialog.this.numNeighborsField.setText("3");
                DAMFirstDialog.this.hclOpsPanel.setHCLSelected(false);
            } else if (command.equals("cancel-command")) {
                DAMFirstDialog.this.okPressed = false;
                DAMFirstDialog.this.dispose();
            } else if (command.equals("info-command")) {
                // empty if block
            }
        }
    }
}

