/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.dam;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.ListSelectionModel;
import javax.swing.border.EtchedBorder;
import javax.swing.event.TableColumnModelListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.tigr.microarray.mev.TMEV;
import org.tigr.microarray.mev.cluster.gui.IData;
import org.tigr.microarray.mev.cluster.gui.IFramework;
import org.tigr.microarray.mev.cluster.gui.impl.dam.DAMSearchDialog;
import org.tigr.microarray.mev.cluster.gui.impl.dam.DAMSecondDialog;

public class DAMClassificationEditor
extends JFrame {
    IFramework framework;
    IData data;
    boolean classifyGenes;
    private boolean stopHere = true;
    private boolean nextPressed = false;
    private boolean cancelPressed = false;
    private boolean incompatible = false;
    private boolean fileSaved = false;
    private boolean fileOpened = false;
    int numberOfClasses;
    String[] fieldNames;
    int numGenes;
    int numExps;
    JTable damClassTable;
    DAMClassTableModel damTabModel;
    JMenuBar menuBar;
    JMenu fileMenu;
    JMenu editMenu;
    JMenu toolsMenu;
    JMenu assignSubMenu;
    JMenu sortAscMenu;
    JMenu sortDescMenu;
    JMenuItem openItem;
    JMenuItem closeItem;
    JMenuItem selectAllItem;
    JMenuItem searchItem;
    JMenuItem sortByClassItem;
    JMenuItem origOrderItem;
    JMenuItem[] classItem;
    JMenuItem[] labelsAscItem;
    JMenuItem[] labelsDescItem;
    JRadioButton saveButton;
    JRadioButton doNotSaveButton;
    JButton nextButton;
    JButton cancelButton;
    JFrame mainFrame;
    DAMSearchDialog searchDialog;
    Object[][] origData;

    public DAMClassificationEditor(IFramework framework, boolean classifyGenes, int numberOfClasses) {
        int i;
        int i2;
        this.setTitle("DAM Classification Editor");
        this.mainFrame = (JFrame)framework.getFrame();
        this.setBounds(0, 0, 550, 800);
        this.setBackground(Color.white);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                DAMClassificationEditor.this.closeDialog(evt);
            }
        });
        this.setDefaultCloseOperation(0);
        this.framework = framework;
        this.data = framework.getData();
        this.numGenes = this.data.getExperiment().getNumberOfGenes();
        this.numExps = this.data.getExperiment().getNumberOfSamples();
        this.fieldNames = this.data.getFieldNames();
        this.classifyGenes = classifyGenes;
        this.numberOfClasses = numberOfClasses;
        this.menuBar = new JMenuBar();
        this.setJMenuBar(this.menuBar);
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.fill = 1;
        JPanel pane = new JPanel();
        pane.setLayout(gridbag);
        JPanel tablePanel = new JPanel();
        GridBagLayout grid1 = new GridBagLayout();
        tablePanel.setLayout(grid1);
        this.damTabModel = new DAMClassTableModel();
        this.damClassTable = new JTable(this.damTabModel);
        this.damClassTable.setAutoResizeMode(0);
        TableColumn column = null;
        for (int i3 = 0; i3 < this.damTabModel.getColumnCount(); ++i3) {
            column = this.damClassTable.getColumnModel().getColumn(i3);
            column.setMinWidth(30);
        }
        this.damClassTable.setColumnModel(new DAMClassTableColumnModel(this.damClassTable.getColumnModel()));
        this.damClassTable.getModel().addTableModelListener(new ClassSelectionListener());
        this.searchDialog = new DAMSearchDialog(JOptionPane.getFrameForComponent(this), this.damClassTable, numberOfClasses, false);
        JScrollPane scroll = new JScrollPane(this.damClassTable);
        this.buildConstraints(constraints, 0, 0, 1, 1, 100, 100);
        grid1.setConstraints(scroll, constraints);
        tablePanel.add(scroll);
        this.buildConstraints(constraints, 0, 0, 1, 1, 100, 90);
        gridbag.setConstraints(tablePanel, constraints);
        pane.add(tablePanel);
        JPanel bottomPanel = new JPanel();
        bottomPanel.setBorder(new EtchedBorder());
        bottomPanel.setBackground(Color.white);
        GridBagLayout grid2 = new GridBagLayout();
        bottomPanel.setLayout(grid2);
        this.saveButton = new JRadioButton("Save classification to file", true);
        this.saveButton.setBackground(Color.white);
        this.doNotSaveButton = new JRadioButton("Do not save classification to file", false);
        this.doNotSaveButton.setBackground(Color.white);
        ButtonGroup saveOrNot = new ButtonGroup();
        saveOrNot.add(this.saveButton);
        saveOrNot.add(this.doNotSaveButton);
        final JFileChooser fc = new JFileChooser(TMEV.getDataPath());
        fc.setDialogTitle("Save classification");
        this.cancelButton = new JButton("Cancel >");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DAMClassificationEditor.this.dispose();
            }
        });
        this.nextButton = new JButton("Next >");
        this.nextButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                if (DAMClassificationEditor.this.doNotSaveButton.isSelected()) {
                    DAMClassificationEditor.this.dispose();
                    DAMClassificationEditor.this.stopHere = false;
                    DAMClassificationEditor.this.nextPressed = true;
                } else {
                    int returnVal = fc.showSaveDialog(DAMClassificationEditor.this);
                    if (returnVal == 0) {
                        File file = fc.getSelectedFile();
                        DAMClassificationEditor.this.saveToFile(file);
                        DAMSecondDialog kSecDialog = new DAMSecondDialog(DAMClassificationEditor.this.mainFrame, true);
                        kSecDialog.setVisible(true);
                        if (!kSecDialog.proceed()) {
                            DAMClassificationEditor.this.stopHere = true;
                        } else {
                            DAMClassificationEditor.this.stopHere = false;
                        }
                        DAMClassificationEditor.this.incompatible = false;
                        DAMClassificationEditor.this.fileSaved = true;
                        if (DAMClassificationEditor.this.stopHere) {
                            DAMClassificationEditor.this.nextPressed = false;
                            DAMClassificationEditor.this.setVisible(true);
                        } else {
                            DAMClassificationEditor.this.nextPressed = true;
                            DAMClassificationEditor.this.dispose();
                        }
                    }
                }
            }
        });
        constraints.fill = 0;
        this.buildConstraints(constraints, 0, 0, 1, 1, 100, 33);
        grid2.setConstraints(this.saveButton, constraints);
        bottomPanel.add(this.saveButton);
        this.buildConstraints(constraints, 0, 1, 1, 1, 0, 33);
        grid2.setConstraints(this.doNotSaveButton, constraints);
        bottomPanel.add(this.doNotSaveButton);
        this.buildConstraints(constraints, 0, 2, 1, 1, 0, 34);
        grid2.setConstraints(this.nextButton, constraints);
        bottomPanel.add(this.nextButton);
        constraints.fill = 1;
        this.buildConstraints(constraints, 0, 1, 1, 1, 0, 10);
        gridbag.setConstraints(bottomPanel, constraints);
        pane.add(bottomPanel);
        this.setContentPane(pane);
        if (classifyGenes) {
            this.labelsAscItem = new JMenuItem[this.fieldNames.length];
            this.labelsDescItem = new JMenuItem[this.fieldNames.length];
            for (i2 = 0; i2 < this.fieldNames.length; ++i2) {
                this.labelsAscItem[i2] = new JMenuItem(this.fieldNames[i2]);
                this.labelsDescItem[i2] = new JMenuItem(this.fieldNames[i2]);
            }
        } else {
            this.labelsAscItem = new JMenuItem[1];
            this.labelsAscItem[0] = new JMenuItem("Sample/Experiment Name");
            this.labelsDescItem = new JMenuItem[1];
            this.labelsDescItem[0] = new JMenuItem("Sample/Experiment Name");
        }
        for (i2 = 0; i2 < this.labelsAscItem.length; ++i2) {
            this.labelsAscItem[i2].addActionListener(new SortListener(true, false));
            this.labelsDescItem[i2].addActionListener(new SortListener(false, false));
        }
        this.classItem = new JMenuItem[numberOfClasses + 1];
        for (i2 = 0; i2 < numberOfClasses; ++i2) {
            this.classItem[i2] = new JMenuItem("Class " + (i2 + 1));
        }
        this.classItem[numberOfClasses] = new JMenuItem("Neutral");
        for (i2 = 0; i2 < this.classItem.length; ++i2) {
            this.classItem[i2].addActionListener(new AssignListener());
        }
        final JFileChooser fc1 = new JFileChooser(TMEV.getDataPath());
        fc1.setDialogTitle("Open Classification");
        this.fileMenu = new JMenu("File");
        this.openItem = new JMenuItem("Apply File");
        this.openItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                int returnVal = fc1.showOpenDialog(DAMClassificationEditor.this);
                if (returnVal == 0) {
                    File file = fc1.getSelectedFile();
                    DAMClassificationEditor.this.loadFromFile(file);
                    DAMClassificationEditor.this.fileOpened = true;
                    DAMClassificationEditor.this.nextPressed = false;
                }
            }
        });
        this.fileMenu.add(this.openItem);
        this.menuBar.add(this.fileMenu);
        this.editMenu = new JMenu("Edit");
        this.selectAllItem = new JMenuItem("Select all rows");
        this.selectAllItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DAMClassificationEditor.this.damClassTable.selectAll();
            }
        });
        this.editMenu.add(this.selectAllItem);
        this.assignSubMenu = new JMenu("Assign selected rows to");
        for (i = 0; i < this.classItem.length; ++i) {
            this.assignSubMenu.add(this.classItem[i]);
        }
        this.editMenu.add(this.assignSubMenu);
        this.menuBar.add(this.editMenu);
        this.toolsMenu = new JMenu("Tools");
        this.searchItem = new JMenuItem("Search");
        this.searchItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DAMClassificationEditor.this.searchTable();
            }
        });
        this.toolsMenu.add(this.searchItem);
        this.sortAscMenu = new JMenu("Sort ascending by");
        for (i = 0; i < this.labelsAscItem.length; ++i) {
            this.sortAscMenu.add(this.labelsAscItem[i]);
        }
        this.toolsMenu.add(this.sortAscMenu);
        this.sortDescMenu = new JMenu("Sort descending by");
        for (i = 0; i < this.labelsDescItem.length; ++i) {
            this.sortDescMenu.add(this.labelsDescItem[i]);
        }
        this.toolsMenu.add(this.sortDescMenu);
        this.sortByClassItem = new JMenuItem("Sort by classification");
        this.sortByClassItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DAMClassificationEditor.this.sortByClassification();
            }
        });
        this.toolsMenu.add(this.sortByClassItem);
        this.origOrderItem = new JMenuItem("Restore original ordering");
        this.origOrderItem.addActionListener(new SortListener(true, true));
        this.toolsMenu.add(this.origOrderItem);
        this.menuBar.add(this.toolsMenu);
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.cancelPressed = true;
        this.dispose();
    }

    void buildConstraints(GridBagConstraints gbc, int gx, int gy, int gw, int gh, int wx, int wy) {
        gbc.gridx = gx;
        gbc.gridy = gy;
        gbc.gridwidth = gw;
        gbc.gridheight = gh;
        gbc.weightx = wx;
        gbc.weighty = wy;
    }

    @Override
    public void setVisible(boolean visible) {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((screenSize.width - this.getSize().width) / 2, (screenSize.height - this.getSize().height) / 2);
        super.setVisible(visible);
    }

    public void sortByColumn(int column, boolean ascending, boolean originalOrder) {
        int j;
        int i;
        if (originalOrder) {
            int j2;
            int i2;
            Object[][] sortedData = new Object[this.damTabModel.getRowCount()][this.damTabModel.getColumnCount()];
            for (i2 = 0; i2 < sortedData.length; ++i2) {
                for (j2 = 0; j2 < sortedData[0].length; ++j2) {
                    sortedData[i2][j2] = this.origData[i2][j2];
                }
            }
            for (i2 = 0; i2 < sortedData.length; ++i2) {
                for (j2 = 0; j2 < sortedData[0].length; ++j2) {
                    this.damTabModel.setValueAt(sortedData[i2][j2], i2, j2);
                }
                this.validateTable(sortedData, i2);
            }
            return;
        }
        if (column < 0 || column > this.damTabModel.getColumnCount()) {
            return;
        }
        Object[][] sortedData = new Object[this.damTabModel.getRowCount()][this.damTabModel.getColumnCount()];
        Object[] sortFields = new SortableField[this.damTabModel.getRowCount()];
        for (int i3 = 0; i3 < sortFields.length; ++i3) {
            int origDataRow = (Integer)this.damTabModel.getValueAt(i3, 0);
            sortFields[i3] = new SortableField(origDataRow, column);
        }
        Arrays.sort(sortFields);
        int[] sortedIndices = new int[sortFields.length];
        for (i = 0; i < sortedIndices.length; ++i) {
            sortedIndices[i] = ((SortableField)sortFields[i]).getIndex();
        }
        if (!ascending) {
            sortedIndices = this.reverse(sortedIndices);
        }
        for (i = 0; i < sortedData.length; ++i) {
            for (j = 0; j < sortedData[i].length; ++j) {
                sortedData[i][j] = this.origData[sortedIndices[i]][j];
            }
        }
        for (i = 0; i < sortedData.length; ++i) {
            for (j = 0; j < sortedData[i].length; ++j) {
                this.damTabModel.setValueAt(sortedData[i][j], i, j);
            }
            this.validateTable(sortedData, i);
        }
        this.damClassTable.removeRowSelectionInterval(0, this.damClassTable.getRowCount() - 1);
    }

    private int[] reverse(int[] arr) {
        int[] revArr = new int[arr.length];
        int revCount = 0;
        int count = arr.length - 1;
        for (int i = 0; i < arr.length; ++i) {
            revArr[revCount] = arr[count];
            ++revCount;
            --count;
        }
        return revArr;
    }

    private void sortByClassification() {
        int j;
        int i;
        int i2;
        Vector[] classVectors = new Vector[this.numberOfClasses + 1];
        for (i2 = 0; i2 < classVectors.length; ++i2) {
            classVectors[i2] = new Vector();
        }
        block1: for (i2 = 0; i2 < this.damTabModel.getRowCount(); ++i2) {
            for (int j2 = 1; j2 <= this.numberOfClasses + 1; ++j2) {
                boolean b = (Boolean)this.damTabModel.getValueAt(i2, j2);
                if (!b) continue;
                classVectors[j2 - 1].add(new Integer(i2));
                continue block1;
            }
        }
        int[] sortedIndices = new int[this.damTabModel.getRowCount()];
        int counter = 0;
        for (int i3 = 0; i3 < classVectors.length; ++i3) {
            for (int j3 = 0; j3 < classVectors[i3].size(); ++j3) {
                sortedIndices[counter] = (Integer)classVectors[i3].get(j3);
                ++counter;
            }
        }
        Object[][] sortedData = new Object[this.damTabModel.getRowCount()][this.damTabModel.getColumnCount()];
        for (i = 0; i < sortedData.length; ++i) {
            for (j = 0; j < sortedData[0].length; ++j) {
                sortedData[i][j] = this.damTabModel.getValueAt(sortedIndices[i], j);
            }
        }
        for (i = 0; i < this.damTabModel.getRowCount(); ++i) {
            for (j = 0; j < this.damTabModel.getColumnCount(); ++j) {
                this.damTabModel.setValueAt(sortedData[i][j], i, j);
            }
            this.validateTable(sortedData, i);
        }
        this.damClassTable.removeRowSelectionInterval(0, this.damClassTable.getRowCount() - 1);
    }

    private void validateTable(Object[][] tabData, int row) {
        for (int i = 1; i <= this.numberOfClasses + 1; ++i) {
            boolean check = (Boolean)tabData[row][i];
            if (!check) continue;
            this.damTabModel.setValueAt(new Boolean(true), row, i);
            break;
        }
    }

    private void searchTable() {
        this.searchDialog.setVisible(true);
        this.searchDialog.toFront();
        this.searchDialog.setLocation(this.getLocation().x + 100, this.getLocation().y + 100);
    }

    private void saveToFile(File file) {
        try {
            PrintWriter pw = new PrintWriter(new FileWriter(file));
            Date currDate = new Date(System.currentTimeMillis());
            String dateString = currDate.toString();
            String userName = System.getProperty("user.name");
            pw.println("# Assignment File");
            pw.println("# User: " + userName + " Save Date: " + dateString);
            pw.println("#");
            pw.print("Module:\t");
            pw.println("DAM");
            for (int i = 1; i < this.numberOfClasses + 1; ++i) {
                pw.print("Group " + i + " Label:\t");
                pw.println("Class " + i);
            }
            pw.println("#");
            pw.println("Index\tName\tGroup Assignment");
            int numRows = this.damTabModel.getRowCount();
            for (int sample = 0; sample < numRows; ++sample) {
                pw.print(String.valueOf(sample + 1) + "\t");
                pw.print(this.damTabModel.getValueAt(sample, this.numberOfClasses + 2) + "\t");
                for (int j = 1; j <= this.numberOfClasses; ++j) {
                    if (!((Boolean)this.damTabModel.getValueAt(sample, j)).booleanValue()) continue;
                    pw.println("Class " + j);
                    break;
                }
                if (!((Boolean)this.damTabModel.getValueAt(sample, this.numberOfClasses + 1)).booleanValue()) continue;
                pw.println("Exclude");
            }
            pw.flush();
            pw.close();
        }
        catch (FileNotFoundException fnfe) {
            fnfe.printStackTrace();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    private void loadFromFile(File file) {
        try {
            Object[] optionst;
            String line;
            BufferedReader br = new BufferedReader(new FileReader(file));
            Vector<String> data = new Vector<String>();
            while ((line = br.readLine()) != null) {
                data.add(line.trim());
            }
            br.close();
            Vector<String> groupNames = new Vector<String>();
            Vector<Integer> sampleIndices = new Vector<Integer>();
            Vector<String> sampleNames = new Vector<String>();
            Vector<String> groupAssignments = new Vector<String>();
            for (int row = 0; row < data.size(); ++row) {
                line = (String)data.get(row);
                if (line.startsWith("#") || line.startsWith("SampleIndex")) continue;
                String[] lineArray = line.split("\t");
                if (lineArray[0].startsWith("Module:")) {
                    if (lineArray[1].equals("DAM")) continue;
                    optionst = new Object[]{"Continue", "Cancel"};
                    if (JOptionPane.showOptionDialog(null, "The saved file was saved using a different module, " + lineArray[1] + ". \n Would you like MeV to try to load it anyway?", "File type warning", 1, 3, null, optionst, optionst[0]) == 0) continue;
                    return;
                }
                if (lineArray[0].startsWith("Group ") && lineArray[0].endsWith("Label:")) {
                    groupNames.add(lineArray[1]);
                    continue;
                }
                try {
                    Integer.parseInt(lineArray[0]);
                }
                catch (NumberFormatException nfe) {
                    continue;
                }
                sampleIndices.add(new Integer(lineArray[0]));
                sampleNames.add(lineArray[1]);
                groupAssignments.add(lineArray[2]);
            }
            int numRows = this.damTabModel.getRowCount();
            if (numRows != sampleNames.size()) {
                System.out.println(numRows + "  " + sampleNames.size());
                System.out.println(numRows + " s length " + sampleNames.size());
                JOptionPane.showMessageDialog(this, "<html>Error -- number of samples designated in assignment file (" + String.valueOf(sampleNames.size()) + ")<br>" + "does not match the number of samples loaded in MeV (" + numRows + ").<br>" + "Assignments are not set.</html>", "File Compatibility Error", 0);
                this.incompatible = true;
                return;
            }
            if (this.numberOfClasses != groupNames.size()) {
                optionst = new Object[]{"Continue", "Cancel"};
                if (JOptionPane.showOptionDialog(null, "The saved file was saved using " + groupNames.size() + " classes.\nWould you like MeV to attempt to load selections into " + this.numberOfClasses + " classes?", "Class number warning", 1, 3, null, optionst, optionst[0]) == 1) {
                    return;
                }
            }
            int fileSampleIndex = 0;
            int groupIndex = 0;
            for (int sample = 0; sample < numRows; ++sample) {
                boolean doIndex = false;
                for (int i = 0; i < numRows; ++i) {
                    if (i == sample || !((String)this.damTabModel.getValueAt(sample, this.numberOfClasses + 2)).equals((String)this.damTabModel.getValueAt(i, this.numberOfClasses + 2))) continue;
                    doIndex = true;
                }
                try {
                    fileSampleIndex = sampleNames.indexOf((String)this.damTabModel.getValueAt(sample, this.numberOfClasses + 2));
                }
                catch (Exception e) {
                    e.printStackTrace();
                    fileSampleIndex = -1;
                }
                if (fileSampleIndex == -1) {
                    doIndex = true;
                }
                if (doIndex) {
                    this.setStateBasedOnIndex(groupAssignments, groupNames);
                    break;
                }
                String groupName = (String)groupAssignments.get(fileSampleIndex);
                groupIndex = groupNames.indexOf(groupName);
                if (groupIndex == -1 || groupIndex > this.numberOfClasses) {
                    groupIndex = this.numberOfClasses;
                }
                try {
                    this.damTabModel.setValueAt(new Boolean(true), sample, groupIndex + 1);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.damTabModel.setValueAt(new Boolean(true), sample, this.numberOfClasses + 1);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.incompatible = true;
            JOptionPane.showMessageDialog(this, "<html>The file format cannot be read.</html>", "File Compatibility Error", 0);
        }
    }

    private void setStateBasedOnIndex(Vector<String> groupAssignments, Vector<String> groupNames) {
        Object[] optionst = new Object[]{"Continue", "Cancel"};
        if (JOptionPane.showOptionDialog(null, "The saved file was saved using a different sample annotation or has duplicate annotation. \n Would you like MeV to try to load it by index order?", "File type warning", 1, 3, null, optionst, optionst[0]) == 1) {
            return;
        }
        int numRows = this.damTabModel.getRowCount();
        for (int sample = 0; sample < numRows; ++sample) {
            try {
                this.damTabModel.setValueAt(new Boolean(true), sample, groupNames.indexOf(groupAssignments.get(sample) + 1));
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                this.damTabModel.setValueAt(new Boolean(true), sample, this.numberOfClasses + 1);
            }
        }
    }

    public Vector[] getClassification() {
        Vector<Integer> indicesVector1 = new Vector<Integer>();
        Vector<Integer> indicesVector2 = new Vector<Integer>();
        Vector<Integer> classVector = new Vector<Integer>();
        Vector[] classVectorArray = new Vector[3];
        for (int i = 0; i < this.damTabModel.getRowCount(); ++i) {
            if (((Boolean)this.damTabModel.getValueAt(i, this.numberOfClasses + 1)).booleanValue()) {
                indicesVector2.add((Integer)this.damTabModel.getValueAt(i, 0));
                continue;
            }
            indicesVector1.add((Integer)this.damTabModel.getValueAt(i, 0));
            classVector.add(new Integer(this.getClass(i)));
        }
        classVectorArray[0] = indicesVector1;
        classVectorArray[1] = classVector;
        classVectorArray[2] = indicesVector2;
        return classVectorArray;
    }

    public boolean isNextPressed() {
        return this.nextPressed;
    }

    public boolean isCancelPressed() {
        return this.cancelPressed;
    }

    private int getClass(int row) {
        int i;
        for (i = 1; i <= this.numberOfClasses + 1 && !((Boolean)this.damTabModel.getValueAt(row, i)).booleanValue(); ++i) {
        }
        return i;
    }

    public boolean proceed() {
        return !this.stopHere;
    }

    public boolean fileIsIncompatible() {
        return this.incompatible;
    }

    public void showWarningMessage() {
        JTextArea area = new JTextArea();
        area.append("Proceed with this file?");
        area.append("\n");
        area.setEditable(false);
        area.setBackground(Color.gray.brighter());
        JOptionPane.showMessageDialog(this, area, "Warning", 2);
    }

    public class SortListener
    implements ActionListener {
        boolean asc;
        boolean origOrd;

        public SortListener(boolean asc, boolean origOrd) {
            this.asc = asc;
            this.origOrd = origOrd;
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            Object source = evt.getSource();
            if (source instanceof JMenuItem) {
                String key = ((JMenuItem)source).getText();
                int colToSort = DAMClassificationEditor.this.damTabModel.getColumnIndex(key);
                DAMClassificationEditor.this.sortByColumn(colToSort, this.asc, this.origOrd);
            }
        }
    }

    public class AssignListener
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent evt) {
            Object source = evt.getSource();
            if (source instanceof JMenuItem) {
                String key = ((JMenuItem)source).getText();
                int classCol = DAMClassificationEditor.this.damTabModel.getColumnIndex(key);
                int[] selectedRows = DAMClassificationEditor.this.damClassTable.getSelectedRows();
                int[] selectedIndices = new int[selectedRows.length];
                for (int i = 0; i < selectedRows.length; ++i) {
                    DAMClassificationEditor.this.damTabModel.setValueAt(new Boolean(true), selectedRows[i], classCol);
                }
            }
        }
    }

    private class SortableField
    implements Comparable {
        private String field;
        private int index;

        SortableField(int index, int column) {
            this.index = index;
            this.field = (String)DAMClassificationEditor.this.origData[index][column];
        }

        public int compareTo(Object other) {
            SortableField otherField = (SortableField)other;
            return this.field.compareTo(otherField.getField());
        }

        public int getIndex() {
            return this.index;
        }

        public String getField() {
            return this.field;
        }
    }

    class ClassSelectionListener
    implements TableModelListener {
        ClassSelectionListener() {
        }

        @Override
        public void tableChanged(TableModelEvent tme) {
            int selectedCol = tme.getColumn();
            int selectedRow = tme.getFirstRow();
            if (selectedCol < 1 || selectedCol > DAMClassificationEditor.this.numberOfClasses + 1) {
                return;
            }
            if (this.verifySelected(selectedRow, selectedCol)) {
                this.changeNeighbors(selectedRow, selectedCol);
            }
            int origDataRow = (Integer)DAMClassificationEditor.this.damTabModel.getValueAt(selectedRow, 0);
            DAMClassificationEditor.this.origData[origDataRow][selectedCol] = new Boolean(true);
            for (int i = 1; i <= DAMClassificationEditor.this.numberOfClasses + 1; ++i) {
                if (i == selectedCol) continue;
                DAMClassificationEditor.this.origData[origDataRow][i] = new Boolean(false);
            }
        }

        private void changeNeighbors(int first, int col) {
            for (int i = 1; i <= DAMClassificationEditor.this.numberOfClasses + 1; ++i) {
                if (i == col) continue;
                DAMClassificationEditor.this.damClassTable.setValueAt(new Boolean(false), first, i);
            }
        }

        private boolean verifySelected(int row, int col) {
            boolean selVal = (Boolean)DAMClassificationEditor.this.damClassTable.getValueAt(row, col);
            if (selVal) {
                return true;
            }
            Vector<Boolean> truthValues = new Vector<Boolean>();
            for (int i = 1; i <= DAMClassificationEditor.this.numberOfClasses + 1; ++i) {
                if (i == col) continue;
                boolean value = (Boolean)DAMClassificationEditor.this.damClassTable.getValueAt(row, i);
                truthValues.add(new Boolean(value));
            }
            boolean val1 = true;
            for (int i = 0; i < truthValues.size(); ++i) {
                boolean val2 = (Boolean)truthValues.get(i);
                if (!val2) continue;
                val1 = false;
                break;
            }
            if (val1) {
                DAMClassificationEditor.this.damClassTable.setValueAt(new Boolean(true), row, col);
            }
            return false;
        }
    }

    class DAMClassTableColumnModel
    implements TableColumnModel {
        TableColumnModel tcm;

        public DAMClassTableColumnModel(TableColumnModel TCM) {
            this.tcm = TCM;
        }

        @Override
        public void addColumn(TableColumn tableColumn) {
            this.tcm.addColumn(tableColumn);
        }

        @Override
        public void addColumnModelListener(TableColumnModelListener tableColumnModelListener) {
            this.tcm.addColumnModelListener(tableColumnModelListener);
        }

        @Override
        public TableColumn getColumn(int param) {
            return this.tcm.getColumn(param);
        }

        @Override
        public int getColumnCount() {
            return this.tcm.getColumnCount();
        }

        @Override
        public int getColumnIndex(Object obj) {
            return this.tcm.getColumnIndex(obj);
        }

        @Override
        public int getColumnIndexAtX(int param) {
            return this.tcm.getColumnIndexAtX(param);
        }

        @Override
        public int getColumnMargin() {
            return this.tcm.getColumnMargin();
        }

        @Override
        public boolean getColumnSelectionAllowed() {
            return this.tcm.getColumnSelectionAllowed();
        }

        public Enumeration getColumns() {
            return this.tcm.getColumns();
        }

        @Override
        public int getSelectedColumnCount() {
            return this.tcm.getSelectedColumnCount();
        }

        @Override
        public int[] getSelectedColumns() {
            return this.tcm.getSelectedColumns();
        }

        @Override
        public ListSelectionModel getSelectionModel() {
            return this.tcm.getSelectionModel();
        }

        @Override
        public int getTotalColumnWidth() {
            return this.tcm.getTotalColumnWidth();
        }

        @Override
        public void moveColumn(int from, int to) {
            if (from <= DAMClassificationEditor.this.numberOfClasses + 1 || to <= DAMClassificationEditor.this.numberOfClasses + 1) {
                return;
            }
            this.tcm.moveColumn(from, to);
        }

        @Override
        public void removeColumn(TableColumn tableColumn) {
            this.tcm.removeColumn(tableColumn);
        }

        @Override
        public void removeColumnModelListener(TableColumnModelListener tableColumnModelListener) {
            this.tcm.removeColumnModelListener(tableColumnModelListener);
        }

        @Override
        public void setColumnMargin(int param) {
            this.tcm.setColumnMargin(param);
        }

        @Override
        public void setColumnSelectionAllowed(boolean param) {
            this.tcm.setColumnSelectionAllowed(param);
        }

        @Override
        public void setSelectionModel(ListSelectionModel listSelectionModel) {
            this.tcm.setSelectionModel(listSelectionModel);
        }
    }

    class DAMClassTableModel
    extends AbstractTableModel {
        String[] columnNames;
        Object[][] tableData;
        int indexLastClass;

        public DAMClassTableModel() {
            int col;
            int row;
            int i;
            this.indexLastClass = DAMClassificationEditor.this.numberOfClasses;
            if (DAMClassificationEditor.this.classifyGenes) {
                this.columnNames = new String[DAMClassificationEditor.this.fieldNames.length + DAMClassificationEditor.this.numberOfClasses + 2];
                this.columnNames[0] = "Index";
                for (i = 0; i < DAMClassificationEditor.this.numberOfClasses; ++i) {
                    this.columnNames[i + 1] = "Class " + (i + 1);
                }
                this.columnNames[DAMClassificationEditor.this.numberOfClasses + 1] = "Neutral";
                for (i = 0; i < DAMClassificationEditor.this.fieldNames.length; ++i) {
                    this.columnNames[DAMClassificationEditor.this.numberOfClasses + 2 + i] = DAMClassificationEditor.this.fieldNames[i];
                }
                this.tableData = new Object[DAMClassificationEditor.this.numGenes][this.columnNames.length];
                for (row = 0; row < this.tableData.length; ++row) {
                    for (col = 0; col < this.columnNames.length; ++col) {
                        this.tableData[row][col] = col == 0 ? new Integer(row) : (col > 0 && col < DAMClassificationEditor.this.numberOfClasses + 1 ? new Boolean(false) : (col == DAMClassificationEditor.this.numberOfClasses + 1 ? new Boolean(true) : DAMClassificationEditor.this.data.getElementAttribute(row, col - (DAMClassificationEditor.this.numberOfClasses + 2))));
                    }
                }
            } else {
                this.columnNames = new String[DAMClassificationEditor.this.numberOfClasses + 3];
                this.columnNames[0] = "Index";
                for (i = 0; i < DAMClassificationEditor.this.numberOfClasses; ++i) {
                    this.columnNames[i + 1] = "Class " + (i + 1);
                }
                this.columnNames[DAMClassificationEditor.this.numberOfClasses + 1] = "Neutral";
                this.columnNames[DAMClassificationEditor.this.numberOfClasses + 2] = "Sample/Experiment Name";
                this.tableData = new Object[DAMClassificationEditor.this.numExps][this.columnNames.length];
                for (row = 0; row < this.tableData.length; ++row) {
                    for (col = 0; col < this.columnNames.length; ++col) {
                        if (col == 0) {
                            this.tableData[row][col] = new Integer(row);
                            continue;
                        }
                        if (col > 0 && col < DAMClassificationEditor.this.numberOfClasses + 1) {
                            this.tableData[row][col] = new Boolean(false);
                            continue;
                        }
                        if (col == DAMClassificationEditor.this.numberOfClasses + 1) {
                            this.tableData[row][col] = new Boolean(true);
                            continue;
                        }
                        if (col != DAMClassificationEditor.this.numberOfClasses + 2) continue;
                        this.tableData[row][col] = DAMClassificationEditor.this.data.getFullSampleName(row);
                    }
                }
            }
            DAMClassificationEditor.this.origData = new Object[this.tableData.length][this.tableData[0].length];
            for (i = 0; i < this.tableData.length; ++i) {
                for (int j = 0; j < this.tableData[0].length; ++j) {
                    DAMClassificationEditor.this.origData[i][j] = this.tableData[i][j];
                }
            }
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public int getRowCount() {
            return this.tableData.length;
        }

        @Override
        public String getColumnName(int col) {
            return this.columnNames[col];
        }

        public int getColumnIndex(String name) {
            int i;
            for (i = 0; i < this.columnNames.length && !this.columnNames[i].equals(name); ++i) {
            }
            if (i < this.columnNames.length) {
                return i;
            }
            return -1;
        }

        @Override
        public Object getValueAt(int row, int col) {
            return this.tableData[row][col];
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            this.tableData[row][col] = value;
            this.fireTableChanged(new TableModelEvent(this, row, row, col));
        }

        public Class getColumnClass(int c) {
            if (c == 0) {
                return Integer.class;
            }
            if (c > 0 && c <= DAMClassificationEditor.this.numberOfClasses + 1) {
                return Boolean.class;
            }
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return col > 0 && col <= DAMClassificationEditor.this.numberOfClasses + 1;
        }
    }

    class DAMClassifierTable
    extends JTable {
        DAMClassifierTable() {
        }
    }
}

