/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.dam;

import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.beans.Expression;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import org.tigr.microarray.mev.cluster.gui.Experiment;
import org.tigr.microarray.mev.cluster.gui.IData;
import org.tigr.microarray.mev.cluster.gui.IFramework;
import org.tigr.microarray.mev.cluster.gui.IViewer;
import org.tigr.microarray.mev.cluster.gui.helpers.ExperimentUtil;
import org.tigr.microarray.mev.cluster.gui.impl.GUIFactory;
import org.tigr.microarray.mev.cluster.gui.impl.ViewerAdapter;
import org.tigr.microarray.mev.cluster.gui.impl.dam.Content3D;
import org.tigr.microarray.mev.cluster.gui.impl.dam.DAMResultConfigDialog;
import org.tigr.microarray.mev.cluster.gui.impl.dam.DAMSelectionAreaDialog;
import org.tigr.util.FloatMatrix;

public class DAM3DViewer
extends ViewerAdapter
implements IViewer {
    private static final String RESET_CMD = "reset-cmd";
    private static final String OPTIONS_CMD = "options-cmd";
    private static final String SELECTION_AREA_CMD = "select-cmd";
    private static final String SAVE_CMD = "save-cmd";
    private static final String SHOW_SELECTION_CMD = "show-selection-cmd";
    private static final String HIDE_SELECTION_BOX_CMD = "hide-selection-box-cmd";
    private static final String SHOW_SPHERES_CMD = "show-spheres-cmd";
    private static final String SHOW_TEXT_CMD = "show-text-cmd";
    private static final String WHITE_CMD = "white-cmd";
    private static final String STORE_CLUSTER_CMD = "store-cluster-cmd";
    private static final String LAUNCH_NEW_SESSION_CMD = "launch-new-session-cmd";
    private IData data;
    private Experiment experiment;
    private Content3D content;
    private JPopupMenu popup;
    private Frame frame;
    private boolean geneViewer;
    private IFramework framework;
    private FloatMatrix matrix3D;
    private int mode;
    private int exptID = 0;

    public DAM3DViewer(Frame frame, int mode, FloatMatrix matrix3D, Experiment experiment, boolean geneViewer) {
        this.frame = frame;
        this.experiment = experiment;
        this.exptID = experiment.getId();
        this.geneViewer = geneViewer;
        this.mode = mode;
        this.matrix3D = matrix3D;
        this.content = this.createContent(mode, matrix3D, experiment, geneViewer);
        this.popup = this.createJPopupMenu();
    }

    public DAM3DViewer(int mode, FloatMatrix matrix3D, boolean geneViewer, Experiment e) {
        this.experiment = e;
        this.mode = mode;
        this.geneViewer = geneViewer;
        this.matrix3D = matrix3D;
        this.content = this.createContent(mode, matrix3D, this.experiment, geneViewer);
        this.popup = this.createJPopupMenu();
    }

    @Override
    public Expression getExpression() {
        return new Expression(this, this.getClass(), "new", new Object[]{new Integer(this.mode), this.matrix3D, new Boolean(this.geneViewer), this.experiment});
    }

    @Override
    public void setExperiment(Experiment e) {
        this.experiment = e;
        this.exptID = e.getId();
        this.content = this.createContent(this.mode, this.matrix3D, this.experiment, this.geneViewer);
        this.popup = this.createJPopupMenu();
    }

    @Override
    public int getExperimentID() {
        return this.exptID;
    }

    @Override
    public void onSelected(IFramework framework) {
        this.framework = framework;
        this.data = framework.getData();
        this.content.setData(this.data);
        this.content.updateScene();
    }

    @Override
    public void onDataChanged(IData data) {
        this.data = data;
        this.content.setData(data);
        this.content.updateScene();
    }

    @Override
    public JComponent getContentComponent() {
        return this.content;
    }

    @Override
    public BufferedImage getImage() {
        return this.content.createImage();
    }

    private Content3D createContent(int mode, FloatMatrix matrix3D, Experiment experiment, boolean geneViewer) {
        return new Content3D(mode, matrix3D, experiment, geneViewer);
    }

    public JPopupMenu getJPopupMenu() {
        return this.popup;
    }

    private JPopupMenu createJPopupMenu() {
        JPopupMenu popup = new JPopupMenu();
        this.addMenuItems(popup);
        return popup;
    }

    private void addMenuItems(JPopupMenu menu) {
        Listener listener = new Listener();
        JMenuItem menuItem = new JMenuItem("Reset", GUIFactory.getIcon("refresh16.gif"));
        menuItem.setActionCommand(RESET_CMD);
        menuItem.addActionListener(listener);
        menu.add(menuItem);
        menuItem = new JMenuItem("Options...", GUIFactory.getIcon("edit16.gif"));
        menuItem.setActionCommand(OPTIONS_CMD);
        menuItem.addActionListener(listener);
        menu.add(menuItem);
        menu.addSeparator();
        menuItem = new JMenuItem("Selection area...", GUIFactory.getIcon("edit16.gif"));
        menuItem.setEnabled(false);
        menuItem.setActionCommand(SELECTION_AREA_CMD);
        menuItem.addActionListener(listener);
        menu.add(menuItem);
        menuItem = new JMenuItem("Store cluster...", GUIFactory.getIcon("new16.gif"));
        menuItem.setEnabled(false);
        menuItem.setActionCommand(STORE_CLUSTER_CMD);
        menuItem.addActionListener(listener);
        menu.add(menuItem);
        menuItem = new JMenuItem("Launch new session", GUIFactory.getIcon("launch_new_mav.gif"));
        menuItem.setEnabled(false);
        menuItem.setActionCommand(LAUNCH_NEW_SESSION_CMD);
        menuItem.addActionListener(listener);
        menu.add(menuItem);
        menuItem = new JMenuItem("Save cluster...", GUIFactory.getIcon("save16.gif"));
        menuItem.setEnabled(false);
        menuItem.setActionCommand(SAVE_CMD);
        menuItem.addActionListener(listener);
        menu.add(menuItem);
        menu.addSeparator();
        menuItem = new JCheckBoxMenuItem("Show selection area");
        menuItem.setActionCommand(SHOW_SELECTION_CMD);
        menuItem.addActionListener(listener);
        menu.add(menuItem);
        menuItem = new JCheckBoxMenuItem("Hide selection box");
        menuItem.setEnabled(false);
        menuItem.setActionCommand(HIDE_SELECTION_BOX_CMD);
        menuItem.addActionListener(listener);
        menu.add(menuItem);
        menuItem = new JCheckBoxMenuItem("Show spheres");
        menuItem.setActionCommand(SHOW_SPHERES_CMD);
        menuItem.addActionListener(listener);
        menu.add(menuItem);
        menuItem = new JCheckBoxMenuItem("Show text");
        menuItem.setEnabled(true);
        menuItem.setActionCommand(SHOW_TEXT_CMD);
        menuItem.addActionListener(listener);
        menu.add(menuItem);
        menuItem = new JCheckBoxMenuItem("White background");
        menuItem.setActionCommand(WHITE_CMD);
        menuItem.addActionListener(listener);
        menu.add(menuItem);
    }

    private JMenuItem getJMenuItem(String command) {
        Component[] components = this.popup.getComponents();
        for (int i = 0; i < components.length; ++i) {
            if (!(components[i] instanceof JMenuItem) || !((JMenuItem)components[i]).getActionCommand().equals(command)) continue;
            return (JMenuItem)components[i];
        }
        return null;
    }

    private void setEnableMenuItem(String command, boolean enable) {
        JMenuItem item = this.getJMenuItem(command);
        if (item == null) {
            return;
        }
        item.setEnabled(enable);
    }

    private void onReset() {
        this.content.reset();
    }

    private void onOptions() {
        DAMResultConfigDialog dlg = new DAMResultConfigDialog(this.frame, this.content.getPointSize(), this.content.getSelectedPointSize(), this.content.getScaleAxisX(), this.content.getScaleAxisY(), this.content.getScaleAxisZ());
        if (dlg.showModal() == 0) {
            this.content.setPointSize(dlg.getPointSize());
            this.content.setSelectedPointSize(dlg.getSelectedPointSize());
            this.content.setScale(dlg.getScaleAxisX(), dlg.getScaleAxisY(), dlg.getScaleAxisZ());
            this.content.updateScene();
        }
    }

    private void onSelectionArea() {
        DAMSelectionAreaDialog dlg = new DAMSelectionAreaDialog(this.frame, this.content.getPositionX(), this.content.getPositionY(), this.content.getPositionZ(), this.content.getSizeX(), this.content.getSizeY(), this.content.getSizeZ());
        if (dlg.showModal() == 0) {
            this.content.setBoxPosition(dlg.getPositionX(), dlg.getPositionY(), dlg.getPositionZ());
            this.content.setBoxSize(dlg.getSizeX(), dlg.getSizeY(), dlg.getSizeZ());
            this.content.updateScene();
        }
    }

    private void onSave() {
        try {
            if (this.geneViewer) {
                ExperimentUtil.saveExperiment((Frame)this.frame, (Experiment)this.experiment, (IData)this.data, (int[])this.content.getSelectedGenes());
            } else {
                ExperimentUtil.saveExperimentCluster((Frame)this.frame, (Experiment)this.experiment, (IData)this.data, (int[])this.content.getSelectedGenes());
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this.frame, "Can not save matrix!", e.toString(), 0);
            e.printStackTrace();
        }
    }

    private void storeCluster() {
        if (this.geneViewer) {
            this.framework.storeCluster(this.content.getSelectedGenes(), this.experiment, 0);
        } else {
            this.framework.storeCluster(this.content.getSelectedGenes(), this.experiment, 1);
        }
        this.content.setSelection(false);
        this.onHideSelection();
        this.onDataChanged(this.data);
        this.content.updateScene();
    }

    private void launchNewSession() {
        if (this.geneViewer) {
            this.framework.launchNewMAV(this.content.getSelectedGenes(), this.experiment, "Multiple Experiment Viewer - Cluster Viewer", 0);
        } else {
            this.framework.launchNewMAV(this.content.getSelectedGenes(), this.experiment, "Multiple Experiment Viewer - Cluster Viewer", 1);
        }
    }

    private void onShowSelection() {
        JMenuItem selectionItem = this.getJMenuItem(SHOW_SELECTION_CMD);
        JMenuItem hideBoxItem = this.getJMenuItem(HIDE_SELECTION_BOX_CMD);
        JMenuItem selectionAreaItem = this.getJMenuItem(SELECTION_AREA_CMD);
        JMenuItem saveClusterItem = this.getJMenuItem(SAVE_CMD);
        JMenuItem storeClusterItem = this.getJMenuItem(STORE_CLUSTER_CMD);
        JMenuItem launchNewItem = this.getJMenuItem(LAUNCH_NEW_SESSION_CMD);
        if (selectionItem.isSelected()) {
            this.content.setSelection(true);
            this.content.setSelectionBox(!hideBoxItem.isSelected());
            selectionAreaItem.setEnabled(true);
            saveClusterItem.setEnabled(true);
            hideBoxItem.setEnabled(true);
            storeClusterItem.setEnabled(true);
            launchNewItem.setEnabled(true);
        } else {
            this.content.setSelection(false);
            this.content.setSelectionBox(false);
            selectionAreaItem.setEnabled(false);
            saveClusterItem.setEnabled(false);
            hideBoxItem.setEnabled(false);
            storeClusterItem.setEnabled(false);
            launchNewItem.setEnabled(false);
        }
        this.content.updateScene();
    }

    private void onHideSelection() {
        this.content.setSelectionBox(!this.content.isSelectionBox());
        this.content.updateScene();
    }

    private void onShowSphere() {
        this.content.setShowSpheres(!this.content.isShowSpheres());
        this.content.updateScene();
        JMenuItem sphereItem = this.getJMenuItem(SHOW_SPHERES_CMD);
        JMenuItem textItem = this.getJMenuItem(SHOW_TEXT_CMD);
        if (sphereItem.isSelected()) {
            this.content.setShowSpheres(true);
            this.content.setShowText(textItem.isSelected());
            textItem.setEnabled(true);
        } else {
            this.content.setShowSpheres(false);
            this.content.setShowText(false);
            textItem.setEnabled(true);
        }
        this.content.updateScene();
    }

    private void onShowText() {
        this.content.setShowText(!this.content.isShowText());
        this.content.updateScene();
    }

    private void onWhiteBackground() {
        this.content.setWhiteBackround(!this.content.isWhiteBackground());
        this.content.updateScene();
    }

    private class Listener
    implements ActionListener {
        private Listener() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            String command = event.getActionCommand();
            if (command.equals(DAM3DViewer.RESET_CMD)) {
                DAM3DViewer.this.onReset();
            } else if (command.equals(DAM3DViewer.OPTIONS_CMD)) {
                DAM3DViewer.this.onOptions();
            } else if (command.equals(DAM3DViewer.SELECTION_AREA_CMD)) {
                DAM3DViewer.this.onSelectionArea();
            } else if (command.equals(DAM3DViewer.SAVE_CMD)) {
                DAM3DViewer.this.onSave();
            } else if (command.equals(DAM3DViewer.SHOW_SELECTION_CMD)) {
                DAM3DViewer.this.onShowSelection();
            } else if (command.equals(DAM3DViewer.HIDE_SELECTION_BOX_CMD)) {
                DAM3DViewer.this.onHideSelection();
            } else if (command.equals(DAM3DViewer.SHOW_SPHERES_CMD)) {
                DAM3DViewer.this.onShowSphere();
            } else if (command.equals(DAM3DViewer.SHOW_TEXT_CMD)) {
                DAM3DViewer.this.onShowText();
            } else if (command.equals(DAM3DViewer.WHITE_CMD)) {
                DAM3DViewer.this.onWhiteBackground();
            } else if (command.equals(DAM3DViewer.STORE_CLUSTER_CMD)) {
                DAM3DViewer.this.storeCluster();
            } else if (command.equals(DAM3DViewer.LAUNCH_NEW_SESSION_CMD)) {
                DAM3DViewer.this.launchNewSession();
            }
        }
    }
}

