/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.dam;

import com.sun.j3d.utils.geometry.Box;
import com.sun.j3d.utils.geometry.Cone;
import com.sun.j3d.utils.geometry.Cylinder;
import com.sun.j3d.utils.geometry.Sphere;
import com.sun.j3d.utils.picking.behaviors.PickRotateBehavior;
import com.sun.j3d.utils.picking.behaviors.PickTranslateBehavior;
import com.sun.j3d.utils.picking.behaviors.PickZoomBehavior;
import com.sun.j3d.utils.universe.SimpleUniverse;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.image.BufferedImage;
import javax.media.j3d.AmbientLight;
import javax.media.j3d.Appearance;
import javax.media.j3d.Background;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.ColoringAttributes;
import javax.media.j3d.Font3D;
import javax.media.j3d.FontExtrusion;
import javax.media.j3d.Geometry;
import javax.media.j3d.ImageComponent2D;
import javax.media.j3d.LineAttributes;
import javax.media.j3d.Material;
import javax.media.j3d.Node;
import javax.media.j3d.PointArray;
import javax.media.j3d.PointAttributes;
import javax.media.j3d.PointLight;
import javax.media.j3d.Screen3D;
import javax.media.j3d.Shape3D;
import javax.media.j3d.Text3D;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.TransparencyAttributes;
import javax.swing.JPanel;
import javax.vecmath.Color3f;
import javax.vecmath.Point3d;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector3f;
import org.tigr.microarray.mev.cluster.gui.Experiment;
import org.tigr.microarray.mev.cluster.gui.IData;
import org.tigr.microarray.mev.cluster.gui.impl.dam.OpenBehavior;
import org.tigr.util.FloatMatrix;

public class Content3D
extends JPanel {
    private IData data;
    private int mode;
    private FloatMatrix U;
    private Experiment experiment;
    private SimpleUniverse universe;
    private Canvas3D onScreenCanvas;
    private Canvas3D offScreenCanvas;
    private BranchGroup scene;
    private TransformGroup spinGroup;
    private boolean whiteBackground = false;
    private boolean selection = false;
    private boolean selectionBox = false;
    private boolean showSpheres = false;
    private boolean showText = false;
    private boolean geneViewer = true;
    private float scaleAxisX = 3.0f;
    private float scaleAxisY = 3.0f;
    private float scaleAxisZ = 3.0f;
    private float boxSizeX = 5.0f;
    private float boxSizeY = 5.0f;
    private float boxSizeZ = 5.0f;
    private float boxPositionX = 0.0f;
    private float boxPositionY = 0.0f;
    private float boxPositionZ = 0.0f;
    private float pointSize = 1.0f;
    private float selectedPointSize = 1.0f;
    private Color3f blackColor = new Color3f(0.0f, 0.0f, 0.0f);
    private Color3f whiteColor = new Color3f(1.0f, 1.0f, 1.0f);

    public Content3D(int mode, FloatMatrix U, Experiment experiment) {
        this.mode = mode;
        this.U = U;
        this.experiment = experiment;
        this.initScales(U);
        this.setLayout(new BorderLayout());
        this.setPreferredSize(new Dimension(10, 10));
        GraphicsConfiguration config = SimpleUniverse.getPreferredConfiguration();
        this.onScreenCanvas = new Canvas3D(config);
        this.universe = new SimpleUniverse(this.onScreenCanvas);
        this.universe.getViewingPlatform().setNominalViewingTransform();
        this.offScreenCanvas = new Canvas3D(config, true);
        Screen3D sOn = this.onScreenCanvas.getScreen3D();
        Screen3D sOff = this.offScreenCanvas.getScreen3D();
        sOff.setSize(sOn.getSize());
        sOff.setPhysicalScreenWidth(sOn.getPhysicalScreenWidth());
        sOff.setPhysicalScreenHeight(sOn.getPhysicalScreenHeight());
        this.universe.getViewer().getView().addCanvas3D(this.offScreenCanvas);
        this.add((Component)this.onScreenCanvas, "Center");
    }

    public Content3D(int mode, FloatMatrix U, Experiment experiment, boolean geneViewer) {
        this.mode = mode;
        this.U = U;
        this.experiment = experiment;
        this.geneViewer = geneViewer;
        this.initScales(U);
        this.setLayout(new BorderLayout());
        this.setPreferredSize(new Dimension(10, 10));
        GraphicsConfiguration config = SimpleUniverse.getPreferredConfiguration();
        this.onScreenCanvas = new Canvas3D(config);
        this.universe = new SimpleUniverse(this.onScreenCanvas);
        this.universe.getViewingPlatform().setNominalViewingTransform();
        this.offScreenCanvas = new Canvas3D(config, true);
        Screen3D sOn = this.onScreenCanvas.getScreen3D();
        Screen3D sOff = this.offScreenCanvas.getScreen3D();
        sOff.setSize(sOn.getSize());
        sOff.setPhysicalScreenWidth(sOn.getPhysicalScreenWidth());
        sOff.setPhysicalScreenHeight(sOn.getPhysicalScreenHeight());
        this.universe.getViewer().getView().addCanvas3D(this.offScreenCanvas);
        this.add((Component)this.onScreenCanvas, "Center");
    }

    public void setData(IData data) {
        this.data = data;
    }

    public float getPositionX() {
        return this.boxPositionX;
    }

    public float getPositionY() {
        return this.boxPositionY;
    }

    public float getPositionZ() {
        return this.boxPositionZ;
    }

    public float getSizeX() {
        return this.boxSizeX;
    }

    public float getSizeY() {
        return this.boxSizeY;
    }

    public float getSizeZ() {
        return this.boxSizeZ;
    }

    public void setBoxPosition(float dimX, float dimY, float dimZ) {
        this.boxPositionX = dimX;
        this.boxPositionY = dimY;
        this.boxPositionZ = dimZ;
    }

    public void setBoxSize(float dimX, float dimY, float dimZ) {
        this.boxSizeX = dimX;
        this.boxSizeY = dimY;
        this.boxSizeZ = dimZ;
    }

    public float getSelectedPointSize() {
        return this.selectedPointSize;
    }

    public void setSelectedPointSize(float size) {
        this.selectedPointSize = size;
    }

    public float getPointSize() {
        return this.pointSize;
    }

    private float getPointSize(boolean selected) {
        return selected ? this.getSelectedPointSize() : this.getPointSize();
    }

    public void setPointSize(float size) {
        this.pointSize = size;
    }

    public float getScaleAxisX() {
        return this.scaleAxisX;
    }

    public float getScaleAxisY() {
        return this.scaleAxisY;
    }

    public float getScaleAxisZ() {
        return this.scaleAxisZ;
    }

    public void setScale(float dimX, float dimY, float dimZ) {
        this.scaleAxisX = dimX;
        this.scaleAxisY = dimY;
        this.scaleAxisZ = dimZ;
    }

    public void setWhiteBackround(boolean value) {
        this.whiteBackground = value;
    }

    public boolean isWhiteBackground() {
        return this.whiteBackground;
    }

    public void setSelection(boolean value) {
        this.selection = value;
    }

    public boolean isSelection() {
        return this.selection;
    }

    public void setSelectionBox(boolean value) {
        this.selectionBox = value;
    }

    public boolean isSelectionBox() {
        return this.selectionBox;
    }

    public void setShowSpheres(boolean value) {
        this.showSpheres = value;
    }

    public boolean isShowSpheres() {
        return this.showSpheres;
    }

    public void setShowText(boolean value) {
        this.showText = value;
    }

    public boolean isShowText() {
        return this.showText;
    }

    public BufferedImage createImage() {
        ImageComponent2D buffer = new ImageComponent2D(1, GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().createCompatibleImage(this.onScreenCanvas.getWidth(), this.onScreenCanvas.getHeight()));
        this.offScreenCanvas.setOffScreenLocation(this.onScreenCanvas.getLocationOnScreen());
        this.offScreenCanvas.setOffScreenBuffer(buffer);
        this.offScreenCanvas.renderOffScreenBuffer();
        this.offScreenCanvas.waitForOffScreenRendering();
        BufferedImage offImage = this.offScreenCanvas.getOffScreenBuffer().getImage();
        BufferedImage image = new BufferedImage(offImage.getWidth(), offImage.getHeight(), 5);
        image.setData(offImage.getData());
        return image;
    }

    public void reset() {
        this.spinGroup.setTransform(new Transform3D());
    }

    protected void updateScene() {
        Transform3D spinTransform = new Transform3D();
        if (this.scene != null) {
            this.spinGroup.getTransform(spinTransform);
            this.scene.detach();
        }
        this.scene = this.createSceneGraph(this.onScreenCanvas, spinTransform);
        this.universe.addBranchGraph(this.scene);
    }

    private void initScales(FloatMatrix U) {
        int rows;
        float max = 0.0f;
        int i = rows = U.getRowDimension();
        while (--i >= 0) {
            max = Math.max(max, Math.max(Math.max(Math.abs(U.get(i, 0)), Math.abs(U.get(i, 1))), Math.abs(U.get(i, 2))));
        }
        this.setScale(max, max, max);
    }

    private BranchGroup createSceneGraph(Canvas3D canvas) {
        return this.createSceneGraph(canvas, null);
    }

    private BranchGroup createSceneGraph(Canvas3D canvas, Transform3D spinTransform) {
        BranchGroup objRoot = new BranchGroup();
        objRoot.setCapability(17);
        BoundingSphere bounds = new BoundingSphere(new Point3d(0.0, 0.0, 0.0), 100.0);
        this.spinGroup = this.createCoordinateSystem(bounds);
        if (spinTransform != null) {
            this.spinGroup.setTransform(spinTransform);
        }
        TransformGroup objScale = this.createScaleTransformGroup(bounds);
        objScale.addChild((Node)this.spinGroup);
        objRoot.addChild((Node)objScale);
        PickRotateBehavior rotateBehavior = new PickRotateBehavior(objRoot, canvas, (Bounds)bounds);
        objRoot.addChild((Node)rotateBehavior);
        PickZoomBehavior zoomBehavior = new PickZoomBehavior(objRoot, canvas, (Bounds)bounds);
        objRoot.addChild((Node)zoomBehavior);
        PickTranslateBehavior translateBehavior = new PickTranslateBehavior(objRoot, canvas, (Bounds)bounds);
        objRoot.addChild((Node)translateBehavior);
        objRoot.compile();
        return objRoot;
    }

    private TransformGroup createScaleTransformGroup(BoundingSphere bounds) {
        Transform3D t = new Transform3D();
        t.setScale(0.22);
        TransformGroup scale = new TransformGroup(t);
        Color3f bgColor = this.isWhiteBackground() ? this.whiteColor : this.blackColor;
        Background bg = new Background(bgColor);
        bg.setApplicationBounds((Bounds)bounds);
        scale.addChild((Node)bg);
        scale.addChild((Node)this.createAmbientLight(bounds));
        scale.addChild((Node)this.createLight(bounds, new Vector3d(0.0, 0.0, 3.0)));
        scale.addChild((Node)this.createLight(bounds, new Vector3d(0.0, 0.0, 10.0)));
        return scale;
    }

    private TransformGroup createCoordinateSystem(BoundingSphere bounds) {
        TransformGroup group = new TransformGroup();
        group.setCapability(18);
        group.setCapability(17);
        group.setCapability(1);
        group.addChild((Node)this.createXAxis());
        group.addChild((Node)this.createYAxis());
        group.addChild((Node)this.createZAxis());
        if (this.isShowSpheres()) {
            group.addChild((Node)this.createSpheres());
        } else if (this.getPointSize() > 0.0f) {
            Shape3D points;
            Shape3D[] pointShapes = this.createUsualPoints();
            if (pointShapes != null) {
                for (int i = 0; i < pointShapes.length; ++i) {
                    group.addChild((Node)pointShapes[i]);
                }
            }
            if ((points = this.createSelectedPoints()) != null) {
                group.addChild((Node)points);
            }
        }
        if (this.isSelectionBox()) {
            group.addChild((Node)this.createSelectionBox());
        }
        if (this.isShowText()) {
            group.addChild((Node)this.createText());
        }
        OpenBehavior openObject = new OpenBehavior(group);
        openObject.setSchedulingBounds((Bounds)bounds);
        group.addChild((Node)openObject);
        return group;
    }

    private TransformGroup createLight(BoundingSphere bounds, Vector3d vector) {
        Transform3D t = new Transform3D();
        t.set(vector);
        TransformGroup lightGroup = new TransformGroup(t);
        lightGroup.setCapability(18);
        lightGroup.setCapability(17);
        lightGroup.setCapability(1);
        ColoringAttributes attr = new ColoringAttributes();
        Color3f color = new Color3f(1.0f, 1.0f, 1.0f);
        attr.setColor(color);
        Appearance appearance = new Appearance();
        appearance.setColoringAttributes(attr);
        lightGroup.addChild((Node)new Sphere(0.01f, 1, 15, appearance));
        PointLight light = new PointLight(color, new Point3f(0.0f, 0.0f, 0.0f), new Point3f(1.0f, 0.0f, 0.0f));
        light.setInfluencingBounds((Bounds)bounds);
        lightGroup.addChild((Node)light);
        return lightGroup;
    }

    private AmbientLight createAmbientLight(BoundingSphere bounds) {
        AmbientLight light = new AmbientLight(new Color3f(0.2f, 0.2f, 0.2f));
        light.setInfluencingBounds((Bounds)bounds);
        return light;
    }

    private Cone createCone() {
        return new Cone(0.05f, 0.2f);
    }

    private Cylinder createCylinder(Color3f color) {
        Material material = new Material(color, this.blackColor, color, this.whiteColor, 100.0f);
        if (this.isWhiteBackground()) {
            material.setEmissiveColor(new Color3f(0.0f, 0.0f, 1.0f));
        }
        Appearance appearance = new Appearance();
        appearance.setLineAttributes(new LineAttributes(10.0f, 0, true));
        appearance.setMaterial(material);
        return new Cylinder(0.025f, 6.0f, appearance);
    }

    private TransformGroup createSelectionBox() {
        Material material = new Material(new Color3f(0.5f, 0.5f, 0.5f), this.blackColor, new Color3f(0.5f, 0.5f, 0.5f), this.blackColor, 100.0f);
        material.setLightingEnable(true);
        Appearance appearance = new Appearance();
        TransparencyAttributes ta = new TransparencyAttributes();
        ta.setTransparency(0.5f);
        ta.setTransparencyMode(2);
        appearance.setTransparencyAttributes(ta);
        appearance.setMaterial(material);
        Transform3D transform = new Transform3D();
        float factorX = 3.0f / this.scaleAxisX;
        float factorY = 3.0f / this.scaleAxisY;
        float factorZ = 3.0f / this.scaleAxisZ;
        Vector3f vector = new Vector3f(this.boxPositionX * factorX, this.boxPositionY * factorY, this.boxPositionZ * factorZ);
        transform.set(vector);
        TransformGroup selectionBox = new TransformGroup(transform);
        selectionBox.addChild((Node)new Box(this.boxSizeX * factorX / 2.0f, this.boxSizeY * factorY / 2.0f, this.boxSizeZ * factorZ / 2.0f, appearance));
        return selectionBox;
    }

    private boolean isPointSelected(float x, float y, float z) {
        float X1 = this.boxPositionX - this.boxSizeX / 2.0f;
        float X2 = this.boxPositionX + this.boxSizeX / 2.0f;
        float Y1 = this.boxPositionY - this.boxSizeY / 2.0f;
        float Y2 = this.boxPositionY + this.boxSizeY / 2.0f;
        float Z1 = this.boxPositionZ - this.boxSizeZ / 2.0f;
        float Z2 = this.boxPositionZ + this.boxSizeZ / 2.0f;
        return x >= X1 && x <= X2 && y >= Y1 && y <= Y2 && z >= Z1 && z <= Z2;
    }

    protected int[] getSelectedGenes() {
        int[] genes = new int[this.getPointsCount(true)];
        int pos = 0;
        for (int i = 0; i < this.U.getRowDimension(); ++i) {
            if (!this.isPointSelected(this.U.get(i, 0), this.U.get(i, 1), this.U.get(i, 2))) continue;
            genes[pos] = this.experiment.getGeneIndexMappedToData(i);
            ++pos;
        }
        return genes;
    }

    private int getPointsCount(boolean selected) {
        int count = 0;
        int selCount = 0;
        for (int i = 0; i < this.U.getRowDimension(); ++i) {
            if (this.isPointSelected(this.U.get(i, 0), this.U.get(i, 1), this.U.get(i, 2))) {
                ++selCount;
                continue;
            }
            ++count;
        }
        return selected ? selCount : count;
    }

    private int getUsualPointsCount() {
        if (this.isSelection()) {
            return this.getPointsCount(false);
        }
        return this.U.getRowDimension();
    }

    private Shape3D createSelectedPoints() {
        if (!this.isSelection()) {
            return null;
        }
        int count = this.getPointsCount(true);
        if (count < 1) {
            return null;
        }
        Color3f color = new Color3f(1.0f, 0.3f, 1.0f);
        Material material = new Material(color, color, color, color, 100.0f);
        material.setLightingEnable(true);
        Appearance appearance = new Appearance();
        appearance.setPointAttributes(new PointAttributes(this.getSelectedPointSize(), false));
        appearance.setMaterial(material);
        PointArray points = new PointArray(count, 7);
        float factorX = 3.0f / this.scaleAxisX;
        float factorY = 3.0f / this.scaleAxisY;
        float factorZ = 3.0f / this.scaleAxisZ;
        int index = 0;
        for (int i = 0; i < this.U.getRowDimension(); ++i) {
            float z;
            float y;
            float x = this.U.get(i, 0);
            if (!this.isPointSelected(x, y = this.U.get(i, 1), z = this.U.get(i, 2))) continue;
            points.setCoordinate(index, new Point3f(x * factorX, y * factorY, z * factorZ));
            ++index;
        }
        Shape3D pointsShape = new Shape3D();
        pointsShape.setAppearance(appearance);
        pointsShape.setGeometry((Geometry)points);
        return pointsShape;
    }

    private Appearance createPointAppearance(Color3f color) {
        Material material = new Material(color, color, color, color, 100.0f);
        material.setLightingEnable(true);
        Appearance appearance = new Appearance();
        appearance.setPointAttributes(new PointAttributes(this.getPointSize(), false));
        appearance.setMaterial(material);
        return appearance;
    }

    private Shape3D[] createUsualPoints() {
        Color3f color;
        int i;
        int count = this.getUsualPointsCount();
        if (count < 1) {
            return null;
        }
        int uncoloredCount = this.data.getColoredProbesCount(-1);
        int delta = uncoloredCount == 0 ? 0 : 1;
        Color[] colors = this.geneViewer ? this.data.getColors() : this.data.getExperimentColors();
        PointArray[] pointArrays = new PointArray[colors.length + delta];
        Appearance[] appearances = new Appearance[colors.length + delta];
        int[] counters = new int[colors.length + delta];
        if (uncoloredCount > 0) {
            appearances[0] = this.createPointAppearance(this.isWhiteBackground() ? this.blackColor : this.whiteColor);
            pointArrays[0] = new PointArray(uncoloredCount, 7);
            counters[0] = 0;
        }
        if (this.geneViewer) {
            for (i = 0; i < colors.length; ++i) {
                color = new Color3f(colors[i]);
                appearances[i + delta] = this.createPointAppearance(color);
                pointArrays[i + delta] = new PointArray(this.data.getColoredProbesCount(i), 7);
                counters[i + delta] = 0;
            }
        } else {
            for (i = 0; i < colors.length; ++i) {
                color = new Color3f(colors[i]);
                appearances[i + delta] = this.createPointAppearance(color);
                pointArrays[i + delta] = new PointArray(this.data.getColoredExperimentsCount(i), 7);
                counters[i + delta] = 0;
            }
        }
        float factorX = 3.0f / this.scaleAxisX;
        float factorY = 3.0f / this.scaleAxisY;
        float factorZ = 3.0f / this.scaleAxisZ;
        int index = 0;
        for (int i2 = 0; i2 < this.U.getRowDimension(); ++i2) {
            float x = this.U.get(i2, 0);
            float y = this.U.get(i2, 1);
            float z = this.U.get(i2, 2);
            if (this.isSelection() && this.isPointSelected(x, y, z)) continue;
            index = this.geneViewer ? this.data.getProbeColorIndex(this.experiment.getGeneIndexMappedToData(i2)) + delta : this.data.getExperimentColorIndex(i2) + delta;
            pointArrays[index].setCoordinate(counters[index], new Point3f(x * factorX, y * factorY, z * factorZ));
            int n = index;
            counters[n] = counters[n] + 1;
        }
        Shape3D[] pointShapes = new Shape3D[pointArrays.length];
        for (int i3 = 0; i3 < pointShapes.length; ++i3) {
            pointShapes[i3] = new Shape3D();
            pointShapes[i3].setAppearance(appearances[i3]);
            pointShapes[i3].setGeometry((Geometry)pointArrays[i3]);
        }
        return pointShapes;
    }

    private Appearance createSphereAppearance(Color3f color) {
        Material material = new Material(color, this.blackColor, color, this.whiteColor, 100.0f);
        material.setLightingEnable(true);
        Appearance appearance = new Appearance();
        appearance.setMaterial(material);
        return appearance;
    }

    private TransformGroup createSpheres() {
        TransformGroup spheres = new TransformGroup();
        float factorX = 3.0f / this.scaleAxisX;
        float factorY = 3.0f / this.scaleAxisY;
        float factorZ = 3.0f / this.scaleAxisZ;
        Color3f uColor = this.isWhiteBackground() ? this.blackColor : this.whiteColor;
        Appearance uAppearance = this.createSphereAppearance(uColor);
        Color3f sColor = this.isSelection() ? new Color3f(1.0f, 0.3f, 1.0f) : uColor;
        Appearance sAppearance = this.createSphereAppearance(sColor);
        for (int i = 0; i < this.U.getRowDimension(); ++i) {
            boolean selected;
            float x = this.U.get(i, 0);
            float y = this.U.get(i, 1);
            float z = this.U.get(i, 2);
            Transform3D transform = new Transform3D();
            Vector3d vector3d = new Vector3d((double)(x * factorX), (double)(y * factorY), (double)(z * factorZ));
            transform.set(vector3d);
            TransformGroup sphere = new TransformGroup(transform);
            boolean bl = selected = this.isSelection() && this.isPointSelected(x, y, z);
            if (this.geneViewer) {
                if (this.data.getProbeColor(this.experiment.getGeneIndexMappedToData(i)) == null) {
                    sphere.addChild((Node)new Sphere(this.getPointSize(selected) / 20.0f, selected ? sAppearance : uAppearance));
                } else {
                    sphere.addChild((Node)new Sphere(this.getPointSize(selected) / 20.0f, selected ? sAppearance : this.createSphereAppearance(new Color3f(this.data.getProbeColor(this.experiment.getGeneIndexMappedToData(i))))));
                }
            } else if (this.data.getExperimentColor(i) == null) {
                sphere.addChild((Node)new Sphere(this.getPointSize(selected) / 20.0f, selected ? sAppearance : uAppearance));
            } else {
                sphere.addChild((Node)new Sphere(this.getPointSize(selected) / 20.0f, selected ? sAppearance : this.createSphereAppearance(new Color3f(this.data.getExperimentColor(i)))));
            }
            spheres.addChild((Node)sphere);
        }
        return spheres;
    }

    private TransformGroup createText() {
        TransformGroup textGroup = new TransformGroup();
        float factorX = 3.0f / this.scaleAxisX;
        float factorY = 3.0f / this.scaleAxisY;
        float factorZ = 3.0f / this.scaleAxisZ;
        Font3D font = new Font3D(new Font("TestFont", 1, Math.round(this.getPointSize(false))), new FontExtrusion());
        Color3f color3f = !this.whiteBackground ? new Color3f(1.0f, 1.0f, 1.0f) : new Color3f(0.0f, 0.0f, 0.0f);
        Material material = !this.whiteBackground ? new Material(color3f, this.whiteColor, color3f, this.whiteColor, 100.0f) : new Material(color3f, this.blackColor, color3f, this.blackColor, 100.0f);
        material.setLightingEnable(true);
        Appearance appearance = new Appearance();
        appearance.setMaterial(material);
        Transform3D fontTransform = new Transform3D();
        fontTransform.setScale(0.1);
        for (int i = 0; i < this.U.getRowDimension(); ++i) {
            float x = this.U.get(i, 0);
            float y = this.U.get(i, 1);
            float z = this.U.get(i, 2);
            TransformGroup tempGroup = new TransformGroup(fontTransform);
            String text = this.mode == 1 ? this.data.getUniqueId(i) : this.data.getSampleName(this.experiment.getSampleIndex(i));
            Text3D text3d = new Text3D(font, text, new Point3f(x * factorX * 10.0f + this.getPointSize(this.isPointSelected(x, y, z)), (y - 0.035f) * factorY * 10.0f, z * factorZ * 10.0f));
            Shape3D shape3d = new Shape3D();
            shape3d.setGeometry((Geometry)text3d);
            shape3d.setAppearance(appearance);
            tempGroup.addChild((Node)shape3d);
            textGroup.addChild((Node)tempGroup);
        }
        return textGroup;
    }

    private Shape3D createTextShape3D(String text) {
        Material axisFontMaterial;
        Font3D axisFont = new Font3D(new Font("TestFont", 1, 1), new FontExtrusion());
        Text3D text3D = new Text3D(axisFont, text);
        Shape3D shape = new Shape3D();
        shape.setGeometry((Geometry)text3D);
        if (!this.whiteBackground) {
            Color3f color3f = new Color3f(0.5f, 0.5f, 0.5f);
            axisFontMaterial = new Material(color3f, this.blackColor, color3f, this.whiteColor, 100.0f);
        } else {
            Color3f color3f = new Color3f(0.0f, 0.0f, 0.0f);
            axisFontMaterial = new Material(color3f, this.blackColor, color3f, this.blackColor, 100.0f);
        }
        axisFontMaterial.setLightingEnable(true);
        Appearance axisFontAppearance = new Appearance();
        axisFontAppearance.setMaterial(axisFontMaterial);
        shape.setAppearance(axisFontAppearance);
        return shape;
    }

    private TransformGroup createXAxis() {
        Transform3D axisTrans = new Transform3D();
        axisTrans.rotZ(-1.5707963267948966);
        Transform3D fontTrans = new Transform3D();
        fontTrans.rotZ(1.5707963267948966);
        if (!this.whiteBackground) {
            return this.createAxis("X", new Color3f(0.5f, 0.5f, 0.5f), axisTrans, fontTrans);
        }
        return this.createAxis("X", new Color3f(0.0f, 0.0f, 0.0f), axisTrans, fontTrans);
    }

    private TransformGroup createYAxis() {
        if (!this.whiteBackground) {
            return this.createAxis("Y", new Color3f(0.3f, 0.3f, 1.0f), null, null);
        }
        return this.createAxis("Y", new Color3f(0.0f, 0.0f, 0.0f), null, null);
    }

    private TransformGroup createZAxis() {
        Transform3D axisTrans = new Transform3D();
        axisTrans.rotX(-1.5707963267948966);
        Transform3D zTrans = new Transform3D();
        zTrans.rotY(1.5707963267948966);
        axisTrans.mul(zTrans);
        Transform3D fontTrans = new Transform3D();
        fontTrans.rotZ(1.5707963267948966);
        if (!this.whiteBackground) {
            return this.createAxis("Z", new Color3f(1.0f, 0.3f, 1.0f), axisTrans, fontTrans);
        }
        return this.createAxis("Z", new Color3f(0.0f, 0.0f, 0.0f), axisTrans, fontTrans);
    }

    private TransformGroup createAxis(String name, Color3f color, Transform3D axisTrans, Transform3D fontTrans) {
        TransformGroup axis = new TransformGroup();
        if (axisTrans != null) {
            axis.setTransform(axisTrans);
        }
        axis.addChild((Node)this.createCylinder(color));
        Transform3D posTransform = new Transform3D();
        posTransform.set(new Vector3d(0.0, 3.1, 0.0));
        TransformGroup posEnd = new TransformGroup(posTransform);
        posEnd.addChild((Node)this.createCone());
        Transform3D negTransform = new Transform3D();
        negTransform.set(new Vector3d(0.0, -3.1, 0.0));
        Transform3D rotate180X = new Transform3D();
        rotate180X.rotX(Math.PI);
        negTransform.mul(rotate180X);
        TransformGroup negEnd = new TransformGroup(negTransform);
        negEnd.addChild((Node)this.createCone());
        Transform3D fontTransform = new Transform3D();
        fontTransform.set(0.22, new Vector3d(0.25, 2.75, -0.0125));
        TransformGroup fontGroup = new TransformGroup(fontTransform);
        TransformGroup rotFontGroup = new TransformGroup();
        if (fontTrans != null) {
            rotFontGroup.setTransform(fontTrans);
        }
        Shape3D shape3D = this.createTextShape3D(name);
        rotFontGroup.addChild((Node)shape3D);
        fontGroup.addChild((Node)rotFontGroup);
        axis.addChild((Node)fontGroup);
        axis.addChild((Node)posEnd);
        axis.addChild((Node)negEnd);
        return axis;
    }
}

