/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.coa;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.tigr.microarray.mev.cluster.gui.impl.GUIFactory;
import org.tigr.microarray.mev.cluster.gui.impl.coa.COAContent3D;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.AlgorithmDialog;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.DialogListener;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.dialogHelpUtil.HelpWindow;

public class COASelectionAreaDialog
extends AlgorithmDialog {
    private int result;
    private COAContent3D content;
    private JTextField textField1;
    private JTextField textField2;
    private JTextField textField3;
    private JTextField textField4;
    private JTextField textField5;
    private JTextField textField6;
    private float positionX;
    private float positionY;
    private float positionZ;
    private float sizeX;
    private float sizeY;
    private float sizeZ;
    private int initSizePos;
    private float initSize;
    private final float maxPos;
    private JSlider posXSlider;
    private JSlider posYSlider;
    private JSlider posZSlider;
    private JSlider sizeXSlider;
    private JSlider sizeYSlider;
    private JSlider sizeZSlider;

    public COASelectionAreaDialog(Frame parent, float positionX, float positionY, float positionZ, float sizeX, float sizeY, float sizeZ) {
        super(new JFrame(), "COA selection area configuration", true);
        this.positionX = positionX;
        this.positionY = positionY;
        this.positionZ = positionZ;
        this.sizeX = sizeX;
        this.sizeY = sizeY;
        this.sizeZ = sizeZ;
        this.maxPos = positionX;
        Listener listener = new Listener();
        this.addWindowListener(listener);
        JPanel parameters = new JPanel(new GridLayout(0, 2, 10, 0));
        parameters.setBorder(new EmptyBorder(20, 20, 20, 10));
        parameters.setBackground(Color.white);
        parameters.add(new JLabel("Position X  "));
        this.textField1 = new JTextField(Float.toString(positionX), 5);
        parameters.add((Component)this.textField1, "East");
        parameters.add(new JLabel("Position Y  "));
        this.textField2 = new JTextField(Float.toString(positionY), 5);
        parameters.add((Component)this.textField2, "East");
        parameters.add(new JLabel("Position Z  "));
        this.textField3 = new JTextField(Float.toString(positionZ), 5);
        parameters.add((Component)this.textField3, "East");
        parameters.add(new JLabel("Size X  "));
        this.textField4 = new JTextField(Float.toString(sizeX), 5);
        parameters.add((Component)this.textField4, "East");
        parameters.add(new JLabel("Size Y "));
        this.textField5 = new JTextField(Float.toString(sizeY), 5);
        parameters.add((Component)this.textField5, "East");
        parameters.add(new JLabel("Size Z "));
        this.textField6 = new JTextField(Float.toString(sizeZ), 5);
        parameters.add((Component)this.textField6, "East");
        JPanel panel3 = new JPanel(new BorderLayout());
        panel3.setForeground(Color.white);
        panel3.setBorder(BorderFactory.createLineBorder(Color.gray));
        panel3.setBackground(Color.white);
        panel3.add((Component)parameters, "West");
        panel3.add((Component)new JLabel(GUIFactory.getIcon("dialog_button_bar.gif")), "East");
        JPanel panel1 = new JPanel(new BorderLayout());
        panel1.add((Component)panel3, "Center");
        this.addContent(panel1);
        this.setActionListeners(listener);
        this.pack();
        this.setResizable(false);
    }

    public COASelectionAreaDialog(COAContent3D content, Frame parent, float positionX, float positionY, float positionZ, float sizeX, float sizeY, float sizeZ, float maxPosition) {
        super(new JFrame(), "COA selection area configuration", false);
        this.positionX = positionX;
        this.positionY = positionY;
        this.positionZ = positionZ;
        this.sizeX = sizeX;
        this.sizeY = sizeY;
        this.sizeZ = sizeZ;
        this.content = content;
        this.maxPos = maxPosition;
        this.posXSlider = new JSlider(-1000, 1000, 0);
        this.posYSlider = new JSlider(-1000, 1000, 0);
        this.posZSlider = new JSlider(-1000, 1000, 0);
        this.initSizePos = this.getSliderPos(sizeX);
        this.initSize = sizeX;
        this.sizeXSlider = new JSlider(0, 2000, this.initSizePos);
        this.sizeYSlider = new JSlider(0, 2000, this.initSizePos);
        this.sizeZSlider = new JSlider(0, 2000, this.initSizePos);
        this.posXSlider.setBackground(Color.white);
        this.posYSlider.setBackground(Color.white);
        this.posZSlider.setBackground(Color.white);
        this.sizeXSlider.setBackground(Color.white);
        this.sizeYSlider.setBackground(Color.white);
        this.sizeZSlider.setBackground(Color.white);
        this.textField1 = new JTextField(Float.toString(positionX), 5);
        this.textField2 = new JTextField(Float.toString(positionY), 5);
        this.textField3 = new JTextField(Float.toString(positionZ), 5);
        this.textField4 = new JTextField(Float.toString(sizeX), 5);
        this.textField5 = new JTextField(Float.toString(sizeY), 5);
        this.textField6 = new JTextField(Float.toString(sizeY), 5);
        this.textField1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    String s = COASelectionAreaDialog.this.textField1.getText();
                    float val = Float.parseFloat(s);
                    int sliderValue = COASelectionAreaDialog.this.getSliderPos(val);
                    if (sliderValue >= 1000) {
                        COASelectionAreaDialog.this.posXSlider.setValue(1000);
                        COASelectionAreaDialog.this.textField1.setText("" + COASelectionAreaDialog.this.maxPos);
                    } else if (sliderValue <= -1000) {
                        COASelectionAreaDialog.this.posXSlider.setValue(-1000);
                        COASelectionAreaDialog.this.textField1.setText("" + -1.0f * COASelectionAreaDialog.this.maxPos);
                    } else {
                        COASelectionAreaDialog.this.posXSlider.setValue(sliderValue);
                        COASelectionAreaDialog.this.textField1.setText("" + val);
                    }
                }
                catch (Exception exc) {
                    COASelectionAreaDialog.this.posXSlider.setValue(0);
                    COASelectionAreaDialog.this.textField1.setText("0.0");
                    COASelectionAreaDialog.this.setPositionX(0.0f);
                    COASelectionAreaDialog.this.updateContent();
                }
                String posString = COASelectionAreaDialog.this.textField1.getText();
                float posX = Float.parseFloat(posString);
                COASelectionAreaDialog.this.setPositionX(posX);
                COASelectionAreaDialog.this.updateContent();
            }
        });
        this.textField1.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent e) {
                try {
                    String s = COASelectionAreaDialog.this.textField1.getText();
                    float val = Float.parseFloat(s);
                    int sliderValue = COASelectionAreaDialog.this.getSliderPos(val);
                    if (sliderValue >= 1000) {
                        COASelectionAreaDialog.this.posXSlider.setValue(1000);
                        COASelectionAreaDialog.this.textField1.setText("" + COASelectionAreaDialog.this.maxPos);
                    } else if (sliderValue <= -1000) {
                        COASelectionAreaDialog.this.posXSlider.setValue(-1000);
                        COASelectionAreaDialog.this.textField1.setText("" + -1.0f * COASelectionAreaDialog.this.maxPos);
                    } else {
                        COASelectionAreaDialog.this.posXSlider.setValue(sliderValue);
                        COASelectionAreaDialog.this.textField1.setText("" + val);
                    }
                }
                catch (Exception exc) {
                    COASelectionAreaDialog.this.posXSlider.setValue(0);
                    COASelectionAreaDialog.this.textField1.setText("0.0");
                    COASelectionAreaDialog.this.setPositionX(0.0f);
                    COASelectionAreaDialog.this.updateContent();
                }
                String posString = COASelectionAreaDialog.this.textField1.getText();
                float posX = Float.parseFloat(posString);
                COASelectionAreaDialog.this.setPositionX(posX);
                COASelectionAreaDialog.this.updateContent();
            }

            @Override
            public void focusGained(FocusEvent e) {
            }
        });
        this.posXSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                JSlider source = (JSlider)e.getSource();
                int value = source.getValue();
                float displayValue = COASelectionAreaDialog.this.getCoord(value);
                if (value == -1000) {
                    displayValue = -1.0f * COASelectionAreaDialog.this.maxPos;
                }
                if (value == 1000) {
                    displayValue = COASelectionAreaDialog.this.maxPos;
                }
                COASelectionAreaDialog.this.textField1.setText("" + displayValue);
                String dString = COASelectionAreaDialog.this.textField1.getText();
                float pos = Float.parseFloat(dString);
                COASelectionAreaDialog.this.setPositionX(pos);
                COASelectionAreaDialog.this.updateContent();
            }
        });
        this.textField2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    String s = COASelectionAreaDialog.this.textField2.getText();
                    float val = Float.parseFloat(s);
                    int sliderValue = COASelectionAreaDialog.this.getSliderPos(val);
                    if (sliderValue >= 1000) {
                        COASelectionAreaDialog.this.posYSlider.setValue(1000);
                        COASelectionAreaDialog.this.textField2.setText("" + COASelectionAreaDialog.this.maxPos);
                    } else if (sliderValue <= -1000) {
                        COASelectionAreaDialog.this.posYSlider.setValue(-1000);
                        COASelectionAreaDialog.this.textField2.setText("" + -1.0f * COASelectionAreaDialog.this.maxPos);
                    } else {
                        COASelectionAreaDialog.this.posYSlider.setValue(sliderValue);
                        COASelectionAreaDialog.this.textField2.setText("" + val);
                    }
                }
                catch (Exception exc) {
                    COASelectionAreaDialog.this.posYSlider.setValue(0);
                    COASelectionAreaDialog.this.textField2.setText("0.0");
                    COASelectionAreaDialog.this.setPositionY(0.0f);
                    COASelectionAreaDialog.this.updateContent();
                }
                String posString = COASelectionAreaDialog.this.textField2.getText();
                float pos = Float.parseFloat(posString);
                COASelectionAreaDialog.this.setPositionY(pos);
                COASelectionAreaDialog.this.updateContent();
            }
        });
        this.textField2.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent e) {
                try {
                    String s = COASelectionAreaDialog.this.textField2.getText();
                    float val = Float.parseFloat(s);
                    int sliderValue = COASelectionAreaDialog.this.getSliderPos(val);
                    if (sliderValue >= 1000) {
                        COASelectionAreaDialog.this.posYSlider.setValue(1000);
                        COASelectionAreaDialog.this.textField2.setText("" + COASelectionAreaDialog.this.maxPos);
                    } else if (sliderValue <= -1000) {
                        COASelectionAreaDialog.this.posYSlider.setValue(-1000);
                        COASelectionAreaDialog.this.textField2.setText("" + -1.0f * COASelectionAreaDialog.this.maxPos);
                    } else {
                        COASelectionAreaDialog.this.posYSlider.setValue(sliderValue);
                        COASelectionAreaDialog.this.textField2.setText("" + val);
                    }
                }
                catch (Exception exc) {
                    COASelectionAreaDialog.this.posYSlider.setValue(0);
                    COASelectionAreaDialog.this.textField2.setText("0.0");
                    COASelectionAreaDialog.this.setPositionY(0.0f);
                    COASelectionAreaDialog.this.updateContent();
                }
                String posString = COASelectionAreaDialog.this.textField2.getText();
                float pos = Float.parseFloat(posString);
                COASelectionAreaDialog.this.setPositionY(pos);
                COASelectionAreaDialog.this.updateContent();
            }

            @Override
            public void focusGained(FocusEvent e) {
            }
        });
        this.posYSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                JSlider source = (JSlider)e.getSource();
                int value = source.getValue();
                float displayValue = COASelectionAreaDialog.this.getCoord(value);
                if (value == -1000) {
                    displayValue = -1.0f * COASelectionAreaDialog.this.maxPos;
                }
                if (value == 1000) {
                    displayValue = COASelectionAreaDialog.this.maxPos;
                }
                COASelectionAreaDialog.this.textField2.setText("" + displayValue);
                String dString = COASelectionAreaDialog.this.textField2.getText();
                float pos = Float.parseFloat(dString);
                COASelectionAreaDialog.this.setPositionY(pos);
                COASelectionAreaDialog.this.updateContent();
            }
        });
        this.textField3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    String s = COASelectionAreaDialog.this.textField3.getText();
                    float val = Float.parseFloat(s);
                    int sliderValue = COASelectionAreaDialog.this.getSliderPos(val);
                    if (sliderValue >= 1000) {
                        COASelectionAreaDialog.this.posZSlider.setValue(1000);
                        COASelectionAreaDialog.this.textField3.setText("" + COASelectionAreaDialog.this.maxPos);
                    } else if (sliderValue <= -1000) {
                        COASelectionAreaDialog.this.posZSlider.setValue(-1000);
                        COASelectionAreaDialog.this.textField3.setText("" + -1.0f * COASelectionAreaDialog.this.maxPos);
                    } else {
                        COASelectionAreaDialog.this.posZSlider.setValue(sliderValue);
                        COASelectionAreaDialog.this.textField3.setText("" + val);
                    }
                }
                catch (Exception exc) {
                    COASelectionAreaDialog.this.posZSlider.setValue(0);
                    COASelectionAreaDialog.this.textField3.setText("0.0");
                    COASelectionAreaDialog.this.setPositionZ(0.0f);
                    COASelectionAreaDialog.this.updateContent();
                }
                String posString = COASelectionAreaDialog.this.textField3.getText();
                float pos = Float.parseFloat(posString);
                COASelectionAreaDialog.this.setPositionZ(pos);
                COASelectionAreaDialog.this.updateContent();
            }
        });
        this.textField3.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent e) {
                try {
                    String s = COASelectionAreaDialog.this.textField3.getText();
                    float val = Float.parseFloat(s);
                    int sliderValue = COASelectionAreaDialog.this.getSliderPos(val);
                    if (sliderValue >= 1000) {
                        COASelectionAreaDialog.this.posZSlider.setValue(1000);
                        COASelectionAreaDialog.this.textField3.setText("" + COASelectionAreaDialog.this.maxPos);
                    } else if (sliderValue <= -1000) {
                        COASelectionAreaDialog.this.posZSlider.setValue(-1000);
                        COASelectionAreaDialog.this.textField3.setText("" + -1.0f * COASelectionAreaDialog.this.maxPos);
                    } else {
                        COASelectionAreaDialog.this.posZSlider.setValue(sliderValue);
                        COASelectionAreaDialog.this.textField3.setText("" + val);
                    }
                }
                catch (Exception exc) {
                    COASelectionAreaDialog.this.posZSlider.setValue(0);
                    COASelectionAreaDialog.this.textField3.setText("0.0");
                    COASelectionAreaDialog.this.setPositionZ(0.0f);
                    COASelectionAreaDialog.this.updateContent();
                }
                String posString = COASelectionAreaDialog.this.textField3.getText();
                float pos = Float.parseFloat(posString);
                COASelectionAreaDialog.this.setPositionZ(pos);
                COASelectionAreaDialog.this.updateContent();
            }

            @Override
            public void focusGained(FocusEvent e) {
            }
        });
        this.posZSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                JSlider source = (JSlider)e.getSource();
                int value = source.getValue();
                float displayValue = COASelectionAreaDialog.this.getCoord(value);
                if (value == -1000) {
                    displayValue = -1.0f * COASelectionAreaDialog.this.maxPos;
                }
                if (value == 1000) {
                    displayValue = COASelectionAreaDialog.this.maxPos;
                }
                COASelectionAreaDialog.this.textField3.setText("" + displayValue);
                String dString = COASelectionAreaDialog.this.textField3.getText();
                float pos = Float.parseFloat(dString);
                COASelectionAreaDialog.this.setPositionZ(pos);
                COASelectionAreaDialog.this.updateContent();
            }
        });
        this.textField4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    String s = COASelectionAreaDialog.this.textField4.getText();
                    float val = Float.parseFloat(s);
                    int sliderValue = COASelectionAreaDialog.this.getSliderPos(val);
                    if (sliderValue >= 2000) {
                        COASelectionAreaDialog.this.sizeXSlider.setValue(2000);
                        COASelectionAreaDialog.this.textField4.setText("" + 2.0f * COASelectionAreaDialog.this.maxPos);
                    } else if (sliderValue == 0) {
                        COASelectionAreaDialog.this.sizeXSlider.setValue(0);
                        COASelectionAreaDialog.this.textField4.setText("0.0");
                    } else {
                        COASelectionAreaDialog.this.sizeXSlider.setValue(sliderValue);
                        COASelectionAreaDialog.this.textField4.setText("" + val);
                    }
                }
                catch (Exception exc) {
                    COASelectionAreaDialog.this.sizeXSlider.setValue(COASelectionAreaDialog.this.initSizePos);
                    COASelectionAreaDialog.this.textField4.setText("" + COASelectionAreaDialog.this.initSize);
                    COASelectionAreaDialog.this.setSizeX(COASelectionAreaDialog.this.initSize);
                    COASelectionAreaDialog.this.updateContent();
                }
                String sizeString = COASelectionAreaDialog.this.textField4.getText();
                float size = Float.parseFloat(sizeString);
                COASelectionAreaDialog.this.setSizeX(size);
                COASelectionAreaDialog.this.updateContent();
            }
        });
        this.textField4.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent e) {
                try {
                    String s = COASelectionAreaDialog.this.textField4.getText();
                    float val = Float.parseFloat(s);
                    int sliderValue = COASelectionAreaDialog.this.getSliderPos(val);
                    if (sliderValue >= 2000) {
                        COASelectionAreaDialog.this.sizeXSlider.setValue(2000);
                        COASelectionAreaDialog.this.textField4.setText("" + 2.0f * COASelectionAreaDialog.this.maxPos);
                    } else if (sliderValue == 0) {
                        COASelectionAreaDialog.this.sizeXSlider.setValue(0);
                        COASelectionAreaDialog.this.textField4.setText("0.0");
                    } else {
                        COASelectionAreaDialog.this.sizeXSlider.setValue(sliderValue);
                        COASelectionAreaDialog.this.textField4.setText("" + val);
                    }
                }
                catch (Exception exc) {
                    COASelectionAreaDialog.this.sizeXSlider.setValue(COASelectionAreaDialog.this.initSizePos);
                    COASelectionAreaDialog.this.textField4.setText("" + COASelectionAreaDialog.this.initSize);
                    COASelectionAreaDialog.this.setSizeX(COASelectionAreaDialog.this.initSize);
                    COASelectionAreaDialog.this.updateContent();
                }
                String sizeString = COASelectionAreaDialog.this.textField4.getText();
                float size = Float.parseFloat(sizeString);
                COASelectionAreaDialog.this.setSizeX(size);
                COASelectionAreaDialog.this.updateContent();
            }

            @Override
            public void focusGained(FocusEvent e) {
            }
        });
        this.sizeXSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                JSlider source = (JSlider)e.getSource();
                int value = source.getValue();
                float displayValue = COASelectionAreaDialog.this.getCoord(value);
                if (value == 0) {
                    displayValue = 0.0f;
                }
                if (value == 2000) {
                    displayValue = 2.0f * COASelectionAreaDialog.this.maxPos;
                }
                COASelectionAreaDialog.this.textField4.setText("" + displayValue);
                String dString = COASelectionAreaDialog.this.textField4.getText();
                float size = Float.parseFloat(dString);
                COASelectionAreaDialog.this.setSizeX(size);
                COASelectionAreaDialog.this.updateContent();
            }
        });
        this.textField5.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    String s = COASelectionAreaDialog.this.textField5.getText();
                    float val = Float.parseFloat(s);
                    int sliderValue = COASelectionAreaDialog.this.getSliderPos(val);
                    if (sliderValue >= 2000) {
                        COASelectionAreaDialog.this.sizeYSlider.setValue(2000);
                        COASelectionAreaDialog.this.textField5.setText("" + 2.0f * COASelectionAreaDialog.this.maxPos);
                    } else if (sliderValue == 0) {
                        COASelectionAreaDialog.this.sizeYSlider.setValue(0);
                        COASelectionAreaDialog.this.textField5.setText("0.0");
                    } else {
                        COASelectionAreaDialog.this.sizeYSlider.setValue(sliderValue);
                        COASelectionAreaDialog.this.textField5.setText("" + val);
                    }
                }
                catch (Exception exc) {
                    COASelectionAreaDialog.this.sizeYSlider.setValue(COASelectionAreaDialog.this.initSizePos);
                    COASelectionAreaDialog.this.textField5.setText("" + COASelectionAreaDialog.this.initSize);
                    COASelectionAreaDialog.this.setSizeY(COASelectionAreaDialog.this.initSize);
                    COASelectionAreaDialog.this.updateContent();
                }
                String sizeString = COASelectionAreaDialog.this.textField5.getText();
                float size = Float.parseFloat(sizeString);
                COASelectionAreaDialog.this.setSizeY(size);
                COASelectionAreaDialog.this.updateContent();
            }
        });
        this.textField5.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent e) {
                try {
                    String s = COASelectionAreaDialog.this.textField5.getText();
                    float val = Float.parseFloat(s);
                    int sliderValue = COASelectionAreaDialog.this.getSliderPos(val);
                    if (sliderValue >= 2000) {
                        COASelectionAreaDialog.this.sizeYSlider.setValue(2000);
                        COASelectionAreaDialog.this.textField5.setText("" + 2.0f * COASelectionAreaDialog.this.maxPos);
                    } else if (sliderValue == 0) {
                        COASelectionAreaDialog.this.sizeYSlider.setValue(0);
                        COASelectionAreaDialog.this.textField5.setText("0.0");
                    } else {
                        COASelectionAreaDialog.this.sizeYSlider.setValue(sliderValue);
                        COASelectionAreaDialog.this.textField5.setText("" + val);
                    }
                }
                catch (Exception exc) {
                    COASelectionAreaDialog.this.sizeYSlider.setValue(COASelectionAreaDialog.this.initSizePos);
                    COASelectionAreaDialog.this.textField5.setText("" + COASelectionAreaDialog.this.initSize);
                    COASelectionAreaDialog.this.setSizeY(COASelectionAreaDialog.this.initSize);
                    COASelectionAreaDialog.this.updateContent();
                }
                String sizeString = COASelectionAreaDialog.this.textField5.getText();
                float size = Float.parseFloat(sizeString);
                COASelectionAreaDialog.this.setSizeY(size);
                COASelectionAreaDialog.this.updateContent();
            }

            @Override
            public void focusGained(FocusEvent e) {
            }
        });
        this.sizeYSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                JSlider source = (JSlider)e.getSource();
                int value = source.getValue();
                float displayValue = COASelectionAreaDialog.this.getCoord(value);
                if (value == 0) {
                    displayValue = 0.0f;
                }
                if (value == 2000) {
                    displayValue = 2.0f * COASelectionAreaDialog.this.maxPos;
                }
                COASelectionAreaDialog.this.textField5.setText("" + displayValue);
                String dString = COASelectionAreaDialog.this.textField5.getText();
                float size = Float.parseFloat(dString);
                COASelectionAreaDialog.this.setSizeY(size);
                COASelectionAreaDialog.this.updateContent();
            }
        });
        this.textField6.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    String s = COASelectionAreaDialog.this.textField6.getText();
                    float val = Float.parseFloat(s);
                    int sliderValue = COASelectionAreaDialog.this.getSliderPos(val);
                    if (sliderValue >= 2000) {
                        COASelectionAreaDialog.this.sizeZSlider.setValue(2000);
                        COASelectionAreaDialog.this.textField6.setText("" + 2.0f * COASelectionAreaDialog.this.maxPos);
                    } else if (sliderValue == 0) {
                        COASelectionAreaDialog.this.sizeZSlider.setValue(0);
                        COASelectionAreaDialog.this.textField6.setText("0.0");
                    } else {
                        COASelectionAreaDialog.this.sizeZSlider.setValue(sliderValue);
                        COASelectionAreaDialog.this.textField6.setText("" + val);
                    }
                }
                catch (Exception exc) {
                    COASelectionAreaDialog.this.sizeZSlider.setValue(COASelectionAreaDialog.this.initSizePos);
                    COASelectionAreaDialog.this.textField6.setText("" + COASelectionAreaDialog.this.initSize);
                    COASelectionAreaDialog.this.setSizeZ(COASelectionAreaDialog.this.initSize);
                    COASelectionAreaDialog.this.updateContent();
                }
                String sizeString = COASelectionAreaDialog.this.textField6.getText();
                float size = Float.parseFloat(sizeString);
                COASelectionAreaDialog.this.setSizeZ(size);
                COASelectionAreaDialog.this.updateContent();
            }
        });
        this.textField6.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent e) {
                try {
                    String s = COASelectionAreaDialog.this.textField6.getText();
                    float val = Float.parseFloat(s);
                    int sliderValue = COASelectionAreaDialog.this.getSliderPos(val);
                    if (sliderValue >= 2000) {
                        COASelectionAreaDialog.this.sizeZSlider.setValue(2000);
                        COASelectionAreaDialog.this.textField6.setText("" + 2.0f * COASelectionAreaDialog.this.maxPos);
                    } else if (sliderValue == 0) {
                        COASelectionAreaDialog.this.sizeZSlider.setValue(0);
                        COASelectionAreaDialog.this.textField6.setText("0.0");
                    } else {
                        COASelectionAreaDialog.this.sizeZSlider.setValue(sliderValue);
                        COASelectionAreaDialog.this.textField6.setText("" + val);
                    }
                }
                catch (Exception exc) {
                    COASelectionAreaDialog.this.sizeZSlider.setValue(COASelectionAreaDialog.this.initSizePos);
                    COASelectionAreaDialog.this.textField6.setText("" + COASelectionAreaDialog.this.initSize);
                    COASelectionAreaDialog.this.setSizeZ(COASelectionAreaDialog.this.initSize);
                    COASelectionAreaDialog.this.updateContent();
                }
                String sizeString = COASelectionAreaDialog.this.textField6.getText();
                float size = Float.parseFloat(sizeString);
                COASelectionAreaDialog.this.setSizeZ(size);
                COASelectionAreaDialog.this.updateContent();
            }

            @Override
            public void focusGained(FocusEvent e) {
            }
        });
        this.sizeZSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                JSlider source = (JSlider)e.getSource();
                int value = source.getValue();
                float displayValue = COASelectionAreaDialog.this.getCoord(value);
                if (value == 0) {
                    displayValue = 0.0f;
                }
                if (value == 2000) {
                    displayValue = 2.0f * COASelectionAreaDialog.this.maxPos;
                }
                COASelectionAreaDialog.this.textField6.setText("" + displayValue);
                String dString = COASelectionAreaDialog.this.textField6.getText();
                float size = Float.parseFloat(dString);
                COASelectionAreaDialog.this.setSizeZ(size);
                COASelectionAreaDialog.this.updateContent();
            }
        });
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        JPanel pane = new JPanel();
        pane.setBackground(Color.white);
        pane.setBorder(new EtchedBorder());
        pane.setLayout(gridbag);
        JLabel posXLabel = new JLabel("Position X  ");
        this.buildConstraints(constraints, 0, 0, 1, 1, 25, 16);
        gridbag.setConstraints(posXLabel, constraints);
        pane.add(posXLabel);
        this.buildConstraints(constraints, 1, 0, 1, 1, 25, 0);
        gridbag.setConstraints(this.textField1, constraints);
        pane.add(this.textField1);
        this.buildConstraints(constraints, 2, 0, 1, 1, 50, 0);
        gridbag.setConstraints(this.posXSlider, constraints);
        pane.add(this.posXSlider);
        JLabel posYLabel = new JLabel("Position Y  ");
        this.buildConstraints(constraints, 0, 1, 1, 1, 25, 16);
        gridbag.setConstraints(posYLabel, constraints);
        pane.add(posYLabel);
        this.buildConstraints(constraints, 1, 1, 1, 1, 25, 0);
        gridbag.setConstraints(this.textField2, constraints);
        pane.add(this.textField2);
        this.buildConstraints(constraints, 2, 1, 1, 1, 50, 0);
        gridbag.setConstraints(this.posYSlider, constraints);
        pane.add(this.posYSlider);
        JLabel posZLabel = new JLabel("Position Z  ");
        this.buildConstraints(constraints, 0, 2, 1, 1, 25, 17);
        gridbag.setConstraints(posZLabel, constraints);
        pane.add(posZLabel);
        this.buildConstraints(constraints, 1, 2, 1, 1, 25, 0);
        gridbag.setConstraints(this.textField3, constraints);
        pane.add(this.textField3);
        this.buildConstraints(constraints, 2, 2, 1, 1, 50, 0);
        gridbag.setConstraints(this.posZSlider, constraints);
        pane.add(this.posZSlider);
        JLabel sizeXLabel = new JLabel("Size X  ");
        this.buildConstraints(constraints, 0, 3, 1, 1, 25, 17);
        gridbag.setConstraints(sizeXLabel, constraints);
        pane.add(sizeXLabel);
        this.buildConstraints(constraints, 1, 3, 1, 1, 25, 0);
        gridbag.setConstraints(this.textField4, constraints);
        pane.add(this.textField4);
        this.buildConstraints(constraints, 2, 3, 1, 1, 50, 0);
        gridbag.setConstraints(this.sizeXSlider, constraints);
        pane.add(this.sizeXSlider);
        JLabel sizeYLabel = new JLabel("Size Y  ");
        this.buildConstraints(constraints, 0, 4, 1, 1, 25, 17);
        gridbag.setConstraints(sizeYLabel, constraints);
        pane.add(sizeYLabel);
        this.buildConstraints(constraints, 1, 4, 1, 1, 25, 0);
        gridbag.setConstraints(this.textField5, constraints);
        pane.add(this.textField5);
        this.buildConstraints(constraints, 2, 4, 1, 1, 50, 0);
        gridbag.setConstraints(this.sizeYSlider, constraints);
        pane.add(this.sizeYSlider);
        JLabel sizeZLabel = new JLabel("Size Z  ");
        this.buildConstraints(constraints, 0, 5, 1, 1, 25, 17);
        gridbag.setConstraints(sizeZLabel, constraints);
        pane.add(sizeZLabel);
        this.buildConstraints(constraints, 1, 5, 1, 1, 25, 0);
        gridbag.setConstraints(this.textField6, constraints);
        pane.add(this.textField6);
        this.buildConstraints(constraints, 2, 5, 1, 1, 50, 0);
        gridbag.setConstraints(this.sizeZSlider, constraints);
        pane.add(this.sizeZSlider);
        this.addContent(pane);
        Listener listener = new Listener();
        this.addWindowListener(listener);
        this.setActionListeners(listener);
        this.pack();
    }

    private int getSliderPos(float pos) {
        return Math.round(1000.0f / this.maxPos * pos);
    }

    private float getCoord(int sliderPos) {
        return this.maxPos * (float)sliderPos / 1000.0f;
    }

    void buildConstraints(GridBagConstraints gbc, int gx, int gy, int gw, int gh, int wx, int wy) {
        gbc.gridx = gx;
        gbc.gridy = gy;
        gbc.gridwidth = gw;
        gbc.gridheight = gh;
        gbc.weightx = wx;
        gbc.weighty = wy;
    }

    public int showModal() {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((screenSize.width - this.getSize().width) / 2, (screenSize.height - this.getSize().height) / 2);
        this.show();
        return this.result;
    }

    public float getPositionX() {
        return Float.parseFloat(this.textField1.getText());
    }

    private void setPositionX(float posX) {
        this.positionX = posX;
    }

    public float getPositionY() {
        return Float.parseFloat(this.textField2.getText());
    }

    private void setPositionY(float posY) {
        this.positionY = posY;
    }

    public float getPositionZ() {
        return Float.parseFloat(this.textField3.getText());
    }

    private void setPositionZ(float posZ) {
        this.positionZ = posZ;
    }

    public float getSizeX() {
        return Float.parseFloat(this.textField4.getText());
    }

    private void setSizeX(float val) {
        this.sizeX = val;
    }

    public float getSizeY() {
        return Float.parseFloat(this.textField5.getText());
    }

    private void setSizeY(float val) {
        this.sizeY = val;
    }

    public float getSizeZ() {
        return Float.parseFloat(this.textField6.getText());
    }

    private void setSizeZ(float val) {
        this.sizeZ = val;
    }

    private void updateContent() {
        this.content.setBoxPosition(this.getPositionX(), this.getPositionY(), this.getPositionZ());
        this.content.setBoxSize(this.getSizeX(), this.getSizeY(), this.getSizeZ());
        this.content.updateScene();
    }

    private void updateContentToInit() {
        this.content.setBoxPosition(0.0f, 0.0f, 0.0f);
        this.content.setBoxSize(this.initSize, this.initSize, this.initSize);
        this.content.updateScene();
    }

    private void resetValues() {
        this.posXSlider.setValue(0);
        this.posYSlider.setValue(0);
        this.posZSlider.setValue(0);
        this.sizeXSlider.setValue(this.initSizePos);
        this.sizeYSlider.setValue(this.initSizePos);
        this.sizeZSlider.setValue(this.initSizePos);
        this.textField1.setText("0.0");
        this.textField2.setText("0.0");
        this.textField3.setText("0.0");
        this.textField4.setText("" + this.initSize);
        this.textField5.setText("" + this.initSize);
        this.textField6.setText("" + this.initSize);
    }

    public static void main(String[] args) {
        COASelectionAreaDialog dialog = new COASelectionAreaDialog(new Frame(), 0.0f, 0.0f, 0.0f, 5.0f, 5.0f, 5.0f);
        dialog.showModal();
    }

    private class Listener
    extends DialogListener {
        private Listener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String command = e.getActionCommand();
            if (command.equals("ok-command")) {
                try {
                    Float.parseFloat(COASelectionAreaDialog.this.textField1.getText());
                    Float.parseFloat(COASelectionAreaDialog.this.textField2.getText());
                    Float.parseFloat(COASelectionAreaDialog.this.textField3.getText());
                    Float.parseFloat(COASelectionAreaDialog.this.textField4.getText());
                    Float.parseFloat(COASelectionAreaDialog.this.textField5.getText());
                    Float.parseFloat(COASelectionAreaDialog.this.textField6.getText());
                    COASelectionAreaDialog.this.result = 0;
                }
                catch (Exception exception) {
                    COASelectionAreaDialog.this.result = 2;
                }
                COASelectionAreaDialog.this.dispose();
            } else if (command.equals("cancel-command")) {
                COASelectionAreaDialog.this.result = 2;
                COASelectionAreaDialog.this.dispose();
            } else if (command.equals("reset-command")) {
                COASelectionAreaDialog.this.resetValues();
                COASelectionAreaDialog.this.updateContentToInit();
            } else if (command.equals("info-command")) {
                HelpWindow.launchBrowser(COASelectionAreaDialog.this, "COA Selection Area Configuration");
            }
        }

        @Override
        public void windowClosing(WindowEvent e) {
            COASelectionAreaDialog.this.result = -1;
            COASelectionAreaDialog.this.dispose();
        }
    }
}

