/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.coa;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import org.tigr.microarray.mev.cluster.gui.impl.GUIFactory;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.AlgorithmDialog;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.DialogListener;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.dialogHelpUtil.HelpWindow;

public class COAResultConfigDialog
extends AlgorithmDialog {
    private int result;
    private JTextField textField1;
    private JTextField textField2;
    private JTextField textField3;
    private JTextField textField4;
    private JTextField textField5;
    private float pointSize;
    private float selectedPointSize;
    private float scaleAxisX;
    float scaleAxisY;
    float scaleAxisZ;

    public COAResultConfigDialog(Frame parent, float pointSize, float selectedPointSize, float scaleAxisX, float scaleAxisY, float scaleAxisZ) {
        super(new JFrame(), "COA Result Configuration", true);
        this.pointSize = pointSize;
        this.selectedPointSize = selectedPointSize;
        this.scaleAxisX = scaleAxisX;
        this.scaleAxisY = scaleAxisY;
        this.scaleAxisZ = scaleAxisZ;
        Listener listener = new Listener();
        this.addWindowListener(listener);
        JPanel parameters = new JPanel(new GridLayout(0, 2, 10, 0));
        parameters.setBorder(new EmptyBorder(20, 20, 20, 10));
        parameters.setBackground(Color.white);
        parameters.add(new JLabel("Scale axis X  "));
        this.textField1 = new JTextField(Float.toString(scaleAxisX), 5);
        parameters.add((Component)this.textField1, "East");
        parameters.add(new JLabel("Scale axis Y  "));
        this.textField2 = new JTextField(Float.toString(scaleAxisY), 5);
        parameters.add((Component)this.textField2, "East");
        parameters.add(new JLabel("Scale axis Z  "));
        this.textField3 = new JTextField(Float.toString(scaleAxisZ), 5);
        parameters.add((Component)this.textField3, "East");
        parameters.add(new JLabel("Pointsize  "));
        this.textField4 = new JTextField(Float.toString(pointSize), 5);
        parameters.add((Component)this.textField4, "East");
        parameters.add(new JLabel("Selected "));
        this.textField5 = new JTextField(Float.toString(selectedPointSize), 5);
        parameters.add((Component)this.textField5, "East");
        JPanel panel2 = new JPanel(new BorderLayout());
        panel2.setBorder(new EmptyBorder(10, 0, 0, 0));
        JPanel panel3 = new JPanel(new BorderLayout());
        panel3.setForeground(Color.white);
        panel3.setBorder(BorderFactory.createLineBorder(Color.gray));
        panel3.setBackground(Color.white);
        panel3.add((Component)parameters, "West");
        panel3.add((Component)new JLabel(GUIFactory.getIcon("dialog_button_bar.gif")), "East");
        JPanel panel1 = new JPanel(new BorderLayout());
        panel1.add((Component)panel2, "South");
        panel1.add((Component)panel3, "North");
        this.addContent(panel1);
        this.setActionListeners(listener);
        this.pack();
        this.setResizable(false);
    }

    public int showModal() {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((screenSize.width - this.getSize().width) / 2, (screenSize.height - this.getSize().height) / 2);
        this.show();
        return this.result;
    }

    public float getScaleAxisX() {
        return Float.parseFloat(this.textField1.getText());
    }

    public float getScaleAxisY() {
        return Float.parseFloat(this.textField2.getText());
    }

    public float getScaleAxisZ() {
        return Float.parseFloat(this.textField3.getText());
    }

    public float getPointSize() {
        return Float.parseFloat(this.textField4.getText());
    }

    public float getSelectedPointSize() {
        return Float.parseFloat(this.textField5.getText());
    }

    public static void main(String[] args) {
        COAResultConfigDialog dialog = new COAResultConfigDialog(new Frame(), 1.0f, 1.0f, 5.0f, 5.0f, 5.0f);
        dialog.showModal();
    }

    private class Listener
    extends DialogListener {
        private Listener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String command = e.getActionCommand();
            if (command.equals("ok-command")) {
                try {
                    Float.parseFloat(COAResultConfigDialog.this.textField1.getText());
                    Float.parseFloat(COAResultConfigDialog.this.textField2.getText());
                    Float.parseFloat(COAResultConfigDialog.this.textField3.getText());
                    Float.parseFloat(COAResultConfigDialog.this.textField4.getText());
                    Float.parseFloat(COAResultConfigDialog.this.textField5.getText());
                    COAResultConfigDialog.this.result = 0;
                }
                catch (Exception exception) {
                    COAResultConfigDialog.this.result = 2;
                }
                COAResultConfigDialog.this.dispose();
            } else if (command.equals("cancel-command")) {
                COAResultConfigDialog.this.result = 2;
                COAResultConfigDialog.this.dispose();
            } else if (command.equals("reset-command")) {
                COAResultConfigDialog.this.textField1.setText(String.valueOf(COAResultConfigDialog.this.scaleAxisX));
                COAResultConfigDialog.this.textField2.setText(String.valueOf(COAResultConfigDialog.this.scaleAxisY));
                COAResultConfigDialog.this.textField3.setText(String.valueOf(COAResultConfigDialog.this.scaleAxisZ));
                COAResultConfigDialog.this.textField4.setText(String.valueOf(COAResultConfigDialog.this.pointSize));
                COAResultConfigDialog.this.textField5.setText(String.valueOf(COAResultConfigDialog.this.selectedPointSize));
            } else if (command.equals("info-command")) {
                HelpWindow.launchBrowser(COAResultConfigDialog.this, "COA Result Configuration");
            }
        }

        @Override
        public void windowClosing(WindowEvent e) {
            COAResultConfigDialog.this.result = -1;
            COAResultConfigDialog.this.dispose();
        }
    }
}

