/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.coa;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.AlgorithmDialog;

public class COAInitDialog
extends AlgorithmDialog {
    boolean okPressed = false;
    JTextField numNeighborsField;

    public COAInitDialog(JFrame parentFrame, boolean modality) {
        super(parentFrame, "COA", modality);
        this.setBounds(0, 0, 600, 200);
        this.setBackground(Color.white);
        this.setDefaultCloseOperation(2);
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.fill = 0;
        JPanel pane = new JPanel();
        pane.setBackground(Color.white);
        pane.setBorder(new EtchedBorder());
        pane.setLayout(gridbag);
        JLabel numNeibsLabel = new JLabel("Number for neighbors for KNN imputation :");
        this.buildConstraints(constraints, 0, 0, 1, 1, 50, 100);
        gridbag.setConstraints(numNeibsLabel, constraints);
        pane.add(numNeibsLabel);
        this.numNeighborsField = new JTextField("10", 7);
        this.buildConstraints(constraints, 1, 0, 1, 1, 50, 100);
        gridbag.setConstraints(this.numNeighborsField, constraints);
        pane.add(this.numNeighborsField);
        this.addContent(pane);
        EventListener listener = new EventListener();
        this.setActionListeners(listener);
        this.addWindowListener(listener);
    }

    @Override
    public void setVisible(boolean visible) {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((screenSize.width - this.getSize().width) / 2, (screenSize.height - this.getSize().height) / 2);
        super.setVisible(visible);
    }

    void buildConstraints(GridBagConstraints gbc, int gx, int gy, int gw, int gh, int wx, int wy) {
        gbc.gridx = gx;
        gbc.gridy = gy;
        gbc.gridwidth = gw;
        gbc.gridheight = gh;
        gbc.weightx = wx;
        gbc.weighty = wy;
    }

    public boolean isOkPressed() {
        return this.okPressed;
    }

    public int getNumNeighbors() {
        return Integer.parseInt(this.numNeighborsField.getText());
    }

    public static void main(String[] args) {
        COAInitDialog cd = new COAInitDialog(new JFrame(), true);
        cd.setVisible(true);
    }

    public class EventListener
    extends WindowAdapter
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent ae) {
            String command = ae.getActionCommand();
            if (command.equals("ok-command")) {
                try {
                    int numNeibs = COAInitDialog.this.getNumNeighbors();
                    if (numNeibs <= 0) {
                        JOptionPane.showMessageDialog(null, "Invalid number of neighbors", "Error", 0);
                        return;
                    }
                    COAInitDialog.this.okPressed = true;
                    COAInitDialog.this.dispose();
                }
                catch (NumberFormatException nfe) {
                    JOptionPane.showMessageDialog(null, "Invalid number of neighbors", "Error", 0);
                    return;
                }
            } else if (command.equals("reset-command")) {
                COAInitDialog.this.numNeighborsField.setText("10");
            } else if (command.equals("cancel-command")) {
                COAInitDialog.this.okPressed = false;
                COAInitDialog.this.dispose();
            } else if (command.equals("info-command")) {
                // empty if block
            }
        }
    }
}

