/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.coa;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.text.DecimalFormat;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextArea;
import org.tigr.microarray.mev.TMEV;
import org.tigr.microarray.mev.cluster.gui.impl.GUIFactory;
import org.tigr.microarray.mev.cluster.gui.impl.ViewerAdapter;

public class COAInertiaValsViewer
extends ViewerAdapter
implements Serializable {
    private JComponent header;
    private JTextArea content;
    private double[] inertiaVals;
    private double[] cumulInertiaVals;
    private JPopupMenu popup;

    public COAInertiaValsViewer(double[] inertiaVals, double[] cumulInertiaVals) {
        this.inertiaVals = inertiaVals;
        this.cumulInertiaVals = cumulInertiaVals;
        this.header = this.createHeader();
        this.content = this.createContent();
        this.setMaxWidth(this.content, this.header);
    }

    public COAInertiaValsViewer(JTextArea content, JComponent header) {
        this.content = content;
        this.header = header;
        this.setMaxWidth(content, header);
    }

    @Override
    public JComponent getContentComponent() {
        return this.content;
    }

    @Override
    public JComponent getHeaderComponent() {
        return this.header;
    }

    void buildConstraints(GridBagConstraints gbc, int gx, int gy, int gw, int gh, int wx, int wy) {
        gbc.gridx = gx;
        gbc.gridy = gy;
        gbc.gridwidth = gw;
        gbc.gridheight = gh;
        gbc.weightx = wx;
        gbc.weighty = wy;
    }

    private JComponent createHeader() {
        JPanel panel = new JPanel();
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        panel.setBackground(Color.white);
        panel.setLayout(gridbag);
        constraints.fill = 2;
        constraints.insets = new Insets(10, 200, 10, 200);
        JLabel label1 = new JLabel("<html><body bgcolor='#FFFFFF'><font face='serif' size='5' color='#000080'><b>Inertia values</b></font></body></html>");
        this.buildConstraints(constraints, 0, 0, 1, 1, 100, 80);
        gridbag.setConstraints(label1, constraints);
        panel.add(label1);
        JTextArea area = new JTextArea();
        area.setEditable(false);
        StringBuffer sb = new StringBuffer();
        sb.append("  Axis\tInertia (%)\tCumulative Inertia (%)");
        area.setForeground(Color.blue);
        area.setText(sb.toString());
        area.setCaretPosition(0);
        this.buildConstraints(constraints, 0, 1, 1, 1, 0, 20);
        constraints.anchor = 15;
        constraints.insets = new Insets(10, 0, 0, 0);
        gridbag.setConstraints(area, constraints);
        panel.add(area);
        return panel;
    }

    private JTextArea createContent() {
        JTextArea area = new JTextArea();
        area.setEditable(false);
        StringBuffer sb = new StringBuffer();
        DecimalFormat nf = new DecimalFormat();
        nf.setMaximumFractionDigits(2);
        nf.setMinimumFractionDigits(2);
        for (int counter = 0; counter < this.inertiaVals.length; ++counter) {
            sb.append("   " + (counter + 1) + "\t" + this.printFormat(this.inertiaVals[counter]) + "\t" + this.printFormat(this.cumulInertiaVals[counter]) + "\n");
        }
        area.setText(sb.toString());
        area.setCaretPosition(0);
        final JFileChooser fc = new JFileChooser(TMEV.getDataPath());
        fc.setDialogTitle("Save Inertia values");
        this.popup = new JPopupMenu();
        JMenuItem menuItem = new JMenuItem("Save inertia values", GUIFactory.getIcon("save16.gif"));
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                int returnVal = fc.showSaveDialog(COAInertiaValsViewer.this.getHeaderComponent());
                if (returnVal == 0) {
                    File file = fc.getSelectedFile();
                    try {
                        PrintWriter out = new PrintWriter(new FileOutputStream(file));
                        out.print("Axis\tInertia (%)\tCumulative Inertia (%)\n\n");
                        for (int i = 0; i < COAInertiaValsViewer.this.inertiaVals.length; ++i) {
                            out.print(i + 1 + "\t" + COAInertiaValsViewer.this.inertiaVals[i] + "\t" + COAInertiaValsViewer.this.cumulInertiaVals[i] + "\n");
                        }
                        out.println();
                        out.flush();
                        out.close();
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
            }
        });
        this.popup.add(menuItem);
        area.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                this.maybeShowPopup(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                this.maybeShowPopup(e);
            }

            private void maybeShowPopup(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    COAInertiaValsViewer.this.popup.show(e.getComponent(), e.getX(), e.getY());
                }
            }
        });
        return area;
    }

    private void setMaxWidth(JComponent content, JComponent header) {
        int c_width = content.getPreferredSize().width;
        int h_width = header.getPreferredSize().width;
        if (c_width > h_width) {
            header.setPreferredSize(new Dimension(c_width, header.getPreferredSize().height));
        } else {
            content.setPreferredSize(new Dimension(h_width, content.getPreferredSize().height));
        }
    }

    private String printFormat(double d) {
        DecimalFormat nf = new DecimalFormat();
        nf.setMaximumFractionDigits(2);
        nf.setMinimumFractionDigits(2);
        if (Double.isNaN(d)) {
            return "N/A";
        }
        return nf.format(d);
    }
}

