/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.coa;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.tree.DefaultMutableTreeNode;
import org.tigr.microarray.mev.cluster.algorithm.Algorithm;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmData;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmEvent;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmException;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmListener;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmParameters;
import org.tigr.microarray.mev.cluster.gui.Experiment;
import org.tigr.microarray.mev.cluster.gui.IClusterGUI;
import org.tigr.microarray.mev.cluster.gui.IData;
import org.tigr.microarray.mev.cluster.gui.IFramework;
import org.tigr.microarray.mev.cluster.gui.IViewer;
import org.tigr.microarray.mev.cluster.gui.LeafInfo;
import org.tigr.microarray.mev.cluster.gui.impl.coa.COA2DViewer;
import org.tigr.microarray.mev.cluster.gui.impl.coa.COA3DViewer;
import org.tigr.microarray.mev.cluster.gui.impl.coa.COAAdditional3DAxesDialog;
import org.tigr.microarray.mev.cluster.gui.impl.coa.COADummyViewer;
import org.tigr.microarray.mev.cluster.gui.impl.coa.COAInertiaValsViewer;
import org.tigr.microarray.mev.cluster.gui.impl.coa.COAInitDialog;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.DialogListener;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.Logger;
import org.tigr.microarray.mev.script.scriptGUI.IScriptGUI;
import org.tigr.util.FloatMatrix;

public class COAGUI
implements IClusterGUI,
IScriptGUI {
    private static final String ADD_NEW_3D_CMD = "add-new-3d-cmd";
    private static final String ADD_NEW_2D_CMD = "add-new-2d-cmd";
    public static final int GENES = 1;
    public static final int EXPTS = 2;
    public static final int BOTH = 3;
    private Algorithm algorithm;
    private Logger logger;
    private IData data;
    private Experiment experiment;
    private FloatMatrix geneUMatrix;
    private FloatMatrix exptUMatrix;
    private FloatMatrix lambdaValues;
    private IFramework currFramework;
    private DefaultMutableTreeNode projectionNode;
    private double[] lambdaArray;
    private double[] inertiaVals;
    private double[] cumulativeInertiaVals;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DefaultMutableTreeNode execute(IFramework framework) throws AlgorithmException {
        this.experiment = framework.getData().getExperiment();
        this.data = framework.getData();
        int number_of_samples = this.experiment.getNumberOfSamples();
        int number_of_genes = this.experiment.getNumberOfGenes();
        COAInitDialog cDialog = new COAInitDialog((JFrame)framework.getFrame(), true);
        cDialog.setVisible(true);
        if (!cDialog.isOkPressed()) {
            return null;
        }
        int numNeibs = cDialog.getNumNeighbors();
        Listener listener = new Listener();
        try {
            this.algorithm = framework.getAlgorithmFactory().getAlgorithm("COA");
            this.algorithm.addAlgorithmListener((AlgorithmListener)listener);
            this.logger = new Logger(framework.getFrame(), "COA Log Window", listener);
            this.logger.show();
            this.logger.append("Starting SVD calculation\n");
            this.currFramework = framework;
            AlgorithmData data = new AlgorithmData();
            data.addMatrix("experiment", this.experiment.getMatrix());
            data.addParam("numNeighbors", String.valueOf(numNeibs));
            long start = System.currentTimeMillis();
            AlgorithmData result = this.algorithm.execute(data);
            long time = System.currentTimeMillis() - start;
            this.geneUMatrix = result.getMatrix("gene");
            this.exptUMatrix = result.getMatrix("expt");
            this.lambdaValues = result.getMatrix("lambdaValues");
            this.calculateInertiaVals();
            DefaultMutableTreeNode node = new DefaultMutableTreeNode("COA");
            this.addResultNodes(framework.getFrame(), node, time, this.experiment);
            DefaultMutableTreeNode defaultMutableTreeNode = node;
            return defaultMutableTreeNode;
        }
        finally {
            if (this.algorithm != null) {
                this.algorithm.removeAlgorithmListener((AlgorithmListener)listener);
            }
            if (this.logger != null) {
                this.logger.dispose();
            }
        }
    }

    private void calculateInertiaVals() {
        int i;
        this.lambdaArray = new double[this.lambdaValues.getRowDimension()];
        for (int i2 = 0; i2 < this.lambdaArray.length; ++i2) {
            this.lambdaArray[i2] = this.lambdaValues.get(i2, 0);
        }
        double totalLambdaSquared = 0.0;
        for (i = 0; i < this.lambdaArray.length; ++i) {
            totalLambdaSquared += Math.pow(this.lambdaArray[i], 2.0);
        }
        this.inertiaVals = new double[this.lambdaArray.length];
        this.cumulativeInertiaVals = new double[this.lambdaArray.length];
        for (i = 0; i < this.inertiaVals.length; ++i) {
            this.inertiaVals[i] = Math.pow(this.lambdaArray[i], 2.0) * 100.0 / totalLambdaSquared;
        }
        this.cumulativeInertiaVals[0] = this.inertiaVals[0];
        for (i = 1; i < this.cumulativeInertiaVals.length; ++i) {
            double currCumul = 0.0;
            for (int j = 0; j <= i; ++j) {
                currCumul += this.inertiaVals[j];
            }
            this.cumulativeInertiaVals[i] = currCumul;
        }
    }

    private void addResultNodes(Frame frame, DefaultMutableTreeNode node, long time, Experiment experiment) {
        Listener listener = new Listener();
        COADummyViewer cdv = new COADummyViewer(this.geneUMatrix, this.exptUMatrix);
        DefaultMutableTreeNode firstNode = new DefaultMutableTreeNode("Components 1, 2, 3");
        DefaultMutableTreeNode threeDNode = new DefaultMutableTreeNode("3D Views");
        DefaultMutableTreeNode twoDNode = new DefaultMutableTreeNode("2D Views");
        this.add3DViewNode(frame, threeDNode, experiment, 0, 1, 2);
        this.add2DViewNode(twoDNode, experiment, 0, 1, 2);
        firstNode.add(threeDNode);
        firstNode.add(twoDNode);
        JPopupMenu projMenu = new JPopupMenu();
        JMenuItem menuItem = new JMenuItem("Add new 3-axis projections");
        menuItem.setActionCommand(ADD_NEW_3D_CMD);
        menuItem.addActionListener(listener);
        projMenu.add(menuItem);
        menuItem = new JMenuItem("Add new 2-axis projections");
        menuItem.setActionCommand(ADD_NEW_2D_CMD);
        menuItem.addActionListener(listener);
        projMenu.add(menuItem);
        this.projectionNode = new DefaultMutableTreeNode(new LeafInfo("Projections on COA axes", (IViewer)cdv, cdv.getJPopupMenu()));
        this.projectionNode.add(firstNode);
        node.add(this.projectionNode);
        this.addCOAInertiaViewer(node);
    }

    private void addCOAInertiaViewer(DefaultMutableTreeNode root) {
        COAInertiaValsViewer inertiaValsViewer = new COAInertiaValsViewer(this.inertiaVals, this.cumulativeInertiaVals);
        root.add(new DefaultMutableTreeNode(new LeafInfo("Inertia values", (IViewer)inertiaValsViewer)));
    }

    private void add3DViewNode(Frame frame, DefaultMutableTreeNode node, Experiment experiment) {
        COA3DViewer coa3DGeneViewer = new COA3DViewer(frame, this.geneUMatrix, experiment, 1, 0, 1, 2);
        COA3DViewer coa3DExptViewer = new COA3DViewer(frame, this.exptUMatrix, experiment, 2, 0, 1, 2);
        COA3DViewer coa3DBothViewer = new COA3DViewer(frame, this.geneUMatrix, this.exptUMatrix, experiment, 3, 0, 1, 2);
        node.add(new DefaultMutableTreeNode(new LeafInfo("3D view - genes", (IViewer)coa3DGeneViewer, coa3DGeneViewer.getJPopupMenu())));
        node.add(new DefaultMutableTreeNode(new LeafInfo("3D view - expts", (IViewer)coa3DExptViewer, coa3DExptViewer.getJPopupMenu())));
        node.add(new DefaultMutableTreeNode(new LeafInfo("3D view - both", (IViewer)coa3DBothViewer, coa3DBothViewer.getJPopupMenu())));
    }

    private void add3DViewNode(Frame frame, DefaultMutableTreeNode node, Experiment experiment, int xAxis, int yAxis, int zAxis) {
        COA3DViewer coa3DGeneViewer = new COA3DViewer(frame, this.geneUMatrix, experiment, 1, xAxis, yAxis, zAxis);
        COA3DViewer coa3DExptViewer = new COA3DViewer(frame, this.exptUMatrix, experiment, 2, xAxis, yAxis, zAxis);
        COA3DViewer coa3DBothViewer = new COA3DViewer(frame, this.geneUMatrix, this.exptUMatrix, experiment, 3, xAxis, yAxis, zAxis);
        node.add(new DefaultMutableTreeNode(new LeafInfo("3D view - genes", (IViewer)coa3DGeneViewer, coa3DGeneViewer.getJPopupMenu())));
        node.add(new DefaultMutableTreeNode(new LeafInfo("3D view - expts", (IViewer)coa3DExptViewer, coa3DExptViewer.getJPopupMenu())));
        node.add(new DefaultMutableTreeNode(new LeafInfo("3D view - both", (IViewer)coa3DBothViewer, coa3DBothViewer.getJPopupMenu())));
    }

    private void add2DViewNode(DefaultMutableTreeNode node, Experiment experiment) {
        DefaultMutableTreeNode genes = new DefaultMutableTreeNode("2D views - genes");
        DefaultMutableTreeNode expts = new DefaultMutableTreeNode("2D views - expts");
        DefaultMutableTreeNode both = new DefaultMutableTreeNode("2D views - both");
        COA2DViewer coa01 = new COA2DViewer(experiment, this.geneUMatrix, 1, 0, 1);
        COA2DViewer coa12 = new COA2DViewer(experiment, this.geneUMatrix, 1, 1, 2);
        COA2DViewer coa02 = new COA2DViewer(experiment, this.geneUMatrix, 1, 0, 2);
        genes.add(new DefaultMutableTreeNode(new LeafInfo("1, 2", (IViewer)coa01, coa01.getJPopupMenu())));
        genes.add(new DefaultMutableTreeNode(new LeafInfo("2, 3", (IViewer)coa12, coa12.getJPopupMenu())));
        genes.add(new DefaultMutableTreeNode(new LeafInfo("1, 3", (IViewer)coa02, coa02.getJPopupMenu())));
        COA2DViewer coaExpts01 = new COA2DViewer(experiment, this.exptUMatrix, 2, 0, 1);
        COA2DViewer coaExpts12 = new COA2DViewer(experiment, this.exptUMatrix, 2, 1, 2);
        COA2DViewer coaExpts02 = new COA2DViewer(experiment, this.exptUMatrix, 2, 0, 2);
        expts.add(new DefaultMutableTreeNode(new LeafInfo("1, 2", (IViewer)coaExpts01, coaExpts01.getJPopupMenu())));
        expts.add(new DefaultMutableTreeNode(new LeafInfo("2, 3", (IViewer)coaExpts12, coaExpts12.getJPopupMenu())));
        expts.add(new DefaultMutableTreeNode(new LeafInfo("1, 3", (IViewer)coaExpts02, coaExpts02.getJPopupMenu())));
        COA2DViewer both01 = new COA2DViewer(experiment, this.geneUMatrix, this.exptUMatrix, 3, 0, 1);
        COA2DViewer both12 = new COA2DViewer(experiment, this.geneUMatrix, this.exptUMatrix, 3, 1, 2);
        COA2DViewer both02 = new COA2DViewer(experiment, this.geneUMatrix, this.exptUMatrix, 3, 0, 2);
        both.add(new DefaultMutableTreeNode(new LeafInfo("1, 2", (IViewer)both01, both01.getJPopupMenu())));
        both.add(new DefaultMutableTreeNode(new LeafInfo("2, 3", (IViewer)both12, both12.getJPopupMenu())));
        both.add(new DefaultMutableTreeNode(new LeafInfo("1, 3", (IViewer)both02, both02.getJPopupMenu())));
        node.add(genes);
        node.add(expts);
        node.add(both);
    }

    private void add2DViewNode(DefaultMutableTreeNode node, Experiment experiment, int xAxis, int yAxis, int zAxis) {
        DefaultMutableTreeNode genes = new DefaultMutableTreeNode("2D views - genes");
        DefaultMutableTreeNode expts = new DefaultMutableTreeNode("2D views - expts");
        DefaultMutableTreeNode both = new DefaultMutableTreeNode("2D views - both");
        COA2DViewer coaxy = new COA2DViewer(experiment, this.geneUMatrix, 1, xAxis, yAxis);
        COA2DViewer coayz = new COA2DViewer(experiment, this.geneUMatrix, 1, yAxis, zAxis);
        COA2DViewer coaxz = new COA2DViewer(experiment, this.geneUMatrix, 1, xAxis, zAxis);
        genes.add(new DefaultMutableTreeNode(new LeafInfo("" + (xAxis + 1) + ", " + (yAxis + 1), (IViewer)coaxy, coaxy.getJPopupMenu())));
        genes.add(new DefaultMutableTreeNode(new LeafInfo("" + (yAxis + 1) + ", " + (zAxis + 1), (IViewer)coayz, coayz.getJPopupMenu())));
        genes.add(new DefaultMutableTreeNode(new LeafInfo("" + (xAxis + 1) + ", " + (zAxis + 1), (IViewer)coaxz, coaxz.getJPopupMenu())));
        COA2DViewer coaExptsxy = new COA2DViewer(experiment, this.exptUMatrix, 2, xAxis, yAxis);
        COA2DViewer coaExptsyz = new COA2DViewer(experiment, this.exptUMatrix, 2, yAxis, zAxis);
        COA2DViewer coaExptsxz = new COA2DViewer(experiment, this.exptUMatrix, 2, xAxis, zAxis);
        expts.add(new DefaultMutableTreeNode(new LeafInfo("" + (xAxis + 1) + ", " + (yAxis + 1), (IViewer)coaExptsxy, coaExptsxy.getJPopupMenu())));
        expts.add(new DefaultMutableTreeNode(new LeafInfo("" + (yAxis + 1) + ", " + (zAxis + 1), (IViewer)coaExptsyz, coaExptsyz.getJPopupMenu())));
        expts.add(new DefaultMutableTreeNode(new LeafInfo("" + (xAxis + 1) + ", " + (zAxis + 1), (IViewer)coaExptsxz, coaExptsxz.getJPopupMenu())));
        COA2DViewer bothxy = new COA2DViewer(experiment, this.geneUMatrix, this.exptUMatrix, 3, xAxis, yAxis);
        COA2DViewer bothyz = new COA2DViewer(experiment, this.geneUMatrix, this.exptUMatrix, 3, yAxis, zAxis);
        COA2DViewer bothxz = new COA2DViewer(experiment, this.geneUMatrix, this.exptUMatrix, 3, xAxis, zAxis);
        both.add(new DefaultMutableTreeNode(new LeafInfo("" + (xAxis + 1) + ", " + (yAxis + 1), (IViewer)bothxy, bothxy.getJPopupMenu())));
        both.add(new DefaultMutableTreeNode(new LeafInfo("" + (yAxis + 1) + ", " + (zAxis + 1), (IViewer)bothyz, bothyz.getJPopupMenu())));
        both.add(new DefaultMutableTreeNode(new LeafInfo("" + (xAxis + 1) + ", " + (zAxis + 1), (IViewer)bothxz, bothxz.getJPopupMenu())));
        node.add(genes);
        node.add(expts);
        node.add(both);
    }

    private float[] getFloatArray(FloatMatrix matrix, int column) {
        float[] array = new float[matrix.getRowDimension()];
        for (int i = 0; i < array.length; ++i) {
            array[i] = matrix.A[i][column];
        }
        return array;
    }

    public void addNew3DNode() {
        COAAdditional3DAxesDialog pd = new COAAdditional3DAxesDialog((JFrame)this.currFramework.getFrame(), true, this.geneUMatrix.getColumnDimension());
        pd.setVisible(true);
        if (!pd.isOkPressed()) {
            return;
        }
        int selectedX = pd.getXAxis();
        int selectedY = pd.getYAxis();
        int selectedZ = pd.getZAxis();
        DefaultMutableTreeNode newNode = new DefaultMutableTreeNode("Components " + (selectedX + 1) + ", " + (selectedY + 1) + ", " + (selectedZ + 1));
        this.add3DViewNode(this.currFramework.getFrame(), newNode, this.currFramework.getData().getExperiment(), selectedX, selectedY, selectedZ);
        DefaultMutableTreeNode twoDNode = new DefaultMutableTreeNode("2D Views");
        this.add2DViewNode(twoDNode, this.currFramework.getData().getExperiment(), selectedX, selectedY, selectedZ);
        newNode.add(twoDNode);
        this.currFramework.addNode(this.projectionNode, newNode);
    }

    public void addNew2DNode() {
        COAAdditional3DAxesDialog pd = new COAAdditional3DAxesDialog((JFrame)this.currFramework.getFrame(), true, this.geneUMatrix.getColumnDimension());
        pd.setZBoxInvisible(true);
        pd.setVisible(true);
        if (!pd.isOkPressed()) {
            return;
        }
        int selectedX = pd.getXAxis();
        int selectedY = pd.getYAxis();
        DefaultMutableTreeNode newNode = new DefaultMutableTreeNode("Components " + (selectedX + 1) + ", " + (selectedY + 1));
        COA2DViewer coaGenexy = new COA2DViewer(this.experiment, this.geneUMatrix, 1, selectedX, selectedY);
        COA2DViewer coaExptxy = new COA2DViewer(this.experiment, this.exptUMatrix, 2, selectedX, selectedY);
        COA2DViewer coaBothxy = new COA2DViewer(this.experiment, this.geneUMatrix, this.exptUMatrix, 3, selectedX, selectedY);
        newNode.add(new DefaultMutableTreeNode(new LeafInfo("Genes", (IViewer)coaGenexy, coaGenexy.getJPopupMenu())));
        newNode.add(new DefaultMutableTreeNode(new LeafInfo("Expts", (IViewer)coaExptxy, coaExptxy.getJPopupMenu())));
        newNode.add(new DefaultMutableTreeNode(new LeafInfo("Both", (IViewer)coaBothxy, coaBothxy.getJPopupMenu())));
        this.currFramework.addNode(this.projectionNode, newNode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DefaultMutableTreeNode executeScript(IFramework framework, AlgorithmData algData, Experiment experiment) throws AlgorithmException {
        Listener listener = new Listener();
        try {
            this.algorithm = framework.getAlgorithmFactory().getAlgorithm("COA");
            this.algorithm.addAlgorithmListener((AlgorithmListener)listener);
            this.logger = new Logger(framework.getFrame(), "COA Log Window", listener);
            this.logger.show();
            this.logger.append("Starting SVD calculation\n");
            this.currFramework = framework;
            AlgorithmParameters params = algData.getParams();
            int numNeibs = params.getInt("numNeighbors");
            algData.addMatrix("experiment", experiment.getMatrix());
            long start = System.currentTimeMillis();
            AlgorithmData result = this.algorithm.execute(algData);
            long time = System.currentTimeMillis() - start;
            this.geneUMatrix = result.getMatrix("gene");
            this.exptUMatrix = result.getMatrix("expt");
            this.lambdaValues = result.getMatrix("lambdaValues");
            this.calculateInertiaVals();
            DefaultMutableTreeNode node = new DefaultMutableTreeNode("COA");
            this.addResultNodes(framework.getFrame(), node, time, experiment);
            DefaultMutableTreeNode defaultMutableTreeNode = node;
            return defaultMutableTreeNode;
        }
        finally {
            if (this.algorithm != null) {
                this.algorithm.removeAlgorithmListener((AlgorithmListener)listener);
            }
            if (this.logger != null) {
                this.logger.dispose();
            }
        }
    }

    public AlgorithmData getScriptParameters(IFramework framework) {
        this.experiment = framework.getData().getExperiment();
        this.data = framework.getData();
        int number_of_samples = this.experiment.getNumberOfSamples();
        int number_of_genes = this.experiment.getNumberOfGenes();
        COAInitDialog cDialog = new COAInitDialog((JFrame)framework.getFrame(), true);
        cDialog.setVisible(true);
        if (!cDialog.isOkPressed()) {
            return null;
        }
        int numNeibs = cDialog.getNumNeighbors();
        AlgorithmData data = new AlgorithmData();
        data.addParam("numNeighbors", String.valueOf(numNeibs));
        data.addParam("name", "COA");
        data.addParam("alg-type", "data-visualization");
        data.addParam("output-class", "single-output");
        String[] outputNodes = new String[]{"Data Visualization"};
        data.addStringArray("output-nodes", outputNodes);
        return data;
    }

    private class Listener
    extends DialogListener
    implements AlgorithmListener {
        private Listener() {
        }

        public void valueChanged(AlgorithmEvent event) {
            COAGUI.this.logger.append(event.getDescription());
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String command = e.getActionCommand();
            if (command.equals("cancel-command")) {
                COAGUI.this.algorithm.abort();
                COAGUI.this.logger.dispose();
            } else if (command.equals(COAGUI.ADD_NEW_3D_CMD)) {
                COAGUI.this.addNew3DNode();
            } else if (command.equals(COAGUI.ADD_NEW_2D_CMD)) {
                COAGUI.this.addNew2DNode();
            }
        }

        @Override
        public void windowClosing(WindowEvent e) {
            COAGUI.this.algorithm.abort();
            COAGUI.this.logger.dispose();
        }
    }
}

