/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.coa;

import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.Expression;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.tree.DefaultMutableTreeNode;
import org.tigr.microarray.mev.cluster.gui.Experiment;
import org.tigr.microarray.mev.cluster.gui.IFramework;
import org.tigr.microarray.mev.cluster.gui.IViewer;
import org.tigr.microarray.mev.cluster.gui.LeafInfo;
import org.tigr.microarray.mev.cluster.gui.impl.ViewerAdapter;
import org.tigr.microarray.mev.cluster.gui.impl.coa.COA2DViewer;
import org.tigr.microarray.mev.cluster.gui.impl.coa.COA3DViewer;
import org.tigr.microarray.mev.cluster.gui.impl.coa.COAAdditional3DAxesDialog;
import org.tigr.util.FloatMatrix;

public class COADummyViewer
extends ViewerAdapter {
    private static final String ADD_NEW_3D_CMD = "add-new-3d-cmd";
    private static final String ADD_NEW_2D_CMD = "add-new-2d-cmd";
    private JPopupMenu popup;
    private IFramework framework;
    private FloatMatrix geneUMatrix;
    private FloatMatrix exptUMatrix;
    private Experiment experiment;

    public COADummyViewer(FloatMatrix geneUMatrix, FloatMatrix exptUMatrix) {
        this.geneUMatrix = geneUMatrix;
        this.exptUMatrix = exptUMatrix;
        this.popup = this.createJPopupMenu();
    }

    @Override
    public Expression getExpression() {
        return new Expression(this, this.getClass(), "new", new Object[]{this.geneUMatrix, this.exptUMatrix});
    }

    @Override
    public void onSelected(IFramework framework) {
        this.framework = framework;
        if (this.popup == null) {
            this.popup = this.createJPopupMenu();
            DefaultMutableTreeNode node = framework.getCurrentNode();
            if (node != null && node.getUserObject() instanceof LeafInfo) {
                LeafInfo leafInfo = (LeafInfo)node.getUserObject();
                leafInfo.setPopupMenu(this.popup);
            }
        }
    }

    public JPopupMenu getJPopupMenu() {
        return this.popup;
    }

    private JPopupMenu createJPopupMenu() {
        JPopupMenu popup = new JPopupMenu();
        this.addMenuItems(popup);
        return popup;
    }

    private void addMenuItems(JPopupMenu menu) {
        Listener listener = new Listener();
        JMenuItem menuItem = new JMenuItem("Add new 3-axis projections");
        menuItem.setActionCommand(ADD_NEW_3D_CMD);
        menuItem.addActionListener(listener);
        menu.add(menuItem);
        menuItem = new JMenuItem("Add new 2-axis projections");
        menuItem.setActionCommand(ADD_NEW_2D_CMD);
        menuItem.addActionListener(listener);
        menu.add(menuItem);
    }

    private JMenuItem getJMenuItem(String command) {
        Component[] components = this.popup.getComponents();
        for (int i = 0; i < components.length; ++i) {
            if (!(components[i] instanceof JMenuItem) || !((JMenuItem)components[i]).getActionCommand().equals(command)) continue;
            return (JMenuItem)components[i];
        }
        return null;
    }

    private void add2DViewNode(DefaultMutableTreeNode node, Experiment experiment, int xAxis, int yAxis, int zAxis) {
        DefaultMutableTreeNode genes = new DefaultMutableTreeNode("2D views - genes");
        DefaultMutableTreeNode expts = new DefaultMutableTreeNode("2D views - expts");
        DefaultMutableTreeNode both = new DefaultMutableTreeNode("2D views - both");
        COA2DViewer coaxy = new COA2DViewer(experiment, this.geneUMatrix, 1, xAxis, yAxis);
        COA2DViewer coayz = new COA2DViewer(experiment, this.geneUMatrix, 1, yAxis, zAxis);
        COA2DViewer coaxz = new COA2DViewer(experiment, this.geneUMatrix, 1, xAxis, zAxis);
        genes.add(new DefaultMutableTreeNode(new LeafInfo("" + (xAxis + 1) + ", " + (yAxis + 1), (IViewer)coaxy, coaxy.getJPopupMenu())));
        genes.add(new DefaultMutableTreeNode(new LeafInfo("" + (yAxis + 1) + ", " + (zAxis + 1), (IViewer)coayz, coayz.getJPopupMenu())));
        genes.add(new DefaultMutableTreeNode(new LeafInfo("" + (xAxis + 1) + ", " + (zAxis + 1), (IViewer)coaxz, coaxz.getJPopupMenu())));
        COA2DViewer coaExptsxy = new COA2DViewer(experiment, this.exptUMatrix, 2, xAxis, yAxis);
        COA2DViewer coaExptsyz = new COA2DViewer(experiment, this.exptUMatrix, 2, yAxis, zAxis);
        COA2DViewer coaExptsxz = new COA2DViewer(experiment, this.exptUMatrix, 2, xAxis, zAxis);
        expts.add(new DefaultMutableTreeNode(new LeafInfo("" + (xAxis + 1) + ", " + (yAxis + 1), (IViewer)coaExptsxy, coaExptsxy.getJPopupMenu())));
        expts.add(new DefaultMutableTreeNode(new LeafInfo("" + (yAxis + 1) + ", " + (zAxis + 1), (IViewer)coaExptsyz, coaExptsyz.getJPopupMenu())));
        expts.add(new DefaultMutableTreeNode(new LeafInfo("" + (xAxis + 1) + ", " + (zAxis + 1), (IViewer)coaExptsxz, coaExptsxz.getJPopupMenu())));
        COA2DViewer bothxy = new COA2DViewer(experiment, this.geneUMatrix, this.exptUMatrix, 3, xAxis, yAxis);
        COA2DViewer bothyz = new COA2DViewer(experiment, this.geneUMatrix, this.exptUMatrix, 3, yAxis, zAxis);
        COA2DViewer bothxz = new COA2DViewer(experiment, this.geneUMatrix, this.exptUMatrix, 3, xAxis, zAxis);
        both.add(new DefaultMutableTreeNode(new LeafInfo("" + (xAxis + 1) + ", " + (yAxis + 1), (IViewer)bothxy, bothxy.getJPopupMenu())));
        both.add(new DefaultMutableTreeNode(new LeafInfo("" + (yAxis + 1) + ", " + (zAxis + 1), (IViewer)bothyz, bothyz.getJPopupMenu())));
        both.add(new DefaultMutableTreeNode(new LeafInfo("" + (xAxis + 1) + ", " + (zAxis + 1), (IViewer)bothxz, bothxz.getJPopupMenu())));
        node.add(genes);
        node.add(expts);
        node.add(both);
    }

    private void add3DViewNode(Frame frame, DefaultMutableTreeNode node, Experiment experiment, int xAxis, int yAxis, int zAxis) {
        COA3DViewer coa3DGeneViewer = new COA3DViewer(frame, this.geneUMatrix, experiment, 1, xAxis, yAxis, zAxis);
        COA3DViewer coa3DExptViewer = new COA3DViewer(frame, this.exptUMatrix, experiment, 2, xAxis, yAxis, zAxis);
        COA3DViewer coa3DBothViewer = new COA3DViewer(frame, this.geneUMatrix, this.exptUMatrix, experiment, 3, xAxis, yAxis, zAxis);
        node.add(new DefaultMutableTreeNode(new LeafInfo("3D view - genes", (IViewer)coa3DGeneViewer, coa3DGeneViewer.getJPopupMenu())));
        node.add(new DefaultMutableTreeNode(new LeafInfo("3D view - expts", (IViewer)coa3DExptViewer, coa3DExptViewer.getJPopupMenu())));
        node.add(new DefaultMutableTreeNode(new LeafInfo("3D view - both", (IViewer)coa3DBothViewer, coa3DBothViewer.getJPopupMenu())));
    }

    public void addNew3DNode() {
        COAAdditional3DAxesDialog pd = new COAAdditional3DAxesDialog((JFrame)this.framework.getFrame(), true, this.geneUMatrix.getColumnDimension());
        pd.setVisible(true);
        if (!pd.isOkPressed()) {
            return;
        }
        int selectedX = pd.getXAxis();
        int selectedY = pd.getYAxis();
        int selectedZ = pd.getZAxis();
        DefaultMutableTreeNode newNode = new DefaultMutableTreeNode("Components " + (selectedX + 1) + ", " + (selectedY + 1) + ", " + (selectedZ + 1));
        DefaultMutableTreeNode threeDNode = new DefaultMutableTreeNode("3D Views");
        this.add3DViewNode(this.framework.getFrame(), threeDNode, this.framework.getData().getExperiment(), selectedX, selectedY, selectedZ);
        DefaultMutableTreeNode twoDNode = new DefaultMutableTreeNode("2D Views");
        this.add2DViewNode(twoDNode, this.framework.getData().getExperiment(), selectedX, selectedY, selectedZ);
        newNode.add(threeDNode);
        newNode.add(twoDNode);
        this.framework.addNode(this.framework.getCurrentNode(), newNode);
    }

    public void addNew2DNode() {
        COAAdditional3DAxesDialog pd = new COAAdditional3DAxesDialog((JFrame)this.framework.getFrame(), true, this.geneUMatrix.getColumnDimension());
        pd.setZBoxInvisible(true);
        pd.setVisible(true);
        if (!pd.isOkPressed()) {
            return;
        }
        int selectedX = pd.getXAxis();
        int selectedY = pd.getYAxis();
        DefaultMutableTreeNode newNode = new DefaultMutableTreeNode("Components " + (selectedX + 1) + ", " + (selectedY + 1));
        COA2DViewer coaGenexy = new COA2DViewer(this.framework.getData().getExperiment(), this.geneUMatrix, 1, selectedX, selectedY);
        COA2DViewer coaExptxy = new COA2DViewer(this.framework.getData().getExperiment(), this.exptUMatrix, 2, selectedX, selectedY);
        COA2DViewer coaBothxy = new COA2DViewer(this.framework.getData().getExperiment(), this.geneUMatrix, this.exptUMatrix, 3, selectedX, selectedY);
        newNode.add(new DefaultMutableTreeNode(new LeafInfo("Genes", (IViewer)coaGenexy, coaGenexy.getJPopupMenu())));
        newNode.add(new DefaultMutableTreeNode(new LeafInfo("Expts", (IViewer)coaExptxy, coaExptxy.getJPopupMenu())));
        newNode.add(new DefaultMutableTreeNode(new LeafInfo("Both", (IViewer)coaBothxy, coaBothxy.getJPopupMenu())));
        this.framework.addNode(this.framework.getCurrentNode(), newNode);
    }

    private class Listener
    extends MouseAdapter
    implements ActionListener {
        private Listener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String command = e.getActionCommand();
            if (command.equals(COADummyViewer.ADD_NEW_3D_CMD)) {
                COADummyViewer.this.addNew3DNode();
            } else if (command.equals(COADummyViewer.ADD_NEW_2D_CMD)) {
                COADummyViewer.this.addNew2DNode();
            }
        }

        @Override
        public void mouseReleased(MouseEvent event) {
            this.maybeShowPopup(event);
        }

        @Override
        public void mousePressed(MouseEvent event) {
            this.maybeShowPopup(event);
        }

        private void maybeShowPopup(MouseEvent e) {
            if (!e.isPopupTrigger()) {
                return;
            }
            COADummyViewer.this.popup.show(e.getComponent(), e.getX(), e.getY());
        }
    }
}

