/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.coa;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.EtchedBorder;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.AlgorithmDialog;

public class COAAdditional3DAxesDialog
extends AlgorithmDialog {
    boolean okPressed = false;
    private int numAxes;
    private JComboBox xAxisBox;
    private JComboBox yAxisBox;
    private JComboBox zAxisBox;

    public COAAdditional3DAxesDialog(JFrame parentFrame, boolean modal, int numAxes) {
        super(parentFrame, "Select new projection axes", modal);
        this.numAxes = numAxes;
        this.setBounds(0, 0, 500, 200);
        this.setBackground(Color.white);
        this.setDefaultCloseOperation(2);
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.fill = 0;
        JPanel pane = new JPanel();
        pane.setBackground(Color.white);
        pane.setBorder(new EtchedBorder());
        pane.setLayout(gridbag);
        String[] axes = new String[numAxes];
        for (int i = 0; i < axes.length; ++i) {
            axes[i] = String.valueOf(i + 1);
        }
        this.xAxisBox = new JComboBox<String>(axes);
        this.yAxisBox = new JComboBox<String>(axes);
        this.zAxisBox = new JComboBox<String>(axes);
        this.xAxisBox.setSelectedIndex(0);
        this.yAxisBox.setSelectedIndex(1);
        this.zAxisBox.setSelectedIndex(2);
        JLabel selectAxesLabel = new JLabel("Select components to plot: ");
        this.buildConstraints(constraints, 0, 0, 1, 1, 40, 100);
        gridbag.setConstraints(selectAxesLabel, constraints);
        pane.add(selectAxesLabel);
        this.buildConstraints(constraints, 1, 0, 1, 1, 20, 0);
        gridbag.setConstraints(this.xAxisBox, constraints);
        pane.add(this.xAxisBox);
        this.buildConstraints(constraints, 2, 0, 1, 1, 20, 0);
        gridbag.setConstraints(this.yAxisBox, constraints);
        pane.add(this.yAxisBox);
        this.buildConstraints(constraints, 3, 0, 1, 1, 20, 0);
        gridbag.setConstraints(this.zAxisBox, constraints);
        pane.add(this.zAxisBox);
        this.addContent(pane);
        EventListener listener = new EventListener();
        this.setActionListeners(listener);
        this.addWindowListener(listener);
    }

    @Override
    public void setVisible(boolean visible) {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((screenSize.width - this.getSize().width) / 2, (screenSize.height - this.getSize().height) / 2);
        super.setVisible(visible);
    }

    void buildConstraints(GridBagConstraints gbc, int gx, int gy, int gw, int gh, int wx, int wy) {
        gbc.gridx = gx;
        gbc.gridy = gy;
        gbc.gridwidth = gw;
        gbc.gridheight = gh;
        gbc.weightx = wx;
        gbc.weighty = wy;
    }

    public int getXAxis() {
        return this.xAxisBox.getSelectedIndex();
    }

    public int getYAxis() {
        return this.yAxisBox.getSelectedIndex();
    }

    public int getZAxis() {
        return this.zAxisBox.getSelectedIndex();
    }

    public void setZBoxInvisible(boolean invis) {
        this.zAxisBox.setEnabled(!invis);
        this.zAxisBox.setVisible(!invis);
    }

    public boolean isOkPressed() {
        return this.okPressed;
    }

    public static void main(String[] args) {
        COAAdditional3DAxesDialog pd = new COAAdditional3DAxesDialog(new JFrame(), true, 10);
        pd.setVisible(true);
    }

    public class EventListener
    extends WindowAdapter
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent ae) {
            String command = ae.getActionCommand();
            if (command.equals("ok-command")) {
                int x = COAAdditional3DAxesDialog.this.getXAxis();
                int y = COAAdditional3DAxesDialog.this.getYAxis();
                int z = COAAdditional3DAxesDialog.this.getZAxis();
                if (!COAAdditional3DAxesDialog.this.zAxisBox.isVisible()) {
                    if (x == y) {
                        JOptionPane.showMessageDialog(null, "Both axes cannot be the same", "Error", 0);
                        return;
                    }
                } else if (x == y || y == z || x == z) {
                    JOptionPane.showMessageDialog(null, "No two axes can be the same", "Error", 0);
                    return;
                }
                COAAdditional3DAxesDialog.this.okPressed = true;
                COAAdditional3DAxesDialog.this.dispose();
            } else if (command.equals("reset-command")) {
                COAAdditional3DAxesDialog.this.xAxisBox.setSelectedIndex(0);
                COAAdditional3DAxesDialog.this.yAxisBox.setSelectedIndex(1);
                COAAdditional3DAxesDialog.this.zAxisBox.setSelectedIndex(2);
            } else if (command.equals("cancel-command")) {
                COAAdditional3DAxesDialog.this.okPressed = false;
                COAAdditional3DAxesDialog.this.dispose();
            } else if (command.equals("info-command")) {
                // empty if block
            }
        }
    }
}

