/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.coa;

import java.awt.Component;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.beans.Expression;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Vector;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JTextArea;
import javax.swing.tree.DefaultMutableTreeNode;
import org.tigr.microarray.mev.ShowThrowableDialog;
import org.tigr.microarray.mev.TMEV;
import org.tigr.microarray.mev.cluster.gui.Experiment;
import org.tigr.microarray.mev.cluster.gui.IData;
import org.tigr.microarray.mev.cluster.gui.IDisplayMenu;
import org.tigr.microarray.mev.cluster.gui.IFramework;
import org.tigr.microarray.mev.cluster.gui.LeafInfo;
import org.tigr.microarray.mev.cluster.gui.helpers.ExperimentUtil;
import org.tigr.microarray.mev.cluster.gui.impl.GUIFactory;
import org.tigr.microarray.mev.cluster.gui.impl.ViewerAdapter;
import org.tigr.microarray.mev.cluster.gui.impl.coa.COAContent3D;
import org.tigr.microarray.mev.cluster.gui.impl.coa.COAResultConfigDialog;
import org.tigr.microarray.mev.cluster.gui.impl.coa.COASelectionAreaDialog;
import org.tigr.util.FloatMatrix;

public class COA3DViewer
extends ViewerAdapter {
    private static final String RESET_CMD = "reset-cmd";
    private static final String OPTIONS_CMD = "options-cmd";
    private static final String SELECTION_AREA_CMD = "select-cmd";
    private static final String SAVE_CMD = "save-cmd";
    private static final String SAVE_GENE_CLUSTER_CMD = "save-genes-cmd";
    private static final String SAVE_EXPT_CLUSTER_CMD = "save-expts-cmd";
    private static final String SHOW_SELECTION_CMD = "show-selection-cmd";
    private static final String HIDE_SELECTION_BOX_CMD = "hide-selection-box-cmd";
    private static final String SHOW_SPHERES_CMD = "show-spheres-cmd";
    private static final String SHOW_TEXT_CMD = "show-text-cmd";
    private static final String SHOW_GENE_TEXT_FROM_BOTH_CMD = "show-gene-test-from-both-cmd";
    private static final String SHOW_EXPT_TEXT_FROM_BOTH_CMD = "show-expt-test-from-both-cmd";
    private static final String WHITE_CMD = "white-cmd";
    private static final String STORE_CLUSTER_CMD = "store-cluster-cmd";
    private static final String STORE_GENE_CLUSTER_CMD = "store-gene-cluster-cmd";
    private static final String STORE_EXPT_CLUSTER_CMD = "store-expt-cluster-cmd";
    private static final String LAUNCH_NEW_SESSION_CMD = "launch-new-session-cmd";
    private static final String LAUNCH_NEW_GENE_SESSION_CMD = "launch-new-gene-session-cmd";
    private static final String LAUNCH_NEW_EXPT_SESSION_CMD = "launch-new-expt-session-cmd";
    private static final String SAVE_3D_GENE_COORDS_CMD = "save-3d-gene-coords-cmd";
    private static final String SAVE_3D_EXPT_COORDS_CMD = "save-3d-expt-coords-cmd";
    private IData data;
    private Experiment experiment;
    private COAContent3D content;
    private JPopupMenu popup;
    private JPopupMenu popup2;
    private Frame frame;
    private int geneOrExpt;
    private int xAxis;
    private int yAxis;
    private int zAxis;
    private int labelIndex = -1;
    private IFramework framework;
    private FloatMatrix geneUMatrix;
    private FloatMatrix exptUMatrix;
    private FloatMatrix U;
    private COASelectionAreaDialog dlg;
    private int exptID = 0;
    private static boolean enabled3D = true;
    private JComponent renderContent = null;

    public COA3DViewer(Frame frame, FloatMatrix U, Experiment experiment, int geneOrExpt) {
        this.frame = frame;
        this.experiment = experiment;
        this.exptID = experiment.getId();
        this.geneOrExpt = geneOrExpt;
        this.U = U;
        if (enabled3D) {
            try {
                this.content = this.createContent(U, experiment, geneOrExpt);
                this.dlg = new COASelectionAreaDialog(this.content, frame, this.content.getPositionX(), this.content.getPositionY(), this.content.getPositionZ(), this.content.getSizeX(), this.content.getSizeY(), this.content.getSizeZ(), this.content.getMaxValue());
                this.popup = this.createJPopupMenu();
                Listener listener2 = new Listener();
                this.popup2 = this.createJPopupMenu(listener2);
                this.getContentComponent().addMouseListener(listener2);
                enabled3D = true;
                this.renderContent = this.content;
            }
            catch (UnsatisfiedLinkError ule) {
                ShowThrowableDialog.show((Frame)new Frame(), (String)"No Java 3D detected", (Throwable)new Exception("Java3D is not installed. The 3D viewer cannot be created."));
                enabled3D = false;
                this.renderContent = this.getJ3DErrorPlaceholderContent();
            }
            catch (NoClassDefFoundError ncdfe) {
                ShowThrowableDialog.show((Frame)new Frame(), (String)"No Java 3D detected", (Throwable)new Exception("Java3D is not installed. The 3D viewer cannot be created."));
                enabled3D = false;
                this.renderContent = this.getJ3DErrorPlaceholderContent();
            }
        } else {
            this.renderContent = this.getJ3DErrorPlaceholderContent();
        }
    }

    private JTextArea getJ3DErrorPlaceholderContent() {
        JTextArea area = new JTextArea(20, 20);
        area.setEditable(false);
        area.setMargin(new Insets(0, 10, 0, 0));
        area.setText("No 3D viewer is available. To view the results of this analysis, please install Java3D, available at java.sun.com. \nUse the File -> Save Analysis As option to save your results. \nAfter installing Java3D, restart MeV and load the saved analysis file to view these results in an interactive form. \n");
        area.setCaretPosition(0);
        return area;
    }

    public COA3DViewer(Frame frame, FloatMatrix U, Experiment experiment, int geneOrExpt, int xAxis, int yAxis, int zAxis) {
        this.frame = frame;
        this.experiment = experiment;
        this.exptID = experiment.getId();
        this.geneOrExpt = geneOrExpt;
        this.U = U;
        this.xAxis = xAxis;
        this.yAxis = yAxis;
        this.zAxis = zAxis;
        if (enabled3D) {
            try {
                this.content = this.createContent(U, experiment, geneOrExpt, xAxis, yAxis, zAxis);
                this.dlg = new COASelectionAreaDialog(this.content, frame, this.content.getPositionX(), this.content.getPositionY(), this.content.getPositionZ(), this.content.getSizeX(), this.content.getSizeY(), this.content.getSizeZ(), this.content.getMaxValue());
                this.popup = this.createJPopupMenu();
                Listener listener2 = new Listener();
                this.popup2 = this.createJPopupMenu(listener2);
                this.renderContent = this.content;
                this.getContentComponent().addMouseListener(listener2);
                enabled3D = true;
            }
            catch (UnsatisfiedLinkError ule) {
                ShowThrowableDialog.show((Frame)new Frame(), (String)"No Java 3D detected", (Throwable)new Exception("Java3D is not installed. The 3D viewer cannot be created."));
                enabled3D = false;
                this.renderContent = this.getJ3DErrorPlaceholderContent();
            }
            catch (NoClassDefFoundError ncdfe) {
                ShowThrowableDialog.show((Frame)new Frame(), (String)"No Java 3D detected", (Throwable)new Exception("Java3D is not installed. The 3D viewer cannot be created."));
                enabled3D = false;
                this.renderContent = this.getJ3DErrorPlaceholderContent();
            }
        } else {
            this.renderContent = this.getJ3DErrorPlaceholderContent();
        }
    }

    public COA3DViewer(Frame frame, FloatMatrix geneUMatrix, FloatMatrix exptUMatrix, Experiment experiment, int geneOrExpt) {
        this.frame = frame;
        this.experiment = experiment;
        this.exptID = experiment.getId();
        this.geneOrExpt = geneOrExpt;
        this.geneUMatrix = geneUMatrix;
        this.exptUMatrix = exptUMatrix;
        if (enabled3D) {
            try {
                this.content = this.createContent(geneUMatrix, exptUMatrix, experiment, geneOrExpt);
                this.dlg = new COASelectionAreaDialog(this.content, frame, this.content.getPositionX(), this.content.getPositionY(), this.content.getPositionZ(), this.content.getSizeX(), this.content.getSizeY(), this.content.getSizeZ(), this.content.getMaxValue());
                this.popup = this.createJPopupMenu();
                Listener listener2 = new Listener();
                this.popup2 = this.createJPopupMenu(listener2);
                this.getContentComponent().addMouseListener(listener2);
                enabled3D = true;
                this.renderContent = this.content;
            }
            catch (UnsatisfiedLinkError ule) {
                ShowThrowableDialog.show((Frame)new Frame(), (String)"No Java 3D detected", (Throwable)new Exception("Java3D is not installed. The 3D viewer cannot be created."));
                enabled3D = false;
                this.renderContent = this.getJ3DErrorPlaceholderContent();
            }
            catch (NoClassDefFoundError ncdfe) {
                ShowThrowableDialog.show((Frame)new Frame(), (String)"No Java 3D detected", (Throwable)new Exception("Java3D is not installed. The 3D viewer cannot be created."));
                enabled3D = false;
                this.renderContent = this.getJ3DErrorPlaceholderContent();
            }
        } else {
            this.renderContent = this.getJ3DErrorPlaceholderContent();
        }
    }

    public COA3DViewer(Frame frame, FloatMatrix geneUMatrix, FloatMatrix exptUMatrix, Experiment experiment, int geneOrExpt, int xAxis, int yAxis, int zAxis) {
        this.frame = frame;
        this.experiment = experiment;
        this.exptID = experiment.getId();
        this.geneOrExpt = geneOrExpt;
        this.geneUMatrix = geneUMatrix;
        this.exptUMatrix = exptUMatrix;
        this.xAxis = xAxis;
        this.yAxis = yAxis;
        this.zAxis = zAxis;
        if (enabled3D) {
            try {
                this.content = this.createContent(geneUMatrix, exptUMatrix, experiment, geneOrExpt, xAxis, yAxis, zAxis);
                this.renderContent = this.content;
                this.dlg = new COASelectionAreaDialog(this.content, frame, this.content.getPositionX(), this.content.getPositionY(), this.content.getPositionZ(), this.content.getSizeX(), this.content.getSizeY(), this.content.getSizeZ(), this.content.getMaxValue());
                this.popup = this.createJPopupMenu();
                Listener listener2 = new Listener();
                this.popup2 = this.createJPopupMenu(listener2);
                this.getContentComponent().addMouseListener(listener2);
                enabled3D = true;
            }
            catch (UnsatisfiedLinkError ule) {
                ShowThrowableDialog.show((Frame)new Frame(), (String)"No Java 3D detected", (Throwable)new Exception("Java3D is not installed. The 3D viewer cannot be created."));
                enabled3D = false;
                this.renderContent = this.getJ3DErrorPlaceholderContent();
            }
            catch (NoClassDefFoundError ncdfe) {
                ShowThrowableDialog.show((Frame)new Frame(), (String)"No Java 3D detected", (Throwable)new Exception("Java3D is not installed. The 3D viewer cannot be created."));
                enabled3D = false;
                this.renderContent = this.getJ3DErrorPlaceholderContent();
            }
        } else {
            this.renderContent = this.getJ3DErrorPlaceholderContent();
        }
    }

    public COA3DViewer(Experiment e, FloatMatrix geneUMatrix, FloatMatrix exptUMatrix, Integer geneOrExpt, FloatMatrix U, Integer xAxis, Integer yAxis, Integer zAxis) {
        this.geneOrExpt = geneOrExpt;
        this.geneUMatrix = geneUMatrix;
        this.exptUMatrix = exptUMatrix;
        this.U = U;
        this.xAxis = xAxis;
        this.yAxis = yAxis;
        this.zAxis = zAxis;
        this.experiment = e;
        this.exptID = this.experiment.getId();
        try {
            if (this.geneOrExpt == 3) {
                this.content = this.createContent(geneUMatrix, exptUMatrix, this.experiment, geneOrExpt, xAxis, yAxis, zAxis);
                this.dlg = new COASelectionAreaDialog(this.content, this.frame, this.content.getPositionX(), this.content.getPositionY(), this.content.getPositionZ(), this.content.getSizeX(), this.content.getSizeY(), this.content.getSizeZ(), this.content.getMaxValue());
            } else {
                this.content = this.createContent(U, this.experiment, geneOrExpt, xAxis, yAxis, zAxis);
                this.dlg = new COASelectionAreaDialog(this.content, this.frame, this.content.getPositionX(), this.content.getPositionY(), this.content.getPositionZ(), this.content.getSizeX(), this.content.getSizeY(), this.content.getSizeZ(), this.content.getMaxValue());
            }
            this.renderContent = this.content;
            this.popup = this.createJPopupMenu();
            enabled3D = true;
        }
        catch (UnsatisfiedLinkError ule) {
            enabled3D = false;
            this.renderContent = this.getJ3DErrorPlaceholderContent();
        }
        catch (NoClassDefFoundError ncdfe) {
            enabled3D = false;
            this.renderContent = this.getJ3DErrorPlaceholderContent();
        }
    }

    @Override
    public Expression getExpression() {
        return new Expression(this, this.getClass(), "new", new Object[]{this.experiment, this.geneUMatrix, this.exptUMatrix, new Integer(this.geneOrExpt), this.U, new Integer(this.xAxis), new Integer(this.yAxis), new Integer(this.zAxis)});
    }

    @Override
    public Experiment getExperiment() {
        return this.experiment;
    }

    @Override
    public int getExperimentID() {
        return this.exptID;
    }

    @Override
    public void onSelected(IFramework framework) {
        this.framework = framework;
        this.frame = framework.getFrame();
        this.data = framework.getData();
        IDisplayMenu menu = framework.getDisplayMenu();
        this.labelIndex = menu.getLabelIndex();
        if (enabled3D) {
            this.content.setData(this.data);
            this.content.setGeneLabelIndex(this.labelIndex);
            this.onMenuChanged(menu);
            this.content.updateScene();
            if (this.popup == null) {
                this.popup = this.createJPopupMenu();
                DefaultMutableTreeNode node = framework.getCurrentNode();
                if (node != null && node.getUserObject() instanceof LeafInfo) {
                    LeafInfo leafInfo = (LeafInfo)node.getUserObject();
                    leafInfo.setPopupMenu(this.popup);
                }
            }
        }
    }

    @Override
    public void onMenuChanged(IDisplayMenu menu) {
        this.labelIndex = menu.getLabelIndex();
        this.content.setGeneLabelIndex(this.labelIndex);
        this.content.updateScene();
    }

    @Override
    public void onDataChanged(IData data) {
        this.data = data;
        this.content.setData(data);
        this.content.updateScene();
    }

    @Override
    public JComponent getContentComponent() {
        return this.renderContent;
    }

    @Override
    public BufferedImage getImage() {
        return this.content.createImage();
    }

    private COAContent3D createContent(FloatMatrix U, Experiment experiment, int geneOrExpt) {
        return new COAContent3D(U, experiment, geneOrExpt);
    }

    private COAContent3D createContent(FloatMatrix geneUMatrix, FloatMatrix exptUMatrix, Experiment experiment, int geneOrExpt) {
        return new COAContent3D(geneUMatrix, exptUMatrix, experiment, geneOrExpt);
    }

    private COAContent3D createContent(FloatMatrix U, Experiment experiment, int geneOrExpt, int xAxis, int yaxis, int zAxis) {
        return new COAContent3D(U, experiment, geneOrExpt, xAxis, this.yAxis, zAxis);
    }

    private COAContent3D createContent(FloatMatrix geneUMatrix, FloatMatrix exptUMatrix, Experiment experiment, int geneOrExpt, int xAxis, int yaxis, int zAxis) {
        return new COAContent3D(geneUMatrix, exptUMatrix, experiment, geneOrExpt, xAxis, this.yAxis, zAxis);
    }

    public JPopupMenu getJPopupMenu() {
        return this.popup;
    }

    private JPopupMenu createJPopupMenu() {
        JPopupMenu popup = new JPopupMenu();
        this.addMenuItems(popup);
        return popup;
    }

    private JPopupMenu createJPopupMenu(Listener listener) {
        JPopupMenu popup = new JPopupMenu();
        this.addMenuItems(popup, listener);
        return popup;
    }

    private void addMenuItems(JPopupMenu menu) {
        Listener listener = new Listener();
        JMenuItem menuItem = new JMenuItem("Reset", GUIFactory.getIcon("refresh16.gif"));
        menuItem.setActionCommand(RESET_CMD);
        menuItem.addActionListener(listener);
        menu.add(menuItem);
        menuItem = new JMenuItem("Options...", GUIFactory.getIcon("edit16.gif"));
        menuItem.setActionCommand(OPTIONS_CMD);
        menuItem.addActionListener(listener);
        menu.add(menuItem);
        menu.addSeparator();
        menuItem = new JMenuItem("Selection area...", GUIFactory.getIcon("edit16.gif"));
        menuItem.setEnabled(false);
        menuItem.setActionCommand(SELECTION_AREA_CMD);
        menuItem.addActionListener(listener);
        menu.add(menuItem);
        menu.addSeparator();
        if (this.geneOrExpt == 3) {
            menuItem = new JMenuItem("Store gene cluster...", GUIFactory.getIcon("new16.gif"));
            menuItem.setEnabled(false);
            menuItem.setActionCommand(STORE_GENE_CLUSTER_CMD);
            menuItem.addActionListener(listener);
            menu.add(menuItem);
            menuItem = new JMenuItem("Launch new session with selected genes", GUIFactory.getIcon("launch_new_mav.gif"));
            menuItem.setEnabled(false);
            menuItem.setActionCommand(LAUNCH_NEW_GENE_SESSION_CMD);
            menuItem.addActionListener(listener);
            menu.add(menuItem);
            menuItem = new JMenuItem("Save gene cluster...", GUIFactory.getIcon("save16.gif"));
            menuItem.setEnabled(false);
            menuItem.setActionCommand(SAVE_GENE_CLUSTER_CMD);
            menuItem.addActionListener(listener);
            menu.add(menuItem);
            menuItem = new JCheckBoxMenuItem("Show gene text");
            menuItem.setEnabled(true);
            menuItem.setActionCommand(SHOW_GENE_TEXT_FROM_BOTH_CMD);
            menuItem.addActionListener(listener);
            menu.add(menuItem);
            menu.addSeparator();
            menuItem = new JMenuItem("Store sample cluster...", GUIFactory.getIcon("new16.gif"));
            menuItem.setEnabled(false);
            menuItem.setActionCommand(STORE_EXPT_CLUSTER_CMD);
            menuItem.addActionListener(listener);
            menu.add(menuItem);
            menuItem = new JMenuItem("Launch new session with selected samples", GUIFactory.getIcon("launch_new_mav.gif"));
            menuItem.setEnabled(false);
            menuItem.setActionCommand(LAUNCH_NEW_EXPT_SESSION_CMD);
            menuItem.addActionListener(listener);
            menu.add(menuItem);
            menuItem = new JMenuItem("Save sample cluster...", GUIFactory.getIcon("save16.gif"));
            menuItem.setEnabled(false);
            menuItem.setActionCommand(SAVE_EXPT_CLUSTER_CMD);
            menuItem.addActionListener(listener);
            menu.add(menuItem);
            menuItem = new JCheckBoxMenuItem("Show sample text");
            menuItem.setEnabled(true);
            menuItem.setActionCommand(SHOW_EXPT_TEXT_FROM_BOTH_CMD);
            menuItem.addActionListener(listener);
            menu.add(menuItem);
            menu.addSeparator();
            menuItem = new JMenuItem("Save 3D Gene Coordinates");
            menuItem.setEnabled(true);
            menuItem.setActionCommand(SAVE_3D_GENE_COORDS_CMD);
            menuItem.addActionListener(listener);
            menu.add(menuItem);
            menuItem = new JMenuItem("Save 3D Sample Coordinates");
            menuItem.setEnabled(true);
            menuItem.setActionCommand(SAVE_3D_EXPT_COORDS_CMD);
            menuItem.addActionListener(listener);
            menu.add(menuItem);
            menu.addSeparator();
        } else {
            menuItem = new JMenuItem("Store cluster...", GUIFactory.getIcon("new16.gif"));
            menuItem.setEnabled(false);
            menuItem.setActionCommand(STORE_CLUSTER_CMD);
            menuItem.addActionListener(listener);
            menu.add(menuItem);
            menuItem = new JMenuItem("Launch new session", GUIFactory.getIcon("launch_new_mav.gif"));
            menuItem.setEnabled(false);
            menuItem.setActionCommand(LAUNCH_NEW_SESSION_CMD);
            menuItem.addActionListener(listener);
            menu.add(menuItem);
            menuItem = new JMenuItem("Save cluster...", GUIFactory.getIcon("save16.gif"));
            menuItem.setEnabled(false);
            menuItem.setActionCommand(SAVE_CMD);
            menuItem.addActionListener(listener);
            menu.add(menuItem);
            menuItem = new JCheckBoxMenuItem("Show text");
            menuItem.setEnabled(true);
            menuItem.setActionCommand(SHOW_TEXT_CMD);
            menuItem.addActionListener(listener);
            menu.add(menuItem);
            menu.addSeparator();
        }
        menuItem = new JCheckBoxMenuItem("Show selection area");
        menuItem.setActionCommand(SHOW_SELECTION_CMD);
        menuItem.addActionListener(listener);
        menu.add(menuItem);
        menuItem = new JCheckBoxMenuItem("Hide selection box");
        menuItem.setEnabled(false);
        menuItem.setActionCommand(HIDE_SELECTION_BOX_CMD);
        menuItem.addActionListener(listener);
        menu.add(menuItem);
        menuItem = new JCheckBoxMenuItem("Show spheres");
        menuItem.setActionCommand(SHOW_SPHERES_CMD);
        menuItem.addActionListener(listener);
        menu.add(menuItem);
        menuItem = new JCheckBoxMenuItem("White background");
        menuItem.setActionCommand(WHITE_CMD);
        menuItem.addActionListener(listener);
        menu.add(menuItem);
    }

    private void addMenuItems(JPopupMenu menu, ActionListener listener) {
        JMenuItem menuItem = new JMenuItem("Reset", GUIFactory.getIcon("refresh16.gif"));
        menuItem.setActionCommand(RESET_CMD);
        menuItem.addActionListener(listener);
        menu.add(menuItem);
        menuItem = new JMenuItem("Options...", GUIFactory.getIcon("edit16.gif"));
        menuItem.setActionCommand(OPTIONS_CMD);
        menuItem.addActionListener(listener);
        menu.add(menuItem);
        menu.addSeparator();
        menuItem = new JMenuItem("Selection area...", GUIFactory.getIcon("edit16.gif"));
        menuItem.setEnabled(false);
        menuItem.setActionCommand(SELECTION_AREA_CMD);
        menuItem.addActionListener(listener);
        menu.add(menuItem);
        menu.addSeparator();
        if (this.geneOrExpt == 3) {
            menuItem = new JMenuItem("Store gene cluster...", GUIFactory.getIcon("new16.gif"));
            menuItem.setEnabled(false);
            menuItem.setActionCommand(STORE_GENE_CLUSTER_CMD);
            menuItem.addActionListener(listener);
            menu.add(menuItem);
            menuItem = new JMenuItem("Launch new session with selected genes", GUIFactory.getIcon("launch_new_mav.gif"));
            menuItem.setEnabled(false);
            menuItem.setActionCommand(LAUNCH_NEW_GENE_SESSION_CMD);
            menuItem.addActionListener(listener);
            menu.add(menuItem);
            menuItem = new JMenuItem("Save gene cluster...", GUIFactory.getIcon("save16.gif"));
            menuItem.setEnabled(false);
            menuItem.setActionCommand(SAVE_GENE_CLUSTER_CMD);
            menuItem.addActionListener(listener);
            menu.add(menuItem);
            menuItem = new JCheckBoxMenuItem("Show gene text");
            menuItem.setEnabled(true);
            menuItem.setActionCommand(SHOW_GENE_TEXT_FROM_BOTH_CMD);
            menuItem.addActionListener(listener);
            menu.add(menuItem);
            menu.addSeparator();
            menuItem = new JMenuItem("Store sample cluster...", GUIFactory.getIcon("new16.gif"));
            menuItem.setEnabled(false);
            menuItem.setActionCommand(STORE_EXPT_CLUSTER_CMD);
            menuItem.addActionListener(listener);
            menu.add(menuItem);
            menuItem = new JMenuItem("Launch new session with selected samples", GUIFactory.getIcon("launch_new_mav.gif"));
            menuItem.setEnabled(false);
            menuItem.setActionCommand(LAUNCH_NEW_EXPT_SESSION_CMD);
            menuItem.addActionListener(listener);
            menu.add(menuItem);
            menuItem = new JMenuItem("Save sample cluster...", GUIFactory.getIcon("save16.gif"));
            menuItem.setEnabled(false);
            menuItem.setActionCommand(SAVE_EXPT_CLUSTER_CMD);
            menuItem.addActionListener(listener);
            menu.add(menuItem);
            menuItem = new JCheckBoxMenuItem("Show sample text");
            menuItem.setEnabled(true);
            menuItem.setActionCommand(SHOW_EXPT_TEXT_FROM_BOTH_CMD);
            menuItem.addActionListener(listener);
            menu.add(menuItem);
            menu.addSeparator();
        } else {
            menuItem = new JMenuItem("Store cluster...", GUIFactory.getIcon("new16.gif"));
            menuItem.setEnabled(false);
            menuItem.setActionCommand(STORE_CLUSTER_CMD);
            menuItem.addActionListener(listener);
            menu.add(menuItem);
            menuItem = new JMenuItem("Launch new session", GUIFactory.getIcon("launch_new_mav.gif"));
            menuItem.setEnabled(false);
            menuItem.setActionCommand(LAUNCH_NEW_SESSION_CMD);
            menuItem.addActionListener(listener);
            menu.add(menuItem);
            menuItem = new JMenuItem("Save cluster...", GUIFactory.getIcon("save16.gif"));
            menuItem.setEnabled(false);
            menuItem.setActionCommand(SAVE_CMD);
            menuItem.addActionListener(listener);
            menu.add(menuItem);
            menuItem = new JCheckBoxMenuItem("Show text");
            menuItem.setEnabled(true);
            menuItem.setActionCommand(SHOW_TEXT_CMD);
            menuItem.addActionListener(listener);
            menu.add(menuItem);
            menu.addSeparator();
        }
        menuItem = new JCheckBoxMenuItem("Show selection area");
        menuItem.setActionCommand(SHOW_SELECTION_CMD);
        menuItem.addActionListener(listener);
        menu.add(menuItem);
        menuItem = new JCheckBoxMenuItem("Hide selection box");
        menuItem.setEnabled(false);
        menuItem.setActionCommand(HIDE_SELECTION_BOX_CMD);
        menuItem.addActionListener(listener);
        menu.add(menuItem);
        menuItem = new JCheckBoxMenuItem("Show spheres");
        menuItem.setActionCommand(SHOW_SPHERES_CMD);
        menuItem.addActionListener(listener);
        menu.add(menuItem);
        menuItem = new JCheckBoxMenuItem("White background");
        menuItem.setActionCommand(WHITE_CMD);
        menuItem.addActionListener(listener);
        menu.add(menuItem);
    }

    private JMenuItem getJMenuItem(String command) {
        Component[] components = this.popup.getComponents();
        for (int i = 0; i < components.length; ++i) {
            if (!(components[i] instanceof JMenuItem) || !((JMenuItem)components[i]).getActionCommand().equals(command)) continue;
            return (JMenuItem)components[i];
        }
        return null;
    }

    private void setEnableMenuItem(String command, boolean enable) {
        JMenuItem item = this.getJMenuItem(command);
        if (item == null) {
            return;
        }
        item.setEnabled(enable);
    }

    private void onReset() {
        this.content.reset();
    }

    private void onOptions() {
        COAResultConfigDialog dlg = new COAResultConfigDialog(this.frame, this.content.getPointSize(), this.content.getSelectedPointSize(), this.content.getScaleAxisX(), this.content.getScaleAxisY(), this.content.getScaleAxisZ());
        if (dlg.showModal() == 0) {
            this.content.setPointSize(dlg.getPointSize());
            this.content.setSelectedPointSize(dlg.getSelectedPointSize());
            this.content.setScale(dlg.getScaleAxisX(), dlg.getScaleAxisY(), dlg.getScaleAxisZ());
            this.content.updateScene();
        }
    }

    private void onSelectionArea() {
        if (this.dlg.showModal() == 0) {
            this.content.setBoxPosition(this.dlg.getPositionX(), this.dlg.getPositionY(), this.dlg.getPositionZ());
            this.content.setBoxSize(this.dlg.getSizeX(), this.dlg.getSizeY(), this.dlg.getSizeZ());
            this.content.updateScene();
        }
    }

    private void onSave() {
        try {
            if (this.geneOrExpt == 1) {
                ExperimentUtil.saveExperiment((Frame)this.frame, (Experiment)this.experiment, (IData)this.data, (int[])this.content.getSelectedGenes());
            } else if (this.geneOrExpt == 2) {
                ExperimentUtil.saveExperimentCluster((Frame)this.frame, (Experiment)this.experiment, (IData)this.data, (int[])this.content.getSelectedGenes());
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this.frame, "Can not save matrix!", e.toString(), 0);
            e.printStackTrace();
        }
    }

    private void onSaveGenesFromBoth() {
        try {
            ExperimentUtil.saveExperiment((Frame)this.frame, (Experiment)this.experiment, (IData)this.data, (int[])this.content.getSelectedGenesFromBoth());
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this.frame, "Can not save matrix!", e.toString(), 0);
            e.printStackTrace();
        }
    }

    private void onSaveExptsFromBoth() {
        try {
            ExperimentUtil.saveExperimentCluster((Frame)this.frame, (Experiment)this.experiment, (IData)this.data, (int[])this.content.getSelectedExptsFromBoth());
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this.frame, "Can not save matrix!", e.toString(), 0);
            e.printStackTrace();
        }
    }

    private void storeCluster() {
        if (this.geneOrExpt == 1) {
            this.framework.storeSubCluster(this.content.getSelectedGenes(), this.experiment, 0);
        } else if (this.geneOrExpt == 2) {
            this.framework.storeSubCluster(this.content.getSelectedGenes(), this.experiment, 1);
        }
        this.content.setSelection(false);
        this.onDataChanged(this.data);
        this.content.updateScene();
    }

    private void storeGeneClusterFromBoth() {
        this.framework.storeSubCluster(this.content.getSelectedGenesFromBoth(), this.experiment, 0);
        this.content.setSelection(false);
        this.onDataChanged(this.data);
        this.content.updateScene();
    }

    private void storeExptClusterFromBoth() {
        this.framework.storeSubCluster(this.content.getSelectedExptsFromBoth(), this.experiment, 1);
        this.content.setSelection(false);
        this.onDataChanged(this.data);
        this.content.updateScene();
    }

    private void launchNewSession() {
        if (this.geneOrExpt == 1) {
            this.framework.launchNewMAV(this.content.getSelectedGenes(), this.experiment, "Multiple Experiment Viewer - Cluster Viewer", 0);
        } else if (this.geneOrExpt == 2) {
            this.framework.launchNewMAV(this.content.getSelectedGenes(), this.experiment, "Multiple Experiment Viewer - Cluster Viewer", 1);
        }
    }

    private void launchNewGeneSessionFromBoth() {
        this.framework.launchNewMAV(this.content.getSelectedGenesFromBoth(), this.experiment, "Multiple Experiment Viewer - Cluster Viewer", 0);
    }

    private void launchNewExptSessionFromBoth() {
        this.framework.launchNewMAV(this.content.getSelectedExptsFromBoth(), this.experiment, "Multiple Experiment Viewer - Cluster Viewer", 1);
    }

    private void onShowSelection() {
        JMenuItem selectionItem = this.getJMenuItem(SHOW_SELECTION_CMD);
        JMenuItem hideBoxItem = this.getJMenuItem(HIDE_SELECTION_BOX_CMD);
        JMenuItem selectionAreaItem = this.getJMenuItem(SELECTION_AREA_CMD);
        if (this.geneOrExpt == 1 || this.geneOrExpt == 2) {
            JMenuItem saveClusterItem = this.getJMenuItem(SAVE_CMD);
            JMenuItem storeClusterItem = this.getJMenuItem(STORE_CLUSTER_CMD);
            JMenuItem launchNewItem = this.getJMenuItem(LAUNCH_NEW_SESSION_CMD);
            if (selectionItem.isSelected()) {
                this.content.setSelection(true);
                this.content.setSelectionBox(!hideBoxItem.isSelected());
                selectionAreaItem.setEnabled(true);
                saveClusterItem.setEnabled(true);
                hideBoxItem.setEnabled(true);
                storeClusterItem.setEnabled(true);
                launchNewItem.setEnabled(true);
            } else {
                this.content.setSelection(false);
                this.content.setSelectionBox(false);
                selectionAreaItem.setEnabled(false);
                saveClusterItem.setEnabled(false);
                hideBoxItem.setEnabled(false);
                storeClusterItem.setEnabled(false);
                launchNewItem.setEnabled(false);
            }
        } else {
            JMenuItem saveGeneClusterItem = this.getJMenuItem(SAVE_GENE_CLUSTER_CMD);
            JMenuItem storeGeneClusterItem = this.getJMenuItem(STORE_GENE_CLUSTER_CMD);
            JMenuItem launchNewGeneItem = this.getJMenuItem(LAUNCH_NEW_GENE_SESSION_CMD);
            JMenuItem saveExptClusterItem = this.getJMenuItem(SAVE_EXPT_CLUSTER_CMD);
            JMenuItem storeExptClusterItem = this.getJMenuItem(STORE_EXPT_CLUSTER_CMD);
            JMenuItem launchNewExptItem = this.getJMenuItem(LAUNCH_NEW_EXPT_SESSION_CMD);
            if (selectionItem.isSelected()) {
                this.content.setSelection(true);
                this.content.setSelectionBox(!hideBoxItem.isSelected());
                selectionAreaItem.setEnabled(true);
                saveGeneClusterItem.setEnabled(true);
                saveExptClusterItem.setEnabled(true);
                hideBoxItem.setEnabled(true);
                storeGeneClusterItem.setEnabled(true);
                storeExptClusterItem.setEnabled(true);
                launchNewGeneItem.setEnabled(true);
                launchNewExptItem.setEnabled(true);
            } else {
                this.content.setSelection(false);
                this.content.setSelectionBox(false);
                selectionAreaItem.setEnabled(false);
                saveGeneClusterItem.setEnabled(false);
                saveExptClusterItem.setEnabled(false);
                hideBoxItem.setEnabled(false);
                storeGeneClusterItem.setEnabled(false);
                storeExptClusterItem.setEnabled(false);
                launchNewGeneItem.setEnabled(false);
                launchNewExptItem.setEnabled(false);
            }
        }
        this.content.updateScene();
    }

    private void onHideSelection() {
        this.content.setSelectionBox(!this.content.isSelectionBox());
        this.content.updateScene();
    }

    private void onShowSphere() {
        this.content.setShowSpheres(!this.content.isShowSpheres());
        this.content.updateScene();
        if (this.geneOrExpt == 1 || this.geneOrExpt == 2) {
            JMenuItem sphereItem = this.getJMenuItem(SHOW_SPHERES_CMD);
            JMenuItem textItem = this.getJMenuItem(SHOW_TEXT_CMD);
            if (sphereItem.isSelected()) {
                this.content.setShowSpheres(true);
                this.content.setShowText(textItem.isSelected());
                textItem.setEnabled(true);
            } else {
                this.content.setShowSpheres(false);
                this.content.setShowText(textItem.isSelected());
                textItem.setEnabled(true);
            }
        } else {
            JMenuItem sphereItem = this.getJMenuItem(SHOW_SPHERES_CMD);
            JMenuItem geneTextItem = this.getJMenuItem(SHOW_GENE_TEXT_FROM_BOTH_CMD);
            JMenuItem exptTextItem = this.getJMenuItem(SHOW_EXPT_TEXT_FROM_BOTH_CMD);
            if (sphereItem.isSelected()) {
                this.content.setShowSpheres(true);
                this.content.setShowGeneTextFromBoth(geneTextItem.isSelected());
                geneTextItem.setEnabled(true);
                this.content.setShowExptTextFromBoth(exptTextItem.isSelected());
                exptTextItem.setEnabled(true);
            } else {
                this.content.setShowSpheres(false);
                this.content.setShowGeneTextFromBoth(geneTextItem.isSelected());
                geneTextItem.setEnabled(true);
                this.content.setShowExptTextFromBoth(exptTextItem.isSelected());
                exptTextItem.setEnabled(true);
            }
        }
        this.content.updateScene();
    }

    private void onShowText() {
        this.content.setShowText(!this.content.isShowText());
        this.content.updateScene();
    }

    private void onShowGeneTextFromBoth() {
        this.content.setShowGeneTextFromBoth(!this.content.isShowGeneTextFromBoth());
        this.content.updateScene();
    }

    private void onShowExptTextFromBoth() {
        this.content.setShowExptTextFromBoth(!this.content.isShowExptTextFromBoth());
        this.content.updateScene();
    }

    private void onWhiteBackground() {
        this.content.setWhiteBackround(!this.content.isWhiteBackground());
        this.content.updateScene();
    }

    @Override
    public JComponent getRowHeaderComponent() {
        return null;
    }

    private void output3DCoords(boolean outputGenes) {
        block12: {
            FloatMatrix coordMatrix;
            String[] annFields;
            JFileChooser fileChooser = new JFileChooser(TMEV.getDataPath());
            if (outputGenes) {
                annFields = this.data.getFieldNames();
                coordMatrix = this.geneUMatrix;
            } else {
                Vector sampleAnnFields = this.data.getSampleAnnotationFieldNames();
                coordMatrix = this.exptUMatrix;
                annFields = new String[sampleAnnFields.size()];
                for (int i = 0; i < annFields.length; ++i) {
                    annFields[i] = (String)sampleAnnFields.get(i);
                }
            }
            try {
                if (fileChooser.showSaveDialog(this.frame) != 0) break block12;
                File file = fileChooser.getSelectedFile();
                PrintWriter pw = new PrintWriter(new FileWriter(file));
                for (int i = 0; i < annFields.length; ++i) {
                    pw.print(annFields[i] + "\t");
                }
                pw.println("X\tY\tZ");
                int nRows = coordMatrix.getRowDimension();
                if (outputGenes) {
                    for (int i = 0; i < nRows; ++i) {
                        for (int j = 0; j < annFields.length; ++j) {
                            pw.print(this.data.getElementAttribute(this.experiment.getGeneIndexMappedToData(i), j) + "\t");
                        }
                        pw.print(coordMatrix.get(i, 0) + "\t");
                        pw.print(coordMatrix.get(i, 1) + "\t");
                        pw.println(coordMatrix.get(i, 2));
                    }
                } else {
                    for (int i = 0; i < nRows; ++i) {
                        for (int j = 0; j < annFields.length; ++j) {
                            pw.print(this.data.getSampleAnnotation(i, annFields[j]) + "\t");
                        }
                        pw.print(coordMatrix.get(i, 0) + "\t");
                        pw.print(coordMatrix.get(i, 1) + "\t");
                        pw.println(coordMatrix.get(i, 2));
                    }
                }
                pw.flush();
                pw.close();
            }
            catch (IOException ioe) {
                JOptionPane.showMessageDialog(this.frame, "Error opening or saving to file", "Coordinate ouput Error", 0);
            }
        }
    }

    private class Listener
    extends MouseAdapter
    implements ActionListener {
        private Listener() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            String command = event.getActionCommand();
            if (command.equals(COA3DViewer.RESET_CMD)) {
                COA3DViewer.this.onReset();
            } else if (command.equals(COA3DViewer.OPTIONS_CMD)) {
                COA3DViewer.this.onOptions();
            } else if (command.equals(COA3DViewer.SELECTION_AREA_CMD)) {
                COA3DViewer.this.onSelectionArea();
            } else if (command.equals(COA3DViewer.SAVE_GENE_CLUSTER_CMD)) {
                COA3DViewer.this.onSaveGenesFromBoth();
            } else if (command.equals(COA3DViewer.SAVE_EXPT_CLUSTER_CMD)) {
                COA3DViewer.this.onSaveExptsFromBoth();
            } else if (command.equals(COA3DViewer.SAVE_CMD)) {
                COA3DViewer.this.onSave();
            } else if (command.equals(COA3DViewer.SHOW_SELECTION_CMD)) {
                COA3DViewer.this.onShowSelection();
            } else if (command.equals(COA3DViewer.HIDE_SELECTION_BOX_CMD)) {
                COA3DViewer.this.onHideSelection();
            } else if (command.equals(COA3DViewer.SHOW_SPHERES_CMD)) {
                COA3DViewer.this.onShowSphere();
            } else if (command.equals(COA3DViewer.SHOW_TEXT_CMD)) {
                COA3DViewer.this.onShowText();
            } else if (command.equals(COA3DViewer.SHOW_GENE_TEXT_FROM_BOTH_CMD)) {
                COA3DViewer.this.onShowGeneTextFromBoth();
            } else if (command.equals(COA3DViewer.SHOW_EXPT_TEXT_FROM_BOTH_CMD)) {
                COA3DViewer.this.onShowExptTextFromBoth();
            } else if (command.equals(COA3DViewer.WHITE_CMD)) {
                COA3DViewer.this.onWhiteBackground();
            } else if (command.equals(COA3DViewer.STORE_CLUSTER_CMD)) {
                COA3DViewer.this.storeCluster();
            } else if (command.equals(COA3DViewer.STORE_GENE_CLUSTER_CMD)) {
                COA3DViewer.this.storeGeneClusterFromBoth();
            } else if (command.equals(COA3DViewer.STORE_EXPT_CLUSTER_CMD)) {
                COA3DViewer.this.storeExptClusterFromBoth();
            } else if (command.equals(COA3DViewer.LAUNCH_NEW_SESSION_CMD)) {
                COA3DViewer.this.launchNewSession();
            } else if (command.equals(COA3DViewer.LAUNCH_NEW_GENE_SESSION_CMD)) {
                COA3DViewer.this.launchNewGeneSessionFromBoth();
            } else if (command.equals(COA3DViewer.LAUNCH_NEW_EXPT_SESSION_CMD)) {
                COA3DViewer.this.launchNewExptSessionFromBoth();
            } else if (command.equals(COA3DViewer.SAVE_3D_GENE_COORDS_CMD)) {
                COA3DViewer.this.output3DCoords(true);
            } else if (command.equals(COA3DViewer.SAVE_3D_EXPT_COORDS_CMD)) {
                COA3DViewer.this.output3DCoords(false);
            }
        }

        @Override
        public void mouseReleased(MouseEvent event) {
            this.maybeShowPopup(event);
        }

        @Override
        public void mousePressed(MouseEvent event) {
            this.maybeShowPopup(event);
        }

        private void maybeShowPopup(MouseEvent e) {
            if (!e.isPopupTrigger()) {
                return;
            }
            COA3DViewer.this.popup2.show(e.getComponent(), e.getX(), e.getY());
        }
    }
}

