/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.coa;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Ellipse2D;
import java.awt.image.BufferedImage;
import java.beans.Expression;
import java.text.DecimalFormat;
import java.util.Vector;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.event.MouseInputAdapter;
import javax.swing.tree.DefaultMutableTreeNode;
import org.tigr.microarray.mev.cluster.gui.Experiment;
import org.tigr.microarray.mev.cluster.gui.IData;
import org.tigr.microarray.mev.cluster.gui.IDisplayMenu;
import org.tigr.microarray.mev.cluster.gui.IFramework;
import org.tigr.microarray.mev.cluster.gui.IViewer;
import org.tigr.microarray.mev.cluster.gui.LeafInfo;
import org.tigr.microarray.mev.cluster.gui.helpers.ExperimentUtil;
import org.tigr.microarray.mev.cluster.gui.impl.GUIFactory;
import org.tigr.util.FloatMatrix;

public class COA2DViewer
extends JPanel
implements IViewer {
    private static final String SAVE_CMD = "save-cmd";
    private static final String SAVE_GENE_CLUSTER_CMD = "save-genes-cmd";
    private static final String SAVE_EXPT_CLUSTER_CMD = "save-expts-cmd";
    private static final String SHOW_TEXT_CMD = "show-text-cmd";
    private static final String SHOW_TICK_LABELS_CMD = "show-tick-labels-cmd";
    private static final String STORE_CLUSTER_CMD = "store-cluster-cmd";
    private static final String STORE_GENE_CLUSTER_CMD = "store-gene-cluster-cmd";
    private static final String STORE_EXPT_CLUSTER_CMD = "store-expt-cluster-cmd";
    private static final String LAUNCH_NEW_SESSION_CMD = "launch-new-session-cmd";
    private static final String LAUNCH_NEW_GENE_SESSION_CMD = "launch-new-gene-session-cmd";
    private static final String LAUNCH_NEW_EXPT_SESSION_CMD = "launch-new-expt-session-cmd";
    private static final String DISPLAY_EXPT_NAMES_CMD = "display-expt-names-cmd";
    private static final String SHOW_LARGER_POINTS_CMD = "show-larger-points-cmd";
    private float[] yArray;
    private float[] xArray;
    private int geneOrExpt;
    private int axis1;
    private int axis2;
    private FloatMatrix UMatrix;
    private FloatMatrix geneUMatrix;
    private FloatMatrix exptUMatrix;
    private FloatMatrix scaledGeneUMatrix;
    private FloatMatrix scaledExptUMatrix;
    private Experiment experiment;
    private IFramework framework;
    private Frame frame;
    private IData data;
    private JPopupMenu popup;
    private Ellipse2D.Double ellipse;
    private boolean displayExptNames;
    private boolean showLargePoints;
    private boolean showTickLabels;
    Rectangle currentRect = null;
    Rectangle rectToDraw = null;
    Rectangle previousRectDrawn = new Rectangle();
    private int exptID = 0;

    public COA2DViewer(Experiment experiment, float[] xArray, float[] yArray, int geneOrExpt, int axis1, int axis2) {
        this.yArray = yArray;
        this.xArray = xArray;
        this.displayExptNames = false;
        this.showLargePoints = false;
        this.showTickLabels = true;
        this.geneOrExpt = geneOrExpt;
        this.axis1 = axis1;
        this.axis2 = axis2;
        this.experiment = experiment;
        this.exptID = experiment.getId();
        this.ellipse = new Ellipse2D.Double();
        this.setBackground(Color.white);
        this.popup = this.createJPopupMenu();
        GraphListener graphListener = new GraphListener();
        this.addMouseListener(graphListener);
        this.addMouseMotionListener(graphListener);
    }

    public COA2DViewer(Experiment experiment, FloatMatrix UMatrix, int geneOrExpt, int axis1, int axis2) {
        this.UMatrix = UMatrix;
        this.axis1 = axis1;
        this.axis2 = axis2;
        this.xArray = this.getFloatArray(UMatrix, axis1);
        this.yArray = this.getFloatArray(UMatrix, axis2);
        this.displayExptNames = false;
        this.showLargePoints = false;
        this.showTickLabels = true;
        this.geneOrExpt = geneOrExpt;
        this.experiment = experiment;
        this.exptID = experiment.getId();
        this.ellipse = new Ellipse2D.Double();
        this.setBackground(Color.white);
        this.popup = this.createJPopupMenu();
        GraphListener graphListener = new GraphListener();
        this.addMouseListener(graphListener);
        this.addMouseMotionListener(graphListener);
    }

    public COA2DViewer(Experiment experiment, FloatMatrix geneUMatrix, FloatMatrix exptUMatrix, int geneOrExpt, int axis1, int axis2) {
        this.geneUMatrix = geneUMatrix;
        this.exptUMatrix = exptUMatrix;
        this.scaledGeneUMatrix = (FloatMatrix)geneUMatrix.clone();
        this.scaledExptUMatrix = (FloatMatrix)exptUMatrix.clone();
        this.UMatrix = this.combineMatrices(this.scaledGeneUMatrix, this.scaledExptUMatrix);
        this.axis1 = axis1;
        this.axis2 = axis2;
        this.xArray = this.getFloatArray(this.UMatrix, axis1);
        this.yArray = this.getFloatArray(this.UMatrix, axis2);
        this.displayExptNames = false;
        this.showLargePoints = false;
        this.showTickLabels = true;
        this.geneOrExpt = geneOrExpt;
        this.experiment = experiment;
        this.exptID = experiment.getId();
        this.ellipse = new Ellipse2D.Double();
        this.setBackground(Color.white);
        this.popup = this.createJPopupMenu();
        GraphListener graphListener = new GraphListener();
        this.addMouseListener(graphListener);
        this.addMouseMotionListener(graphListener);
    }

    public COA2DViewer(Experiment e, FloatMatrix geneUMatrix, FloatMatrix expUMatrix, float[] xArray, float[] yArray, Integer geneOrExpt, Integer axis1, Integer axis2) {
        this.xArray = xArray;
        this.yArray = yArray;
        this.axis1 = axis1;
        this.axis2 = axis2;
        this.displayExptNames = false;
        this.showLargePoints = false;
        this.showTickLabels = true;
        this.geneOrExpt = geneOrExpt;
        if (geneUMatrix != null) {
            this.geneUMatrix = geneUMatrix;
        }
        if (expUMatrix != null) {
            this.exptUMatrix = expUMatrix;
        }
        if (this.geneOrExpt == 3) {
            this.scaledGeneUMatrix = (FloatMatrix)geneUMatrix.clone();
            this.scaledExptUMatrix = (FloatMatrix)this.exptUMatrix.clone();
        }
        this.ellipse = new Ellipse2D.Double();
        this.setBackground(Color.white);
        this.popup = this.createJPopupMenu();
        GraphListener graphListener = new GraphListener();
        this.addMouseListener(graphListener);
        this.addMouseMotionListener(graphListener);
        this.setExperiment(e);
    }

    public Expression getExpression() {
        return new Expression(this, this.getClass(), "new", new Object[]{this.experiment, this.geneUMatrix, this.exptUMatrix, this.xArray, this.yArray, new Integer(this.geneOrExpt), new Integer(this.axis1), new Integer(this.axis2)});
    }

    public void setExperiment(Experiment e) {
        this.experiment = e;
        this.exptID = this.experiment.getId();
    }

    private void scaleMatrices(FloatMatrix U1, FloatMatrix U2) {
        float max1 = 0.0f;
        float max2 = 0.0f;
        int rows1 = U1.getRowDimension();
        int rows2 = U2.getRowDimension();
        int i = rows1;
        while (--i >= 0) {
            max1 = Math.max(max1, Math.max(Math.max(Math.abs(U1.get(i, 0)), Math.abs(U1.get(i, 1))), Math.abs(U1.get(i, 2))));
        }
        i = rows2;
        while (--i >= 0) {
            max2 = Math.max(max2, Math.max(Math.max(Math.abs(U2.get(i, 0)), Math.abs(U2.get(i, 1))), Math.abs(U2.get(i, 2))));
        }
        float max = Math.max(max1, max2);
        if (max1 == max2) {
            this.scaledGeneUMatrix = (FloatMatrix)this.geneUMatrix.clone();
            this.scaledExptUMatrix = (FloatMatrix)this.exptUMatrix.clone();
        } else if (max1 > max2) {
            this.scaledGeneUMatrix = (FloatMatrix)this.geneUMatrix.clone();
            float scalingFactor = max1 / max2;
            this.scaledExptUMatrix = this.exptUMatrix.times(scalingFactor);
        } else {
            this.scaledExptUMatrix = (FloatMatrix)this.exptUMatrix.clone();
            float scalingFactor = max2 / max1;
            this.scaledGeneUMatrix = this.geneUMatrix.times(scalingFactor);
        }
    }

    private FloatMatrix combineMatrices(FloatMatrix U1, FloatMatrix U2) {
        FloatMatrix combinedMatrix = new FloatMatrix(U1.getRowDimension() + U2.getRowDimension(), U1.getColumnDimension());
        for (int i = 0; i < U1.getRowDimension(); ++i) {
            for (int j = 0; j < U1.getColumnDimension(); ++j) {
                combinedMatrix.A[i][j] = U1.A[i][j];
            }
        }
        int counter = U1.getRowDimension();
        for (int i = 0; i < U2.getRowDimension(); ++i) {
            for (int j = 0; j < U2.getColumnDimension(); ++j) {
                combinedMatrix.A[counter + i][j] = U2.A[i][j];
            }
        }
        return combinedMatrix;
    }

    private float[] getFloatArray(FloatMatrix matrix, int column) {
        float[] array = new float[matrix.getRowDimension()];
        for (int i = 0; i < array.length; ++i) {
            array[i] = matrix.A[i][column];
        }
        return array;
    }

    @Override
    public void paint(Graphics g) {
        String currName;
        double stringWidth;
        double[] currCoords;
        int i;
        double advance;
        int i2;
        int i3;
        super.paint(g);
        Graphics2D g2D = (Graphics2D)g;
        int panelWidth = this.getWidth();
        int panelHeight = this.getHeight();
        int originX = (int)Math.round((double)(this.getWidth() / 2));
        int originY = (int)Math.round((double)(this.getHeight() / 2));
        double origMaxXValue = this.getMax(this.xArray);
        double origMaxYValue = this.getMax(this.yArray);
        double origMinXValue = this.getMin(this.xArray);
        double origMinYValue = this.getMin(this.yArray);
        double xScalingFactor = this.getXScalingFactor(origMaxXValue, origMinXValue);
        double yScalingFactor = this.getYScalingFactor(origMaxYValue, origMinYValue);
        g2D.setStroke(new BasicStroke(2.0f));
        g2D.drawLine(0, (int)Math.round((double)(this.getHeight() / 2)), this.getWidth(), (int)Math.round((double)(this.getHeight() / 2)));
        g2D.drawLine((int)Math.round((double)(this.getWidth() / 2)), 0, (int)Math.round((double)(this.getWidth() / 2)), this.getHeight());
        double[] xIntervalArray = new double[6];
        double[] yIntervalArray = new double[6];
        double xIncrement = 0.0;
        double yIncrement = 0.0;
        xIncrement = Math.abs(origMaxXValue) > Math.abs(origMinXValue) ? Math.abs(origMaxXValue / 5.0) : Math.abs(origMinXValue / 5.0);
        yIncrement = Math.abs(origMaxYValue) > Math.abs(origMinYValue) ? Math.abs(origMaxYValue / 5.0) : Math.abs(origMinYValue / 5.0);
        double xCounter = 0.0;
        double yCounter = 0.0;
        for (i3 = 0; i3 < xIntervalArray.length; ++i3) {
            xIntervalArray[i3] = xCounter;
            xCounter += xIncrement;
            yIntervalArray[i3] = yCounter;
            yCounter += yIncrement;
        }
        if (this.showTickLabels) {
            double stringWidth2;
            for (i3 = 1; i3 < xIntervalArray.length; ++i3) {
                g2D.drawLine((int)Math.round(xIntervalArray[i3] * xScalingFactor) + this.getWidth() / 2, this.getHeight() / 2 - 5, (int)Math.round(xIntervalArray[i3] * xScalingFactor) + this.getWidth() / 2, this.getHeight() / 2 + 5);
            }
            for (i3 = 1; i3 < xIntervalArray.length; ++i3) {
                g2D.drawLine(this.getWidth() / 2 - (int)Math.round(xIntervalArray[i3] * xScalingFactor), this.getHeight() / 2 - 5, this.getWidth() / 2 - (int)Math.round(xIntervalArray[i3] * xScalingFactor), this.getHeight() / 2 + 5);
            }
            for (i3 = 1; i3 < yIntervalArray.length; ++i3) {
                g2D.drawLine(this.getWidth() / 2 - 5, this.getHeight() / 2 + (int)Math.round(yIntervalArray[i3] * yScalingFactor), this.getWidth() / 2 + 5, this.getHeight() / 2 + (int)Math.round(yIntervalArray[i3] * yScalingFactor));
            }
            for (i3 = 1; i3 < yIntervalArray.length; ++i3) {
                g2D.drawLine(this.getWidth() / 2 - 5, this.getHeight() / 2 - (int)Math.round(yIntervalArray[i3] * yScalingFactor), this.getWidth() / 2 + 5, this.getHeight() / 2 - (int)Math.round(yIntervalArray[i3] * yScalingFactor));
            }
            g2D.setStroke(new BasicStroke(2.0f));
            g2D.setColor(Color.black);
            DecimalFormat nf = new DecimalFormat();
            for (i2 = 1; i2 < xIntervalArray.length; ++i2) {
                stringWidth2 = g2D.getFontMetrics().stringWidth(nf.format(xIntervalArray[i2]));
                g2D.drawString(nf.format(xIntervalArray[i2]), (int)Math.round(xIntervalArray[i2] * xScalingFactor) + this.getWidth() / 2 - (int)Math.round(0.5 * stringWidth2), this.getHeight() / 2 + 20);
            }
            for (i2 = 1; i2 < xIntervalArray.length; ++i2) {
                stringWidth2 = g2D.getFontMetrics().stringWidth("-" + nf.format(xIntervalArray[i2]));
                g2D.drawString("-" + nf.format(xIntervalArray[i2]), this.getWidth() / 2 - (int)Math.round(xIntervalArray[i2] * xScalingFactor) - (int)Math.round(0.5 * stringWidth2), this.getHeight() / 2 + 20);
            }
            for (i2 = 1; i2 < yIntervalArray.length; ++i2) {
                g2D.drawString(nf.format(yIntervalArray[i2]), this.getWidth() / 2 + 10, this.getHeight() / 2 - (int)Math.round(yIntervalArray[i2] * yScalingFactor));
            }
            for (i2 = 1; i2 < yIntervalArray.length; ++i2) {
                g2D.drawString("-" + nf.format(yIntervalArray[i2]), this.getWidth() / 2 + 10, this.getHeight() / 2 + (int)Math.round(yIntervalArray[i2] * yScalingFactor));
            }
        }
        if (this.geneOrExpt == 1 || this.geneOrExpt == 2) {
            for (i3 = 0; i3 < this.xArray.length; ++i3) {
                Color currPointColor = Color.black;
                if (this.geneOrExpt == 1) {
                    currPointColor = this.data.getProbeColor(this.experiment.getGeneIndexMappedToData(i3));
                    if (currPointColor == null) {
                        currPointColor = Color.black;
                    }
                } else if (this.geneOrExpt == 2 && (currPointColor = this.data.getExperimentColor(i3)) == null) {
                    currPointColor = Color.black;
                }
                g2D.setColor(currPointColor);
                if (this.showLargePoints) {
                    this.drawRectPoint(g2D, this.xArray[i3], this.yArray[i3], this.getXScalingFactor(origMaxXValue, origMinXValue), this.getYScalingFactor(origMaxYValue, origMinYValue), 8);
                } else {
                    this.drawPoint(g2D, this.xArray[i3], this.yArray[i3], this.getXScalingFactor(origMaxXValue, origMinXValue), this.getYScalingFactor(origMaxYValue, origMinYValue), 5);
                }
                g2D.setColor(Color.black);
            }
            g2D.drawString("X axis = " + (this.axis1 + 1) + ", Y axis = " + (this.axis2 + 1), this.getWidth() / 2 + 25, this.getHeight() - 25);
        } else {
            Color currPointColor = Color.black;
            for (i2 = 0; i2 < this.geneUMatrix.getRowDimension(); ++i2) {
                currPointColor = this.data.getProbeColor(this.experiment.getGeneIndexMappedToData(i2));
                if (currPointColor == null) {
                    currPointColor = Color.gray;
                }
                g2D.setColor(currPointColor);
                this.drawPoint(g2D, this.xArray[i2], this.yArray[i2], this.getXScalingFactor(origMaxXValue, origMinXValue), this.getYScalingFactor(origMaxYValue, origMinYValue), 5);
                g2D.setColor(Color.gray);
            }
            for (i2 = this.geneUMatrix.getRowDimension(); i2 < this.xArray.length; ++i2) {
                currPointColor = this.data.getExperimentColor(i2 - this.geneUMatrix.getRowDimension());
                if (currPointColor == null) {
                    currPointColor = Color.black;
                }
                g2D.setColor(currPointColor);
                this.drawRectPoint(g2D, this.xArray[i2], this.yArray[i2], this.getXScalingFactor(origMaxXValue, origMinXValue), this.getYScalingFactor(origMaxYValue, origMinYValue), 8);
                g2D.setColor(Color.black);
            }
            g2D.setColor(Color.black);
            g2D.drawString("X axis = " + (this.axis1 + 1) + ", Y axis = " + (this.axis2 + 1), this.getWidth() / 2 + 25, this.getHeight() - 25);
        }
        if (this.geneOrExpt == 2 && this.displayExptNames) {
            FontMetrics fmet = g2D.getFontMetrics(g2D.getFont());
            double ascent = fmet.getAscent();
            advance = fmet.getMaxAdvance();
            for (i = 0; i < this.xArray.length; ++i) {
                currCoords = this.getCoords(this.xArray[i], this.yArray[i]);
                if (currCoords[0] + 0.5 * advance + (stringWidth = (double)fmet.stringWidth(currName = this.data.getSampleName(i))) > (double)this.getWidth()) {
                    g2D.drawString(currName, (float)(currCoords[0] - stringWidth - 0.25 * advance), (float)(currCoords[1] + 0.5 * ascent));
                    continue;
                }
                g2D.drawString(currName, (float)(currCoords[0] + 0.5 * advance), (float)(currCoords[1] + 0.5 * ascent));
            }
        }
        if (this.geneOrExpt == 3 && this.displayExptNames) {
            FontMetrics fmet = g2D.getFontMetrics(g2D.getFont());
            double ascent = fmet.getAscent();
            advance = fmet.getMaxAdvance();
            for (i = this.geneUMatrix.getRowDimension(); i < this.xArray.length; ++i) {
                currCoords = this.getCoords(this.xArray[i], this.yArray[i]);
                if (currCoords[0] + 0.5 * advance + (stringWidth = (double)fmet.stringWidth(currName = this.data.getSampleName(i - this.geneUMatrix.getRowDimension()))) > (double)this.getWidth()) {
                    g2D.drawString(currName, (float)(currCoords[0] - stringWidth - 0.25 * advance), (float)(currCoords[1] + 0.5 * ascent));
                    continue;
                }
                g2D.drawString(currName, (float)(currCoords[0] + 0.5 * advance), (float)(currCoords[1] + 0.5 * ascent));
            }
        }
        if (this.currentRect != null) {
            g2D.setXORMode(Color.white);
            g2D.draw(this.ellipse);
        }
    }

    private void drawPoint(Graphics2D g2D, double xValue, double yValue, double xScale, double yScale, int diameter) {
        int xRaw = (int)Math.round(xValue * xScale);
        int yRaw = (int)Math.round(yValue * yScale);
        int xCoord = (int)Math.round((double)(this.getWidth() / 2)) + xRaw;
        int yCoord = (int)Math.round((double)(this.getHeight() / 2)) - yRaw;
        g2D.fillOval(xCoord, yCoord, diameter, diameter);
    }

    private void drawRectPoint(Graphics2D g2D, double xValue, double yValue, double xScale, double yScale, int dim) {
        int xRaw = (int)Math.round(xValue * xScale);
        int yRaw = (int)Math.round(yValue * yScale);
        int xCoord = (int)Math.round((double)(this.getWidth() / 2)) + xRaw;
        int yCoord = (int)Math.round((double)(this.getHeight() / 2)) - yRaw;
        g2D.fillRect(xCoord, yCoord, dim, dim);
    }

    private double getMax(float[] array) {
        float max = Float.NEGATIVE_INFINITY;
        for (int i = 0; i < array.length; ++i) {
            if (!(max < array[i])) continue;
            max = array[i];
        }
        return max;
    }

    private double getMin(float[] array) {
        float min = Float.POSITIVE_INFINITY;
        for (int i = 0; i < array.length; ++i) {
            if (!(min > array[i])) continue;
            min = array[i];
        }
        return min;
    }

    private double getXScalingFactor(double maxValue, double minValue) {
        double largest = 1.0;
        if (maxValue > 0.0 && minValue > 0.0) {
            largest = maxValue;
        } else if (maxValue > 0.0 && minValue < 0.0) {
            largest = maxValue > Math.abs(minValue) ? maxValue : Math.abs(minValue);
        } else if (maxValue <= 0.0) {
            largest = Math.abs(minValue);
        } else if (minValue == 0.0) {
            largest = maxValue;
        }
        double scalingFactor = 0.0;
        scalingFactor = (double)(this.getWidth() / 2 - 50) / largest;
        return scalingFactor;
    }

    private double getYScalingFactor(double maxValue, double minValue) {
        double largest = 1.0;
        if (maxValue > 0.0 && minValue > 0.0) {
            largest = maxValue;
        } else if (maxValue > 0.0 && minValue < 0.0) {
            largest = maxValue > Math.abs(minValue) ? maxValue : Math.abs(minValue);
        } else if (maxValue <= 0.0) {
            largest = Math.abs(minValue);
        } else if (minValue == 0.0) {
            largest = maxValue;
        }
        double scalingFactor = 0.0;
        scalingFactor = (double)(this.getHeight() / 2 - 50) / largest;
        return scalingFactor;
    }

    public int[][] getClusters() {
        return null;
    }

    public int[] getSelectedPoints() {
        Vector<Integer> selPointsVector = new Vector<Integer>();
        for (int i = 0; i < this.UMatrix.getRowDimension(); ++i) {
            double[] currCoords = this.getCoords(this.xArray[i], this.yArray[i]);
            if (!this.ellipse.contains(currCoords[0], currCoords[1])) continue;
            if (this.geneOrExpt == 1) {
                selPointsVector.add(new Integer(this.experiment.getGeneIndexMappedToData(i)));
                continue;
            }
            if (this.geneOrExpt != 2) continue;
            selPointsVector.add(new Integer(this.experiment.getSampleIndex(i)));
        }
        int[] selPoints = new int[selPointsVector.size()];
        for (int i = 0; i < selPoints.length; ++i) {
            selPoints[i] = (Integer)selPointsVector.get(i);
        }
        return selPoints;
    }

    public int[] getSelectedGenesFromBoth() {
        Vector<Integer> selPointsVector = new Vector<Integer>();
        for (int i = 0; i < this.geneUMatrix.getRowDimension(); ++i) {
            double[] currCoords = this.getCoords(this.xArray[i], this.yArray[i]);
            if (!this.ellipse.contains(currCoords[0], currCoords[1])) continue;
            selPointsVector.add(new Integer(this.experiment.getGeneIndexMappedToData(i)));
        }
        int[] selPoints = new int[selPointsVector.size()];
        for (int i = 0; i < selPoints.length; ++i) {
            selPoints[i] = (Integer)selPointsVector.get(i);
        }
        return selPoints;
    }

    public int[] getSelectedExptsFromBoth() {
        Vector<Integer> selPointsVector = new Vector<Integer>();
        for (int i = this.geneUMatrix.getRowDimension(); i < this.UMatrix.getRowDimension(); ++i) {
            double[] currCoords = this.getCoords(this.xArray[i], this.yArray[i]);
            if (!this.ellipse.contains(currCoords[0], currCoords[1])) continue;
            selPointsVector.add(new Integer(this.experiment.getSampleIndex(i - this.geneUMatrix.getRowDimension())));
        }
        int[] selPoints = new int[selPointsVector.size()];
        for (int i = 0; i < selPoints.length; ++i) {
            selPoints[i] = (Integer)selPointsVector.get(i);
        }
        return selPoints;
    }

    private double[] getCoords(double xValue, double yValue) {
        double origMaxXValue = this.getMax(this.xArray);
        double origMaxYValue = this.getMax(this.yArray);
        double origMinXValue = this.getMin(this.xArray);
        double origMinYValue = this.getMin(this.yArray);
        double xScalingFactor = this.getXScalingFactor(origMaxXValue, origMinXValue);
        double yScalingFactor = this.getYScalingFactor(origMaxYValue, origMinYValue);
        double xRaw = Math.round(xValue * xScalingFactor);
        double yRaw = Math.round(yValue * yScalingFactor);
        double xCoord = (double)Math.round((double)(this.getWidth() / 2)) + xRaw;
        double yCoord = (double)Math.round((double)(this.getHeight() / 2)) - yRaw;
        double[] coords = new double[]{xCoord, yCoord};
        return coords;
    }

    public JComponent getContentComponent() {
        return this;
    }

    public JComponent getCornerComponent(int cornerIndex) {
        return null;
    }

    public Experiment getExperiment() {
        return this.experiment;
    }

    public JComponent getHeaderComponent() {
        return null;
    }

    public BufferedImage getImage() {
        return null;
    }

    public JComponent getRowHeaderComponent() {
        return null;
    }

    public int getViewerType() {
        return -1;
    }

    public void onClosed() {
    }

    public void onDataChanged(IData data) {
        this.setData(data);
    }

    public void onDeselected() {
    }

    public void onMenuChanged(IDisplayMenu menu) {
    }

    public void onSelected(IFramework framework) {
        this.framework = framework;
        this.frame = framework.getFrame();
        this.setData(framework.getData());
        if (this.popup == null) {
            this.popup = this.createJPopupMenu();
            DefaultMutableTreeNode node = framework.getCurrentNode();
            if (node != null && node.getUserObject() instanceof LeafInfo) {
                LeafInfo leafInfo = (LeafInfo)node.getUserObject();
                leafInfo.setPopupMenu(this.popup);
            }
        }
    }

    public void setData(IData data) {
        this.data = data;
    }

    public JPopupMenu getJPopupMenu() {
        return this.popup;
    }

    private JPopupMenu createJPopupMenu() {
        JPopupMenu popup = new JPopupMenu();
        this.addMenuItems(popup);
        return popup;
    }

    private void addMenuItems(JPopupMenu menu) {
        JMenuItem menuItem;
        Listener listener = new Listener();
        if (this.geneOrExpt == 3) {
            menuItem = new JMenuItem("Store gene cluster...", GUIFactory.getIcon("new16.gif"));
            menuItem.setEnabled(false);
            menuItem.setActionCommand(STORE_GENE_CLUSTER_CMD);
            menuItem.addActionListener(listener);
            menu.add(menuItem);
            menuItem = new JMenuItem("Launch new session with selected genes", GUIFactory.getIcon("launch_new_mav.gif"));
            menuItem.setEnabled(false);
            menuItem.setActionCommand(LAUNCH_NEW_GENE_SESSION_CMD);
            menuItem.addActionListener(listener);
            menu.add(menuItem);
            menuItem = new JMenuItem("Save gene cluster...", GUIFactory.getIcon("save16.gif"));
            menuItem.setEnabled(false);
            menuItem.setActionCommand(SAVE_GENE_CLUSTER_CMD);
            menuItem.addActionListener(listener);
            menu.add(menuItem);
            menu.addSeparator();
            menuItem = new JMenuItem("Store sample cluster...", GUIFactory.getIcon("new16.gif"));
            menuItem.setEnabled(false);
            menuItem.setActionCommand(STORE_EXPT_CLUSTER_CMD);
            menuItem.addActionListener(listener);
            menu.add(menuItem);
            menuItem = new JMenuItem("Launch new session with selected samples", GUIFactory.getIcon("launch_new_mav.gif"));
            menuItem.setEnabled(false);
            menuItem.setActionCommand(LAUNCH_NEW_EXPT_SESSION_CMD);
            menuItem.addActionListener(listener);
            menu.add(menuItem);
            menuItem = new JMenuItem("Save sample cluster...", GUIFactory.getIcon("save16.gif"));
            menuItem.setEnabled(false);
            menuItem.setActionCommand(SAVE_EXPT_CLUSTER_CMD);
            menuItem.addActionListener(listener);
            menu.add(menuItem);
        } else {
            menuItem = new JMenuItem("Store cluster...", GUIFactory.getIcon("new16.gif"));
            menuItem.setEnabled(false);
            menuItem.setActionCommand(STORE_CLUSTER_CMD);
            menuItem.addActionListener(listener);
            menu.add(menuItem);
            menuItem = new JMenuItem("Launch new session", GUIFactory.getIcon("launch_new_mav.gif"));
            menuItem.setEnabled(false);
            menuItem.setActionCommand(LAUNCH_NEW_SESSION_CMD);
            menuItem.addActionListener(listener);
            menu.add(menuItem);
            menuItem = new JMenuItem("Save cluster...", GUIFactory.getIcon("save16.gif"));
            menuItem.setEnabled(false);
            menuItem.setActionCommand(SAVE_CMD);
            menuItem.addActionListener(listener);
            menu.add(menuItem);
        }
        if (this.geneOrExpt == 2 || this.geneOrExpt == 3) {
            menu.addSeparator();
            menuItem = new JCheckBoxMenuItem("Show sample names");
            menuItem.setEnabled(true);
            menuItem.setActionCommand(DISPLAY_EXPT_NAMES_CMD);
            menuItem.addActionListener(listener);
            menu.add(menuItem);
        }
        if (this.geneOrExpt == 2 || this.geneOrExpt == 1) {
            menuItem = new JCheckBoxMenuItem("Larger point size");
            menuItem.setEnabled(true);
            menuItem.setActionCommand(SHOW_LARGER_POINTS_CMD);
            menuItem.addActionListener(listener);
            menu.add(menuItem);
        }
        menuItem = new JCheckBoxMenuItem("Show tick marks and labels");
        menuItem.setEnabled(true);
        menuItem.setSelected(true);
        menuItem.setActionCommand(SHOW_TICK_LABELS_CMD);
        menuItem.addActionListener(listener);
        menu.add(menuItem);
    }

    private JMenuItem getJMenuItem(String command) {
        Component[] components = this.popup.getComponents();
        for (int i = 0; i < components.length; ++i) {
            if (!(components[i] instanceof JMenuItem) || !((JMenuItem)components[i]).getActionCommand().equals(command)) continue;
            return (JMenuItem)components[i];
        }
        return null;
    }

    private void setEnableMenuItem(String command, boolean enable) {
        JMenuItem item = this.getJMenuItem(command);
        if (item == null) {
            return;
        }
        item.setEnabled(enable);
    }

    private void onSave() {
        try {
            if (this.geneOrExpt == 1) {
                ExperimentUtil.saveExperiment((Frame)this.frame, (Experiment)this.experiment, (IData)this.data, (int[])this.getSelectedPoints());
            } else if (this.geneOrExpt == 2) {
                ExperimentUtil.saveExperimentCluster((Frame)this.frame, (Experiment)this.experiment, (IData)this.data, (int[])this.getSelectedPoints());
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this.frame, "Can not save matrix!", e.toString(), 0);
            e.printStackTrace();
        }
    }

    private void onSaveGenesFromBoth() {
        try {
            ExperimentUtil.saveExperiment((Frame)this.frame, (Experiment)this.experiment, (IData)this.data, (int[])this.getSelectedGenesFromBoth());
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this.frame, "Can not save matrix!", e.toString(), 0);
            e.printStackTrace();
        }
    }

    private void onSaveExptsFromBoth() {
        try {
            ExperimentUtil.saveExperimentCluster((Frame)this.frame, (Experiment)this.experiment, (IData)this.data, (int[])this.getSelectedExptsFromBoth());
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this.frame, "Can not save matrix!", e.toString(), 0);
            e.printStackTrace();
        }
    }

    private void storeCluster() {
        if (this.geneOrExpt == 1) {
            this.framework.storeSubCluster(this.getSelectedPoints(), this.experiment, 0);
        } else if (this.geneOrExpt == 2) {
            this.framework.storeSubCluster(this.getSelectedPoints(), this.experiment, 1);
        }
        this.onDataChanged(this.data);
        this.repaint();
    }

    private void storeGeneClusterFromBoth() {
        this.framework.storeSubCluster(this.getSelectedGenesFromBoth(), this.experiment, 0);
        this.onDataChanged(this.data);
        this.repaint();
    }

    private void storeExptClusterFromBoth() {
        this.framework.storeSubCluster(this.getSelectedExptsFromBoth(), this.experiment, 1);
        this.onDataChanged(this.data);
        this.repaint();
    }

    private void launchNewSession() {
        if (this.geneOrExpt == 1) {
            this.framework.launchNewMAV(this.getSelectedPoints(), this.experiment, "Multiple Experiment Viewer - Cluster Viewer", 0);
        } else if (this.geneOrExpt == 2) {
            this.framework.launchNewMAV(this.getSelectedPoints(), this.experiment, "Multiple Experiment Viewer - Cluster Viewer", 1);
        }
    }

    private void launchNewGeneSessionFromBoth() {
        this.framework.launchNewMAV(this.getSelectedGenesFromBoth(), this.experiment, "Multiple Experiment Viewer - Cluster Viewer", 0);
    }

    private void launchNewExptSessionFromBoth() {
        this.framework.launchNewMAV(this.getSelectedExptsFromBoth(), this.experiment, "Multiple Experiment Viewer - Cluster Viewer", 1);
    }

    private void onShowSelection() {
        if (this.geneOrExpt == 1 || this.geneOrExpt == 2) {
            JMenuItem saveClusterItem = this.getJMenuItem(SAVE_CMD);
            JMenuItem storeClusterItem = this.getJMenuItem(STORE_CLUSTER_CMD);
            JMenuItem launchNewItem = this.getJMenuItem(LAUNCH_NEW_SESSION_CMD);
            if (!this.ellipse.isEmpty()) {
                saveClusterItem.setEnabled(true);
                storeClusterItem.setEnabled(true);
                launchNewItem.setEnabled(true);
            } else {
                saveClusterItem.setEnabled(false);
                storeClusterItem.setEnabled(false);
                launchNewItem.setEnabled(false);
            }
        } else {
            JMenuItem saveGeneClusterItem = this.getJMenuItem(SAVE_GENE_CLUSTER_CMD);
            JMenuItem storeGeneClusterItem = this.getJMenuItem(STORE_GENE_CLUSTER_CMD);
            JMenuItem launchNewGeneItem = this.getJMenuItem(LAUNCH_NEW_GENE_SESSION_CMD);
            JMenuItem saveExptClusterItem = this.getJMenuItem(SAVE_EXPT_CLUSTER_CMD);
            JMenuItem storeExptClusterItem = this.getJMenuItem(STORE_EXPT_CLUSTER_CMD);
            JMenuItem launchNewExptItem = this.getJMenuItem(LAUNCH_NEW_EXPT_SESSION_CMD);
            if (!this.ellipse.isEmpty()) {
                saveGeneClusterItem.setEnabled(true);
                saveExptClusterItem.setEnabled(true);
                storeGeneClusterItem.setEnabled(true);
                storeExptClusterItem.setEnabled(true);
                launchNewGeneItem.setEnabled(true);
                launchNewExptItem.setEnabled(true);
            } else {
                saveGeneClusterItem.setEnabled(false);
                saveExptClusterItem.setEnabled(false);
                storeGeneClusterItem.setEnabled(false);
                storeExptClusterItem.setEnabled(false);
                launchNewGeneItem.setEnabled(false);
                launchNewExptItem.setEnabled(false);
            }
        }
    }

    private void showExptNames() {
        this.displayExptNames = !this.displayExptNames;
        this.repaint();
    }

    private void displayLargePoints() {
        this.showLargePoints = !this.showLargePoints;
        this.repaint();
    }

    private void displayTickLabels() {
        this.showTickLabels = !this.showTickLabels;
        this.repaint();
    }

    public int getExperimentID() {
        return this.exptID;
    }

    public void setExperimentID(int id) {
        this.exptID = id;
    }

    private class Listener
    extends MouseAdapter
    implements ActionListener {
        private Listener() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            String command = event.getActionCommand();
            if (command.equals(COA2DViewer.SAVE_GENE_CLUSTER_CMD)) {
                COA2DViewer.this.onSaveGenesFromBoth();
            } else if (command.equals(COA2DViewer.SAVE_EXPT_CLUSTER_CMD)) {
                COA2DViewer.this.onSaveExptsFromBoth();
            } else if (command.equals(COA2DViewer.SAVE_CMD)) {
                COA2DViewer.this.onSave();
            } else if (command.equals(COA2DViewer.STORE_CLUSTER_CMD)) {
                COA2DViewer.this.storeCluster();
            } else if (command.equals(COA2DViewer.STORE_GENE_CLUSTER_CMD)) {
                COA2DViewer.this.storeGeneClusterFromBoth();
            } else if (command.equals(COA2DViewer.STORE_EXPT_CLUSTER_CMD)) {
                COA2DViewer.this.storeExptClusterFromBoth();
            } else if (command.equals(COA2DViewer.LAUNCH_NEW_SESSION_CMD)) {
                COA2DViewer.this.launchNewSession();
            } else if (command.equals(COA2DViewer.LAUNCH_NEW_GENE_SESSION_CMD)) {
                COA2DViewer.this.launchNewGeneSessionFromBoth();
            } else if (command.equals(COA2DViewer.LAUNCH_NEW_EXPT_SESSION_CMD)) {
                COA2DViewer.this.launchNewExptSessionFromBoth();
            } else if (command.equals(COA2DViewer.DISPLAY_EXPT_NAMES_CMD)) {
                COA2DViewer.this.showExptNames();
            } else if (command.equals(COA2DViewer.SHOW_LARGER_POINTS_CMD)) {
                COA2DViewer.this.displayLargePoints();
            } else if (command.equals(COA2DViewer.SHOW_TICK_LABELS_CMD)) {
                COA2DViewer.this.displayTickLabels();
            }
        }
    }

    private class GraphListener
    extends MouseInputAdapter {
        private GraphListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            int x = e.getX();
            int y = e.getY();
            COA2DViewer.this.currentRect = new Rectangle(x, y, 0, 0);
            this.updateDrawableRect(COA2DViewer.this.getWidth(), COA2DViewer.this.getHeight());
            COA2DViewer.this.repaint();
            COA2DViewer.this.onShowSelection();
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            this.updateSize(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.updateSize(e);
        }

        void updateSize(MouseEvent e) {
            int x = e.getX();
            int y = e.getY();
            COA2DViewer.this.currentRect.setSize(x - COA2DViewer.this.currentRect.x, y - COA2DViewer.this.currentRect.y);
            this.updateDrawableRect(COA2DViewer.this.getWidth(), COA2DViewer.this.getHeight());
            Rectangle totalRepaint = COA2DViewer.this.rectToDraw.union(COA2DViewer.this.previousRectDrawn);
            COA2DViewer.this.ellipse.setFrame(totalRepaint.getX(), totalRepaint.getY(), totalRepaint.getWidth(), totalRepaint.getHeight());
            COA2DViewer.this.repaint();
            COA2DViewer.this.onShowSelection();
        }

        private void updateDrawableRect(int compWidth, int compHeight) {
            int x = COA2DViewer.this.currentRect.x;
            int y = COA2DViewer.this.currentRect.y;
            int width = COA2DViewer.this.currentRect.width;
            int height = COA2DViewer.this.currentRect.height;
            if (width < 0 && (x = x - (width = 0 - width) + 1) < 0) {
                width += x;
                x = 0;
            }
            if (height < 0 && (y = y - (height = 0 - height) + 1) < 0) {
                height += y;
                y = 0;
            }
            if (x + width > compWidth) {
                width = compWidth - x;
            }
            if (y + height > compHeight) {
                height = compHeight - y;
            }
            if (COA2DViewer.this.rectToDraw != null) {
                COA2DViewer.this.previousRectDrawn.setBounds(COA2DViewer.this.rectToDraw.x, COA2DViewer.this.rectToDraw.y, COA2DViewer.this.rectToDraw.width, COA2DViewer.this.rectToDraw.height);
                COA2DViewer.this.rectToDraw.setBounds(x, y, width, height);
            } else {
                COA2DViewer.this.rectToDraw = new Rectangle(x, y, width, height);
            }
        }
    }
}

