/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.clvalid;

import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.tree.DefaultMutableTreeNode;
import org.tigr.microarray.mev.cluster.algorithm.Algorithm;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmData;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmEvent;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmException;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmListener;
import org.tigr.microarray.mev.cluster.algorithm.impl.CLVALID;
import org.tigr.microarray.mev.cluster.gui.Experiment;
import org.tigr.microarray.mev.cluster.gui.IClusterGUI;
import org.tigr.microarray.mev.cluster.gui.IFramework;
import org.tigr.microarray.mev.cluster.gui.impl.clvalid.CLVALIDInitBox;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.DialogListener;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.Progress;
import org.tigr.microarray.mev.script.scriptGUI.IScriptGUI;

public class CLVALIDGUI
implements IClusterGUI,
IScriptGUI {
    private Algorithm algorithm;
    private Progress progress;
    private Experiment experiment;
    Vector<String> exptNamesVector;

    public DefaultMutableTreeNode execute(AlgorithmData algData) throws AlgorithmException {
        this.algorithm = new CLVALID();
        algData = this.algorithm.execute(algData);
        return algData.getResultNode("validation-node");
    }

    public DefaultMutableTreeNode execute(IFramework framework) throws AlgorithmException {
        CLVALIDInitBox dialog = new CLVALIDInitBox(framework.getFrame(), framework.getClusterRepository(0), framework.getData().getChipAnnotation().getChipType());
        dialog.setVisible(true);
        if (!dialog.isOkPressed()) {
            return null;
        }
        long start = System.currentTimeMillis();
        Listener listener = new Listener();
        try {
            int i;
            this.progress = new Progress(framework.getFrame(), "", listener);
            this.progress.show();
            this.progress.setIndeterminate(true);
            this.progress.setIndeterminantString("This process may take awhile...");
            this.progress.setDescription("Performing Cluster Validation");
            this.progress.setTitle("Cluster Validation");
            this.experiment = framework.getData().getExperiment();
            int number_of_samples = this.experiment.getNumberOfSamples();
            int[] columnIndices = this.experiment.getColumnIndicesCopy();
            ArrayList<String> sampleLabels = new ArrayList<String>();
            ArrayList<String> geneLabels = new ArrayList<String>();
            for (i = 0; i < number_of_samples; ++i) {
                sampleLabels.add(framework.getData().getFullSampleName(columnIndices[i]));
            }
            for (i = 0; i < this.experiment.getNumberOfGenes(); ++i) {
                geneLabels.add(framework.getData().getElementAnnotation(i, "PROBE_ID")[0]);
            }
            AlgorithmData validationData = new AlgorithmData();
            validationData.addMatrix("experiment", this.experiment.getMatrix());
            validationData.addStringArray("geneLabels", geneLabels.toArray(new String[geneLabels.size()]));
            validationData.addStringArray("sampleLabels", sampleLabels.toArray(new String[sampleLabels.size()]));
            dialog.getValidationGenerator().addValidationParameters(validationData);
            this.performValidation(validationData);
            long time = System.currentTimeMillis() - start;
            this.progress.dispose();
            GeneralInfo info = new GeneralInfo();
            info.time = time;
            info.lowRange = dialog.getValidationGenerator().getLowClusterRange();
            info.highRange = dialog.getValidationGenerator().getHighClusterRange();
            info.linkageMethod = dialog.getValidationGenerator().getValidationLinkageMethod();
            info.distanceMetric = dialog.getValidationGenerator().getValidationDistanceMetric();
            info.internal = dialog.getValidationGenerator().isInternalV();
            info.stability = dialog.getValidationGenerator().isStabilityV();
            info.biological = dialog.getValidationGenerator().isBiologicalV();
            info.bioconductorAnnotation = dialog.getValidationGenerator().getBioCAnnotationString();
            info.isClusterGenes = dialog.getValidationGenerator().isClusterGenes();
            info.clusterID = dialog.getValidationGenerator().getClusterID();
            info.methodsArray = dialog.getValidationGenerator().getMethodsArray();
            return this.createResultTree(validationData.getResultNode("validation-node"), info);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.progress.dispose();
            return null;
        }
    }

    public DefaultMutableTreeNode performValidation(AlgorithmData data) throws AlgorithmException {
        try {
            CLVALIDGUI clv = new CLVALIDGUI();
            return clv.execute(data);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("Error running clValid");
            throw new AlgorithmException("Error running Cluster Validation");
        }
    }

    public AlgorithmData getScriptParameters(IFramework framework) {
        return null;
    }

    public DefaultMutableTreeNode executeScript(IFramework framework, AlgorithmData algData, Experiment experiment) throws AlgorithmException {
        return null;
    }

    private DefaultMutableTreeNode createResultTree(DefaultMutableTreeNode resultNode, GeneralInfo info) {
        DefaultMutableTreeNode root = new DefaultMutableTreeNode("CLVALID");
        root.add(resultNode);
        this.addGeneralInfo(root, info);
        return root;
    }

    private void addGeneralInfo(DefaultMutableTreeNode root, GeneralInfo info) {
        DefaultMutableTreeNode node = new DefaultMutableTreeNode("General Information");
        node.add(new DefaultMutableTreeNode("Time: " + String.valueOf(info.time - 1L) + " ms"));
        node.add(new DefaultMutableTreeNode("Clustering by " + (info.isClusterGenes ? "genes" : "samples")));
        if (info.internal) {
            node.add(new DefaultMutableTreeNode("Internal Validation"));
        }
        if (info.stability) {
            node.add(new DefaultMutableTreeNode("Stability Validation"));
        }
        if (info.biological) {
            node.add(new DefaultMutableTreeNode("Biological Validation"));
        }
        node.add(new DefaultMutableTreeNode("Cluster Range: " + info.lowRange + "-" + info.highRange));
        node.add(new DefaultMutableTreeNode("Distance Metric: " + info.distanceMetric));
        if (info.methodsArray[0].equals("hierarchical") || info.methodsArray[info.methodsArray.length - 1].equals("agnus")) {
            node.add(new DefaultMutableTreeNode("Linkage Metric: " + info.linkageMethod));
        }
        if (info.biological) {
            node.add(new DefaultMutableTreeNode("Bioconductor Annotation: " + info.bioconductorAnnotation));
        }
        String methods = "";
        for (int i = 0; i < info.methodsArray.length; ++i) {
            methods = methods + info.methodsArray[i] + ", ";
        }
        methods = methods.substring(0, methods.length() - 2);
        node.add(new DefaultMutableTreeNode("Clustering Methods: " + methods));
        node.add(new DefaultMutableTreeNode("Cluster: " + info.clusterID));
        root.add(node);
    }

    private class GeneralInfo {
        public String clusterID;
        public boolean isClusterGenes;
        public String bioconductorAnnotation;
        public boolean biological;
        public boolean stability;
        public boolean internal;
        public String[] methodsArray;
        public int highRange;
        public int lowRange;
        public String distanceMetric;
        public String linkageMethod;
        public long time;

        private GeneralInfo() {
        }
    }

    private class Listener
    extends DialogListener
    implements AlgorithmListener {
        private Listener() {
        }

        public void valueChanged(AlgorithmEvent event) {
            switch (event.getId()) {
                case 1: {
                    CLVALIDGUI.this.progress.setUnits(event.getIntValue());
                    CLVALIDGUI.this.progress.setDescription(event.getDescription());
                    break;
                }
                case 2: {
                    CLVALIDGUI.this.progress.setValue(event.getIntValue());
                    CLVALIDGUI.this.progress.setDescription(event.getDescription());
                    break;
                }
                case 3: {
                    int value = event.getIntValue();
                    if (value != -1) break;
                }
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String command = e.getActionCommand();
            if (command.equals("cancel-command")) {
                CLVALIDGUI.this.algorithm.abort();
                CLVALIDGUI.this.progress.dispose();
            }
        }

        @Override
        public void windowClosing(WindowEvent e) {
            CLVALIDGUI.this.algorithm.abort();
            CLVALIDGUI.this.progress.dispose();
        }
    }
}

