/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.cast;

import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.util.Arrays;
import javax.swing.JFrame;
import javax.swing.tree.DefaultMutableTreeNode;
import org.tigr.microarray.mev.cluster.Cluster;
import org.tigr.microarray.mev.cluster.Node;
import org.tigr.microarray.mev.cluster.NodeList;
import org.tigr.microarray.mev.cluster.NodeValueList;
import org.tigr.microarray.mev.cluster.algorithm.Algorithm;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmData;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmEvent;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmException;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmListener;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmParameters;
import org.tigr.microarray.mev.cluster.gui.Experiment;
import org.tigr.microarray.mev.cluster.gui.IClusterGUI;
import org.tigr.microarray.mev.cluster.gui.IData;
import org.tigr.microarray.mev.cluster.gui.IDistanceMenu;
import org.tigr.microarray.mev.cluster.gui.IFramework;
import org.tigr.microarray.mev.cluster.gui.IViewer;
import org.tigr.microarray.mev.cluster.gui.LeafInfo;
import org.tigr.microarray.mev.cluster.gui.helpers.CentroidUserObject;
import org.tigr.microarray.mev.cluster.gui.helpers.ClusterTableViewer;
import org.tigr.microarray.mev.cluster.gui.helpers.ExperimentClusterTableViewer;
import org.tigr.microarray.mev.cluster.gui.impl.cast.CASTCentroidViewer;
import org.tigr.microarray.mev.cluster.gui.impl.cast.CASTCentroidsViewer;
import org.tigr.microarray.mev.cluster.gui.impl.cast.CASTExperimentCentroidViewer;
import org.tigr.microarray.mev.cluster.gui.impl.cast.CASTExperimentCentroidsViewer;
import org.tigr.microarray.mev.cluster.gui.impl.cast.CASTExperimentClusterViewer;
import org.tigr.microarray.mev.cluster.gui.impl.cast.CASTExperimentViewer;
import org.tigr.microarray.mev.cluster.gui.impl.cast.CASTInfoViewer;
import org.tigr.microarray.mev.cluster.gui.impl.cast.CASTInitDialog;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.DialogListener;
import org.tigr.microarray.mev.cluster.gui.impl.hcl.HCLGUI;
import org.tigr.microarray.mev.cluster.gui.impl.hcl.HCLInitDialog;
import org.tigr.microarray.mev.cluster.gui.impl.hcl.HCLTreeData;
import org.tigr.microarray.mev.cluster.gui.impl.hcl.HCLViewer;
import org.tigr.microarray.mev.script.scriptGUI.IScriptGUI;
import org.tigr.util.FloatMatrix;

public class CASTGUI
implements IClusterGUI,
IScriptGUI {
    private Algorithm algorithm;
    private Experiment experiment;
    private IData data;
    private int[][] clusters;
    private FloatMatrix means;
    private FloatMatrix variances;
    private boolean clusterGenes;
    private int k;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DefaultMutableTreeNode execute(IFramework framework) throws AlgorithmException {
        this.data = framework.getData();
        float threshold = 0.5f;
        boolean modal = true;
        IDistanceMenu menu = framework.getDistanceMenu();
        int function = menu.getDistanceFunction();
        int usedFunction = 4;
        if (function == 0) {
            function = 1;
        }
        CASTInitDialog cast_dialog = new CASTInitDialog((JFrame)framework.getFrame(), modal, menu.getFunctionName(function), menu.isAbsoluteDistance());
        cast_dialog.setVisible(true);
        if (!cast_dialog.isOkPressed()) {
            return null;
        }
        this.clusterGenes = cast_dialog.isClusterGenes();
        threshold = Float.parseFloat(cast_dialog.thresholdTextField.getText());
        boolean isHierarchicalTree = cast_dialog.isHCLSelected();
        int hcl_method = 0;
        boolean hcl_samples = false;
        boolean hcl_genes = false;
        int hcl_function = 4;
        boolean hcl_absolute = false;
        if (isHierarchicalTree) {
            HCLInitDialog hcl_dialog = new HCLInitDialog(framework.getFrame(), menu.getFunctionName(cast_dialog.getDistanceMetric()), cast_dialog.isAbsoluteDistance(), true);
            if (hcl_dialog.showModal() != 0) {
                return null;
            }
            hcl_method = hcl_dialog.getMethod();
            hcl_samples = hcl_dialog.isClusterExperiments();
            hcl_genes = hcl_dialog.isClusterGenes();
            hcl_function = hcl_dialog.getDistanceMetric();
            hcl_absolute = hcl_dialog.getAbsoluteSelection();
        }
        this.experiment = framework.getData().getExperiment();
        Listener listener = new Listener();
        try {
            this.algorithm = framework.getAlgorithmFactory().getAlgorithm("CAST");
            this.algorithm.addAlgorithmListener((AlgorithmListener)listener);
            int genes = this.experiment.getNumberOfGenes();
            AlgorithmData data = new AlgorithmData();
            FloatMatrix matrix = this.experiment.getMatrix();
            if (!this.clusterGenes) {
                matrix = matrix.transpose();
            }
            data.addMatrix("experiment", matrix);
            data.addParam("cast-cluster-genes", String.valueOf(this.clusterGenes));
            data.addParam("distance-factor", String.valueOf(1.0f));
            data.addParam("threshold", String.valueOf(threshold));
            function = cast_dialog.getDistanceMetric();
            data.addParam("distance-absolute", String.valueOf(cast_dialog.isAbsoluteDistance()));
            data.addParam("distance-function", String.valueOf(function));
            if (isHierarchicalTree) {
                data.addParam("hierarchical-tree", String.valueOf(true));
                data.addParam("method-linkage", String.valueOf(hcl_method));
                data.addParam("calculate-genes", String.valueOf(hcl_genes));
                data.addParam("calculate-experiments", String.valueOf(hcl_samples));
                data.addParam("hcl-distance-function", String.valueOf(hcl_function));
                data.addParam("hcl-distance-absolute", String.valueOf(hcl_absolute));
            }
            long start = System.currentTimeMillis();
            AlgorithmData result = this.algorithm.execute(data);
            long time = System.currentTimeMillis() - start;
            Cluster result_cluster = result.getCluster("cluster");
            NodeList nodeList = result_cluster.getNodeList();
            AlgorithmParameters resultMap = result.getParams();
            this.k = resultMap.getInt("number-of-clusters");
            this.clusters = new int[this.k][];
            for (int i = 0; i < this.k; ++i) {
                this.clusters[i] = nodeList.getNode(i).getFeaturesIndexes();
            }
            this.means = result.getMatrix("clusters_means");
            this.variances = result.getMatrix("clusters_variances");
            GeneralInfo info = new GeneralInfo();
            info.clusters = this.k;
            info.time = time;
            info.threshold = threshold;
            info.isAbsolute = menu.isAbsoluteDistance();
            if (function == 0 || function == 2 || function == 3 || function == 4 || function == 5 || function == 8 || function == 9 || function == 10 || function == 11) {
                usedFunction = 4;
            } else if (function == 1 || function == 6 || function == 7) {
                usedFunction = 1;
            }
            info.function = menu.getFunctionName(usedFunction);
            info.hcl = isHierarchicalTree;
            info.hcl_genes = hcl_genes;
            info.hcl_samples = hcl_samples;
            info.hcl_method = hcl_method;
            DefaultMutableTreeNode defaultMutableTreeNode = this.createResultTree(result_cluster, info);
            return defaultMutableTreeNode;
        }
        finally {
            if (this.algorithm != null) {
                this.algorithm.removeAlgorithmListener((AlgorithmListener)listener);
            }
        }
    }

    public AlgorithmData getScriptParameters(IFramework framework) {
        this.data = framework.getData();
        float threshold = 0.5f;
        boolean modal = true;
        IDistanceMenu menu = framework.getDistanceMenu();
        int function = menu.getDistanceFunction();
        int usedFunction = 4;
        if (function == 0) {
            function = 1;
        }
        CASTInitDialog cast_dialog = new CASTInitDialog((JFrame)framework.getFrame(), modal, menu.getFunctionName(function), menu.isAbsoluteDistance());
        cast_dialog.setVisible(true);
        if (!cast_dialog.isOkPressed()) {
            return null;
        }
        this.clusterGenes = cast_dialog.isClusterGenes();
        threshold = Float.parseFloat(cast_dialog.thresholdTextField.getText());
        boolean isHierarchicalTree = cast_dialog.isHCLSelected();
        int hcl_method = 0;
        boolean hcl_samples = false;
        boolean hcl_genes = false;
        int hcl_function = 4;
        boolean hcl_absolute = false;
        if (isHierarchicalTree) {
            HCLInitDialog hcl_dialog = new HCLInitDialog(framework.getFrame(), menu.getFunctionName(cast_dialog.getDistanceMetric()), cast_dialog.isAbsoluteDistance(), true);
            if (hcl_dialog.showModal() != 0) {
                return null;
            }
            hcl_method = hcl_dialog.getMethod();
            hcl_samples = hcl_dialog.isClusterExperiments();
            hcl_genes = hcl_dialog.isClusterGenes();
            hcl_function = hcl_dialog.getDistanceMetric();
            hcl_absolute = hcl_dialog.getAbsoluteSelection();
        }
        AlgorithmData data = new AlgorithmData();
        data.addParam("cast-cluster-genes", String.valueOf(this.clusterGenes));
        data.addParam("distance-factor", String.valueOf(1.0f));
        data.addParam("threshold", String.valueOf(threshold));
        function = cast_dialog.getDistanceMetric();
        data.addParam("distance-absolute", String.valueOf(cast_dialog.isAbsoluteDistance()));
        data.addParam("distance-function", String.valueOf(function));
        if (isHierarchicalTree) {
            data.addParam("hierarchical-tree", String.valueOf(true));
            data.addParam("method-linkage", String.valueOf(hcl_method));
            data.addParam("calculate-genes", String.valueOf(hcl_genes));
            data.addParam("calculate-experiments", String.valueOf(hcl_samples));
            data.addParam("hcl-distance-function", String.valueOf(hcl_function));
            data.addParam("hcl-distance-absolute", String.valueOf(hcl_absolute));
        }
        data.addParam("name", "CAST");
        if (this.clusterGenes) {
            data.addParam("alg-type", "cluster-genes");
        } else {
            data.addParam("alg-type", "cluster-experiments");
        }
        if (this.clusterGenes) {
            data.addParam("output-class", "multi-gene-cluster-output");
        } else {
            data.addParam("output-class", "multi-experiment-cluster-output");
        }
        String[] outputNodes = new String[]{"Multi-cluster"};
        data.addStringArray("output-nodes", outputNodes);
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DefaultMutableTreeNode executeScript(IFramework framework, AlgorithmData algData, Experiment experiment) throws AlgorithmException {
        this.experiment = experiment;
        this.data = framework.getData();
        Listener listener = new Listener();
        try {
            this.algorithm = framework.getAlgorithmFactory().getAlgorithm("CAST");
            this.algorithm.addAlgorithmListener((AlgorithmListener)listener);
            FloatMatrix matrix = experiment.getMatrix();
            if (!algData.getParams().getBoolean("cast-cluster-genes")) {
                this.clusterGenes = false;
                matrix = matrix.transpose();
            } else {
                this.clusterGenes = true;
            }
            algData.addMatrix("experiment", matrix);
            long start = System.currentTimeMillis();
            AlgorithmData result = this.algorithm.execute(algData);
            long time = System.currentTimeMillis() - start;
            Cluster result_cluster = result.getCluster("cluster");
            NodeList nodeList = result_cluster.getNodeList();
            AlgorithmParameters resultMap = result.getParams();
            this.k = resultMap.getInt("number-of-clusters");
            this.clusters = new int[this.k][];
            for (int i = 0; i < this.k; ++i) {
                this.clusters[i] = nodeList.getNode(i).getFeaturesIndexes();
            }
            this.means = result.getMatrix("clusters_means");
            this.variances = result.getMatrix("clusters_variances");
            AlgorithmParameters params = algData.getParams();
            int function = params.getInt("distance-function");
            GeneralInfo info = new GeneralInfo();
            info.clusters = this.k;
            info.time = time;
            info.threshold = params.getFloat("threshold");
            info.isAbsolute = params.getBoolean("distance-absolute");
            int usedFunction = 4;
            if (function == 0 || function == 2 || function == 3 || function == 4 || function == 5 || function == 8 || function == 9 || function == 10 || function == 11) {
                usedFunction = 4;
            } else if (function == 1 || function == 6 || function == 7) {
                usedFunction = 1;
            }
            info.function = framework.getDistanceMenu().getFunctionName(usedFunction);
            info.hcl = params.getBoolean("hierarchical-tree");
            info.hcl_genes = params.getBoolean("calculate-genes");
            info.hcl_samples = params.getBoolean("calculate-samples");
            if (info.hcl) {
                info.hcl_method = params.getInt("method-linkage");
            } else {
                info.hcl_method = 0;
            }
            DefaultMutableTreeNode defaultMutableTreeNode = this.createResultTree(result_cluster, info);
            return defaultMutableTreeNode;
        }
        finally {
            if (this.algorithm != null) {
                this.algorithm.removeAlgorithmListener((AlgorithmListener)listener);
            }
        }
    }

    private HCLTreeData getResult(Node clusterNode, int pos) {
        HCLTreeData data = new HCLTreeData();
        NodeValueList valueList = clusterNode.getValues();
        data.child_1_array = (int[])valueList.getNodeValue((int)pos).value;
        data.child_2_array = (int[])valueList.getNodeValue((int)(pos + 1)).value;
        data.node_order = (int[])valueList.getNodeValue((int)(pos + 2)).value;
        data.height = (float[])valueList.getNodeValue((int)(pos + 3)).value;
        return data;
    }

    private DefaultMutableTreeNode createResultTree(Cluster result_cluster, GeneralInfo info) {
        DefaultMutableTreeNode root = this.clusterGenes ? new DefaultMutableTreeNode("CAST - genes") : new DefaultMutableTreeNode("CAST - samples");
        this.addResultNodes(root, result_cluster, info);
        return root;
    }

    private void addResultNodes(DefaultMutableTreeNode root, Cluster result_cluster, GeneralInfo info) {
        this.addExpressionImages(root);
        this.addHierarchicalTrees(root, result_cluster, info);
        this.addCentroidViews(root);
        this.addTableViews(root);
        this.addClusterInfo(root);
        this.addGeneralInfo(root, info);
    }

    private void addTableViews(DefaultMutableTreeNode root) {
        DefaultMutableTreeNode node = new DefaultMutableTreeNode("Table views");
        Object tabViewer = this.clusterGenes ? new ClusterTableViewer(this.experiment, this.clusters, this.data) : new ExperimentClusterTableViewer(this.experiment, this.clusters, this.data);
        for (int i = 0; i < this.clusters.length; ++i) {
            node.add(new DefaultMutableTreeNode(new LeafInfo("Cluster " + String.valueOf(i + 1), (IViewer)tabViewer, (Object)new Integer(i))));
        }
        root.add(node);
    }

    private void addExpressionImages(DefaultMutableTreeNode root) {
        DefaultMutableTreeNode node = new DefaultMutableTreeNode("Expression Images");
        Object expViewer = this.clusterGenes ? new CASTExperimentViewer(this.experiment, this.clusters) : new CASTExperimentClusterViewer(this.experiment, this.clusters);
        for (int i = 0; i < this.clusters.length; ++i) {
            node.add(new DefaultMutableTreeNode(new LeafInfo("Cluster " + String.valueOf(i + 1), (IViewer)expViewer, (Object)new Integer(i))));
        }
        root.add(node);
    }

    private void addHierarchicalTrees(DefaultMutableTreeNode root, Cluster result_cluster, GeneralInfo info) {
        int i;
        if (!info.hcl) {
            return;
        }
        DefaultMutableTreeNode node = new DefaultMutableTreeNode("Hierarchical Trees");
        NodeList nodeList = result_cluster.getNodeList();
        Object clusters = null;
        if (!this.clusterGenes) {
            clusters = new int[this.k][];
            for (i = 0; i < this.k; ++i) {
                clusters[i] = nodeList.getNode(i).getFeaturesIndexes();
            }
            if (info.hcl_samples) {
                clusters = this.getOrderedIndices(nodeList, (int[][])clusters, info.hcl_genes);
            }
        }
        for (i = 0; i < nodeList.getSize(); ++i) {
            if (this.clusterGenes) {
                node.add(new DefaultMutableTreeNode(new LeafInfo("Cluster " + String.valueOf(i + 1), this.createHCLViewer(nodeList.getNode(i), info, null))));
                continue;
            }
            node.add(new DefaultMutableTreeNode(new LeafInfo("Cluster " + String.valueOf(i + 1), this.createHCLViewer(nodeList.getNode(i), info, (int[][])clusters), (Object)new Integer(i))));
        }
        root.add(node);
    }

    private IViewer createHCLViewer(Node clusterNode, GeneralInfo info, int[][] sampleClusters) {
        HCLTreeData samples_result;
        HCLTreeData genes_result;
        HCLTreeData hCLTreeData = genes_result = info.hcl_genes ? this.getResult(clusterNode, 0) : null;
        HCLTreeData hCLTreeData2 = info.hcl_samples ? this.getResult(clusterNode, info.hcl_genes ? 4 : 0) : (samples_result = null);
        if (this.clusterGenes) {
            return new HCLViewer(this.experiment, clusterNode.getFeaturesIndexes(), genes_result, samples_result);
        }
        return new HCLViewer(this.experiment, clusterNode.getFeaturesIndexes(), genes_result, samples_result, sampleClusters, true);
    }

    private void addClusterInfo(DefaultMutableTreeNode root) {
        DefaultMutableTreeNode node = new DefaultMutableTreeNode("Cluster Information");
        if (this.clusterGenes) {
            node.add(new DefaultMutableTreeNode(new LeafInfo("Genes in Clusters (#,%)", (IViewer)new CASTInfoViewer(this.clusters, this.experiment.getNumberOfGenes()))));
        } else {
            node.add(new DefaultMutableTreeNode(new LeafInfo("Samples in Clusters (#,%)", (IViewer)new CASTInfoViewer(this.clusters, this.experiment.getNumberOfSamples(), false))));
        }
        root.add(node);
    }

    private void addCentroidViews(DefaultMutableTreeNode root) {
        DefaultMutableTreeNode centroidNode = new DefaultMutableTreeNode("Centroid Graphs");
        DefaultMutableTreeNode expressionNode = new DefaultMutableTreeNode("Expression Graphs");
        if (this.clusterGenes) {
            CASTCentroidViewer centroidViewer = new CASTCentroidViewer(this.experiment, this.clusters);
            centroidViewer.setMeans(this.means.A);
            centroidViewer.setVariances(this.variances.A);
            for (int i = 0; i < this.clusters.length; ++i) {
                centroidNode.add(new DefaultMutableTreeNode(new LeafInfo("Cluster " + String.valueOf(i + 1), (IViewer)centroidViewer, (Object)new CentroidUserObject(i, 0))));
                expressionNode.add(new DefaultMutableTreeNode(new LeafInfo("Cluster " + String.valueOf(i + 1), (IViewer)centroidViewer, (Object)new CentroidUserObject(i, 1))));
            }
            CASTCentroidsViewer centroidsViewer = new CASTCentroidsViewer(this.experiment, this.clusters);
            centroidsViewer.setMeans(this.means.A);
            centroidsViewer.setVariances(this.variances.A);
            centroidNode.add(new DefaultMutableTreeNode(new LeafInfo("All Clusters", (IViewer)centroidsViewer, (Object)new Integer(0))));
            expressionNode.add(new DefaultMutableTreeNode(new LeafInfo("All Clusters", (IViewer)centroidsViewer, (Object)new Integer(1))));
        } else {
            CASTExperimentCentroidViewer expCentroidViewer = new CASTExperimentCentroidViewer(this.experiment, this.clusters);
            expCentroidViewer.setMeans(this.means.A);
            expCentroidViewer.setVariances(this.variances.A);
            for (int i = 0; i < this.clusters.length; ++i) {
                centroidNode.add(new DefaultMutableTreeNode(new LeafInfo("Cluster " + String.valueOf(i + 1), (IViewer)expCentroidViewer, (Object)new CentroidUserObject(i, 0))));
                expressionNode.add(new DefaultMutableTreeNode(new LeafInfo("Cluster " + String.valueOf(i + 1), (IViewer)expCentroidViewer, (Object)new CentroidUserObject(i, 1))));
            }
            CASTExperimentCentroidsViewer expCentroidsViewer = new CASTExperimentCentroidsViewer(this.experiment, this.clusters);
            expCentroidsViewer.setMeans(this.means.A);
            expCentroidsViewer.setVariances(this.variances.A);
            centroidNode.add(new DefaultMutableTreeNode(new LeafInfo("All Clusters", (IViewer)expCentroidsViewer, (Object)new Integer(0))));
            expressionNode.add(new DefaultMutableTreeNode(new LeafInfo("All Clusters", (IViewer)expCentroidsViewer, (Object)new Integer(1))));
        }
        root.add(centroidNode);
        root.add(expressionNode);
    }

    private void addGeneralInfo(DefaultMutableTreeNode root, GeneralInfo info) {
        DefaultMutableTreeNode node = new DefaultMutableTreeNode("General Information");
        node.add(new DefaultMutableTreeNode("Clusters: " + String.valueOf(info.clusters)));
        node.add(new DefaultMutableTreeNode("Threshold: " + String.valueOf(info.threshold)));
        node.add(new DefaultMutableTreeNode("Absolute distance: " + String.valueOf(info.isAbsolute)));
        node.add(new DefaultMutableTreeNode("HCL: " + info.getMethodName()));
        node.add(new DefaultMutableTreeNode("Time: " + String.valueOf(info.time) + " ms"));
        node.add(new DefaultMutableTreeNode(info.function));
        root.add(node);
    }

    private int[][] getOrderedIndices(NodeList nodeList, int[][] sampleClusters, boolean calcGeneHCL) {
        for (int i = 0; i < sampleClusters.length; ++i) {
            if (sampleClusters[i].length <= 0) continue;
            HCLTreeData result = this.getResult(nodeList.getNode(i), calcGeneHCL ? 4 : 0);
            sampleClusters[i] = this.getSampleOrder(result, sampleClusters[i]);
        }
        return sampleClusters;
    }

    private int[] getSampleOrder(HCLTreeData result, int[] indices) {
        return this.getLeafOrder(result.node_order, result.child_1_array, result.child_2_array, indices);
    }

    private int[] getLeafOrder(int[] nodeOrder, int[] child1, int[] child2, int[] indices) {
        int[] leafOrder = new int[nodeOrder.length];
        Arrays.fill(leafOrder, -1);
        this.fillLeafOrder(leafOrder, child1, child2, 0, child1.length - 2, indices);
        return leafOrder;
    }

    private int fillLeafOrder(int[] leafOrder, int[] child1, int[] child2, int pos, int index, int[] indices) {
        if (child1[index] != -1) {
            pos = this.fillLeafOrder(leafOrder, child1, child2, pos, child1[index], indices);
        }
        if (child2[index] != -1) {
            pos = this.fillLeafOrder(leafOrder, child1, child2, pos, child2[index], indices);
        } else {
            leafOrder[pos] = indices == null ? index : indices[index];
            ++pos;
        }
        return pos;
    }

    private class GeneralInfo {
        public int clusters;
        public long time;
        public float threshold;
        public boolean isAbsolute;
        public String function;
        private boolean hcl;
        private int hcl_method;
        private boolean hcl_genes;
        private boolean hcl_samples;

        private GeneralInfo() {
        }

        public String getMethodName() {
            return this.hcl ? HCLGUI.GeneralInfo.getMethodName(this.hcl_method) : "no linkage";
        }
    }

    private class Listener
    extends DialogListener
    implements AlgorithmListener {
        private Listener() {
        }

        public void valueChanged(AlgorithmEvent event) {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String command = e.getActionCommand();
            if (command.equals("cancel-command")) {
                CASTGUI.this.algorithm.abort();
                this.cleanUp();
            }
        }

        @Override
        public void windowClosing(WindowEvent e) {
            CASTGUI.this.algorithm.abort();
            this.cleanUp();
        }

        public void cleanUp() {
        }
    }
}

