/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.bn.prepareXMLBif;

import java.util.ArrayList;
import java.util.HashSet;
import org.tigr.microarray.mev.cluster.gui.impl.bn.SimpleGeneEdge;

public class SifToXMLBifUtil {
    public static boolean debug = false;

    public static int maxEltsInOneSetOfValues(ArrayList values) {
        int max = 0;
        ArrayList oneSetOfValues = null;
        for (int i = 0; i < values.size(); ++i) {
            oneSetOfValues = (ArrayList)values.get(i);
            if (oneSetOfValues.size() <= max) continue;
            max = oneSetOfValues.size();
        }
        return max;
    }

    public static ArrayList getOneUniformDistribution(int valueSize) {
        double d = 1.0 / (double)valueSize;
        ArrayList<Double> oneDistribution = new ArrayList<Double>(valueSize);
        for (int k = 0; k < valueSize; ++k) {
            oneDistribution.add(new Double(d));
        }
        return oneDistribution;
    }

    public static ArrayList getNames(ArrayList interactions) {
        HashSet<String> names = new HashSet<String>();
        SimpleGeneEdge sGE = null;
        for (int i = 0; i < interactions.size(); ++i) {
            sGE = (SimpleGeneEdge)interactions.get(i);
            names.add(sGE.getFrom());
            names.add(sGE.getTo());
        }
        ArrayList<String> result = new ArrayList<String>();
        result.addAll(names);
        return result;
    }

    public static int getMaxParents(ArrayList interactions, ArrayList names) {
        int numParents = 0;
        int maxParents = 0;
        for (int j = 0; j < names.size(); ++j) {
            numParents = 0;
            for (int i = 0; i < interactions.size(); ++i) {
                SimpleGeneEdge tmp = (SimpleGeneEdge)interactions.get(i);
                if (!tmp.getTo().equals((String)names.get(j))) continue;
                ++numParents;
            }
            if (numParents <= maxParents) continue;
            maxParents = numParents;
        }
        return maxParents;
    }

    public static double getMaxWeight(ArrayList interactions) {
        SimpleGeneEdge sGE = null;
        double max = 0.0;
        for (int i = 0; i < interactions.size(); ++i) {
            sGE = (SimpleGeneEdge)interactions.get(i);
            if (!(sGE.getWeight() > max)) continue;
            max = sGE.getWeight();
        }
        return max;
    }

    public static int getCardinalityOfParents(ArrayList parents, int iAttribute, ArrayList values) {
        int card = 1;
        for (int p = 0; p < parents.size(); ++p) {
            card *= ((ArrayList)values.get(p)).size();
        }
        return card;
    }

    public static ArrayList[][] makeUniformDistributions(ArrayList names, ArrayList values, int maxParents, ArrayList interactions) {
        int maxElts = SifToXMLBifUtil.maxEltsInOneSetOfValues(values);
        System.gc();
        if (debug) {
            System.out.println("maxElts=" + maxElts);
        }
        ArrayList[][] distributions = new ArrayList[names.size()][(int)Math.pow(maxElts, maxParents)];
        ArrayList oneSetOfValues = null;
        for (int i = 0; i < names.size(); ++i) {
            if (debug) {
                System.out.println("for name " + i + "=" + names.get(i));
            }
            oneSetOfValues = (ArrayList)values.get(i);
            ArrayList parents = SifToXMLBifUtil.getParents(names, i, interactions);
            for (int j = 0; j < SifToXMLBifUtil.getCardinalityOfParents(parents, i, values); ++j) {
                distributions[i][j] = SifToXMLBifUtil.getOneUniformDistribution(oneSetOfValues.size());
                if (!debug) continue;
                System.out.println("distr[" + i + "][" + j + "]=" + distributions[i][j]);
            }
        }
        return distributions;
    }

    public static ArrayList[][] computeDistributions(ArrayList names, ArrayList values, int maxParents, ArrayList interactions) {
        System.gc();
        int maxElts = SifToXMLBifUtil.maxEltsInOneSetOfValues(values);
        if (debug) {
            System.out.println("maxElts=" + maxElts);
        }
        int numNames = names.size();
        int numValues = values.size();
        ArrayList valuesForOneGene = null;
        String name = null;
        ArrayList oneSetOfValues = null;
        double maxWeight = SifToXMLBifUtil.getMaxWeight(interactions);
        ArrayList[][] distributions = new ArrayList[names.size()][(int)Math.pow(maxElts, maxParents)];
        ArrayList parents = null;
        int card = 1;
        int index = 0;
        for (int i = 0; i < numNames; ++i) {
            index = 0;
            card = 1;
            name = (String)names.get(i);
            oneSetOfValues = (ArrayList)values.get(i);
            if (debug) {
                System.out.println("name=" + name + " @i=" + i);
            }
            parents = SifToXMLBifUtil.getParents(names, i, interactions);
            card = SifToXMLBifUtil.getCardinalityOfParents(parents, i, values);
            if (parents.size() == 0) {
                while (index < card) {
                    distributions[i][index] = SifToXMLBifUtil.getOneUniformDistribution(oneSetOfValues.size());
                    if (debug) {
                        System.out.println("no par: distr[" + i + "][" + index + "]=" + distributions[i][index]);
                    }
                    ++index;
                }
                continue;
            }
            int j = 0;
            valuesForOneGene = (ArrayList)values.get(j);
            while (index < card) {
                if (index == valuesForOneGene.size()) {
                    valuesForOneGene = (ArrayList)values.get(++j);
                }
                if (debug) {
                    System.out.print("#j=" + j + " for parent=");
                    System.out.print(parents.get(j));
                }
                distributions[i][index] = SifToXMLBifUtil.computeOneDistribution(index, card, name, j, names, parents, valuesForOneGene, interactions, maxWeight);
                if (debug) {
                    System.out.println("distr[" + i + "][" + index + "]=" + distributions[i][index]);
                }
                ++index;
            }
        }
        return distributions;
    }

    public static double getWeightForOneName(String name, int j, ArrayList parents, ArrayList interactions) {
        SimpleGeneEdge sGE = null;
        double weight = 0.0;
        String parent = (String)parents.get(j);
        for (int i = 0; i < interactions.size(); ++i) {
            sGE = (SimpleGeneEdge)interactions.get(i);
            if (!sGE.getTo().equals(name) || !sGE.getFrom().equals(parent)) continue;
            weight = sGE.getWeight();
        }
        return weight;
    }

    public static ArrayList computeOneDistribution(int index, int card, String name, int j, ArrayList names, ArrayList parents, ArrayList valuesForOneGene, ArrayList interactions, double maxWeight) {
        if (debug) {
            System.out.println("in computeOneDistr: index=" + index + " card=" + card + " name=" + name + " j=" + j);
        }
        if ((index + 1) % card == 0) {
            double weight = 0.0;
            ArrayList<Double> oneDistr = new ArrayList<Double>();
            double lastValue = 0.0;
            double otherValues = 0.0;
            weight = SifToXMLBifUtil.getWeightForOneName(name, j, parents, interactions);
            lastValue = weight / maxWeight;
            otherValues = (1.0 - lastValue) / (double)(valuesForOneGene.size() - 1);
            for (int i = 0; i < valuesForOneGene.size() - 1; ++i) {
                oneDistr.add(new Double(otherValues));
            }
            oneDistr.add(new Double(lastValue));
            return oneDistr;
        }
        return SifToXMLBifUtil.getOneUniformDistribution(valuesForOneGene.size());
    }

    public static ArrayList getParents(ArrayList names, int index, ArrayList interactions) {
        ArrayList<String> parents = new ArrayList<String>();
        for (int i = 0; i < interactions.size(); ++i) {
            SimpleGeneEdge tmp = (SimpleGeneEdge)interactions.get(i);
            if (!tmp.getTo().equals((String)names.get(index))) continue;
            parents.add(tmp.getFrom());
        }
        return parents;
    }
}

