/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.bn.prepareXMLBif;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Properties;
import org.tigr.microarray.mev.cluster.gui.impl.bn.NotDAGException;
import org.tigr.microarray.mev.cluster.gui.impl.bn.NullArgumentException;
import org.tigr.microarray.mev.cluster.gui.impl.bn.Useful;
import org.tigr.microarray.mev.cluster.gui.impl.bn.UsefulInteractions;
import org.tigr.microarray.mev.cluster.gui.impl.bn.algs.Cyclic;
import org.tigr.microarray.mev.cluster.gui.impl.bn.prepareXMLBif.SifToXMLBifUtil;

public class SifToXMLBif {
    public static boolean debug = false;

    public static void createXMLBifGivenSifFile(ArrayList interactions, ArrayList names, PrintWriter pw, Properties props) throws NullArgumentException, NotDAGException {
        int i;
        if (interactions == null || names == null || props == null) {
            throw new NullArgumentException("At least one of interactions or names or props was null\ninteractions=" + interactions + "\nnames=" + names + "\nprops=" + props);
        }
        if (Cyclic.isCyclic(interactions)) {
            throw new NotDAGException("The given graph is cyclic!\ninteractions=" + interactions);
        }
        boolean uniform = true;
        if (props.getProperty("distributionFromWeights", "false").equals("true")) {
            uniform = false;
        }
        System.gc();
        ArrayList<ArrayList> values = new ArrayList<ArrayList>();
        int numStates = Integer.parseInt(props.getProperty("numStates", "3"));
        System.out.println("createXMLBifGivenSifFile, numStates: -- " + numStates);
        ArrayList<String> gene1values = new ArrayList<String>(numStates);
        for (i = 0; i < numStates; ++i) {
            gene1values.add(props.getProperty("state" + i, "state" + i));
        }
        for (i = 0; i < names.size(); ++i) {
            values.add((ArrayList)gene1values.clone());
        }
        int numClasses = Integer.parseInt(props.getProperty("numClasses", "2"));
        System.out.println("createXMLBifGivenSifFile, numClasses: -- " + numClasses);
        ArrayList<String> classValues = new ArrayList<String>(numClasses);
        for (int i2 = 0; i2 < numClasses; ++i2) {
            classValues.add(props.getProperty("class" + i2, "class" + i2));
        }
        int maxParents = SifToXMLBifUtil.getMaxParents(interactions, names);
        if (debug) {
            System.out.println("maxParents=" + maxParents);
        }
        ArrayList[][] distributions = null;
        if (!uniform) {
            distributions = SifToXMLBifUtil.computeDistributions(names, values, maxParents, interactions);
        } else {
            System.gc();
            distributions = SifToXMLBifUtil.makeUniformDistributions(names, values, maxParents, interactions);
        }
        SifToXMLBif.toXMLBIF03(classValues, interactions, names.size(), names, values, distributions, pw);
    }

    public static void createXMLBifGivenSifFile(ArrayList interactions, ArrayList names, boolean distributionFromWeights, int numStates, int numClasses, String outXMLBifFileName) throws NullArgumentException, NotDAGException, FileNotFoundException {
        int i;
        if (interactions == null || names == null) {
            throw new NullArgumentException("At least one of interactions or names or props was null\ninteractions=" + interactions + "\nnames=" + names);
        }
        if (Cyclic.isCyclic(interactions)) {
            throw new NotDAGException("The given graph is cyclic!\ninteractions=" + interactions);
        }
        boolean uniform = true;
        if (!distributionFromWeights) {
            uniform = false;
        }
        System.gc();
        ArrayList<ArrayList> values = new ArrayList<ArrayList>();
        System.out.println("createXMLBifGivenSifFile, numStates: -- " + numStates);
        ArrayList<String> gene1values = new ArrayList<String>(numStates);
        for (i = 0; i < numStates; ++i) {
            gene1values.add("state" + i);
        }
        for (i = 0; i < names.size(); ++i) {
            values.add((ArrayList)gene1values.clone());
        }
        System.out.println("createXMLBifGivenSifFile, numClasses: -- " + numClasses);
        ArrayList<String> classValues = new ArrayList<String>(numClasses);
        for (int i2 = 0; i2 < numClasses; ++i2) {
            classValues.add("class" + i2);
        }
        int maxParents = SifToXMLBifUtil.getMaxParents(interactions, names);
        if (debug) {
            System.out.println("maxParents=" + maxParents);
        }
        ArrayList[][] distributions = null;
        if (!uniform) {
            distributions = SifToXMLBifUtil.computeDistributions(names, values, maxParents, interactions);
        } else {
            System.gc();
            distributions = SifToXMLBifUtil.makeUniformDistributions(names, values, maxParents, interactions);
        }
        PrintWriter pw = new PrintWriter(new FileOutputStream(outXMLBifFileName), true);
        SifToXMLBif.toXMLBIF03(classValues, interactions, names.size(), names, values, distributions, pw);
        pw.close();
    }

    public static void toXMLBIF03(ArrayList classValues, ArrayList interactions, int numAttributes, ArrayList names, ArrayList values, ArrayList[][] distributions, PrintWriter pw) {
        if (interactions == null) {
            pw.print("<!--No model built yet-->");
        }
        pw.print("<?xml version=\"1.0\"?>\n");
        pw.print("<!-- DTD for the XMLBIF 0.3 format -->\n");
        pw.print("<!DOCTYPE BIF [\n");
        pw.print("\t<!ELEMENT BIF ( NETWORK )*>\n");
        pw.print("\t      <!ATTLIST BIF VERSION CDATA #REQUIRED>\n");
        pw.print("\t<!ELEMENT NETWORK ( NAME, ( PROPERTY | VARIABLE | DEFINITION )* )>\n");
        pw.print("\t<!ELEMENT NAME (#PCDATA)>\n");
        pw.print("\t<!ELEMENT VARIABLE ( NAME, ( OUTCOME |  PROPERTY )* ) >\n");
        pw.print("\t      <!ATTLIST VARIABLE TYPE (nature|decision|utility) \"nature\">\n");
        pw.print("\t<!ELEMENT OUTCOME (#PCDATA)>\n");
        pw.print("\t<!ELEMENT DEFINITION ( FOR | GIVEN | TABLE | PROPERTY )* >\n");
        pw.print("\t<!ELEMENT FOR (#PCDATA)>\n");
        pw.print("\t<!ELEMENT GIVEN (#PCDATA)>\n");
        pw.print("\t<!ELEMENT TABLE (#PCDATA)>\n");
        pw.print("\t<!ELEMENT PROPERTY (#PCDATA)>\n");
        pw.print("]>\n");
        pw.print("\n");
        pw.print("\n");
        pw.print("<BIF VERSION=\"0.3\">\n");
        pw.print("<NETWORK>\n");
        pw.print("<NAME>relation name goes here</NAME>\n");
        pw.print("<VARIABLE TYPE=\"nature\">\n");
        pw.print("<NAME>CLASS</NAME>\n");
        for (int iClassValue = 0; iClassValue < classValues.size(); ++iClassValue) {
            pw.print("\t<OUTCOME>" + classValues.get(iClassValue) + "</OUTCOME>\n");
        }
        pw.print("</VARIABLE>\n");
        for (int iAttribute = 0; iAttribute < numAttributes; ++iAttribute) {
            pw.print("<VARIABLE TYPE=\"nature\">\n");
            pw.print("<NAME>" + names.get(iAttribute) + "</NAME>\n");
            for (int iValue = 0; iValue < ((ArrayList)values.get(iAttribute)).size(); ++iValue) {
                pw.print("\t<OUTCOME>" + ((ArrayList)values.get(iAttribute)).get(iValue) + "</OUTCOME>\n");
            }
            pw.print("</VARIABLE>\n");
        }
        pw.print("<DEFINITION>\n");
        pw.print("<FOR>CLASS</FOR>\n");
        pw.print("<TABLE>\n");
        ArrayList classDistr = SifToXMLBifUtil.getOneUniformDistribution(classValues.size());
        for (int iClassValue = 0; iClassValue < classValues.size(); ++iClassValue) {
            pw.print(classDistr.get(iClassValue));
            pw.print(" ");
        }
        pw.print("\n</TABLE>\n");
        pw.print("</DEFINITION>\n");
        for (int iAttribute = 0; iAttribute < numAttributes; ++iAttribute) {
            int iParent;
            pw.print("<DEFINITION>\n");
            pw.print("<FOR>" + names.get(iAttribute) + "</FOR>\n");
            ArrayList parents = SifToXMLBifUtil.getParents(names, iAttribute, interactions);
            for (iParent = 0; iParent < parents.size(); ++iParent) {
                pw.print("\t<GIVEN>" + parents.get(iParent) + "</GIVEN>\n");
            }
            pw.print("<TABLE>\n");
            for (iParent = 0; iParent < SifToXMLBifUtil.getCardinalityOfParents(parents, iAttribute, values); ++iParent) {
                for (int iValue = 0; iValue < ((ArrayList)values.get(iAttribute)).size(); ++iValue) {
                    pw.print(distributions[iAttribute][iParent].get(iValue));
                    pw.print(" ");
                }
                pw.print("\n");
            }
            pw.print("</TABLE>\n");
            pw.print("</DEFINITION>\n");
        }
        pw.print("</NETWORK>\n");
        pw.print("</BIF>\n");
    }

    public static void test(String propsFileName) {
        try {
            Object XMLBifStr = null;
            Properties props = new Properties();
            props.load(new FileInputStream(propsFileName));
            String sifFileName = props.getProperty("sifFileName", null);
            String namesFileName = props.getProperty("namesFileName", null);
            Useful.checkFile(sifFileName);
            Useful.checkFile(namesFileName);
            ArrayList interactions = UsefulInteractions.readDirectedInteractionsWithWeights(sifFileName);
            ArrayList<String> names = Useful.readNamesFromFile(namesFileName);
            String outXMLBifFileName = props.getProperty("outXMLBifFileName", "out_bif.xml");
            PrintWriter pw = new PrintWriter(new FileOutputStream(outXMLBifFileName), true);
            pw.close();
            SifToXMLBif.createXMLBifGivenSifFile(interactions, names, pw, props);
        }
        catch (IOException ioe) {
            System.out.println(ioe);
            ioe.printStackTrace();
        }
        catch (NullArgumentException nae) {
            System.out.println(nae);
            nae.printStackTrace();
        }
        catch (NotDAGException nde) {
            System.out.println(nde);
            nde.printStackTrace();
        }
    }

    public static void main(String[] argv) {
        if (argv.length != 1) {
            System.out.println("Usage: java SifToXMLBif propsFileName\nExample: java SifToXMLBif prepareXMLBif.props");
            System.exit(0);
        }
        String propsFileName = argv[0];
        SifToXMLBif.test(propsFileName);
    }
}

