/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.bn.prepareXMLBif;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;
import java.util.Vector;
import org.tigr.microarray.mev.cluster.gui.impl.bn.BNConstants;
import org.tigr.microarray.mev.cluster.gui.impl.bn.NotDAGException;
import org.tigr.microarray.mev.cluster.gui.impl.bn.NullArgumentException;
import org.tigr.microarray.mev.cluster.gui.impl.bn.SimpleGeneEdge;
import org.tigr.microarray.mev.cluster.gui.impl.bn.Useful;
import org.tigr.microarray.mev.cluster.gui.impl.bn.UsefulInteractions;
import org.tigr.microarray.mev.cluster.gui.impl.bn.algs.DFSModification;
import org.tigr.microarray.mev.cluster.gui.impl.bn.prepareXMLBif.ParseGB_GO;
import org.tigr.microarray.mev.cluster.gui.impl.bn.prepareXMLBif.SifToXMLBif;

public class PrepareXMLBifModule {
    public static boolean debug = false;
    public static String logFileName = null;
    static String path;

    public static ArrayList getInteractionsFromGB_GOs(ArrayList interWithWeights, HashMap gbGOs) throws NullArgumentException {
        if (debug) {
            ParseGB_GO.setDebug(true, logFileName);
        }
        return ParseGB_GO.getInteractionsFromGB_GOs(interWithWeights, gbGOs);
    }

    public static ArrayList getInteractionsFromGB_GOsAndRandom(ArrayList interWithWeights, HashMap gbGOs, long seed) throws NullArgumentException {
        if (debug) {
            ParseGB_GO.setDebug(true, logFileName);
        }
        return ParseGB_GO.getInteractionsFromGB_GOsRandom(interWithWeights, gbGOs, seed);
    }

    public static ArrayList getDAGFromUndirectedGraph(ArrayList interWithWeights) throws NullArgumentException {
        if (debug) {
            DFSModification.setDebug(true, logFileName);
        }
        return DFSModification.getDAGFromUndirectedGraph(interWithWeights);
    }

    public static void test(String propsFileName) {
        String path = BNConstants.getBaseFileLocation();
        path = path + BNConstants.SEP + "tmp" + BNConstants.SEP;
        try {
            Properties props = new Properties();
            props.load(new FileInputStream(propsFileName));
            String isDebugStr = props.getProperty("debug", "false");
            if (isDebugStr.equals("true")) {
                debug = true;
            }
            String sifFileName = path + props.getProperty("sifFileName", null);
            boolean useGO = Boolean.getBoolean(props.getProperty("useGo", "false"));
            String gbGOsFileName = path + props.getProperty("gbGOsFileName", null);
            String namesFileName = path + props.getProperty("namesFileName", null);
            long seed = Integer.parseInt(props.getProperty("seed", "1"));
            System.out.println("test(): namesFileName " + namesFileName);
            System.out.println("test(): sifFileName " + sifFileName);
            Useful.checkFile(sifFileName);
            Useful.checkFile(namesFileName);
            if (useGO) {
                Useful.checkFile(gbGOsFileName);
            }
            String outXMLBifFileName = path + props.getProperty("outXMLBifFileName", "out_bif.xml");
            ArrayList inter = UsefulInteractions.readInteractionsWithWeights(sifFileName);
            ArrayList<String> names = Useful.readNamesFromFile(namesFileName);
            ArrayList newInter = null;
            if (useGO) {
                HashMap gbGOs = ParseGB_GO.readGB_GOs(gbGOsFileName);
                newInter = PrepareXMLBifModule.getInteractionsFromGB_GOsAndRandom(inter, gbGOs, seed);
            } else {
                newInter = PrepareXMLBifModule.getDAGFromUndirectedGraph(inter);
            }
            PrintWriter pw = new PrintWriter(new FileOutputStream(outXMLBifFileName), true);
            SifToXMLBif.createXMLBifGivenSifFile(newInter, names, pw, props);
            pw.close();
        }
        catch (IOException ioe) {
            System.out.println(ioe);
            ioe.printStackTrace();
        }
        catch (NullArgumentException nae) {
            System.out.println(nae);
            nae.printStackTrace();
        }
        catch (NotDAGException nde) {
            System.out.println(nde);
            nde.printStackTrace();
        }
    }

    public static void createXMLBifFromList(String propsFileName, Vector fixedNetworkInter) throws Exception {
        String path = BNConstants.getBaseFileLocation();
        path = path + BNConstants.SEP + "tmp" + BNConstants.SEP;
        try {
            Properties props = new Properties();
            props.load(new FileInputStream(propsFileName));
            String namesFileName = path + props.getProperty("namesFileName", null);
            Useful.checkFile(namesFileName);
            String outXMLBifFileName = path + props.getProperty("", "out_bif_final.xml");
            ArrayList inter = UsefulInteractions.readInteractions(fixedNetworkInter);
            ArrayList<String> names = Useful.readNamesFromFile(namesFileName);
            PrintWriter pw = new PrintWriter(new FileOutputStream(outXMLBifFileName), true);
            SifToXMLBif.createXMLBifGivenSifFile(inter, names, pw, props);
            pw.close();
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (NullArgumentException nae) {
            throw nae;
        }
        catch (NotDAGException nde) {
            throw nde;
        }
        catch (Exception ex) {
            throw ex;
        }
    }

    public static void createXMLBifFromSimpleGeneEdge(String namesFileName, String outXMLBifFileName, String propsFileName, ArrayList<SimpleGeneEdge> interList) throws Exception {
        try {
            Properties props = new Properties();
            props.load(new FileInputStream(propsFileName));
            Useful.checkFile(namesFileName);
            ArrayList<String> names = Useful.readNamesFromFile(namesFileName);
            PrintWriter pw = new PrintWriter(new FileOutputStream(outXMLBifFileName), true);
            SifToXMLBif.createXMLBifGivenSifFile(interList, names, pw, props);
            pw.close();
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (NullArgumentException nae) {
            throw nae;
        }
        catch (NotDAGException nde) {
            throw nde;
        }
        catch (Exception ex) {
            throw ex;
        }
    }

    public static void usage() {
        System.out.println("Usage: java PrepareXMLBifModule propsFileName\nExample: java PrepareXMLBifModule prepareXMLBif.props");
        System.exit(0);
    }

    public static void main(String[] argv) {
        if (argv.length != 1) {
            PrepareXMLBifModule.usage();
        }
        String propsFileName = argv[0];
        PrepareXMLBifModule.test(propsFileName);
    }
}

