/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.bn.prepareXMLBif;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;
import java.util.Random;
import org.tigr.microarray.mev.cluster.gui.impl.bn.NullArgumentException;
import org.tigr.microarray.mev.cluster.gui.impl.bn.SimpleGeneEdge;
import org.tigr.microarray.mev.cluster.gui.impl.bn.Useful;
import org.tigr.microarray.mev.cluster.gui.impl.bn.UsefulInteractions;
import org.tigr.microarray.mev.cluster.gui.impl.bn.algs.Cyclic;
import org.tigr.microarray.mev.cluster.gui.impl.bn.prepareXMLBif.SifToXMLBifUtil;

public class ParseGB_GO {
    public static boolean debug = false;
    public static PrintWriter pw = new PrintWriter(System.out, true);

    public static void setDebug(boolean isDebug) {
        debug = isDebug;
    }

    public static void setDebug(boolean isDebug, String logFileName) {
        try {
            debug = isDebug;
            if (debug) {
                pw = new PrintWriter(new FileOutputStream(logFileName), true);
            }
        }
        catch (IOException ioe) {
            System.out.println(ioe);
        }
    }

    public static HashMap readGB_GOs(String fileName) {
        try {
            Useful.checkFile(fileName);
            HashMap hm = new HashMap();
            FileReader fr = new FileReader(fileName);
            LineNumberReader lnr = new LineNumberReader(fr);
            String s = null;
            String[] tokens = null;
            String[] subTokens = null;
            ArrayList<String> gos = null;
            while ((s = lnr.readLine()) != null) {
                tokens = (s = s.trim()).split("\t");
                if (tokens.length >= 2) {
                    subTokens = tokens[1].split("GO:");
                    gos = new ArrayList<String>(subTokens.length);
                    for (int i = 0; i < subTokens.length; ++i) {
                        gos.add(subTokens[i].trim());
                    }
                    hm.put(tokens[0], gos);
                    continue;
                }
                hm.put(tokens[0], null);
            }
            lnr.close();
            fr.close();
            return hm;
        }
        catch (IOException ioe) {
            System.out.println(ioe);
            return null;
        }
    }

    public static ArrayList getInteractionsFromGB_GOs(ArrayList interactions, HashMap gbGOs) throws NullArgumentException {
        if (interactions == null || gbGOs == null) {
            throw new NullArgumentException("At least one of the given parameters interactions or gbGOs was null!\ninteractions=" + interactions + "\ngbGOs=" + gbGOs);
        }
        ArrayList<SimpleGeneEdge> newInter = new ArrayList<SimpleGeneEdge>();
        SimpleGeneEdge sGE = null;
        String from = null;
        String to = null;
        ArrayList gos = null;
        ArrayList gos2 = null;
        boolean isTFgos = false;
        boolean isTFgos2 = false;
        double weight = 0.0;
        SimpleGeneEdge newSGE = null;
        ArrayList nodes = UsefulInteractions.getNodes(interactions);
        for (int i = 0; i < interactions.size(); ++i) {
            sGE = (SimpleGeneEdge)interactions.get(i);
            from = sGE.getFrom();
            to = sGE.getTo();
            weight = sGE.getWeight();
            if (debug) {
                pw.println("considering edge=" + sGE);
            }
            if (gbGOs.get(from) == null && gbGOs.get(to) == null) continue;
            gos = (ArrayList)gbGOs.get(from);
            gos2 = (ArrayList)gbGOs.get(to);
            isTFgos = ParseGB_GO.isTF(gos);
            if (debug) {
                pw.println("from isTF?" + isTFgos);
            }
            isTFgos2 = ParseGB_GO.isTF(gos2);
            if (debug) {
                pw.println("from isTF?" + isTFgos2);
            }
            if ((!isTFgos || isTFgos2) && (!isTFgos2 || isTFgos) || UsefulInteractions.containsEitherWay(newInter, newSGE = new SimpleGeneEdge(from, to, weight))) continue;
            if (newInter.size() > nodes.size() - 1) break;
            newInter.add(newSGE);
            if (Cyclic.isCyclic(newInter)) {
                newInter.remove(new SimpleGeneEdge(from, to, weight));
            }
            if (SifToXMLBifUtil.getMaxParents(newInter, nodes) <= 3) continue;
            newInter.remove(new SimpleGeneEdge(from, to, weight));
        }
        return newInter;
    }

    public static boolean isTF(ArrayList gos) {
        if (gos == null) {
            return false;
        }
        String s = null;
        for (int i = 0; i < gos.size(); ++i) {
            s = (String)gos.get(i);
            if (s.indexOf("transcription factor") == -1) continue;
            return true;
        }
        return false;
    }

    public static ArrayList getInteractionsFromGB_GOsRandom(ArrayList interactions, ArrayList newInter, long seed) throws NullArgumentException {
        if (interactions == null || newInter == null) {
            throw new NullArgumentException("At least one of the given parameters interactions or newInter was null!\ninteractions=" + interactions + "\nnewInter=" + newInter);
        }
        SimpleGeneEdge sGE = null;
        Random rand = new Random(seed);
        String from = null;
        String to = null;
        double weight = 0.0;
        ArrayList nodes = UsefulInteractions.getNodes(interactions);
        int max = nodes.size() - 1;
        for (int i = 0; i < max; ++i) {
            System.gc();
            sGE = (SimpleGeneEdge)interactions.get(i);
            from = sGE.getFrom();
            to = sGE.getTo();
            weight = sGE.getWeight();
            if (UsefulInteractions.containsEitherWay(newInter, sGE)) continue;
            if (rand.nextBoolean()) {
                newInter.add(new SimpleGeneEdge(from, to, weight));
                System.gc();
                if (!Cyclic.isCyclic(newInter)) continue;
                newInter.remove(new SimpleGeneEdge(from, to, weight));
                continue;
            }
            newInter.add(new SimpleGeneEdge(to, from, weight));
            System.gc();
            if (!Cyclic.isCyclic(newInter)) continue;
            newInter.remove(new SimpleGeneEdge(to, from, weight));
        }
        return newInter;
    }

    public static ArrayList getInteractionsFromGB_GOsRandom(ArrayList interWithWeights, HashMap gbGOs, long seed) throws NullArgumentException {
        if (interWithWeights == null || gbGOs == null) {
            throw new NullArgumentException("At least one of the given parameters interactions or gbGOs was null!\ninteractions=" + interWithWeights + "\ngbGOs=" + gbGOs);
        }
        ArrayList gODirectedInters = ParseGB_GO.getInteractionsFromGB_GOs(interWithWeights, gbGOs);
        return ParseGB_GO.getInteractionsFromGB_GOsRandom(interWithWeights, gODirectedInters, seed);
    }

    public static void test(String propsFileName) {
        try {
            Properties props = new Properties();
            props.load(new FileInputStream(propsFileName));
            String gbGOsFileName = props.getProperty("gbGOsFileName", null);
            String sifFileName = props.getProperty("sifFileName", null);
            long seed = Integer.parseInt(props.getProperty("seed", "1"));
            String newInterFileName = props.getProperty("outDirectedInteractionsFileName", "outDirectedInteractions.txt");
            String newInterAndRandomFileName = props.getProperty("outDirectedInteractionsAndRandomFileName", "outDirectedInteractionsAndRandom.txt");
            Useful.checkFile(gbGOsFileName);
            Useful.checkFile(sifFileName);
            ArrayList inter = UsefulInteractions.readInteractionsWithWeights(sifFileName);
            HashMap gbGOs = ParseGB_GO.readGB_GOs(gbGOsFileName);
            ArrayList newInter = ParseGB_GO.getInteractionsFromGB_GOs(inter, gbGOs);
            UsefulInteractions.writeSifFileWithWeights(newInter, newInterFileName);
            ArrayList newInterAndRandom = ParseGB_GO.getInteractionsFromGB_GOsRandom(inter, newInter, seed);
            UsefulInteractions.writeSifFileWithWeights(newInterAndRandom, newInterAndRandomFileName);
        }
        catch (IOException ioe) {
            System.out.println(ioe);
        }
        catch (NullArgumentException nae) {
            System.out.println(nae);
        }
    }

    public static void usage() {
        System.out.println("Usage: java ParseGB_GO propsFileName\nExample: java ParseGB_GO testParseGB_GO.props");
        System.exit(0);
    }

    public static void main(String[] argv) {
        if (argv.length != 1) {
            ParseGB_GO.usage();
        }
        String propsFileName = argv[0];
        ParseGB_GO.test(propsFileName);
    }
}

