/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.bn.getInteractions;

import java.io.FileNotFoundException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import org.tigr.microarray.mev.cluster.gui.impl.bn.NullArgumentException;
import org.tigr.microarray.mev.cluster.gui.impl.bn.Useful;

public class ReplaceSymbolsWithGbsInSymbolsArticles {
    public static boolean debug = true;

    public static HashMap getGbArticles(HashMap gbSymbols, HashMap symbolsArticles) throws NullArgumentException {
        if (gbSymbols == null || symbolsArticles == null) {
            throw new NullArgumentException("At least one of the given gbSymbols or symbolsArticles is null!\ngbSymbols=" + gbSymbols + "\nsymbolsArticles=" + symbolsArticles);
        }
        HashMap<String, String> gbArticles = new HashMap<String, String>();
        Set keySet = gbSymbols.keySet();
        Iterator it = keySet.iterator();
        String gb = null;
        String symbols = null;
        while (it.hasNext()) {
            gb = (String)it.next();
            symbols = (String)symbolsArticles.get((String)gbSymbols.get(gb));
            if (symbols == null) continue;
            gbArticles.put(gb, symbols);
        }
        return gbArticles;
    }

    public static void usage() {
        System.out.println("Usage: java ReplaceSymbolsWithGbsInSymbolsArticles gbSymsFileName symArtsFileName outputFileName\nExample: java ReplaceSymbolsWithGbsInSymbolsArticles gbSyms.txt symArts.txt outGbArtsFileName");
        System.exit(0);
    }

    public static void test(String gbSymbolsFileName, String symbolsArticlesFileName, String outputFileName) {
        try {
            Useful.checkFile(gbSymbolsFileName);
            Useful.checkFile(symbolsArticlesFileName);
            HashMap gbSymbols = Useful.readHashMapFromFile(gbSymbolsFileName);
            HashMap symbolsArticles = Useful.readHashMapFromFile(symbolsArticlesFileName);
            HashMap gbArticles = ReplaceSymbolsWithGbsInSymbolsArticles.getGbArticles(gbSymbols, symbolsArticles);
            Useful.writeHashMapToFile(gbArticles, outputFileName);
        }
        catch (FileNotFoundException fnfe) {
            System.out.println(fnfe);
        }
        catch (NullArgumentException nae) {
            System.out.println(nae);
        }
    }

    public static void main(String[] argv) {
        if (argv.length != 3) {
            ReplaceSymbolsWithGbsInSymbolsArticles.usage();
        }
        String gbSymbolsFileName = argv[0];
        String symbolsArticlesFileName = argv[1];
        String outputFileName = argv[2];
        ReplaceSymbolsWithGbsInSymbolsArticles.test(gbSymbolsFileName, symbolsArticlesFileName, outputFileName);
    }
}

