/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.bn.getInteractions;

import java.io.FileNotFoundException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.tigr.microarray.mev.cluster.gui.impl.bn.NullArgumentException;
import org.tigr.microarray.mev.cluster.gui.impl.bn.Useful;

public class GetSubsetKeyValuesGivenSubsetKeysAndKeyValues {
    public static HashMap getSubsetKeyValues(HashSet subsetOfKeys, HashMap keyValues) throws NullArgumentException {
        if (subsetOfKeys == null || keyValues == null) {
            throw new NullArgumentException("At least one of the given subsetOfKeys or keyValues is null!\nsubsetOfKeys=" + subsetOfKeys + "\nkeyValues=" + keyValues);
        }
        Set keySet = keyValues.keySet();
        Iterator it = keySet.iterator();
        String key = null;
        HashMap subsetKeyValues = new HashMap();
        while (it.hasNext()) {
            key = (String)it.next();
            if (!Useful.find(subsetOfKeys, key)) continue;
            subsetKeyValues.put(key, keyValues.get(key));
        }
        return subsetKeyValues;
    }

    public static HashMap getSubsetKeyValues(HashSet subsetKeys, String keyValuesInTabDelimitedFormat) throws FileNotFoundException, NullArgumentException {
        Useful.checkFile(keyValuesInTabDelimitedFormat);
        HashMap keyValues = Useful.readHashMapFromFile(keyValuesInTabDelimitedFormat);
        HashMap subsetKeyValues = GetSubsetKeyValuesGivenSubsetKeysAndKeyValues.getSubsetKeyValues(subsetKeys, keyValues);
        return subsetKeyValues;
    }

    public static HashMap getSubsetKeyValues(String subsetKeysFileName, String keyValuesInTabDelimitedFormat) throws FileNotFoundException {
        try {
            Useful.checkFile(subsetKeysFileName);
            Useful.checkFile(keyValuesInTabDelimitedFormat);
            HashSet subsetKeys = Useful.readUniqueNamesFromFile(subsetKeysFileName);
            HashMap keyValues = Useful.readHashMapFromFile(keyValuesInTabDelimitedFormat);
            HashMap subsetKeyValues = GetSubsetKeyValuesGivenSubsetKeysAndKeyValues.getSubsetKeyValues(subsetKeys, keyValues);
            return subsetKeyValues;
        }
        catch (NullArgumentException nae) {
            System.out.println(nae);
            return null;
        }
    }

    public static void test(String subsetKeysFileName, String keyValuesFileName, String outputFileName) {
        try {
            HashMap subsetKeyValues = GetSubsetKeyValuesGivenSubsetKeysAndKeyValues.getSubsetKeyValues(subsetKeysFileName, keyValuesFileName);
            Useful.writeHashMapToFile(subsetKeyValues, outputFileName);
        }
        catch (FileNotFoundException fnfe) {
            System.out.println(fnfe);
        }
        catch (NullArgumentException nae) {
            System.out.println(nae);
        }
    }

    public static void usage() {
        System.out.println("Usage: java GetSubsetKeyValuesGivenSubsetKeysAndKeyValues subsetKeysFileName keyValuesFileName outputSubsetOfKeyValuesFileName\nExample: java GetSubsetKeyValuesGivenSubsetKeysAndKeyValues subsetOfSyms.txt symGBs.txt subsetOfSymsGBs.txt");
    }

    public static void main(String[] argv) {
        if (argv.length != 3) {
            GetSubsetKeyValuesGivenSubsetKeysAndKeyValues.usage();
            System.exit(0);
        }
        String subsetKeysFileName = argv[0];
        String keyValuesFileName = argv[1];
        String outputFileName = argv[2];
        GetSubsetKeyValuesGivenSubsetKeysAndKeyValues.test(subsetKeysFileName, keyValuesFileName, outputFileName);
    }
}

