/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.bn.getInteractions;

import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.util.ArrayList;
import java.util.HashMap;
import org.tigr.microarray.mev.cluster.gui.impl.bn.Constants;
import org.tigr.microarray.mev.cluster.gui.impl.bn.NullArgumentException;
import org.tigr.microarray.mev.cluster.gui.impl.bn.Useful;

public class GetResourcererArticles {
    public static HashMap getResourcererArticles(String resourcererFileName, ArrayList accessions) throws NullArgumentException {
        try {
            if (accessions == null) {
                throw new NullArgumentException("Given accessions is null!");
            }
            HashMap<String, String> hm = new HashMap<String, String>();
            FileReader fr = new FileReader(resourcererFileName);
            LineNumberReader lnr = new LineNumberReader(fr);
            String s = null;
            String[] tokens = null;
            Object subTokens = null;
            String articles = null;
            while ((s = lnr.readLine()) != null) {
                tokens = (s = s.trim()).split("\t");
                if (tokens.length < Constants.RESOURCERER_ARTICLES_COLUMN_NUMBER || !Useful.find(accessions, tokens[Constants.GB_COLUMN_NUMBER].trim())) continue;
                articles = GetResourcererArticles.removeSpacesFromString(tokens[Constants.RESOURCERER_ARTICLES_COLUMN_NUMBER]);
                hm.put(tokens[Constants.GB_COLUMN_NUMBER], articles);
            }
            lnr.close();
            fr.close();
            return hm;
        }
        catch (IOException ioe) {
            System.out.println(ioe);
            return null;
        }
    }

    public static String removeSpacesFromString(String inString) throws NullArgumentException {
        if (inString == null) {
            throw new NullArgumentException("Given inString is null!");
        }
        char[] inCharArray = inString.toCharArray();
        char[] outCharArray = new char[inCharArray.length];
        int count = 0;
        for (int i = 0; i < inCharArray.length; ++i) {
            if (inCharArray[i] == ' ') continue;
            outCharArray[count] = inCharArray[i];
            ++count;
        }
        String outString = new String(outCharArray);
        outString = outString.trim();
        return outString;
    }

    public static HashMap getGBsArticlesGivenResourcererAndGBsFileName(String resourcererFileName, String gbAccessionsFileName) throws FileNotFoundException {
        try {
            ArrayList<String> gbs = Useful.readNamesFromFile(gbAccessionsFileName);
            HashMap hm = GetResourcererArticles.getResourcererArticles(resourcererFileName, gbs);
            return hm;
        }
        catch (NullArgumentException nae) {
            System.out.println(nae);
            return null;
        }
    }

    public static void writeGBsArticlesGivenResourcererAndGBsList(String gbAccessionsFileName, String resourcererFileName, String outputFileName) throws FileNotFoundException {
        try {
            Useful.checkFile(resourcererFileName);
            Useful.checkFile(gbAccessionsFileName);
            ArrayList<String> gbs = Useful.readNamesFromFile(gbAccessionsFileName);
            HashMap hm = GetResourcererArticles.getResourcererArticles(resourcererFileName, gbs);
            Useful.writeHashMapToFile(hm, outputFileName);
        }
        catch (NullArgumentException nae) {
            System.out.println(nae);
        }
    }

    public static void usage() {
        System.out.println("Usage: java GetResourcererArticles gbAccessionsFileName resourcererFileName outputFileName\nExample: java GetResourcererArticles myList_gbs.txt TIGR_40K_Human_Set myList_gbsArticlesFromResourcerer.txt");
        System.exit(0);
    }

    public static void test(String gbAccessionsFileName, String resourcererFileName, String outputFileName) {
        try {
            GetResourcererArticles.writeGBsArticlesGivenResourcererAndGBsList(gbAccessionsFileName, resourcererFileName, outputFileName);
        }
        catch (FileNotFoundException fnfe) {
            System.out.println(fnfe);
        }
    }

    public static void main(String[] argv) {
        if (argv.length != 3) {
            GetResourcererArticles.usage();
        }
        String gbAccessionsFileName = argv[0];
        String resourcererFileName = argv[1];
        String outputFileName = argv[2];
        GetResourcererArticles.test(gbAccessionsFileName, resourcererFileName, outputFileName);
    }
}

