/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.bn.getInteractions;

import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.util.ArrayList;
import java.util.HashMap;
import org.tigr.microarray.mev.cluster.gui.impl.bn.Constants;
import org.tigr.microarray.mev.cluster.gui.impl.bn.NullArgumentException;
import org.tigr.microarray.mev.cluster.gui.impl.bn.Useful;

public class GetOfficialGeneSymbols {
    public static HashMap getOfficialGeneSymbols(String resourcererFileName, ArrayList accessions) throws NullArgumentException {
        try {
            if (accessions == null) {
                throw new NullArgumentException("Given accessions is null!");
            }
            HashMap<String, String> hm = new HashMap<String, String>();
            FileReader fr = new FileReader(resourcererFileName);
            LineNumberReader lnr = new LineNumberReader(fr);
            String s = null;
            String[] tokens = null;
            String[] subTokens = null;
            while ((s = lnr.readLine()) != null) {
                tokens = (s = s.trim()).split("\t");
                if (tokens.length < Constants.SYMBOLS_COLUMN_NUMBER || !Useful.find(accessions, tokens[Constants.GB_COLUMN_NUMBER].trim()) || (subTokens = tokens[Constants.SYMBOLS_COLUMN_NUMBER].split(";")).length < 2) continue;
                hm.put(tokens[Constants.GB_COLUMN_NUMBER], subTokens[0]);
            }
            lnr.close();
            fr.close();
            return hm;
        }
        catch (IOException ioe) {
            System.out.println(ioe);
            return null;
        }
    }

    public static HashMap getGBsSymbolsGivenResourcererAndGBsFileName(String gbAccessionsFileName, String resourcererFileName) throws FileNotFoundException {
        try {
            ArrayList<String> gbs = Useful.readNamesFromFile(gbAccessionsFileName);
            HashMap hm = GetOfficialGeneSymbols.getOfficialGeneSymbols(resourcererFileName, gbs);
            return hm;
        }
        catch (NullArgumentException nae) {
            System.out.println(nae);
            return null;
        }
    }

    public static void writeGBsSymbolsGivenResourcererAndGBsList(String gbAccessionsFileName, String resourcererFileName, String outputFileName) throws FileNotFoundException {
        try {
            ArrayList<String> gbs = Useful.readNamesFromFile(gbAccessionsFileName);
            HashMap hm = GetOfficialGeneSymbols.getOfficialGeneSymbols(resourcererFileName, gbs);
            Useful.writeHashMapToFile(hm, outputFileName);
        }
        catch (NullArgumentException nae) {
            System.out.println(nae);
        }
    }

    public static void usage() {
        System.out.println("Usage: java GetOfficialGeneSymbols gbAccessionsFileName resourcererFileName outputFileName\nExample: java GetOfficialGeneSymbols myList_gbs.txt TIGR_40K_Human_Set myList_gbsGeneSymbols.txt");
        System.exit(0);
    }

    public static void test(String gbAccessionsFileName, String resourcererFileName, String outputFileName) {
        try {
            GetOfficialGeneSymbols.writeGBsSymbolsGivenResourcererAndGBsList(gbAccessionsFileName, resourcererFileName, outputFileName);
        }
        catch (FileNotFoundException fnfe) {
            System.out.println(fnfe);
        }
    }

    public static void main(String[] argv) {
        if (argv.length != 3) {
            GetOfficialGeneSymbols.usage();
        }
        String gbAccessionsFileName = argv[0];
        String resourcererFileName = argv[1];
        String outputFileName = argv[2];
        GetOfficialGeneSymbols.test(gbAccessionsFileName, resourcererFileName, outputFileName);
    }
}

