/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.bn.getInteractions;

import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.tigr.microarray.mev.cluster.gui.impl.bn.GetUnionOfInters;
import org.tigr.microarray.mev.cluster.gui.impl.bn.NullArgumentException;
import org.tigr.microarray.mev.cluster.gui.impl.bn.SimpleGeneEdge;
import org.tigr.microarray.mev.cluster.gui.impl.bn.Useful;
import org.tigr.microarray.mev.cluster.gui.impl.bn.UsefulInteractions;
import org.tigr.microarray.mev.cluster.gui.impl.bn.getInteractions.GetAccessions;
import org.tigr.microarray.mev.cluster.gui.impl.bn.getInteractions.GetGOs;
import org.tigr.microarray.mev.cluster.gui.impl.bn.getInteractions.GetOfficialGeneSymbols;
import org.tigr.microarray.mev.cluster.gui.impl.bn.getInteractions.GetResourcererArticles;
import org.tigr.microarray.mev.cluster.gui.impl.bn.getInteractions.GetSubsetKeyValuesGivenSubsetKeysAndKeyValues;
import org.tigr.microarray.mev.cluster.gui.impl.bn.getInteractions.ReplaceSymbolsWithGbsInSymbolsArticles;

public class GetInteractionsUtil {
    public static boolean debug = true;

    public static HashMap getOfficialGeneSymbols(String resFileName, String gbAccessionsFileName) throws FileNotFoundException {
        return GetOfficialGeneSymbols.getGBsSymbolsGivenResourcererAndGBsFileName(gbAccessionsFileName, resFileName);
    }

    public static HashMap getAccessions(String resFileName, ArrayList geneSymbols) throws FileNotFoundException {
        try {
            return GetAccessions.getAccessions(resFileName, geneSymbols);
        }
        catch (NullArgumentException nae) {
            System.out.println(nae);
            return null;
        }
    }

    public static HashMap getGOs(String resFileName, String gbAccessionsFileName) throws FileNotFoundException {
        return GetGOs.getGOsGivenResourcererAndGBsFileName(resFileName, gbAccessionsFileName);
    }

    public static HashMap getResourcererArticles(String resFileName, String gbAccessionsFileName) throws FileNotFoundException {
        return GetResourcererArticles.getGBsArticlesGivenResourcererAndGBsFileName(resFileName, gbAccessionsFileName);
    }

    public static HashSet getUniqueSymbols(HashMap gbSymbols) throws NullArgumentException {
        if (gbSymbols == null) {
            throw new NullArgumentException("The argument gbSymbols was null");
        }
        return Useful.getUniqueSymbols(gbSymbols);
    }

    public static HashMap getSubsetSymbolsArticlesFromSymbolsArticles(HashSet uniqueSymbols, HashMap symbolsArticles) throws NullArgumentException {
        if (uniqueSymbols == null || symbolsArticles == null) {
            throw new NullArgumentException("At least one of uniqueSymbols or symbolsArticles was null");
        }
        return GetSubsetKeyValuesGivenSubsetKeysAndKeyValues.getSubsetKeyValues(uniqueSymbols, symbolsArticles);
    }

    public static HashMap replaceSymbolsWithGbsInSymbolsArticles(HashMap gbSymbols, HashMap symbolsArticles) throws NullArgumentException {
        if (gbSymbols == null || symbolsArticles == null) {
            throw new NullArgumentException("At least one of gbSymbols or symbolsArticles was null");
        }
        return ReplaceSymbolsWithGbsInSymbolsArticles.getGbArticles(gbSymbols, symbolsArticles);
    }

    public static ArrayList uniquelyMergeArrayLists(ArrayList inter1, ArrayList inter2, ArrayList inter3) throws NullArgumentException {
        if (inter1 == null || inter2 == null || inter3 == null) {
            throw new NullArgumentException("At least one of inter1, inter2 or inter3 is null\ninter1=" + inter1 + "\ninter2=" + inter2 + "\ninter3=" + inter3);
        }
        ArrayList union1And2 = GetUnionOfInters.uniquelyMergeArrayLists(inter1, inter2);
        ArrayList unionAll = null;
        unionAll = union1And2 == null || union1And2.size() == 0 ? GetUnionOfInters.uniquelyMergeArrayLists(inter3, new ArrayList()) : GetUnionOfInters.uniquelyMergeArrayLists(inter3, union1And2);
        if (unionAll == null || unionAll.size() == 0) {
            // empty if block
        }
        return unionAll;
    }

    public static ArrayList replaceSymsWithGBsInInter(String resourcererFileName, ArrayList interFromPpiSyms) throws NullArgumentException {
        try {
            if (interFromPpiSyms == null) {
                throw new NullArgumentException("Given interFromPpiSyms is null!");
            }
            ArrayList newGeneSymbols = UsefulInteractions.getNodes(interFromPpiSyms);
            HashMap newGeneSymbolsGBs = GetInteractionsUtil.getAccessions(resourcererFileName, newGeneSymbols);
            SimpleGeneEdge sGE = null;
            SimpleGeneEdge replacedSGE = null;
            String from = null;
            String to = null;
            String replacedFrom = null;
            String replacedTo = null;
            ArrayList<SimpleGeneEdge> result = new ArrayList<SimpleGeneEdge>();
            for (int i = 0; i < interFromPpiSyms.size(); ++i) {
                sGE = (SimpleGeneEdge)interFromPpiSyms.get(i);
                from = sGE.getFrom();
                to = sGE.getTo();
                replacedFrom = (String)newGeneSymbolsGBs.get(from);
                replacedTo = (String)newGeneSymbolsGBs.get(to);
                if (replacedFrom == null || replacedTo == null || UsefulInteractions.containsEitherWay(result, replacedSGE = new SimpleGeneEdge(replacedFrom, replacedTo, sGE.getWeight()))) continue;
                result.add(replacedSGE);
            }
            return result;
        }
        catch (FileNotFoundException fnfe) {
            System.out.println(fnfe);
            return null;
        }
    }

    public static ArrayList loadKeggInteractions(String species, String location) {
        ArrayList<String> kegg = new ArrayList<String>();
        String fileName = location + species + "_kegg_edges.txt";
        try {
            FileReader fr = new FileReader(fileName);
            LineNumberReader lnr = new LineNumberReader(fr);
            String s = null;
            while ((s = lnr.readLine()) != null) {
                s = s.trim();
                kegg.add(s);
            }
            lnr.close();
            fr.close();
            System.out.println("Loaded KEGG edges: " + kegg.size());
            return kegg;
        }
        catch (IOException ioe) {
            System.out.println(ioe);
            return null;
        }
    }

    public static ArrayList getEdgesfromKegg(ArrayList keggListAll, String accListFile) {
        ArrayList<String> dataNodes = new ArrayList<String>();
        try {
            FileReader fr = new FileReader(accListFile);
            LineNumberReader lnr = new LineNumberReader(fr);
            String s = null;
            while ((s = lnr.readLine()) != null) {
                s = s.trim();
                dataNodes.add(s);
            }
            lnr.close();
            fr.close();
        }
        catch (IOException ioe) {
            System.out.println(ioe);
        }
        ArrayList<SimpleGeneEdge> keggMatches = new ArrayList<SimpleGeneEdge>();
        ArrayList<String> keggMatchesAsStrings = new ArrayList<String>();
        for (int i = 0; i < dataNodes.size(); ++i) {
            String _curAcc = (String)dataNodes.get(i);
            for (int ii = i + 1; ii < dataNodes.size(); ++ii) {
                String _nextAcc = (String)dataNodes.get(ii);
                if (_nextAcc.equals(_curAcc)) continue;
                String _curEdge1 = _curAcc + "-" + _nextAcc;
                String _curEdge2 = _nextAcc + "-" + _curAcc;
                if (keggMatchesAsStrings.contains(_curEdge1) || keggMatchesAsStrings.contains(_curEdge2)) continue;
                keggMatches.add(new SimpleGeneEdge(_curAcc, _nextAcc, 1.0));
                keggMatches.add(new SimpleGeneEdge(_nextAcc, _curAcc, 1.0));
                keggMatchesAsStrings.add(_curEdge1);
                keggMatchesAsStrings.add(_curEdge2);
            }
        }
        if (keggMatches.size() > 0) {
            System.out.println("Returning KEGG matches: " + keggMatches.size());
            keggMatchesAsStrings = null;
            return keggMatches;
        }
        System.out.println("Returning KEGG matches: NONE Found!!");
        return null;
    }

    public static ArrayList replaceSymsWithGBs(HashMap gbSymbols, ArrayList interFromPpiSyms) {
        ArrayList<SimpleGeneEdge> result = new ArrayList<SimpleGeneEdge>();
        SimpleGeneEdge sGE = null;
        block0: for (int i = 0; i < interFromPpiSyms.size(); ++i) {
            sGE = (SimpleGeneEdge)interFromPpiSyms.get(i);
            String fromSym = sGE.getFrom();
            String toSym = sGE.getTo();
            String fromAcc = null;
            String toAcc = null;
            Set entries = gbSymbols.entrySet();
            for (Map.Entry entry : entries) {
                String key = (String)entry.getKey();
                String value = (String)entry.getValue();
                if (value.equals(fromSym)) {
                    fromAcc = key;
                }
                if (value.equals(toSym)) {
                    toAcc = key;
                }
                if (fromAcc == null || toAcc == null) continue;
                result.add(new SimpleGeneEdge(fromAcc, toAcc));
                continue block0;
            }
        }
        return result;
    }
}

