/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.bn.getInteractions;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import org.tigr.microarray.mev.cluster.gui.IData;
import org.tigr.microarray.mev.cluster.gui.impl.bn.BNConstants;
import org.tigr.microarray.mev.cluster.gui.impl.bn.GetUnionOfInters;
import org.tigr.microarray.mev.cluster.gui.impl.bn.NullArgumentException;
import org.tigr.microarray.mev.cluster.gui.impl.bn.OutOfRangeException;
import org.tigr.microarray.mev.cluster.gui.impl.bn.Useful;
import org.tigr.microarray.mev.cluster.gui.impl.bn.UsefulInteractions;
import org.tigr.microarray.mev.cluster.gui.impl.bn.algs.AllPairsShortestPaths;
import org.tigr.microarray.mev.cluster.gui.impl.bn.algs.TransitiveClosure;
import org.tigr.microarray.mev.cluster.gui.impl.bn.getInteractions.GeneInteractions;
import org.tigr.microarray.mev.cluster.gui.impl.bn.getInteractions.GetInteractionsUtil;

public class GetInteractionsModule {
    public static boolean debug = false;
    static String sep = BNConstants.SEP;
    static String path;
    static HashMap<String, String> probeIndexAssocHash;

    public GetInteractionsModule(String basepath) {
        path = basepath;
    }

    public GetInteractionsModule(String basepath, HashMap<String, String> probeIndexAssocHash) {
        path = basepath;
        GetInteractionsModule.probeIndexAssocHash = probeIndexAssocHash;
    }

    public static ArrayList getInteractionsFromLiterature(Properties props) throws NullArgumentException, OutOfRangeException {
        try {
            ArrayList unionOfInter;
            if (props == null) {
                throw new NullArgumentException("The given properties were null");
            }
            debug = false;
            String fileLoc = path + BNConstants.SEP + "tmp" + BNConstants.SEP;
            String resFileLoc = path + BNConstants.SEP;
            String resFileName = resFileLoc + props.getProperty("resourcererFileName");
            String gbAccessionsFileName = fileLoc + props.getProperty("gbAccessionsFileName");
            String symbolsArticlesFromPubmedFileName = resFileLoc + props.getProperty("symbolsArticlesFromPubmedFileName", null);
            String symbolsArticlesFromGeneDbFileName = resFileLoc + props.getProperty("symbolsArticlesFromGeneDbFileName", null);
            int articleRemovalThreshold = Integer.parseInt(props.getProperty("articleRemovalThreshold"));
            HashMap gbSymbols = GetInteractionsUtil.getOfficialGeneSymbols(resFileName, gbAccessionsFileName);
            if (debug) {
                Useful.writeHashMapToFile(gbSymbols, gbAccessionsFileName.substring(0, gbAccessionsFileName.length() - 4) + "gbSymbols_test.txt");
            }
            HashMap gbGOs = GetInteractionsUtil.getGOs(resFileName, gbAccessionsFileName);
            if (debug) {
                Useful.writeHashMapToFile(gbGOs, gbAccessionsFileName.substring(0, gbAccessionsFileName.length() - 4) + "gbGOs_test.txt");
            }
            HashMap gbArticlesFromRes = GetInteractionsUtil.getResourcererArticles(resFileName, gbAccessionsFileName);
            if (debug) {
                Useful.writeHashMapToFile(gbArticlesFromRes, gbAccessionsFileName.substring(0, gbAccessionsFileName.length() - 4) + "gbArticlesFromRes_test.txt");
            }
            HashSet uniqueSymbols = GetInteractionsUtil.getUniqueSymbols(gbSymbols);
            HashMap allSymbolsArticlesFromPubmed = Useful.readHashMapFromFile(symbolsArticlesFromPubmedFileName);
            HashMap symbolsArticlesFromPubmed = GetInteractionsUtil.getSubsetSymbolsArticlesFromSymbolsArticles(uniqueSymbols, allSymbolsArticlesFromPubmed);
            if (debug) {
                Useful.writeHashMapToFile(symbolsArticlesFromPubmed, gbAccessionsFileName.substring(0, gbAccessionsFileName.length() - 4) + "symbolsArticlesFromPubmed_test.txt");
            }
            HashMap allSymbolsArticlesFromGeneDb = Useful.readHashMapFromFile(symbolsArticlesFromGeneDbFileName);
            HashMap symbolsArticlesFromGeneDb = GetInteractionsUtil.getSubsetSymbolsArticlesFromSymbolsArticles(uniqueSymbols, allSymbolsArticlesFromGeneDb);
            if (debug) {
                Useful.writeHashMapToFile(symbolsArticlesFromGeneDb, gbAccessionsFileName.substring(0, gbAccessionsFileName.length() - 4) + "symbolsArticlesFromGeneDb_test.txt");
            }
            HashMap gbArticlesFromPubmed = GetInteractionsUtil.replaceSymbolsWithGbsInSymbolsArticles(gbSymbols, symbolsArticlesFromPubmed);
            if (debug) {
                Useful.writeHashMapToFile(gbArticlesFromPubmed, gbAccessionsFileName.substring(0, gbAccessionsFileName.length() - 4) + "gbArticlesFromPubmed_test.txt");
            }
            HashMap gbArticlesFromGeneDb = GetInteractionsUtil.replaceSymbolsWithGbsInSymbolsArticles(gbSymbols, symbolsArticlesFromGeneDb);
            if (debug) {
                Useful.writeHashMapToFile(gbArticlesFromGeneDb, gbAccessionsFileName.substring(0, gbAccessionsFileName.length() - 4) + "gbArticlesFromGeneDb_test.txt");
            }
            GeneInteractions gI = new GeneInteractions();
            HashMap articlesGbs = GeneInteractions.backwards(gbArticlesFromGeneDb);
            gbArticlesFromGeneDb = GeneInteractions.filter(articlesGbs, gbArticlesFromGeneDb, articleRemovalThreshold);
            ArrayList interGeneDb = gI.createInteractions(gbArticlesFromGeneDb);
            if (articlesGbs == null || gbArticlesFromGeneDb == null || interGeneDb == null) {
                System.out.println("One of the vectors for GeneDB is null");
            }
            articlesGbs = null;
            articlesGbs = GeneInteractions.backwards(gbArticlesFromPubmed);
            gbArticlesFromPubmed = GeneInteractions.filter(articlesGbs, gbArticlesFromPubmed, articleRemovalThreshold);
            ArrayList interPubmed = gI.createInteractions(gbArticlesFromPubmed);
            if (articlesGbs == null || gbArticlesFromPubmed == null || interPubmed == null) {
                System.out.println("One of the vectors for Pubmed is null");
            }
            articlesGbs = null;
            articlesGbs = GeneInteractions.backwards(gbArticlesFromRes);
            gbArticlesFromRes = GeneInteractions.filter(articlesGbs, gbArticlesFromRes, articleRemovalThreshold);
            ArrayList interRes = gI.createInteractions(gbArticlesFromRes);
            if (articlesGbs == null || gbArticlesFromRes == null || interRes == null) {
                System.out.println("One of the vectors for Res is null");
            }
            debug = false;
            if (debug) {
                UsefulInteractions.writeSifFileUndirWithWeights(interGeneDb, gbAccessionsFileName.substring(0, gbAccessionsFileName.length() - 4) + "interGeneDb");
                UsefulInteractions.writeSifFileUndirWithWeights(interPubmed, gbAccessionsFileName.substring(0, gbAccessionsFileName.length() - 4) + "interPubmed");
                UsefulInteractions.writeSifFileUndirWithWeights(interRes, gbAccessionsFileName.substring(0, gbAccessionsFileName.length() - 4) + "interRes");
            }
            if ((unionOfInter = GetInteractionsUtil.uniquelyMergeArrayLists(interGeneDb, interRes, interPubmed)) == null || unionOfInter.size() == 0) {
                return new ArrayList();
            }
            unionOfInter = UsefulInteractions.removeReverseEdge(unionOfInter);
            return unionOfInter;
        }
        catch (IOException ioe) {
            System.out.println(ioe);
            return null;
        }
    }

    public static ArrayList getInteractionsFromPpi(Properties props) throws NullArgumentException {
        try {
            if (props == null) {
                throw new NullArgumentException("The given properties were null");
            }
            String fileLoc = path + BNConstants.SEP + "tmp" + BNConstants.SEP;
            String resFileLoc = path + BNConstants.SEP;
            String ppiFileName = resFileLoc + props.getProperty("ppiFileName", null);
            String resFileName = resFileLoc + props.getProperty("resourcererFileName", null);
            String gbAccessionsFileName = fileLoc + props.getProperty("gbAccessionsFileName", null);
            ArrayList interFromPpiSyms = GetInteractionsModule.getInteractionsFromPpiSyms(props);
            HashMap gbSymbols = GetInteractionsUtil.getOfficialGeneSymbols(resFileName, gbAccessionsFileName);
            ArrayList interFromPpi = GetInteractionsUtil.replaceSymsWithGBs(gbSymbols, interFromPpiSyms);
            if (props.getProperty("usePpiOnlyWithin", "true").equals("false") || props.getProperty("usePpiDirectly", "true").equals("false")) {
                GetInteractionsModule.prepareGBsForPpiNotDirectly(interFromPpi, props);
            }
            interFromPpi = UsefulInteractions.removeReverseEdge(interFromPpi);
            return interFromPpi;
        }
        catch (NullArgumentException nae) {
            System.out.println(nae);
            nae.printStackTrace();
        }
        catch (FileNotFoundException fnfe) {
            System.out.println(fnfe);
            fnfe.printStackTrace();
        }
        return null;
    }

    public static ArrayList getInteractionsFromPpi(ArrayList ppi, ArrayList queryNodes, Properties props) throws NullArgumentException, OutOfRangeException {
        if (ppi == null || queryNodes == null) {
            System.out.println("getInteractionsFromPpi");
            throw new NullArgumentException("At least one of ppi or queryNodes was null\nppi=" + ppi + "\nqueryNodes=" + queryNodes);
        }
        String usePpiDirectlyStr = props.getProperty("usePpiDirectly", "true");
        String usePpiOnlyWithinStr = props.getProperty("usePpiOnlyWithin", "true");
        String useTransitiveClosureStr = props.getProperty("useTransitiveClosure", "false");
        double distanceK = Double.parseDouble(props.getProperty("distanceK", "3.0"));
        if (distanceK < 0.0) {
            throw new OutOfRangeException("DistanceK is out of range (should be positive or equal to zero)!\ndistanceK=" + distanceK);
        }
        ArrayList ppiIner = null;
        ppiIner = usePpiDirectlyStr.equals("true") ? (usePpiOnlyWithinStr.equals("true") ? UsefulInteractions.getSubsetInteractionsGivenNodesOnlyWithin(ppi, queryNodes) : UsefulInteractions.getSubsetInteractionsGivenNodes(ppi, queryNodes)) : (useTransitiveClosureStr.equals("true") ? TransitiveClosure.getInteractionsWithReachableNodes(ppi, queryNodes) : AllPairsShortestPaths.getInteractionsWithNodesAtDistanceK(ppi, queryNodes, distanceK));
        if (ppiIner == null) {
            System.out.println("GetInteractionsModule.getInteractionsFromPpi() NO interactions!!");
        }
        return ppiIner;
    }

    public static ArrayList getInteractionsFromKegg(Properties props) throws NullArgumentException {
        try {
            if (props == null) {
                throw new NullArgumentException("The given properties were null");
            }
            String fileLoc = path + BNConstants.SEP + "tmp" + BNConstants.SEP;
            String gbAccessionsFileName = fileLoc + props.getProperty("gbAccessionsFileName");
            String kegg_sp = fileLoc + props.getProperty("kegg_sp").trim();
            ArrayList keggListAll = GetInteractionsUtil.loadKeggInteractions(kegg_sp, BNConstants.SEP + BNConstants.KEGG_FILE_BASE + BNConstants.SEP);
            ArrayList keggList = GetInteractionsUtil.getEdgesfromKegg(keggListAll, gbAccessionsFileName);
            keggList = UsefulInteractions.removeReverseEdge(keggList);
            return keggList;
        }
        catch (NullArgumentException nae) {
            System.out.println(nae);
            nae.printStackTrace();
            return null;
        }
    }

    public static ArrayList getInteractionsFromLiteratureKegg(Properties props) throws NullArgumentException {
        try {
            if (props == null) {
                throw new NullArgumentException("The given properties were null");
            }
            ArrayList unionLitKegg = null;
            ArrayList kegg = GetInteractionsModule.getInteractionsFromKegg(props);
            ArrayList lit = GetInteractionsModule.getInteractionsFromLiterature(props);
            if (kegg == null || kegg.size() == 0) {
                System.out.println("No valid KEGG interactions found");
                if (lit == null || lit.size() == 0) {
                    System.out.println("No valid LIT interactions found");
                    System.out.println("No valid KEGG-LIT interactions found");
                    return null;
                }
                unionLitKegg = GetUnionOfInters.uniquelyMergeArrayLists(new ArrayList(), lit);
                unionLitKegg = UsefulInteractions.removeReverseEdge(unionLitKegg);
            } else if (lit == null || lit.size() == 0) {
                System.out.println("No valid LIT interactions found");
                unionLitKegg = GetUnionOfInters.uniquelyMergeArrayLists(kegg, new ArrayList());
                unionLitKegg = UsefulInteractions.removeReverseEdge(unionLitKegg);
            } else {
                unionLitKegg = GetUnionOfInters.uniquelyMergeArrayLists(kegg, lit);
                unionLitKegg = UsefulInteractions.removeReverseEdge(unionLitKegg);
            }
            return unionLitKegg;
        }
        catch (OutOfRangeException oore) {
            System.out.println(oore);
            oore.printStackTrace();
        }
        catch (NullArgumentException nae) {
            System.out.println(nae);
            nae.printStackTrace();
        }
        return null;
    }

    public static ArrayList getInteractions(Properties props) throws NullArgumentException, OutOfRangeException {
        if (props == null) {
            throw new NullArgumentException("The given properties were null");
        }
        String isLiteratureStr = props.getProperty("fromLiterature", "true").trim();
        String isPpiStr = props.getProperty("fromPpi", "false").trim();
        String isKeggStr = props.getProperty("fromKegg", "false").trim();
        ArrayList interFromLit = null;
        ArrayList interFromPpi = null;
        Object interFromPpiSyms = null;
        ArrayList interFromKegg = null;
        if (isLiteratureStr.equals("true") && isPpiStr.equals("true") && isKeggStr.equals("true")) {
            return null;
        }
        if (isLiteratureStr.equals("true") && isPpiStr.equals("true") && !isKeggStr.equals("true")) {
            System.out.println("Only Lit & PPI");
            ArrayList unionLitPpi = new ArrayList();
            unionLitPpi = GetInteractionsModule.getInteractionsFromLiteraturePpi(props);
            return unionLitPpi;
        }
        if (isLiteratureStr.equals("true") && !isPpiStr.equals("true") && isKeggStr.equals("true")) {
            System.out.println("Only KEGG & LIT");
            ArrayList keggAndLitInterActions = null;
            keggAndLitInterActions = GetInteractionsModule.getInteractionsFromLiteratureKegg(props);
            return keggAndLitInterActions;
        }
        if (!isLiteratureStr.equals("true") && isPpiStr.equals("true") && isKeggStr.equals("true")) {
            System.out.println("Only KEGG & PPI");
            ArrayList keggAndPpiInterActions = null;
            keggAndPpiInterActions = GetInteractionsModule.getInteractionsFromPpiKegg(props);
            return keggAndPpiInterActions;
        }
        if (isLiteratureStr.equals("true") && !isPpiStr.equals("true") && !isKeggStr.equals("true")) {
            System.out.println("Only LIT");
            interFromLit = GetInteractionsModule.getInteractionsFromLiterature(props);
            return interFromLit;
        }
        if (isPpiStr.equals("true") && !isLiteratureStr.equals("true") && !isKeggStr.equals("true")) {
            System.out.println("Only PPI");
            interFromPpi = GetInteractionsModule.getInteractionsFromPpi(props);
            return interFromPpi;
        }
        if (!isLiteratureStr.equals("true") && !isPpiStr.equals("true") && isKeggStr.equals("true")) {
            System.out.println("Only KEGG");
            interFromKegg = GetInteractionsModule.getInteractionsFromKegg(props);
            return interFromKegg;
        }
        throw new NullArgumentException("At least one of fromPpi or fromLiterature was neither true nor false!\nfromPpi=" + isPpiStr + "\nfromLiterature=" + isLiteratureStr);
    }

    public static ArrayList getInteractionsFromPpiKegg(Properties props) throws NullArgumentException {
        try {
            if (props == null) {
                throw new NullArgumentException("The given properties were null");
            }
            ArrayList unionPpiKegg = null;
            ArrayList kegg = GetInteractionsModule.getInteractionsFromKegg(props);
            ArrayList ppi = GetInteractionsModule.getInteractionsFromPpi(props);
            if (kegg == null || kegg.size() == 0) {
                System.out.println("No valid KEGG interactions found");
                if (ppi == null || ppi.size() == 0) {
                    System.out.println("No valid LIT interactions found");
                    System.out.println("No valid KEGG-LIT interactions found");
                    return null;
                }
                unionPpiKegg = GetUnionOfInters.uniquelyMergeArrayLists(new ArrayList(), ppi);
                unionPpiKegg = UsefulInteractions.removeReverseEdge(unionPpiKegg);
            } else if (ppi == null || ppi.size() == 0) {
                System.out.println("No valid LIT interactions found");
                unionPpiKegg = GetUnionOfInters.uniquelyMergeArrayLists(kegg, new ArrayList());
                unionPpiKegg = UsefulInteractions.removeReverseEdge(unionPpiKegg);
            } else {
                unionPpiKegg = GetUnionOfInters.uniquelyMergeArrayLists(kegg, ppi);
                unionPpiKegg = UsefulInteractions.removeReverseEdge(unionPpiKegg);
            }
            return unionPpiKegg;
        }
        catch (NullArgumentException nae) {
            System.out.println(nae);
            nae.printStackTrace();
            return null;
        }
    }

    public static ArrayList getInteractionsFromPpiSyms(Properties props) throws NullArgumentException {
        try {
            if (props == null) {
                throw new NullArgumentException("The given properties were null");
            }
            String fileLoc = path + BNConstants.SEP + "tmp" + BNConstants.SEP;
            String resFileLoc = path + BNConstants.SEP;
            String ppiFileName = resFileLoc + props.getProperty("ppiFileName", null);
            String resFileName = resFileLoc + props.getProperty("resourcererFileName", null);
            String gbAccessionsFileName = fileLoc + props.getProperty("gbAccessionsFileName", null);
            HashMap gbSymbols = GetInteractionsUtil.getOfficialGeneSymbols(resFileName, gbAccessionsFileName);
            HashSet uniqueSymbols = GetInteractionsUtil.getUniqueSymbols(gbSymbols);
            ArrayList queryNodes = new ArrayList();
            queryNodes.addAll(uniqueSymbols);
            ArrayList ppi = UsefulInteractions.readInteractions(ppiFileName);
            ArrayList ppiInterActions = GetInteractionsModule.getInteractionsFromPpi(ppi, queryNodes, props);
            return ppiInterActions;
        }
        catch (IOException ioe) {
            System.out.println(ioe);
            ioe.printStackTrace();
        }
        catch (NullArgumentException nae) {
            System.out.println(nae);
            nae.printStackTrace();
        }
        catch (OutOfRangeException oore) {
            System.out.println(oore);
            oore.printStackTrace();
        }
        return null;
    }

    public static ArrayList getInteractionsFromLiteraturePpi(Properties props) throws NullArgumentException {
        try {
            if (props == null) {
                throw new NullArgumentException("The given properties were null");
            }
            ArrayList unionLitPpi = null;
            ArrayList interFromPpi = GetInteractionsModule.getInteractionsFromPpi(props);
            ArrayList interFromLit = GetInteractionsModule.getInteractionsFromLiterature(props);
            if (props.getProperty("usePpiOnlyWithin", "true").equals("false") || props.getProperty("usePpiDirectly", "true").equals("false")) {
                GetInteractionsModule.prepareGBsForPpiNotDirectly(interFromPpi, props);
                interFromLit = GetInteractionsModule.getInteractionsFromLiterature(props);
                unionLitPpi = GetUnionOfInters.uniquelyMergeArrayLists(interFromLit, interFromPpi);
            } else {
                interFromLit = GetInteractionsModule.getInteractionsFromLiterature(props);
                unionLitPpi = GetUnionOfInters.uniquelyMergeArrayLists(interFromLit, interFromPpi);
            }
            unionLitPpi = UsefulInteractions.removeReverseEdge(unionLitPpi);
            return unionLitPpi;
        }
        catch (OutOfRangeException oore) {
            System.out.println(oore);
            oore.printStackTrace();
        }
        catch (NullArgumentException nae) {
            System.out.println(nae);
            nae.printStackTrace();
        }
        return null;
    }

    public static void prepareGBsForPpiNotDirectly(ArrayList interFromPpi, Properties props) {
        try {
            Object newGeneSymbols = null;
            HashSet origGBs = null;
            ArrayList newGBs = null;
            Object uniqueNewGBs = null;
            HashSet origAndUniqueNewGBs = new HashSet();
            Iterator it = null;
            String gbAccessionsFileName = path + props.getProperty("gbAccessionsFileName", null);
            String newGbAccessionsFileName = path + props.getProperty("newGbAccessionsFileName", "newGBs.txt");
            String toWrite = "";
            origGBs = Useful.readUniqueNamesFromFile(gbAccessionsFileName);
            newGBs = UsefulInteractions.getNodes(interFromPpi);
            if (newGBs != null && newGBs.size() != 0) {
                origAndUniqueNewGBs.addAll(origGBs);
                origAndUniqueNewGBs.addAll(newGBs);
                it = origAndUniqueNewGBs.iterator();
                while (it.hasNext()) {
                    toWrite = toWrite + it.next() + "\n";
                }
                Useful.writeStrToFile(toWrite, newGbAccessionsFileName);
            }
        }
        catch (FileNotFoundException fnfe) {
            System.out.println(fnfe);
        }
        catch (NullArgumentException nae) {
            System.out.println(nae);
        }
    }

    public static int test(String propertiesFileName, IData data) {
        try {
            Properties props = new Properties();
            props.load(new FileInputStream(propertiesFileName));
            ArrayList interactions = GetInteractionsModule.getInteractions(props);
            if (interactions == null || interactions.size() == 0) {
                System.out.print("Oh no NULL Interaction object. Bad...");
                JOptionPane.showMessageDialog(new JFrame(), "No interactions found, aborting ....", "Info", 1);
                return -1;
            }
            String outInteractionsFileName = props.getProperty("outInteractionsFileName", "outInteractions.txt");
            if (!data.isAnnotationLoaded()) {
                String fname_cyto = Useful.getUniqueFileID() + "_" + "LM.sif";
                System.setProperty("LM_ONLY", fname_cyto);
                UsefulInteractions.writeSifFileUndir(interactions, path + BNConstants.SEP + "results" + BNConstants.SEP + fname_cyto);
            } else {
                String fname_cyto = Useful.getUniqueFileID() + "_" + "LM.xgmml";
                System.setProperty("LM_ONLY", fname_cyto);
                if (probeIndexAssocHash != null) {
                    if (probeIndexAssocHash.size() <= 0) {
                        // empty if block
                    }
                } else {
                    throw new NullArgumentException("Given Probe-Index Hash was null!");
                }
                UsefulInteractions.writeXgmmlFileUndir(interactions, path + BNConstants.SEP + "results" + BNConstants.SEP + fname_cyto, probeIndexAssocHash, data);
            }
            UsefulInteractions.writeSifFileUndirWithWeights(interactions, outInteractionsFileName);
            return interactions.size();
        }
        catch (IOException ioe) {
            System.out.println(ioe);
            ioe.printStackTrace();
            return -1;
        }
        catch (NullArgumentException nae) {
            System.out.println(nae);
            nae.printStackTrace();
            return -1;
        }
        catch (OutOfRangeException oore) {
            System.out.println(oore);
            oore.printStackTrace();
            return -1;
        }
    }

    public static ArrayList getInteractions(String propertiesFileName, IData data) throws OutOfRangeException, IOException, NullArgumentException {
        try {
            Properties props = new Properties();
            props.load(new FileInputStream(propertiesFileName));
            ArrayList interactions = GetInteractionsModule.getInteractions(props);
            if (interactions == null || interactions.size() == 0) {
                System.out.print("Oh no NULL Interaction object. Bad...");
                JOptionPane.showMessageDialog(new JFrame(), "No interactions found, aborting ....", "Info", 1);
                return null;
            }
            System.out.println(interactions.size() + " Interactions Found for type " + propertiesFileName);
            String outInteractionsFileName = props.getProperty("outInteractionsFileName", "outInteractions.txt");
            if (!data.isAnnotationLoaded()) {
                String fname_cyto = Useful.getUniqueFileID() + "_" + "LM.sif";
                System.setProperty("LM_ONLY", fname_cyto);
                UsefulInteractions.writeSifFileUndir(interactions, path + BNConstants.SEP + "results" + BNConstants.SEP + fname_cyto);
            } else {
                String fname_cyto = Useful.getUniqueFileID() + "_" + "LM.xgmml";
                System.setProperty("LM_ONLY", fname_cyto);
                if (probeIndexAssocHash != null) {
                    if (probeIndexAssocHash.size() <= 0) {
                        // empty if block
                    }
                } else {
                    throw new NullArgumentException("Given Probe-Index Hash was null!");
                }
                UsefulInteractions.writeXgmmlFileUndir(interactions, path + BNConstants.SEP + "results" + BNConstants.SEP + fname_cyto, probeIndexAssocHash, data);
            }
            UsefulInteractions.writeSifFileUndirWithWeights(interactions, outInteractionsFileName);
            return interactions;
        }
        catch (IOException ioe) {
            System.out.println(ioe);
            ioe.printStackTrace();
            throw ioe;
        }
        catch (NullArgumentException nae) {
            System.out.println(nae);
            nae.printStackTrace();
            throw nae;
        }
        catch (OutOfRangeException oore) {
            System.out.println(oore);
            oore.printStackTrace();
            throw oore;
        }
    }

    public static void usage() {
        System.out.println("java GetInteractionsModule propsFileName\njava GetInteractionsModule getInteractions.props");
        System.exit(0);
    }

    static {
        probeIndexAssocHash = new HashMap();
    }
}

