/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.bn.getInteractions;

import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.util.ArrayList;
import java.util.HashMap;
import org.tigr.microarray.mev.cluster.gui.impl.bn.Constants;
import org.tigr.microarray.mev.cluster.gui.impl.bn.NullArgumentException;
import org.tigr.microarray.mev.cluster.gui.impl.bn.Useful;

public class GetGOs {
    public static HashMap getGOs(String resourcererFileName, ArrayList accessions) throws NullArgumentException {
        try {
            if (accessions == null) {
                throw new NullArgumentException("Given accessions is null!");
            }
            HashMap<String, String> hm = new HashMap<String, String>();
            FileReader fr = new FileReader(resourcererFileName);
            LineNumberReader lnr = new LineNumberReader(fr);
            String s = null;
            String[] tokens = null;
            Object subTokens = null;
            while ((s = lnr.readLine()) != null) {
                tokens = (s = s.trim()).split("\t");
                if (tokens.length < Constants.GO_COLUMN_NUMBER || !Useful.find(accessions, tokens[Constants.GB_COLUMN_NUMBER].trim())) continue;
                hm.put(tokens[Constants.GB_COLUMN_NUMBER], tokens[Constants.GO_COLUMN_NUMBER]);
            }
            lnr.close();
            fr.close();
            return hm;
        }
        catch (IOException ioe) {
            System.out.println(ioe);
            return null;
        }
    }

    public static HashMap getGOsGivenResourcererAndGBsFileName(String resourcererFileName, String gbAccessionsFileName) throws FileNotFoundException {
        try {
            Useful.checkFile(resourcererFileName);
            Useful.checkFile(gbAccessionsFileName);
            ArrayList<String> gbs = Useful.readNamesFromFile(gbAccessionsFileName);
            HashMap hm = GetGOs.getGOs(resourcererFileName, gbs);
            return hm;
        }
        catch (NullArgumentException nae) {
            System.out.println(nae);
            return null;
        }
    }

    public static void writeGOTermsGivenResourcererAndGBsList(String gbAccessionsFileName, String resourcererFileName, String outputFileName) throws FileNotFoundException {
        try {
            Useful.checkFile(resourcererFileName);
            Useful.checkFile(gbAccessionsFileName);
            ArrayList<String> gbs = Useful.readNamesFromFile(gbAccessionsFileName);
            HashMap hm = GetGOs.getGOs(resourcererFileName, gbs);
            Useful.writeHashMapToFile(hm, outputFileName);
        }
        catch (NullArgumentException nae) {
            System.out.println(nae);
        }
    }

    public static void usage() {
        System.out.println("Usage: java GetGOs gbAccessionsFileName resourcererFileName outputFileName\nExample: java GetGOs myList_gbs.txt TIGR_40K_Human_Set myList_gbsGOs.txt");
        System.exit(0);
    }

    public static void test(String gbAccessionsFileName, String resourcererFileName, String outputFileName) {
        try {
            GetGOs.writeGOTermsGivenResourcererAndGBsList(gbAccessionsFileName, resourcererFileName, outputFileName);
        }
        catch (FileNotFoundException fnfe) {
            System.out.println(fnfe);
        }
    }

    public static void main(String[] argv) {
        if (argv.length != 3) {
            GetGOs.usage();
        }
        String gbAccessionsFileName = argv[0];
        String resourcererFileName = argv[1];
        String outputFileName = argv[2];
        GetGOs.test(gbAccessionsFileName, resourcererFileName, outputFileName);
    }
}

