/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.bn.getInteractions;

import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.util.ArrayList;
import java.util.HashMap;
import org.tigr.microarray.mev.cluster.gui.impl.bn.Constants;
import org.tigr.microarray.mev.cluster.gui.impl.bn.NullArgumentException;
import org.tigr.microarray.mev.cluster.gui.impl.bn.Useful;

public class GetAccessions {
    public static HashMap getAccessions(String resourcererFileName, ArrayList geneSymbols) throws NullArgumentException {
        FileReader fr = null;
        try {
            if (geneSymbols == null) {
                throw new NullArgumentException("Given geneSymbols is null!");
            }
            HashMap<String, String> hm = new HashMap<String, String>();
            fr = new FileReader(resourcererFileName);
            LineNumberReader lnr = new LineNumberReader(fr);
            String s = null;
            String[] tokens = null;
            String[] subTokens = null;
            int dummy = 0;
            while ((s = lnr.readLine()) != null) {
                if (dummy++ <= 2 || (tokens = (s = s.trim()).split("\t")).length < Constants.SYMBOLS_COLUMN_NUMBER + 1 || tokens[Constants.SYMBOLS_COLUMN_NUMBER] == "" || (subTokens = tokens[Constants.SYMBOLS_COLUMN_NUMBER].split(";")).length < 2 || !Useful.find(geneSymbols, subTokens[0].trim())) continue;
                hm.put(subTokens[0], tokens[Constants.GB_COLUMN_NUMBER]);
            }
            lnr.close();
            fr.close();
            return hm;
        }
        catch (IOException ioe) {
            System.out.println("IO Error From: org.tigr.microarray.mev.cluster.gui.impl.bn.getInteractions.getAccessions()");
            System.out.println(ioe);
            return null;
        }
    }

    public static void writeAccessionsGivenResourcererAndGeneSymbolsList(String geneSymbolsFileName, String resourcererFileName, String outputFileName) throws FileNotFoundException {
        try {
            Useful.checkFile(geneSymbolsFileName);
            Useful.checkFile(resourcererFileName);
            ArrayList<String> geneSymbols = Useful.readNamesFromFile(geneSymbolsFileName);
            HashMap hm = GetAccessions.getAccessions(resourcererFileName, geneSymbols);
            Useful.writeHashMapToFile(hm, outputFileName);
        }
        catch (NullArgumentException nae) {
            System.out.println(nae);
        }
    }

    public static void usage() {
        System.out.println("Usage: java GetAccessions geneSymbolsFileName resourcererFileName outputFileName\nExample: java GetAccessions myList_gene_symbols.txt TIGR_40K_Human_Set myList_gene_symbolsGbs.txt");
        System.exit(0);
    }

    public static void test(String geneSymbolsFileName, String resourcererFileName, String outputFileName) {
        try {
            GetAccessions.writeAccessionsGivenResourcererAndGeneSymbolsList(geneSymbolsFileName, resourcererFileName, outputFileName);
        }
        catch (FileNotFoundException fnfe) {
            System.out.println(fnfe);
        }
    }

    public static void main(String[] argv) {
        if (argv.length != 3) {
            GetAccessions.usage();
        }
        String geneSymbolsFileName = argv[0];
        String resourcererFileName = argv[1];
        String outputFileName = argv[2];
        GetAccessions.test(geneSymbolsFileName, resourcererFileName, outputFileName);
    }
}

