/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.bn.getInteractions;

import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.tigr.microarray.mev.cluster.gui.impl.bn.NullArgumentException;
import org.tigr.microarray.mev.cluster.gui.impl.bn.OutOfRangeException;
import org.tigr.microarray.mev.cluster.gui.impl.bn.SimpleGeneEdge;
import org.tigr.microarray.mev.cluster.gui.impl.bn.Useful;
import org.tigr.microarray.mev.cluster.gui.impl.bn.UsefulInteractions;

public class GeneInteractions {
    public static boolean debug = false;

    public ArrayList createInteractions(HashMap symbolsArticles) throws NullArgumentException {
        if (symbolsArticles == null) {
            throw new NullArgumentException("Given symbolsArticles is null!");
        }
        ArrayList<SimpleGeneEdge> interactions = new ArrayList<SimpleGeneEdge>();
        Set symbols = symbolsArticles.keySet();
        Iterator symbolsIt1 = symbols.iterator();
        Iterator symbolsIt2 = null;
        String symbol1 = null;
        String symbol22 = null;
        HashSet articles1 = null;
        HashSet articles2 = null;
        HashSet commonArticles = null;
        int weight = 0;
        SimpleGeneEdge sGE = null;
        HashSet<String> done = new HashSet<String>();
        while (symbolsIt1.hasNext()) {
            symbol1 = (String)symbolsIt1.next();
            articles1 = Useful.StringToHashSet((String)symbolsArticles.get(symbol1));
            for (String symbol22 : symbols) {
                if (symbol1 == null || symbol22 == null || symbol1.equals(symbol22)) continue;
                if (!(done.contains(symbol1 + "_" + symbol22) || done.contains(symbol22 + "_" + symbol1) || (commonArticles = this.getArticlesInCommon(articles1, articles2 = Useful.StringToHashSet((String)symbolsArticles.get(symbol22)))) == null || commonArticles.size() == 0 || UsefulInteractions.containsEitherWay(interactions, sGE = new SimpleGeneEdge(symbol1, symbol22, weight = commonArticles.size())))) {
                    interactions.add(sGE);
                }
                done.add(symbol1 + "_" + symbol22);
            }
        }
        return interactions;
    }

    public HashSet getArticlesInCommon(HashSet articles1, HashSet articles2) {
        if (articles1 == null || articles2 == null) {
            return null;
        }
        HashSet<String> commonArticles = new HashSet<String>();
        Iterator articles1It = articles1.iterator();
        String article1 = null;
        while (articles1It.hasNext()) {
            article1 = (String)articles1It.next();
            if (!articles2.contains(article1)) continue;
            commonArticles.add(article1);
        }
        return commonArticles;
    }

    public static HashMap backwards(HashMap symbolsArticles) throws NullArgumentException {
        if (symbolsArticles == null) {
            throw new NullArgumentException("Given symbolsArticles is null!");
        }
        Set keys = symbolsArticles.keySet();
        Iterator itKeys = keys.iterator();
        String key = null;
        HashSet articles = null;
        HashMap<String, HashSet<String>> artSymbols = new HashMap<String, HashSet<String>>();
        HashSet<String> symbols = null;
        Iterator itArt = null;
        String article2 = null;
        while (itKeys.hasNext()) {
            key = (String)itKeys.next();
            articles = Useful.StringToHashSet((String)symbolsArticles.get(key));
            if (articles == null) continue;
            for (String article2 : articles) {
                symbols = (HashSet<String>)artSymbols.get(article2);
                if (symbols == null) {
                    symbols = new HashSet<String>();
                }
                symbols.add(key);
                artSymbols.put(article2, symbols);
            }
        }
        return artSymbols;
    }

    public static HashMap filter(HashMap artSymbols, HashMap symbolsArticles, int threshold) throws OutOfRangeException, NullArgumentException {
        if (artSymbols == null || symbolsArticles == null) {
            throw new NullArgumentException("At least one of the given <code>HashMap</code>s artSymbols or symbolsArticles is null!\nartSymbols=" + artSymbols + "\nsymbolsArticles=" + symbolsArticles);
        }
        if (threshold < 2) {
            throw new OutOfRangeException("Threshold " + threshold + " is out of range!");
        }
        Set keys1 = artSymbols.keySet();
        Iterator itkeys1 = keys1.iterator();
        String art2 = null;
        HashSet symb = null;
        HashSet<String> articlesToRemove = new HashSet<String>();
        while (itkeys1.hasNext()) {
            art2 = (String)itkeys1.next();
            symb = (HashSet)artSymbols.get(art2);
            if (symb == null || symb.size() <= threshold) continue;
            articlesToRemove.add(art2);
        }
        Set keys2 = symbolsArticles.keySet();
        Iterator itkeys2 = keys2.iterator();
        String symbol = null;
        while (itkeys2.hasNext()) {
            symbol = (String)itkeys2.next();
            HashSet articles = Useful.StringToHashSet((String)symbolsArticles.get(symbol));
            for (String art2 : articlesToRemove) {
                if (art2 == null || articles == null) continue;
                articles.remove(art2);
                symbolsArticles.put(symbol, Useful.HashSetToString(articles));
            }
        }
        return symbolsArticles;
    }

    public static void testCreateInteractions(String gbArticlesFileName) {
        try {
            Useful.checkFile(gbArticlesFileName);
            HashMap gbArticles = Useful.readHashMapFromFile(gbArticlesFileName);
            GeneInteractions gI = new GeneInteractions();
            ArrayList arrayList = gI.createInteractions(gbArticles);
        }
        catch (FileNotFoundException fnfe) {
            System.out.println(fnfe);
        }
        catch (NullArgumentException nae) {
            System.out.println(nae);
        }
    }

    public static void testCreateInteractionsWithFilter(String gbArticlesFileName, int threshold) {
        try {
            HashMap gbArticles = Useful.readHashMapFromFile(gbArticlesFileName);
            HashMap articlesGbs = GeneInteractions.backwards(gbArticles);
            HashMap gbArticles2 = null;
            gbArticles2 = GeneInteractions.filter(articlesGbs, gbArticles, threshold);
            GeneInteractions gI = new GeneInteractions();
            ArrayList inter = gI.createInteractions(gbArticles2);
        }
        catch (OutOfRangeException oore) {
            System.out.println(oore);
        }
        catch (FileNotFoundException fnfe) {
            System.out.println(fnfe);
        }
        catch (NullArgumentException nae) {
            System.out.println(nae);
        }
    }

    public static void usage() {
        System.out.println("Usage: java GeneInteractions gbArticlesFileName articleRemovalThreshold\nExample: java GeneInteractions gbArticles.txt 2");
        System.exit(0);
    }

    public static void main(String[] argv) {
        if (argv.length != 2) {
            GeneInteractions.usage();
        }
        GeneInteractions.testCreateInteractions(argv[0]);
        GeneInteractions.testCreateInteractionsWithFilter(argv[0], Integer.parseInt(argv[1]));
    }
}

