/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.bn.algs;

import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Properties;
import org.tigr.microarray.mev.cluster.gui.impl.bn.NullArgumentException;
import org.tigr.microarray.mev.cluster.gui.impl.bn.OutOfRangeException;
import org.tigr.microarray.mev.cluster.gui.impl.bn.SimpleGeneEdge;
import org.tigr.microarray.mev.cluster.gui.impl.bn.Useful;
import org.tigr.microarray.mev.cluster.gui.impl.bn.UsefulInteractions;

public class TransitiveClosure {
    public static int[][] transitiveClosure(int[][] adjMatrix, int numNodes) throws NullArgumentException, OutOfRangeException {
        if (adjMatrix == null) {
            throw new NullArgumentException("Given adjacencyMatrix is null!");
        }
        if (numNodes <= 0) {
            throw new OutOfRangeException("Given numNodes is negative or zero!\nnumNodes=" + numNodes);
        }
        for (int k = 0; k < numNodes; ++k) {
            for (int i = 0; i < numNodes; ++i) {
                for (int j = 0; j < numNodes; ++j) {
                    adjMatrix[i][j] = adjMatrix[i][j] | adjMatrix[i][k] & adjMatrix[k][j];
                }
            }
        }
        return adjMatrix;
    }

    public static ArrayList getInteractionsWithReachableNodes(ArrayList queryNodes, ArrayList ppiNodes, int[][] adjMatrix) throws NullArgumentException {
        if (queryNodes == null || ppiNodes == null || adjMatrix == null) {
            throw new NullArgumentException("At least one of queryNodes, ppiNodes or adjacencyMatrix is null!\nqueryNodes=" + queryNodes + "\nppiNodes=" + ppiNodes + "adjMatrix=" + adjMatrix);
        }
        ArrayList<SimpleGeneEdge> result = new ArrayList<SimpleGeneEdge>();
        int[] queryNodesIndicesInPpi = new int[queryNodes.size()];
        for (int i = 0; i < queryNodes.size(); ++i) {
            queryNodesIndicesInPpi[i] = ppiNodes.indexOf((String)queryNodes.get(i));
        }
        SimpleGeneEdge sGE = null;
        for (int i = 0; i < queryNodesIndicesInPpi.length; ++i) {
            for (int j = 0; j < adjMatrix[i].length; ++j) {
                if (queryNodesIndicesInPpi[i] == -1 || adjMatrix[queryNodesIndicesInPpi[i]][j] != 1) continue;
                sGE = new SimpleGeneEdge((String)queryNodes.get(i), (String)ppiNodes.get(j), 1.0);
                result.add(sGE);
            }
        }
        return result;
    }

    public static ArrayList getInteractionsWithReachableNodes(ArrayList ppi, ArrayList queryNodes) throws NullArgumentException {
        try {
            if (ppi == null || queryNodes == null) {
                throw new NullArgumentException("At least one of ppi or queryNodes was null\nppi=" + ppi + "\nqueryNodes=" + queryNodes);
            }
            ArrayList ppiNodes = UsefulInteractions.getNodes(ppi);
            int[][] adjMatrix = UsefulInteractions.createAdjMatrix(ppi);
            int[][] reachMatrix = TransitiveClosure.transitiveClosure(adjMatrix, ppiNodes.size());
            ArrayList reachableInters = TransitiveClosure.getInteractionsWithReachableNodes(queryNodes, ppiNodes, reachMatrix);
            return reachableInters;
        }
        catch (OutOfRangeException oore) {
            System.out.println(oore);
            return null;
        }
    }

    public static void test(String propsFileName) {
        try {
            Properties props = new Properties();
            props.load(new FileInputStream(propsFileName));
            String ppiFileName = props.getProperty("ppiFileName", null);
            String queryNodesFileName = props.getProperty("queryNodesFileName", null);
            String outInterWithReachableFileName = props.getProperty("outInteractionsWithReachableNodesFileName", "outInteractionsWithReachableNodes.txt");
            Useful.checkFile(ppiFileName);
            Useful.checkFile(queryNodesFileName);
            ArrayList ppi = UsefulInteractions.readDirectedInteractions(ppiFileName);
            ArrayList<String> queryNodes = Useful.readNamesFromFile(queryNodesFileName);
            ArrayList reachableInters = TransitiveClosure.getInteractionsWithReachableNodes(ppi, queryNodes);
            UsefulInteractions.writeSifFileWithWeights(reachableInters, outInterWithReachableFileName);
        }
        catch (IOException ioe) {
            System.out.println(ioe);
        }
        catch (NullArgumentException nae) {
            System.out.println(nae);
        }
    }

    public static void test() {
        try {
            ArrayList<SimpleGeneEdge> inter = new ArrayList<SimpleGeneEdge>();
            inter.add(new SimpleGeneEdge("a", "b", 1.0));
            inter.add(new SimpleGeneEdge("b", "c", 1.0));
            inter.add(new SimpleGeneEdge("c", "d", 1.0));
            ArrayList<String> query = new ArrayList<String>();
            query.add("b");
            ArrayList arrayList = TransitiveClosure.getInteractionsWithReachableNodes(inter, query);
        }
        catch (NullArgumentException nae) {
            System.out.println(nae);
        }
    }

    public static void usage() {
        System.out.println("Usage: java TransitiveClosure propsFileName\nExample: java TransitiveClosure GraphUtilsAlgs.props");
        System.exit(0);
    }

    public static void main(String[] argv) {
        if (argv.length != 1) {
            TransitiveClosure.test();
            TransitiveClosure.usage();
        }
        String propsFileName = argv[0];
        TransitiveClosure.test(propsFileName);
    }
}

