/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.bn.algs;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Properties;
import org.tigr.microarray.mev.cluster.gui.impl.bn.NullArgumentException;
import org.tigr.microarray.mev.cluster.gui.impl.bn.Useful;
import org.tigr.microarray.mev.cluster.gui.impl.bn.UsefulInteractions;
import org.tigr.microarray.mev.cluster.gui.impl.bn.algs.Cyclic;

public class DFSModification {
    public static boolean debug = false;
    public static PrintWriter pw = new PrintWriter(System.out, true);

    public static void setDebug(boolean isDebug) {
        debug = isDebug;
    }

    public static void setDebug(boolean isDebug, String logFileName) {
        try {
            debug = isDebug;
            if (debug) {
                pw = new PrintWriter(new FileOutputStream(logFileName), true);
            }
        }
        catch (IOException ioe) {
            System.out.println(ioe);
        }
    }

    public static ArrayList getDAGFromUndirectedGraph(ArrayList inter) throws NullArgumentException {
        return Cyclic.getDAGFromUndirectedGraph(inter);
    }

    public static void test(String propsFileName) {
        try {
            Properties props = new Properties();
            props.load(new FileInputStream(propsFileName));
            String sifFileName = props.getProperty("sifFileName", null);
            long seed = Integer.parseInt(props.getProperty("seed", "1"));
            String newInterFileName = props.getProperty("outDirectedInteractionsFileName", "outDirectedInteractions.txt");
            Useful.checkFile(sifFileName);
            ArrayList inter = UsefulInteractions.readInteractionsWithWeights(sifFileName);
            ArrayList newInter = DFSModification.getDAGFromUndirectedGraph(inter);
            System.out.println("cyclic? " + Cyclic.isCyclic(newInter));
            UsefulInteractions.writeSifFileWithWeights(newInter, newInterFileName);
        }
        catch (IOException ioe) {
            System.out.println(ioe);
        }
        catch (NullArgumentException nae) {
            System.out.println(nae);
        }
    }

    public static void usage() {
        System.out.println("Usage: java DFSModification propsFileName\nExample: java DFSModification testDFSModification.props");
        System.exit(0);
    }

    public static void main(String[] argv) {
        if (argv.length != 1) {
            DFSModification.usage();
        }
        String propsFileName = argv[0];
        DFSModification.test(propsFileName);
    }
}

