/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.bn.algs;

import java.io.FileNotFoundException;
import java.util.ArrayList;
import org.tigr.microarray.mev.cluster.gui.impl.bn.NullArgumentException;
import org.tigr.microarray.mev.cluster.gui.impl.bn.OutOfRangeException;
import org.tigr.microarray.mev.cluster.gui.impl.bn.SimpleGeneEdge;
import org.tigr.microarray.mev.cluster.gui.impl.bn.Useful;
import org.tigr.microarray.mev.cluster.gui.impl.bn.UsefulInteractions;

public class Cyclic {
    public static boolean isCyclic(ArrayList inter) throws NullArgumentException {
        boolean isCyclic = false;
        try {
            if (inter == null || inter.size() == 0) {
                throw new NullArgumentException("Given ArrayList inter is null or empty!");
            }
            ArrayList nodes = UsefulInteractions.getNodes(inter);
            int[] color = new int[nodes.size()];
            ArrayList[] p = new ArrayList[nodes.size()];
            for (int i = 0; i < nodes.size(); ++i) {
                color[i] = -1;
                p[i] = new ArrayList();
            }
            int time = 0;
            int[] d = new int[nodes.size()];
            for (int i = 0; i < nodes.size(); ++i) {
                if (color[i] != -1) continue;
                isCyclic = Cyclic.DFS(i, d, p, color, time, inter, nodes, isCyclic);
            }
            return isCyclic;
        }
        catch (OutOfRangeException oore) {
            System.out.println(oore);
            return isCyclic;
        }
    }

    public static ArrayList getDAGFromUndirectedGraph(ArrayList inter) throws NullArgumentException {
        boolean isCyclic = false;
        ArrayList DAG = new ArrayList();
        try {
            if (inter == null || inter.size() == 0) {
                throw new NullArgumentException("Given ArrayList inter is null or empty!");
            }
            ArrayList nodes = UsefulInteractions.getNodes(inter);
            int[] color = new int[nodes.size()];
            ArrayList[] p = new ArrayList[nodes.size()];
            for (int i = 0; i < nodes.size(); ++i) {
                color[i] = -1;
                p[i] = new ArrayList();
            }
            int time = 0;
            int[] d = new int[nodes.size()];
            for (int i = 0; i < nodes.size(); ++i) {
                if (color[i] != -1) continue;
                DAG = Cyclic.DFSModification(i, d, p, color, time, inter, nodes, isCyclic, DAG);
            }
            return DAG;
        }
        catch (OutOfRangeException oore) {
            System.out.println(oore);
            return DAG;
        }
    }

    public static boolean DFS(int u, int[] d, ArrayList[] p, int[] color, int time, ArrayList inter, ArrayList nodes, boolean cyclic) throws NullArgumentException, OutOfRangeException {
        if (d == null || p == null || color == null || inter == null || nodes == null) {
            throw new NullArgumentException("At least one of the given parameters int[] d, ArrayList[] p, int[] color, ArrayList inter or ArrayList nodes was null!\nd=" + d + "\np=" + p + "\ncolor=" + color + "\ninter=" + inter + "\nnodes=" + nodes);
        }
        if (u < 0 || time < 0) {
            throw new OutOfRangeException("At least one of the given int u or int time was null!\nu=" + u + "\ntime=" + time);
        }
        d[u] = time;
        color[u] = 0;
        int[] neighbors = UsefulInteractions.getNeighbors(u, inter, nodes);
        int v = 0;
        for (int i = 0; i < neighbors.length; ++i) {
            v = neighbors[i];
            if (color[v] == 0 && !Useful.contains(p[v], new Integer(u))) {
                cyclic = true;
            }
            if (color[v] != -1) continue;
            p[v].add(new Integer(u));
            cyclic = Cyclic.DFS(v, d, p, color, time, inter, nodes, cyclic);
        }
        ++time;
        color[u] = 1;
        return cyclic;
    }

    public static ArrayList DFSModification(int u, int[] d, ArrayList[] p, int[] color, int time, ArrayList inter, ArrayList nodes, boolean cyclic, ArrayList DAG) throws NullArgumentException, OutOfRangeException {
        if (d == null || p == null || color == null || inter == null || nodes == null) {
            throw new NullArgumentException("At least one of the given parameters int[] d, ArrayList[] p, int[] color, ArrayList inter or ArrayList nodes was null!\nd=" + d + "\np=" + p + "\ncolor=" + color + "\ninter=" + inter + "\nnodes=" + nodes);
        }
        if (u < 0 || time < 0) {
            throw new OutOfRangeException("At least one of the given int u or int time was null!\nu=" + u + "\ntime=" + time);
        }
        SimpleGeneEdge sGE = null;
        d[u] = time;
        color[u] = 0;
        int[] neighbors = UsefulInteractions.getNeighbors(u, inter, nodes);
        int v = 0;
        for (int i = 0; i < neighbors.length; ++i) {
            v = neighbors[i];
            if (color[v] == 0 && !Useful.contains(p[v], new Integer(u))) {
                cyclic = true;
                sGE = new SimpleGeneEdge((String)nodes.get(v), (String)nodes.get(u));
                if (!UsefulInteractions.containsEitherWay(DAG, sGE)) {
                    DAG.add(sGE);
                }
            }
            if (color[v] != -1) continue;
            p[v].add(new Integer(u));
            sGE = new SimpleGeneEdge((String)nodes.get(u), (String)nodes.get(v));
            if (!UsefulInteractions.containsEitherWay(DAG, sGE)) {
                DAG.add(sGE);
            }
            DAG = Cyclic.DFSModification(v, d, p, color, time, inter, nodes, cyclic, DAG);
        }
        ++time;
        color[u] = 1;
        return DAG;
    }

    public static void usage() {
        System.out.println("Usage: java Cyclic interFileName\nExample: java Cyclic myInter.sif");
    }

    public static void test(String interFileName) {
        try {
            ArrayList inter = UsefulInteractions.readDirectedInteractions(interFileName);
            System.out.println("given test inter=" + inter);
            System.out.println("isCyclic?" + Cyclic.isCyclic(inter));
        }
        catch (FileNotFoundException fnfe) {
            System.out.println(fnfe);
        }
        catch (NullArgumentException nae) {
            System.out.println(nae);
        }
    }

    public static void test() {
        try {
            ArrayList<SimpleGeneEdge> inter = new ArrayList<SimpleGeneEdge>();
            inter.add(new SimpleGeneEdge("a", "b", 1.0));
            inter.add(new SimpleGeneEdge("b", "c", 1.0));
            inter.add(new SimpleGeneEdge("c", "d", 1.0));
            System.out.println("testing G1=" + inter);
            System.out.println("isCyclic?" + Cyclic.isCyclic(inter));
            inter.add(new SimpleGeneEdge("d", "b", 1.0));
            System.out.println("testing G2=" + inter);
            System.out.println("isCyclic?" + Cyclic.isCyclic(inter));
        }
        catch (NullArgumentException nae) {
            System.out.println(nae);
        }
    }

    public static void main(String[] argv) {
        if (argv.length != 1) {
            Cyclic.test();
            Cyclic.usage();
            System.exit(0);
        }
        String interFileName = argv[0];
        Cyclic.test(interFileName);
    }
}

