/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.bn.algs;

import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Properties;
import org.tigr.microarray.mev.cluster.gui.impl.bn.NullArgumentException;
import org.tigr.microarray.mev.cluster.gui.impl.bn.OutOfRangeException;
import org.tigr.microarray.mev.cluster.gui.impl.bn.SimpleGeneEdge;
import org.tigr.microarray.mev.cluster.gui.impl.bn.Useful;
import org.tigr.microarray.mev.cluster.gui.impl.bn.UsefulInteractions;

public class AllPairsShortestPaths {
    public static double[][] allPairsShortestPaths(double[][] weightMatrix, int numNodes) throws NullArgumentException, OutOfRangeException {
        if (weightMatrix == null) {
            throw new NullArgumentException("Given weightMatrix is null");
        }
        if (numNodes <= 0) {
            throw new OutOfRangeException("Given numNodes is negative or zero!\nnumNodes=" + numNodes);
        }
        double[][] A = new double[numNodes][numNodes];
        for (int i = 0; i < numNodes; ++i) {
            for (int j = 0; j < numNodes; ++j) {
                A[i][j] = weightMatrix[i][j];
            }
        }
        for (int k = 0; k < numNodes; ++k) {
            for (int i = 0; i < numNodes; ++i) {
                for (int j = 0; j < numNodes; ++j) {
                    A[i][j] = AllPairsShortestPaths.min(A[i][j], A[i][k] + A[k][j]);
                }
            }
        }
        return A;
    }

    public static double min(double i, double j) {
        if (i < j) {
            return i;
        }
        return j;
    }

    public static double[][] allPairsShortestPaths(ArrayList ppi) throws NullArgumentException {
        try {
            if (ppi == null) {
                throw new NullArgumentException("Given ppi ArrayList is null!");
            }
            ArrayList ppiNodes = UsefulInteractions.getNodes(ppi);
            double[][] weightMatrix = UsefulInteractions.createWeightMatrix(ppi);
            UsefulInteractions.printWeightMatrix(weightMatrix, ppiNodes.size());
            double[][] apspMatrix = AllPairsShortestPaths.allPairsShortestPaths(weightMatrix, ppiNodes.size());
            UsefulInteractions.printWeightMatrix(apspMatrix, ppiNodes.size());
            return apspMatrix;
        }
        catch (OutOfRangeException oore) {
            System.out.println(oore);
            return null;
        }
    }

    public static ArrayList getInteractionsWithNodesAtDistanceK(ArrayList ppi, ArrayList queryNodes, double distanceK) throws NullArgumentException {
        try {
            if (queryNodes == null || ppi == null) {
                throw new NullArgumentException("At least one of queryNodes or ppi was null\nqueryNodes=" + queryNodes + "\nppi=" + ppi);
            }
            ArrayList<SimpleGeneEdge> result = new ArrayList<SimpleGeneEdge>();
            ArrayList ppiNodes = UsefulInteractions.getNodes(ppi);
            double[][] weightMatrix = UsefulInteractions.createWeightMatrix(ppi);
            double[][] apspMatrix = AllPairsShortestPaths.allPairsShortestPaths(weightMatrix, ppiNodes.size());
            int[] queryNodesIndicesInPpi = new int[queryNodes.size()];
            for (int i = 0; i < queryNodes.size(); ++i) {
                queryNodesIndicesInPpi[i] = ppiNodes.indexOf((String)queryNodes.get(i));
            }
            SimpleGeneEdge sGE = null;
            for (int i = 0; i < queryNodesIndicesInPpi.length; ++i) {
                for (int j = 0; j < apspMatrix[i].length; ++j) {
                    if (queryNodesIndicesInPpi[i] == -1 || !(apspMatrix[queryNodesIndicesInPpi[i]][j] <= distanceK)) continue;
                    sGE = new SimpleGeneEdge((String)queryNodes.get(i), (String)ppiNodes.get(j), apspMatrix[queryNodesIndicesInPpi[i]][j]);
                    result.add(sGE);
                }
            }
            return result;
        }
        catch (OutOfRangeException oore) {
            System.out.println(oore);
            return null;
        }
    }

    public static void test(String propsFileName) {
        try {
            Properties props = new Properties();
            props.load(new FileInputStream(propsFileName));
            String ppiFileName = props.getProperty("ppiFileName", null);
            String queryNodesFileName = props.getProperty("queryNodesFileName", null);
            double distanceK = Double.parseDouble(props.getProperty("distanceK", "3"));
            String outInterWithNodesAtDistanceKFileName = props.getProperty("outInteractionsWithNodesAtDistanceKFileName", "outInteractionsWithNodesAtDistanceK.txt");
            Useful.checkFile(ppiFileName);
            Useful.checkFile(queryNodesFileName);
            ArrayList ppi = UsefulInteractions.readDirectedInteractions(ppiFileName);
            ArrayList<String> queryNodes = Useful.readNamesFromFile(queryNodesFileName);
            ArrayList interWithNodesAtDistanceK = AllPairsShortestPaths.getInteractionsWithNodesAtDistanceK(ppi, queryNodes, distanceK);
            UsefulInteractions.writeSifFileWithWeights(interWithNodesAtDistanceK, outInterWithNodesAtDistanceKFileName);
        }
        catch (IOException ioe) {
            System.out.println(ioe);
        }
        catch (NullArgumentException nae) {
            System.out.println(nae);
        }
    }

    public static void test() {
        try {
            ArrayList<SimpleGeneEdge> inter = new ArrayList<SimpleGeneEdge>();
            inter.add(new SimpleGeneEdge("a", "b", 1.0));
            inter.add(new SimpleGeneEdge("b", "c", 1.0));
            inter.add(new SimpleGeneEdge("c", "d", 1.0));
            ArrayList<String> query = new ArrayList<String>();
            query.add("a");
            double distanceK = 2.0;
            System.out.println("Testing with given graph: " + inter + "\nand given queryNode=" + query + "\nand given distanceK=" + distanceK);
            ArrayList distanceKInters = AllPairsShortestPaths.getInteractionsWithNodesAtDistanceK(inter, query, distanceK);
            System.out.println("Result: " + distanceKInters);
        }
        catch (NullArgumentException nae) {
            System.out.println(nae);
        }
    }

    public static void usage() {
        System.out.println("Usage: java AllPairsShortestPaths propsFileName\nExample: java AllPairsShortestPaths GraphUtilsAlgs.props");
        System.exit(0);
    }

    public static void main(String[] argv) {
        if (argv.length != 1) {
            AllPairsShortestPaths.test();
            AllPairsShortestPaths.usage();
        }
        String propsFileName = argv[0];
        AllPairsShortestPaths.test(propsFileName);
    }
}

