/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.bn;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import org.tigr.microarray.mev.cluster.gui.IData;
import org.tigr.microarray.mev.cluster.gui.impl.bn.Useful;

public class XGMMLGenerator {
    private static String lineSep = System.getProperty("line.separator");

    public static String createHeader(String label, String cptFileLoc) {
        String xgmml_header = "";
        xgmml_header = "<?xml version='1.0' encoding='UTF-8' standalone='yes'?>" + lineSep;
        xgmml_header = xgmml_header + "<graph id='" + label + "' label='" + label + "' xmlns:dc='http://purl.org/dc/elements/1.1/' xmlns:xlink='http://www.w3.org/1999/xlink' xmlns:rdf='http://www.w3.org/1999/02/22-rdf-syntax-ns#' xmlns:cy='http://www.cytoscape.org' xmlns='http://www.cs.rpi.edu/XGMML' >" + lineSep;
        xgmml_header = xgmml_header + "  <att name='documentVersion' value='1.1'/>" + lineSep;
        xgmml_header = xgmml_header + "  <att name='networkMetadata'>" + lineSep;
        xgmml_header = xgmml_header + "    <rdf:RDF>" + lineSep;
        xgmml_header = xgmml_header + "      <rdf:Description rdf:about='http://www.cytoscape.org/'>" + lineSep;
        xgmml_header = xgmml_header + "        <dc:type>Protein-Protein Interaction</dc:type>" + lineSep;
        xgmml_header = xgmml_header + "        <dc:description>N/A</dc:description>" + lineSep;
        xgmml_header = xgmml_header + "        <dc:identifier>N/A</dc:identifier>" + lineSep;
        xgmml_header = xgmml_header + "        <dc:date>" + Useful.getDateTime() + "</dc:date>" + lineSep;
        xgmml_header = xgmml_header + "        <dc:title>" + label + "</dc:title>" + lineSep;
        xgmml_header = xgmml_header + "        <dc:source>http://www.cytoscape.org/</dc:source>" + lineSep;
        xgmml_header = xgmml_header + "        <dc:format>Cytoscape-XGMML</dc:format>" + lineSep;
        xgmml_header = xgmml_header + "      </rdf:Description>" + lineSep;
        xgmml_header = xgmml_header + "    </rdf:RDF>" + lineSep;
        xgmml_header = xgmml_header + "  </att>" + lineSep;
        xgmml_header = xgmml_header + "  <att name='backgroundColor' value='#ccccff'/>" + lineSep;
        xgmml_header = xgmml_header + "  <att name='layout' value='grid'/>" + lineSep;
        xgmml_header = xgmml_header + "  <att name='cpt' value='" + cptFileLoc.trim().replace("\\", "/") + "'/>" + lineSep;
        return xgmml_header;
    }

    public static String createNode(String label, String id, IData data, int rowInd) {
        String node = "";
        String nodeType = "string";
        node = "  <node label='" + label + "' id='" + id + "' >" + lineSep;
        String[] fieldNames = data.getFieldNames();
        for (int i = 0; i < fieldNames.length; ++i) {
            String[] _tmp = data.getElementAnnotation(rowInd, fieldNames[i]);
            _tmp[0] = _tmp[0].trim().equalsIgnoreCase("na") ? "" : XGMMLGenerator.replaceBadChar(_tmp[0]);
            if (fieldNames[i].equals("GENE_SYMBOL") || fieldNames[i].equals("GENE_TITLE") || fieldNames[i].equals("ENTREZ_ID") || fieldNames[i].equals("GENBANK_ACC")) {
                nodeType = "list";
            }
            node = node + XGMMLGenerator.createNodeAttribute(fieldNames[i], _tmp[0], nodeType);
            nodeType = "string";
        }
        node = node + "    <graphics type='ELLIPSE' width='2' fill='#FFCC99' outline='#CC9900' >" + lineSep;
        node = node + "    \t<att name='cytoscapeNodeGraphicsAttributes'>" + lineSep;
        node = node + "    \t\t<att name='nodeLabelFont' value='Default-0-12'/>" + lineSep;
        node = node + "    \t\t<att name='borderLineType' value='solid'/>" + lineSep;
        node = node + "    \t</att>" + lineSep;
        node = node + "    </graphics>" + lineSep;
        node = node + "  </node>" + lineSep;
        return node;
    }

    public static String createClassNode(String label, String id, IData data) {
        String node = "";
        String nodeType = "string";
        node = "  <node label='" + label + "' id='" + id + "' >" + lineSep;
        String[] fieldNames = data.getFieldNames();
        for (int i = 0; i < fieldNames.length; ++i) {
            if (fieldNames[i].equals("GENE_SYMBOL") || fieldNames[i].equals("GENE_TITLE") || fieldNames[i].equals("ENTREZ_ID") || fieldNames[i].equals("GENBANK_ACC")) {
                nodeType = "list";
            }
            node = node + XGMMLGenerator.createNodeAttribute(fieldNames[i], "CLASS", nodeType);
            nodeType = "string";
        }
        node = node + "    <graphics type='ELLIPSE' width='2' fill='#FFCC99' outline='#CC9900' >" + lineSep;
        node = node + "    \t<att name='cytoscapeNodeGraphicsAttributes'>" + lineSep;
        node = node + "    \t\t<att name='nodeLabelFont' value='Default-0-12'/>" + lineSep;
        node = node + "    \t\t<att name='borderLineType' value='solid'/>" + lineSep;
        node = node + "    \t</att>" + lineSep;
        node = node + "    </graphics>" + lineSep;
        node = node + "  </node>" + lineSep;
        return node;
    }

    private static String replaceBadChar(String string) {
        string = string.replace("'", "");
        return string;
    }

    public static String createNodeAttribute(String attribName, String attribValue, String nodeType) {
        String attrib = "";
        attrib = "    <att type='string' name='" + attribName + "' value='" + attribValue + "'/>" + lineSep;
        return attrib;
    }

    public static String createDummyNodeAttribute(String attribName, String attribValue) {
        String attrib = "";
        attrib = "    <att type='string' name='" + attribName + "' value='" + attribValue + "'/>" + lineSep;
        return attrib;
    }

    public static String createEdge(boolean dir, String srcLbl, String tgtLabel, String srcId, String tgtId) {
        String edge = "";
        edge = "  <edge label='" + srcLbl + " (pd) " + tgtLabel + "' source='" + srcId + "' target='" + tgtId + "' weight='0'>" + lineSep;
        edge = edge + "    <att type='string' name='interaction' value='pd'/>" + lineSep;
        edge = dir ? edge + "    <graphics width='2' fill='#999999' cy:sourceArrow='0' cy:targetArrow='3' cy:sourceArrowColor='#cdcdc1' cy:targetArrowColor='#333333' cy:edgeLabelFont='Default-0-10' cy:edgeLineType='SOLID' cy:curved='STRAIGHT_LINES'/>" + lineSep : edge + "    <graphics width='2' fill='#999999' cy:sourceArrow='0' cy:targetArrow='0' cy:sourceArrowColor='#000000' cy:targetArrowColor='#000000' cy:edgeLabelFont='SanSerif-0-10' cy:edgeLineType='SOLID' cy:curved='STRAIGHT_LINES'/>" + lineSep;
        edge = edge + "  </edge>" + lineSep;
        return edge;
    }

    public static String getFooter() {
        String footer = "";
        footer = "</graph>" + lineSep;
        return footer;
    }

    public static void writeFileXGMML(String file, String content) throws IOException {
        FileOutputStream fos = null;
        fos = new FileOutputStream(file);
        PrintWriter pw = new PrintWriter(fos, true);
        pw.print(content);
        pw.flush();
        pw.close();
    }
}

