/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.bn;

import java.io.File;
import java.io.IOException;
import org.tigr.microarray.mev.TMEV;
import org.tigr.microarray.mev.cluster.gui.impl.bn.BNConstants;
import org.tigr.microarray.mev.cluster.gui.impl.bn.NullArgumentException;
import org.tigr.microarray.mev.cluster.gui.impl.bn.Useful;
import weka.core.Instances;
import weka.core.converters.ArffLoader;
import weka.core.converters.ArffSaver;
import weka.core.converters.CSVLoader;
import weka.core.converters.CSVSaver;

public class WekaUtil {
    public static Instances readInstancesCSV(String inFileName) {
        try {
            String dataPath = TMEV.getDataPath();
            File pathFile = TMEV.getFile((String)"data/");
            if (dataPath != null && !(pathFile = new File(dataPath)).exists()) {
                pathFile = TMEV.getFile((String)"data/");
            }
            CSVLoader loader = new CSVLoader();
            loader.setSource(new File(inFileName));
            Instances data = loader.getDataSet();
            return data;
        }
        catch (IOException ioe) {
            System.out.println(ioe);
            ioe.printStackTrace();
            return null;
        }
    }

    public static Instances readInstancesArff(String inFileName) {
        try {
            Useful.checkFile(inFileName);
            ArffLoader loader = new ArffLoader();
            loader.setSource(new File(inFileName));
            Instances data = loader.getDataSet();
            return data;
        }
        catch (IOException ioe) {
            System.out.println(ioe);
            ioe.printStackTrace();
            return null;
        }
    }

    public static void writeDataToArffFile(Instances data, String arffFileName) throws NullArgumentException {
        String sep = System.getProperty("file.separator");
        String path = System.getProperty("user.dir");
        path = BNConstants.getBaseFileLocation() + BNConstants.SEP + "tmp" + BNConstants.SEP;
        if (data == null) {
            throw new NullArgumentException("Parameter data passed to writeDataToArffFile method was null!");
        }
        try {
            ArffSaver saver = new ArffSaver();
            saver.setInstances(data);
            saver.setFile(new File(path, arffFileName));
            saver.setDestination(new File(path, arffFileName));
            saver.writeBatch();
        }
        catch (IOException ioe) {
            System.out.println(ioe);
        }
    }

    public static void writeDataToCSVFile(Instances data, String csvFileName) throws NullArgumentException {
        if (data == null) {
            throw new NullArgumentException("Parameter data passed to writeDataToCSVFile method was null!");
        }
        try {
            CSVSaver saver = new CSVSaver();
            saver.setInstances(data);
            saver.setFile(new File(csvFileName));
            saver.setDestination(new File(csvFileName));
            saver.writeBatch();
        }
        catch (IOException ioe) {
            System.out.println(ioe);
        }
    }
}

