/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.bn;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Vector;
import org.tigr.microarray.mev.cluster.gui.IData;
import org.tigr.microarray.mev.cluster.gui.impl.bn.BNConstants;
import org.tigr.microarray.mev.cluster.gui.impl.bn.FromWekaToSif;
import org.tigr.microarray.mev.cluster.gui.impl.bn.NullArgumentException;
import org.tigr.microarray.mev.cluster.gui.impl.bn.SimpleGeneEdge;
import org.tigr.microarray.mev.cluster.gui.impl.bn.Useful;

public class UsefulInteractions {
    public static ArrayList readInteractions(String fileName) throws FileNotFoundException {
        try {
            ArrayList<SimpleGeneEdge> inter = new ArrayList<SimpleGeneEdge>();
            FileReader fr = new FileReader(fileName);
            LineNumberReader lnr = new LineNumberReader(fr);
            String s = null;
            String[] tokens = null;
            while ((s = lnr.readLine()) != null) {
                tokens = (s = s.trim()).split(" pp ");
                if (tokens.length != 2) continue;
                inter.add(new SimpleGeneEdge(tokens[0], tokens[1]));
                inter.add(new SimpleGeneEdge(tokens[1], tokens[0]));
            }
            lnr.close();
            fr.close();
            return inter;
        }
        catch (IOException ioe) {
            System.out.println(ioe);
            return null;
        }
    }

    public static ArrayList readInteractions(Vector edges) throws Exception {
        ArrayList<SimpleGeneEdge> inter = new ArrayList<SimpleGeneEdge>();
        String s = null;
        String[] tokens = null;
        Enumeration enumerate = edges.elements();
        while (enumerate.hasMoreElements()) {
            s = (String)enumerate.nextElement();
            String splitOn = " pd ";
            if (s.contains(" pp ")) {
                splitOn = " pp ";
            }
            if (s.contains(" pd ")) {
                splitOn = " pd ";
            }
            if (s.contains(" - ")) {
                splitOn = " - ";
            }
            if ((tokens = s.split(splitOn)).length != 2) continue;
            inter.add(new SimpleGeneEdge(tokens[0], tokens[1]));
        }
        return inter;
    }

    public static ArrayList readInteractionsWithWeights(String fileName) throws FileNotFoundException {
        Useful.checkFile(fileName);
        try {
            ArrayList<SimpleGeneEdge> inter = new ArrayList<SimpleGeneEdge>();
            FileReader fr = new FileReader(fileName);
            LineNumberReader lnr = new LineNumberReader(fr);
            String s = null;
            String[] subTokens = null;
            int index = -1;
            while ((s = lnr.readLine()) != null) {
                index = (s = s.trim()).indexOf(" (pp) ");
                if (index == -1 || (subTokens = s.substring(index + 5, s.length()).trim().split(" = ")).length != 2) continue;
                inter.add(new SimpleGeneEdge(s.substring(0, index).trim(), subTokens[0].trim(), new Double(subTokens[1].trim())));
                inter.add(new SimpleGeneEdge(subTokens[0].trim(), s.substring(0, index).trim(), new Double(subTokens[1].trim())));
            }
            lnr.close();
            fr.close();
            return inter;
        }
        catch (IOException ioe) {
            System.out.println(ioe);
            return null;
        }
    }

    public static boolean containsEitherWay(ArrayList inter, SimpleGeneEdge sGE) throws NullArgumentException {
        String to;
        if (inter == null || sGE == null) {
            throw new NullArgumentException("At least one of the parameters inter or sGE was null\ninter=" + inter + "\nsGE=" + sGE);
        }
        if (inter.size() == 0) {
            return false;
        }
        SimpleGeneEdge sGEi = null;
        String from = sGE.getFrom();
        if (from.equals(to = sGE.getTo())) {
            return true;
        }
        String from_i = null;
        String to_i = null;
        for (int i = 0; i < inter.size(); ++i) {
            sGEi = (SimpleGeneEdge)inter.get(i);
            from_i = sGEi.getFrom();
            to_i = sGEi.getTo();
            if (from_i.equals(from) && to_i.equals(to)) {
                return true;
            }
            if (!to_i.equals(from) || !from_i.equals(to)) continue;
            return true;
        }
        return false;
    }

    public static boolean containsOneWay(ArrayList inter, SimpleGeneEdge sGE) throws NullArgumentException {
        if (inter == null || sGE == null) {
            throw new NullArgumentException("At least one of the parameters inter or sGE was null\ninter=" + inter + "\nsGE=" + sGE);
        }
        SimpleGeneEdge sGEi = null;
        String from = sGE.getFrom();
        String to = sGE.getTo();
        String from_i = null;
        String to_i = null;
        for (int i = 0; i < inter.size(); ++i) {
            sGEi = (SimpleGeneEdge)inter.get(i);
            from_i = sGEi.getFrom();
            to_i = sGEi.getTo();
            if (!from_i.equals(from) || !to_i.equals(to)) continue;
            return true;
        }
        return false;
    }

    public static ArrayList readDirectedInteractions(String fileName) throws FileNotFoundException {
        Useful.checkFile(fileName);
        try {
            ArrayList<SimpleGeneEdge> inter = new ArrayList<SimpleGeneEdge>();
            FileReader fr = new FileReader(fileName);
            LineNumberReader lnr = new LineNumberReader(fr);
            String s = null;
            String[] tokens = null;
            while ((s = lnr.readLine()) != null) {
                tokens = (s = s.trim()).split(" pd ");
                if (tokens.length != 2) continue;
                inter.add(new SimpleGeneEdge(tokens[0], tokens[1]));
            }
            lnr.close();
            fr.close();
            return inter;
        }
        catch (IOException ioe) {
            System.out.println(ioe);
            return null;
        }
    }

    public static ArrayList readDirectedInteractionsWithWeights(String fileName) throws FileNotFoundException {
        Useful.checkFile(fileName);
        try {
            ArrayList<SimpleGeneEdge> inter = new ArrayList<SimpleGeneEdge>();
            FileReader fr = new FileReader(fileName);
            LineNumberReader lnr = new LineNumberReader(fr);
            String s = null;
            String[] subTokens = null;
            int index = -1;
            while ((s = lnr.readLine()) != null) {
                index = (s = s.trim()).indexOf(" (pd) ");
                if (index == -1 || (subTokens = s.substring(index + 5, s.length()).trim().split(" = ")).length != 2) continue;
                inter.add(new SimpleGeneEdge(s.substring(0, index).trim(), subTokens[0].trim(), new Double(subTokens[1].trim())));
            }
            lnr.close();
            fr.close();
            return inter;
        }
        catch (IOException ioe) {
            System.out.println(ioe);
            return null;
        }
    }

    public static void writeSifFile(ArrayList inter, String fileName) throws NullArgumentException {
        try {
            if (inter == null) {
                throw new NullArgumentException("Given inter was null!");
            }
            String path = BNConstants.getBaseFileLocation() + BNConstants.SEP + "results" + BNConstants.SEP;
            FileOutputStream fos = new FileOutputStream(path + fileName);
            PrintWriter pw = new PrintWriter(fos, true);
            SimpleGeneEdge sGE = null;
            for (int i = 0; i < inter.size(); ++i) {
                sGE = (SimpleGeneEdge)inter.get(i);
                pw.println(sGE.getFrom() + " pd " + sGE.getTo());
            }
        }
        catch (IOException ioe) {
            System.out.println(ioe);
        }
    }

    public static void writeSifFileUndir(ArrayList inter, String fileName) throws NullArgumentException {
        FileOutputStream fos = null;
        try {
            if (inter == null) {
                throw new NullArgumentException("Given inter was null!");
            }
            fos = new FileOutputStream(fileName);
            PrintWriter pw = new PrintWriter(fos, true);
            SimpleGeneEdge sGE = null;
            for (int i = 0; i < inter.size(); ++i) {
                sGE = (SimpleGeneEdge)inter.get(i);
                pw.println(sGE.getFrom() + " pp " + sGE.getTo());
            }
        }
        catch (IOException ioe) {
            System.out.println(ioe);
        }
    }

    public static void writeSifFileWithWeights(ArrayList inter, String fileName) throws NullArgumentException {
        String path = System.getProperty("user.dir");
        String sep = System.getProperty("file.separator");
        path = BNConstants.getBaseFileLocation() + BNConstants.SEP + "results" + BNConstants.SEP;
        try {
            if (inter == null) {
                throw new NullArgumentException("Given inter was null!");
            }
            FileOutputStream fos = new FileOutputStream(path + fileName);
            PrintWriter pw = new PrintWriter(fos, true);
            SimpleGeneEdge sGE = null;
            for (int i = 0; i < inter.size(); ++i) {
                sGE = (SimpleGeneEdge)inter.get(i);
                pw.println(sGE.getFrom() + " (pd) " + sGE.getTo() + " = " + sGE.getWeight());
            }
        }
        catch (IOException ioe) {
            System.out.println(ioe);
        }
    }

    public static void writeSifFileUndirWithWeights(ArrayList inter, String fileName) throws NullArgumentException {
        FileOutputStream fos = null;
        String path = System.getProperty("user.dir");
        String sep = System.getProperty("file.separator");
        path = BNConstants.getBaseFileLocation() + BNConstants.SEP + "tmp" + BNConstants.SEP;
        try {
            if (inter == null) {
                throw new NullArgumentException("Given inter was null!");
            }
            fos = new FileOutputStream(path + fileName);
            PrintWriter pw = new PrintWriter(fos, true);
            SimpleGeneEdge sGE = null;
            for (int i = 0; i < inter.size(); ++i) {
                sGE = (SimpleGeneEdge)inter.get(i);
                pw.println(sGE.getFrom() + " (pp) " + sGE.getTo() + " = " + sGE.getWeight());
            }
        }
        catch (IOException ioe) {
            System.out.println(ioe);
        }
    }

    public static void writeXgmmlFileUndir(ArrayList<SimpleGeneEdge> inter, String fileName, HashMap probeIndexAssocHash, IData data) throws NullArgumentException, IOException {
        FromWekaToSif.fromSimpleGeneEdgeToXgmml(false, inter, fileName, probeIndexAssocHash, data);
    }

    public static int[][] createAdjMatrix(ArrayList inter) throws NullArgumentException {
        if (inter == null) {
            throw new NullArgumentException("Given inter was null!");
        }
        ArrayList nodes = UsefulInteractions.getNodes(inter);
        int numNodes = nodes.size();
        int[][] adjMatrix = new int[numNodes][numNodes];
        for (int i = 0; i < numNodes; ++i) {
            for (int j = 0; j < numNodes; ++j) {
                adjMatrix[i][j] = UsefulInteractions.containsOneWay(inter, new SimpleGeneEdge((String)nodes.get(i), (String)nodes.get(j))) ? 1 : 0;
            }
        }
        return adjMatrix;
    }

    public static void printAdjMatrix(int[][] adjMatrix, int numNodes) {
        if (adjMatrix == null) {
            System.out.println("null");
        } else {
            for (int i = 0; i < numNodes; ++i) {
                for (int j = 0; j < numNodes; ++j) {
                    System.out.print(adjMatrix[i][j] + "\t");
                }
                System.out.println();
            }
            System.out.println();
        }
    }

    public static double[][] createWeightMatrix(ArrayList inter) throws NullArgumentException {
        if (inter == null) {
            throw new NullArgumentException("Given inter was null!");
        }
        ArrayList nodes = UsefulInteractions.getNodes(inter);
        int numNodes = nodes.size();
        double[][] weightMatrix = new double[numNodes][numNodes];
        SimpleGeneEdge sGE = null;
        for (int i = 0; i < numNodes; ++i) {
            for (int j = 0; j < numNodes; ++j) {
                sGE = new SimpleGeneEdge((String)nodes.get(i), (String)nodes.get(j));
                weightMatrix[i][j] = UsefulInteractions.containsOneWay(inter, sGE) ? sGE.getWeight() : Double.MAX_VALUE;
            }
        }
        return weightMatrix;
    }

    public static void printWeightMatrix(double[][] weightMatrix, int numNodes) {
        if (weightMatrix == null) {
            System.out.println("null");
        } else {
            for (int i = 0; i < numNodes; ++i) {
                for (int j = 0; j < numNodes; ++j) {
                    if (weightMatrix[i][j] == Double.MAX_VALUE) {
                        System.out.print("inf\t");
                        continue;
                    }
                    System.out.print(weightMatrix[i][j] + "\t");
                }
                System.out.println();
            }
            System.out.println();
        }
    }

    public static ArrayList getNodes(ArrayList inter) throws NullArgumentException {
        if (inter == null) {
            throw new NullArgumentException("Given inter was null!");
        }
        HashSet<String> nodes = new HashSet<String>();
        SimpleGeneEdge sGE = null;
        for (int i = 0; i < inter.size(); ++i) {
            sGE = (SimpleGeneEdge)inter.get(i);
            nodes.add(sGE.getFrom());
            nodes.add(sGE.getTo());
        }
        ArrayList<String> result = new ArrayList<String>();
        result.addAll(nodes);
        return result;
    }

    public static ArrayList getSubsetInteractionsGivenNodesOnlyWithin(ArrayList inter, ArrayList queryNodes) throws NullArgumentException {
        if (inter == null || queryNodes == null) {
            throw new NullArgumentException("At least one of given inter or queryNodes was null!\ninter=" + inter + "\nqueryNodes=" + queryNodes);
        }
        ArrayList<SimpleGeneEdge> result = new ArrayList<SimpleGeneEdge>();
        SimpleGeneEdge sGE = null;
        for (int i = 0; i < inter.size(); ++i) {
            sGE = (SimpleGeneEdge)inter.get(i);
            if (sGE.getFrom().equals(sGE.getTo()) || !queryNodes.contains(sGE.getFrom()) || !queryNodes.contains(sGE.getTo()) || UsefulInteractions.containsEitherWay(result, sGE)) continue;
            result.add(sGE);
        }
        return result;
    }

    public static ArrayList getSubsetInteractionsGivenNodes(ArrayList inter, ArrayList queryNodes) throws NullArgumentException {
        if (inter == null || queryNodes == null) {
            throw new NullArgumentException("At least one of given inter or queryNodes was null!\ninter=" + inter + "\nqueryNodes=" + queryNodes);
        }
        ArrayList<SimpleGeneEdge> result = new ArrayList<SimpleGeneEdge>();
        SimpleGeneEdge sGE = null;
        for (int i = 0; i < inter.size(); ++i) {
            sGE = (SimpleGeneEdge)inter.get(i);
            if (!queryNodes.contains(sGE.getFrom()) && !queryNodes.contains(sGE.getTo())) continue;
            result.add(sGE);
        }
        return result;
    }

    public static int[] getNeighbors(int u, ArrayList inter, ArrayList nodes) {
        SimpleGeneEdge sGE = null;
        ArrayList<String> neighbors = new ArrayList<String>();
        String uStr = null;
        uStr = (String)nodes.get(u);
        for (int i = 0; i < inter.size(); ++i) {
            sGE = (SimpleGeneEdge)inter.get(i);
            if (!uStr.equals(sGE.getFrom())) continue;
            neighbors.add(sGE.getTo());
        }
        int[] result = new int[neighbors.size()];
        String oneNeighbor = null;
        for (int i = 0; i < neighbors.size(); ++i) {
            oneNeighbor = (String)neighbors.get(i);
            result[i] = nodes.indexOf(oneNeighbor);
        }
        return result;
    }

    public static void compareUndirectedToDirectedGraph(ArrayList undirInter, ArrayList dirInter) throws NullArgumentException {
        int i;
        if (undirInter == null || dirInter == null) {
            throw new NullArgumentException("At least one of given interactions was null!\nundirInter=" + undirInter + "\ndirInter=" + dirInter);
        }
        SimpleGeneEdge sGE = null;
        ArrayList<SimpleGeneEdge> missing = new ArrayList<SimpleGeneEdge>();
        System.out.print("Missing edges: ");
        for (i = 0; i < undirInter.size(); ++i) {
            sGE = (SimpleGeneEdge)undirInter.get(i);
            if (UsefulInteractions.containsEitherWay(dirInter, sGE) || UsefulInteractions.containsEitherWay(missing, sGE)) continue;
            missing.add(sGE);
        }
        System.out.println(missing.size());
        for (i = 0; i < missing.size(); ++i) {
            sGE = (SimpleGeneEdge)missing.get(i);
            System.out.println(sGE);
        }
        int e = 0;
        System.out.println("Extra edges: ");
        for (int i2 = 0; i2 < dirInter.size(); ++i2) {
            sGE = (SimpleGeneEdge)dirInter.get(i2);
            if (UsefulInteractions.containsEitherWay(undirInter, sGE)) continue;
            System.out.println(sGE);
            ++e;
        }
        System.out.println("Extra edges: " + e);
    }

    public static ArrayList removeReverseEdge(ArrayList unionOfInter) {
        ArrayList<SimpleGeneEdge> edges = new ArrayList<SimpleGeneEdge>();
        for (int i = 0; i < unionOfInter.size(); ++i) {
            SimpleGeneEdge curEdge = (SimpleGeneEdge)unionOfInter.get(i);
            String from = curEdge.getFrom();
            String to = curEdge.getTo();
            if (to.equals("D") && from.equals("D")) continue;
            SimpleGeneEdge toFind = new SimpleGeneEdge(to, from);
            unionOfInter.set(i, new SimpleGeneEdge("D", "D"));
            int ind = unionOfInter.indexOf(toFind);
            if (ind != -1) {
                unionOfInter.set(ind, new SimpleGeneEdge("D", "D"));
            }
            edges.add(curEdge);
        }
        return edges;
    }

    public static ArrayList<SimpleGeneEdge> mergeInteractions(ArrayList<SimpleGeneEdge> networkSeedEdgeList, ArrayList<SimpleGeneEdge> lmDirEdges, boolean netSeedRules) {
        ArrayList<SimpleGeneEdge> searchWithin_list;
        ArrayList<SimpleGeneEdge> to_test_list;
        ArrayList<SimpleGeneEdge> edges = new ArrayList<SimpleGeneEdge>();
        if (netSeedRules) {
            to_test_list = lmDirEdges;
            searchWithin_list = networkSeedEdgeList;
            edges.addAll(networkSeedEdgeList);
        } else {
            to_test_list = networkSeedEdgeList;
            searchWithin_list = lmDirEdges;
            edges.addAll(lmDirEdges);
        }
        boolean add = true;
        for (int i = 0; i < to_test_list.size(); ++i) {
            SimpleGeneEdge curEdge = to_test_list.get(i);
            for (int ii = 0; ii < searchWithin_list.size(); ++ii) {
                if (!curEdge.equals(searchWithin_list.get(ii)) && !curEdge.reverseEquals(searchWithin_list.get(ii))) continue;
                add = false;
                break;
            }
            if (!add) continue;
            edges.add(curEdge);
        }
        return edges;
    }
}

