/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.bn;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.tigr.microarray.mev.cluster.clusterUtil.Cluster;
import org.tigr.microarray.mev.cluster.gui.IData;
import org.tigr.microarray.mev.cluster.gui.IFramework;
import org.tigr.microarray.mev.cluster.gui.impl.bn.BNConstants;
import org.tigr.microarray.mev.cluster.gui.impl.bn.NullArgumentException;

public class Useful {
    public static void checkFile(String fileName) throws FileNotFoundException {
        if (!new File(fileName).exists()) {
            throw new FileNotFoundException("File denoted by " + fileName + " does not exist!");
        }
    }

    public static HashSet readUniqueNamesFromFile(String fileName) throws FileNotFoundException {
        Useful.checkFile(fileName);
        try {
            HashSet<String> names = new HashSet<String>();
            FileReader fr = new FileReader(fileName);
            LineNumberReader lnr = new LineNumberReader(fr);
            String s = null;
            Object tokens = null;
            while ((s = lnr.readLine()) != null) {
                s = s.trim();
                names.add(s);
            }
            lnr.close();
            fr.close();
            return names;
        }
        catch (IOException ioe) {
            System.out.println(ioe);
            return null;
        }
    }

    public static ArrayList<String> readNamesFromFile(String fileName) throws FileNotFoundException {
        try {
            ArrayList<String> names = new ArrayList<String>();
            FileReader fr = new FileReader(fileName);
            LineNumberReader lnr = new LineNumberReader(fr);
            String s = null;
            while ((s = lnr.readLine()) != null) {
                s = s.trim();
                names.add(s);
            }
            lnr.close();
            fr.close();
            return names;
        }
        catch (IOException ioe) {
            System.out.println(ioe);
            return null;
        }
    }

    public static HashMap readHashMapFromFile(String fileName) throws FileNotFoundException {
        Useful.checkFile(fileName);
        try {
            HashMap<String, String> result = new HashMap<String, String>();
            FileReader fr = new FileReader(fileName);
            LineNumberReader lnr = new LineNumberReader(fr);
            String s = null;
            String[] tokens = null;
            while ((s = lnr.readLine()) != null) {
                tokens = (s = s.trim()).split("\t");
                if (tokens.length < 2) continue;
                result.put(tokens[0], tokens[1]);
            }
            lnr.close();
            fr.close();
            return result;
        }
        catch (IOException ioe) {
            System.out.println(ioe);
            return null;
        }
    }

    public static boolean find(ArrayList names, String toFind) throws NullArgumentException {
        if (names == null || toFind == null) {
            throw new NullArgumentException("At least one of the given names or toFind is null\nnames=" + names + "\ntoFind=" + toFind);
        }
        for (int i = 0; i < names.size(); ++i) {
            if (!((String)names.get(i)).equals(toFind)) continue;
            return true;
        }
        return false;
    }

    public static boolean find(HashSet names, String toFind) throws NullArgumentException {
        if (names == null || toFind == null) {
            throw new NullArgumentException("At least one of the given subsetOfKeys or toFind is null\nnames=" + names + "\ntoFind=" + toFind);
        }
        Iterator it = names.iterator();
        while (it.hasNext()) {
            if (!((String)it.next()).equals(toFind)) continue;
            return true;
        }
        return false;
    }

    public static void writeHashMapToPrintWriter(HashMap hm, PrintWriter pw) throws NullArgumentException {
        if (hm == null) {
            throw new NullArgumentException("Given HashMap is null!");
        }
        try {
            Set keys = hm.keySet();
            Iterator it = keys.iterator();
            String key = null;
            while (it.hasNext()) {
                key = (String)it.next();
                pw.println(key + "\t" + hm.get(key));
            }
            pw.close();
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    public static void writeHashMap(HashMap hm) throws NullArgumentException {
        if (hm == null) {
            throw new NullArgumentException("Given HashMap is null!");
        }
        Useful.writeHashMapToPrintWriter(hm, new PrintWriter(System.out, true));
    }

    public static void writeHashMapToFile(HashMap hm, String fileName) throws NullArgumentException {
        if (hm == null) {
            throw new NullArgumentException("Given HashMap is null!");
        }
        try {
            FileOutputStream fos = new FileOutputStream(fileName, true);
            PrintWriter pw = new PrintWriter(fos, true);
            Useful.writeHashMapToPrintWriter(hm, pw);
        }
        catch (IOException ioe) {
            System.out.println(ioe);
        }
    }

    public static void writeStrToFile(String toWrite, String fileName) throws NullArgumentException {
        if (toWrite == null) {
            throw new NullArgumentException("Given String toWrite is null!");
        }
        try {
            FileOutputStream fos = new FileOutputStream(fileName);
            PrintWriter pw = new PrintWriter(fos, true);
            pw.println(toWrite);
            pw.close();
            fos.close();
        }
        catch (IOException ioe) {
            System.out.println(ioe);
        }
    }

    public static String dec2bin(int dec, int numBits) {
        String decStr = Integer.toBinaryString(dec);
        while (decStr.length() < numBits) {
            decStr = "0" + decStr;
        }
        return decStr;
    }

    public static boolean contains(ArrayList al, Integer u) throws NullArgumentException {
        if (al == null || u == null) {
            throw new NullArgumentException("At least one of the given ArrayList al or Integer u is null\nal=" + al + "\nu=" + u);
        }
        for (int i = 0; i < al.size(); ++i) {
            if (!((Integer)al.get(i)).equals(u)) continue;
            return true;
        }
        return false;
    }

    public static HashSet getUniqueSymbols(HashMap gbSymbols) throws NullArgumentException {
        if (gbSymbols == null) {
            throw new NullArgumentException("Given HashMap gbSymbols was null!");
        }
        HashSet<String> uniqueSymbols = new HashSet<String>();
        Set keySet = gbSymbols.keySet();
        Iterator it = keySet.iterator();
        while (it.hasNext()) {
            uniqueSymbols.add((String)gbSymbols.get((String)it.next()));
        }
        return uniqueSymbols;
    }

    public static HashSet StringToHashSet(String s) {
        if (s == null) {
            return null;
        }
        s = s.trim();
        HashSet<String> hs = new HashSet<String>();
        String[] tokens = s.split(",");
        for (int i = 0; i < tokens.length; ++i) {
            tokens[i] = tokens[i].trim();
            hs.add(tokens[i]);
        }
        return hs;
    }

    public static String HashSetToString(HashSet hs) {
        if (hs == null || hs.size() == 0) {
            return null;
        }
        String s = "";
        Iterator it = hs.iterator();
        while (it.hasNext()) {
            s = s + (String)it.next() + ",";
        }
        return s.substring(0, s.length() - 1);
    }

    public static String getUniqueFileID() {
        Date now = new Date();
        String dateString = now.toString();
        SimpleDateFormat formatDt = new SimpleDateFormat("MMM_dd_yy_HHmmssSSS");
        dateString = formatDt.format(now);
        return dateString;
    }

    public static String getDateTime() {
        Date now = new Date();
        String dateString = now.toString();
        SimpleDateFormat formatDt = new SimpleDateFormat("MMM_dd_yy HH:mm:ss");
        dateString = formatDt.format(now);
        return dateString;
    }

    public static String getWekaArgs(String path, String outArffFileName, String sAlgorithm, boolean useArc, String numParents, String sType, int kfolds) {
        if (System.getProperty("os.name").toLowerCase().contains("win") && System.getProperty("user.dir").contains(" ")) {
            path = path.replace(System.getProperty("user.dir") + BNConstants.SEP, "");
        }
        String arguments = " -t " + path + outArffFileName + " -c 1 -x " + kfolds + " -Q weka.classifiers.bayes.net.search.local." + sAlgorithm + " -- ";
        if (useArc) {
            arguments = arguments + "-R";
        }
        arguments = arguments + " -P " + numParents + " -S " + sType;
        arguments = arguments + " -X " + path + "resultBif.xml";
        arguments = arguments + " -E weka.classifiers.bayes.net.estimate.SimpleEstimator -- -A 0.5";
        return arguments;
    }

    public static String[] getWekaArgsArray(String outArffFileName, String bifFile, String sAlgorithm, boolean useArc, String numParents, String sType, int kfolds) {
        ArrayList<String> args = new ArrayList<String>();
        args.add("");
        args.add("-t");
        args.add(outArffFileName);
        args.add("-c");
        args.add("1");
        args.add("-x");
        args.add(String.valueOf(kfolds));
        args.add("-Q");
        args.add("weka.classifiers.bayes.net.search.local." + sAlgorithm);
        args.add("--");
        if (useArc) {
            args.add("-R");
        }
        args.add("-P");
        args.add(numParents);
        args.add("-S");
        args.add(sType);
        args.add("-X");
        args.add(bifFile);
        args.add("-E");
        args.add("weka.classifiers.bayes.net.estimate.SimpleEstimator");
        args.add("--");
        args.add("-A");
        args.add("0.5");
        String[] argsWeka = args.toArray(new String[args.size()]);
        return argsWeka;
    }

    public static String[] getWekaArgsArrayForFixedFile(String outArffFileName, String bifFile, int kfolds) {
        ArrayList<String> args = new ArrayList<String>();
        args.add("");
        args.add("-t");
        args.add(outArffFileName);
        args.add("-c");
        args.add("1");
        args.add("-x");
        args.add(String.valueOf(kfolds));
        args.add("-Q");
        args.add("weka.classifiers.bayes.net.search.fixed.FromFile");
        args.add("--");
        args.add("-B");
        args.add(bifFile);
        args.add("-E");
        args.add("weka.classifiers.bayes.net.estimate.SimpleEstimator");
        args.add("--");
        args.add("-A");
        args.add("0.5");
        String[] argsWeka = args.toArray(new String[args.size()]);
        return argsWeka;
    }

    public static String getWekaArgsWithCPTs(String path, String outArffFileName, String sAlgorithm, boolean useArc, String numParents, String sType, int kfolds) {
        String arguments = " -t " + path + outArffFileName + " -c 1 -x " + kfolds + " -Q weka.classifiers.bayes.net.search.local." + sAlgorithm + " -- ";
        if (useArc) {
            arguments = arguments + "-R";
        }
        arguments = arguments + " -P " + numParents + " -S " + sType;
        arguments = arguments + " -X " + path + "resultBif.xml";
        arguments = arguments + " -E weka.classifiers.bayes.net.estimate.BMAEstimator -- -A 0.5";
        return arguments;
    }

    public static HashMap<String, String> converter(Cluster cl, IFramework framework, String path) throws Exception {
        int genes = cl.getIndices().length;
        IData data = framework.getData();
        int[] rows = new int[genes];
        rows = cl.getIndices();
        String[] probeId = new String[genes];
        String[] accList = new String[genes];
        HashMap<String, String> accHash = new HashMap<String, String>();
        HashMap<String, String> probeIndexAssocHash = new HashMap<String, String>();
        String lineRead = "";
        try {
            for (int i = 0; i < rows.length; ++i) {
                probeId[i] = data.getSlideDataElement(0, rows[i]).getFieldAt(0);
            }
            File file = new File(path, "affyID_accession.txt");
            FileReader fr = new FileReader(file);
            BufferedReader br = new BufferedReader(fr);
            br.readLine();
            br.readLine();
            while ((lineRead = br.readLine()) != null) {
                String[] fields = lineRead.split("\t");
                accHash.put(fields[0].trim(), fields[1].trim());
            }
            for (int i = 0; i < accList.length; ++i) {
                accList[i] = (String)accHash.get(probeId[i].trim());
                if (accList[i] == null) {
                    throw new Exception("UID " + probeId[i].trim() + " could not be mapped");
                }
                probeIndexAssocHash.put(accList[i], new Integer(rows[i]).toString() + "-" + probeId[i]);
            }
            if (probeIndexAssocHash.size() > 1) {
                probeIndexAssocHash.put("CLASS", "9999-CLASS");
            }
            Useful.writeAccToFile(accList, path);
            return probeIndexAssocHash;
        }
        catch (FileNotFoundException e) {
            System.out.println("File Not Found Error Useful.converter()");
            throw e;
        }
        catch (IOException e) {
            System.out.println("File Write Error Useful.converter()");
            throw e;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            System.out.println("Error Useful.converter()");
            throw e;
        }
        catch (Exception e) {
            throw e;
        }
    }

    private String[] matchSet(String[] accs, HashMap accHash) {
        String[] accList = new String[accs.length];
        for (int i = 0; i < accs.length; ++i) {
            accList[i] = (String)accHash.get(accs[i].trim());
        }
        return accList;
    }

    private static void writeAccToFile(String[] accList, String path) throws Exception {
        String outFile = path + BNConstants.SEP + "tmp" + BNConstants.SEP + "list.txt";
        PrintWriter out = null;
        int nRows = accList.length;
        try {
            out = new PrintWriter(new BufferedWriter(new FileWriter(outFile)));
            for (int row = 0; row < nRows; ++row) {
                out.print(accList[row]);
                out.print("\n");
            }
            out.flush();
            out.close();
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw e;
        }
    }

    public static void buildPropertyFile(boolean lit, boolean ppi, boolean kegg, boolean LitPpi, boolean LitKegg, boolean KeggPpi, boolean LitPpiKegg, boolean goTerms, String path, String keggSpecies, int numClasses, int numStates) {
        int fileSize = 8;
        String[] propFile = new String[8];
        String[] outFile = new String[7];
        propFile[0] = path + BNConstants.SEP + "tmp" + BNConstants.SEP + "getInterModLit.props";
        propFile[1] = path + BNConstants.SEP + "tmp" + BNConstants.SEP + "getInterModPPIDirectly.props";
        propFile[2] = path + BNConstants.SEP + "tmp" + BNConstants.SEP + "getInterModBoth.props";
        propFile[3] = path + BNConstants.SEP + "tmp" + BNConstants.SEP + "getInterModKegg.props";
        propFile[4] = path + BNConstants.SEP + "tmp" + BNConstants.SEP + "getInterModLitKegg.props";
        propFile[5] = path + BNConstants.SEP + "tmp" + BNConstants.SEP + "getInterModPpiKegg.props";
        propFile[6] = path + BNConstants.SEP + "tmp" + BNConstants.SEP + "getInterModLitPpiKegg.props";
        propFile[7] = path + BNConstants.SEP + "tmp" + BNConstants.SEP + "prepareXMLBifMod.props";
        outFile[0] = "outInteractionsLit.txt";
        outFile[1] = "outInteractionsPPI.txt";
        outFile[2] = "outInteractionsBoth.txt";
        outFile[3] = "outInteractionsKegg.txt";
        outFile[4] = "outInteractionsLitKegg.txt";
        outFile[5] = "outInteractionsPpiKegg.txt";
        outFile[6] = "outInteractionsLitPpiKegg.txt";
        PrintWriter out = null;
        try {
            if (LitPpiKegg) {
                out = new PrintWriter(new FileOutputStream(new File(propFile[6])));
                out.println("resourcererFileName=res.txt");
                out.println("gbAccessionsFileName=list.txt");
                out.println("kegg_sp=" + keggSpecies);
                out.println("symbolsArticlesFromPubmedFileName=symArtsPubmed.txt");
                out.println("symbolsArticlesFromGeneDbFileName=symArtsGeneDb.txt");
                out.println("articleRemovalThreshold=2");
                out.println("fromLiterature=true");
                out.println("fromPpi=true");
                out.println("fromKegg=true");
                out.println("outInteractionsFileName=" + outFile[2]);
                out.println("ppiFileName=all_ppi.txt");
                out.flush();
                out.close();
            } else if (KeggPpi) {
                out = new PrintWriter(new FileOutputStream(new File(propFile[5])));
                out.println("resourcererFileName=res.txt");
                out.println("gbAccessionsFileName=list.txt");
                out.println("kegg_sp=" + keggSpecies);
                out.println("symbolsArticlesFromPubmedFileName=symArtsPubmed.txt");
                out.println("symbolsArticlesFromGeneDbFileName=symArtsGeneDb.txt");
                out.println("articleRemovalThreshold=2");
                out.println("fromLiterature=false");
                out.println("fromPpi=true");
                out.println("fromKegg=true");
                out.println("outInteractionsFileName=" + outFile[5]);
                out.println("ppiFileName=all_ppi.txt");
                out.flush();
                out.close();
            } else if (LitKegg) {
                out = new PrintWriter(new FileOutputStream(new File(propFile[4])));
                out.println("resourcererFileName=res.txt");
                out.println("gbAccessionsFileName=list.txt");
                out.println("kegg_sp=" + keggSpecies);
                out.println("symbolsArticlesFromPubmedFileName=symArtsPubmed.txt");
                out.println("symbolsArticlesFromGeneDbFileName=symArtsGeneDb.txt");
                out.println("articleRemovalThreshold=2");
                out.println("fromLiterature=true");
                out.println("fromPpi=false");
                out.println("fromKegg=true");
                out.println("outInteractionsFileName=" + outFile[4]);
                out.flush();
                out.close();
            } else if (LitPpi) {
                out = new PrintWriter(new FileOutputStream(new File(propFile[2])));
                out.println("resourcererFileName=res.txt");
                out.println("gbAccessionsFileName=list.txt");
                out.println("symbolsArticlesFromPubmedFileName=symArtsPubmed.txt");
                out.println("symbolsArticlesFromGeneDbFileName=symArtsGeneDb.txt");
                out.println("articleRemovalThreshold=2");
                out.println("fromLiterature=true");
                out.println("fromPpi=true");
                out.println("fromKegg=false");
                out.println("outInteractionsFileName=" + outFile[2]);
                out.println("ppiFileName=all_ppi.txt");
                out.flush();
                out.close();
            } else if (lit) {
                out = new PrintWriter(new FileOutputStream(new File(propFile[0])));
                out.println("resourcererFileName=res.txt");
                out.println("gbAccessionsFileName=list.txt");
                out.println("symbolsArticlesFromPubmedFileName=symArtsPubmed.txt");
                out.println("symbolsArticlesFromGeneDbFileName=symArtsGeneDb.txt");
                out.println("articleRemovalThreshold=2");
                out.println("fromLiterature=true");
                out.println("fromPpi=false");
                out.println("fromKegg=false");
                out.println("outInteractionsFileName=" + outFile[0]);
                out.flush();
                out.close();
            } else if (kegg) {
                out = new PrintWriter(new FileOutputStream(new File(propFile[3])));
                out.println("resourcererFileName=res.txt");
                out.println("gbAccessionsFileName=list.txt");
                out.println("kegg_sp=" + keggSpecies);
                out.println("symbolsArticlesFromPubmedFileName=symArtsPubmed.txt");
                out.println("symbolsArticlesFromGeneDbFileName=symArtsGeneDb.txt");
                out.println("fromLiterature=false");
                out.println("fromPpi=false");
                out.println("fromKegg=true");
                out.println("outInteractionsFileName=" + outFile[3]);
                out.flush();
                out.close();
            } else if (ppi) {
                out = new PrintWriter(new FileOutputStream(new File(propFile[1])));
                out.println("resourcererFileName=res.txt");
                out.println("gbAccessionsFileName=list.txt");
                out.println("symbolsArticlesFromPubmedFileName=symArtsPubmed.txt");
                out.println("symbolsArticlesFromGeneDbFileName=symArtsGeneDb.txt");
                out.println("articleRemovalThreshold=2");
                out.println("fromLiterature=false");
                out.println("fromPpi=true");
                out.println("fromKegg=false");
                out.println("outInteractionsFileName=" + outFile[1]);
                out.println("usePpiDirectly=true");
                out.println("ppiFileName=all_ppi.txt");
                out.flush();
                out.close();
            }
            out = new PrintWriter(new FileOutputStream(new File(propFile[7])));
            if (goTerms) {
                out.println("useGo=true");
                out.println("gbGOsFileName=gbGO.txt");
            }
            out.println("namesFileName=list.txt");
            out.println("distributionFromWeights=true");
            out.println("outXMLBifFileName=resultBif.xml");
            out.println("numClasses=" + numClasses);
            out.println("numStates=" + numStates);
            if (LitPpiKegg) {
                out.println("sifFileName=" + outFile[6]);
            } else if (LitPpi) {
                out.println("sifFileName=" + outFile[2]);
            } else if (KeggPpi) {
                out.println("sifFileName=" + outFile[5]);
            } else if (LitKegg) {
                out.println("sifFileName=" + outFile[4]);
            } else if (KeggPpi) {
                out.println("sifFileName=" + outFile[5]);
            } else if (ppi) {
                out.println("sifFileName=" + outFile[1]);
            } else if (lit) {
                out.println("sifFileName=" + outFile[0]);
            } else if (kegg) {
                out.println("sifFileName=" + outFile[3]);
            }
            out.flush();
            out.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void createXmlBifPropFile(String fileLoc, int numClasses, int numStates) throws IOException {
        PrintWriter out = null;
        out = new PrintWriter(new FileOutputStream(new File(fileLoc)));
        out.println("namesFileName=list.txt");
        out.println("distributionFromWeights=true");
        out.println("outXMLBifFileName=resultBif.xml");
        out.println("numClasses=" + numClasses);
        out.println("numStates=" + numStates);
        out.flush();
        out.close();
    }

    private void buildPropertyFile(boolean lit, boolean ppi, boolean both, boolean goTerms, String path) {
        int fileSize = 4;
        String[] propFile = new String[4];
        String[] outFile = new String[3];
        propFile[0] = path + BNConstants.SEP + "tmp" + BNConstants.SEP + "getInterModLit.props";
        propFile[1] = path + BNConstants.SEP + "tmp" + BNConstants.SEP + "getInterModPPIDirectly.props";
        propFile[2] = path + BNConstants.SEP + "tmp" + BNConstants.SEP + "getInterModBoth.props";
        propFile[3] = path + BNConstants.SEP + "tmp" + BNConstants.SEP + "prepareXMLBifMod.props";
        outFile[0] = "outInteractionsLit.txt";
        outFile[1] = "outInteractionsPPI.txt";
        outFile[2] = "outInteractionsBoth.txt";
        PrintWriter out = null;
        try {
            if (lit) {
                out = new PrintWriter(new FileOutputStream(new File(propFile[0])));
                out.println("resourcererFileName=res.txt");
                out.println("gbAccessionsFileName=list.txt");
                out.println("symbolsArticlesFromPubmedFileName=symArtsPubmed.txt");
                out.println("symbolsArticlesFromGeneDbFileName=symArtsGeneDb.txt");
                out.println("articleRemovalThreshold=2");
                out.println("fromLiterature=true");
                out.println("fromPpi=false");
                out.println("outInteractionsFileName=" + outFile[0]);
                out.flush();
                out.close();
            }
            if (ppi) {
                out = new PrintWriter(new FileOutputStream(new File(propFile[1])));
                out.println("resourcererFileName=res.txt");
                out.println("gbAccessionsFileName=list.txt");
                out.println("symbolsArticlesFromPubmedFileName=symArtsPubmed.txt");
                out.println("symbolsArticlesFromGeneDbFileName=symArtsGeneDb.txt");
                out.println("articleRemovalThreshold=2");
                out.println("fromLiterature=false");
                out.println("fromPpi=true");
                out.println("outInteractionsFileName=" + outFile[1]);
                out.println("usePpiDirectly=true");
                out.println("ppiFileName=all_ppi.txt");
                out.flush();
                out.close();
            }
            if (both) {
                out = new PrintWriter(new FileOutputStream(new File(propFile[2])));
                out.println("resourcererFileName=res.txt");
                out.println("gbAccessionsFileName=list.txt");
                out.println("symbolsArticlesFromPubmedFileName=symArtsPubmed.txt");
                out.println("symbolsArticlesFromGeneDbFileName=symArtsGeneDb.txt");
                out.println("articleRemovalThreshold=2");
                out.println("fromLiterature=true");
                out.println("fromPpi=true");
                out.println("outInteractionsFileName=" + outFile[2]);
                out.println("ppiFileName=all_ppi.txt");
                out.flush();
                out.close();
            }
            out = new PrintWriter(new FileOutputStream(new File(propFile[3])));
            if (goTerms) {
                out.println("useGo=true");
                out.println("gbGOsFileName=gbGO.txt");
            }
            out.println("namesFileName=list.txt");
            out.println("distributionFromWeights=true");
            out.println("outXMLBifFileName=resultBif.xml");
            if (lit) {
                out.println("sifFileName=" + outFile[0]);
            } else if (ppi) {
                out.println("sifFileName=" + outFile[1]);
            } else if (both) {
                out.println("sifFileName=" + outFile[2]);
            }
            out.flush();
            out.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void copyDirectory(File srcDir, File dstDir) throws IOException {
        if (srcDir.isDirectory()) {
            if (!dstDir.exists()) {
                dstDir.mkdir();
            }
            String[] children = srcDir.list();
            for (int i = 0; i < children.length; ++i) {
                Useful.copyDirectory(new File(srcDir, children[i]), new File(dstDir, children[i]));
            }
        } else {
            Useful.copyFile(srcDir, dstDir);
        }
    }

    private static void copyFile(File src, File dst) throws IOException {
        int len;
        if (dst.exists()) {
            return;
        }
        FileInputStream in = new FileInputStream(src);
        FileOutputStream out = new FileOutputStream(dst);
        byte[] buf = new byte[1024];
        while ((len = ((InputStream)in).read(buf)) > 0) {
            ((OutputStream)out).write(buf, 0, len);
        }
        ((InputStream)in).close();
        ((OutputStream)out).close();
    }

    public static void cleanUpDir(String path) throws IOException {
        File dir = new File(path);
        if (!dir.exists()) {
            throw new IOException("Not a valid path " + path);
        }
        if (!dir.isDirectory()) {
            throw new IOException("Not a directory");
        }
        String[] children = dir.list();
        if (!dir.canWrite()) {
            throw new IOException("Insuficient permission to remove files " + path);
        }
        for (int i = 0; i < children.length; ++i) {
            boolean success;
            String filename = children[i];
            File f = new File(path + "/" + children[i] + "/");
            if (!f.isFile() || (success = f.delete())) continue;
            System.out.println("Unable to remove tmp File " + f.getAbsolutePath());
        }
    }
}

