/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.bn;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.PrintWriter;

public class Transpose {
    public static String[][] initializeMatrix() {
        String[][] matrix = new String[250][250];
        for (int i = 0; i < 250; ++i) {
            for (int j = 0; j < 250; ++j) {
                matrix[i][j] = null;
            }
        }
        return matrix;
    }

    public static String[][] readMatrix(String inFileName) {
        try {
            FileReader fr = new FileReader(new File(inFileName));
            LineNumberReader lnr = new LineNumberReader(fr);
            String s = null;
            String[] tokens = null;
            int i = 0;
            String[][] result = Transpose.initializeMatrix();
            while ((s = lnr.readLine()) != null) {
                s = s.trim();
                tokens = s.split("\t");
                for (int j = 0; j < tokens.length; ++j) {
                    result[i][j] = new String(tokens[j]);
                }
                ++i;
            }
            lnr.close();
            fr.close();
            return result;
        }
        catch (IOException ioe) {
            System.out.println(ioe);
            return null;
        }
    }

    public static void writeMatrix(String[][] matrix, String outFileName) {
        try {
            FileOutputStream fos = new FileOutputStream(new File(outFileName));
            PrintWriter pw = new PrintWriter(fos, true);
            boolean toggle = false;
            for (int i = 0; i < 250; ++i) {
                toggle = false;
                for (int j = 0; j < 250; ++j) {
                    if (matrix[i][j] == null) continue;
                    toggle = true;
                    if (j == 0) {
                        pw.print(matrix[i][j]);
                        continue;
                    }
                    pw.print("\t" + matrix[i][j]);
                }
                if (!toggle) continue;
                pw.println();
            }
        }
        catch (IOException ioe) {
            System.out.println(ioe);
        }
    }

    public static String[][] transposeMatrix(String[][] matrix) {
        String[][] transposedMatrix = Transpose.initializeMatrix();
        for (int i = 0; i < 250; ++i) {
            for (int j = 0; j < 250; ++j) {
                transposedMatrix[i][j] = matrix[j][i];
            }
        }
        return transposedMatrix;
    }

    public static void readAndWriteTranspose(String inFileName, String outFileName) {
        String[][] matrix = Transpose.readMatrix(inFileName);
        String[][] transposedMatrix = Transpose.transposeMatrix(matrix);
        Transpose.writeMatrix(transposedMatrix, outFileName);
    }

    public static void usage() {
        System.out.println("Usage: java Transpose inFileNameTabDelimited outFileNameTabDelimited\nExample: java Transpose expr_data_orig expr_data_transposed");
        System.exit(0);
    }

    public static void printMatrix(String[][] matrix) {
        boolean toggle = false;
        for (int i = 0; i < 250; ++i) {
            toggle = false;
            for (int j = 0; j < 250; ++j) {
                if (matrix[i][j] == null) continue;
                toggle = true;
                System.out.print(matrix[i][j] + "\t");
            }
            if (!toggle) continue;
            System.out.println();
        }
    }

    public static void test(String inFileName, String outFileName) {
        String[][] matrix = Transpose.readMatrix(inFileName);
        System.out.println("test read");
        Transpose.printMatrix(matrix);
        System.out.println("test write");
        Transpose.writeMatrix(matrix, "another_" + inFileName);
        System.out.println("test tranpose");
        String[][] transposedMatrix = Transpose.transposeMatrix(matrix);
        Transpose.printMatrix(transposedMatrix);
        System.out.println("test read and write transpose");
    }
}

