/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.bn;

import org.tigr.microarray.mev.annotation.IAnnotation;
import org.tigr.microarray.mev.cluster.gui.impl.bn.GeneEdge;

public class SimpleGeneEdge
extends GeneEdge {
    double weight = 1.0;
    IAnnotation annoFrom;
    IAnnotation annoTo;

    SimpleGeneEdge(String from, String to, IAnnotation frmA, IAnnotation toA) {
        this.from = from;
        this.to = to;
        this.annoFrom = frmA;
        this.annoTo = toA;
    }

    public SimpleGeneEdge(String from, String to) {
        this.createGeneEdge(from, to);
    }

    public SimpleGeneEdge(String from, String to, double weight) {
        this.createGeneEdge(from, to);
        this.weight = weight;
    }

    @Override
    public String toString() {
        String result = "(" + this.from + "," + this.to + ")=" + this.weight;
        return result;
    }

    public double getWeight() {
        return this.weight;
    }

    public String getEdgeAsString(String edgeConnector) {
        return this.from + " " + edgeConnector + " " + this.to;
    }

    public boolean equals(Object anotherObject) {
        SimpleGeneEdge edge = (SimpleGeneEdge)anotherObject;
        return edge.getFrom().equals(this.from) && edge.getTo().equals(this.to);
    }

    public boolean reverseEquals(Object anotherObject) {
        SimpleGeneEdge edge = (SimpleGeneEdge)anotherObject;
        return edge.getFrom().equals(this.to) && edge.getTo().equals(this.from);
    }

    public int compareTo(Object obj) {
        SimpleGeneEdge another = (SimpleGeneEdge)obj;
        if (this.weight < another.getWeight()) {
            return -1;
        }
        if (this.weight == another.getWeight()) {
            return 0;
        }
        return 1;
    }

    public IAnnotation getFromNodeAnntation() {
        return this.annoFrom;
    }

    public IAnnotation getToNodeAnntation() {
        return this.annoTo;
    }

    public void setFromNodeAnntation(IAnnotation fr) {
        this.annoFrom = fr;
    }

    public void setToNodeAnntation(IAnnotation to) {
        this.annoTo = to;
    }
}

