/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.bn;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Properties;
import org.tigr.microarray.mev.cluster.gui.impl.bn.BootstrapModule;
import org.tigr.microarray.mev.cluster.gui.impl.bn.NullArgumentException;
import org.tigr.microarray.mev.cluster.gui.impl.bn.OutOfRangeException;
import org.tigr.microarray.mev.cluster.gui.impl.bn.RenameStates;
import org.tigr.microarray.mev.cluster.gui.impl.bn.Transpose;
import org.tigr.microarray.mev.cluster.gui.impl.bn.Useful;
import org.tigr.microarray.mev.cluster.gui.impl.bn.WekaUtil;
import weka.core.Instances;
import weka.filters.Filter;
import weka.filters.unsupervised.attribute.Discretize;
import weka.filters.unsupervised.attribute.ReplaceMissingValues;

public class PrepareArrayDataModule {
    public static void transpose(String inFileName, String outFileName) {
        try {
            Useful.checkFile(inFileName);
            Transpose.readAndWriteTranspose(inFileName, outFileName);
        }
        catch (FileNotFoundException fnfe) {
            System.out.println(fnfe);
            fnfe.printStackTrace();
        }
    }

    public static Instances discretize(Instances data, String numBins) throws NullArgumentException, OutOfRangeException {
        if (data == null) {
            throw new NullArgumentException("Parameter data passed to discretize method was null!");
        }
        if (Integer.parseInt(numBins) <= 0) {
            throw new OutOfRangeException("numBins is out of range (should be strictly positive!\nnumBins=" + numBins);
        }
        try {
            String[] options = new String[]{"-B", numBins};
            Discretize discretize = new Discretize();
            discretize.setOptions(options);
            discretize.setInputFormat(data);
            Instances newData = Filter.useFilter((Instances)data, (Filter)discretize);
            return newData;
        }
        catch (Exception e) {
            System.out.println(e);
            e.printStackTrace();
            return null;
        }
    }

    public static Instances replaceMissingValues(Instances data) throws NullArgumentException {
        if (data == null) {
            throw new NullArgumentException("replace values passed to discretize method is null!");
        }
        try {
            ReplaceMissingValues replaceMissingValues = new ReplaceMissingValues();
            replaceMissingValues.setInputFormat(data);
            Instances newData = Filter.useFilter((Instances)data, (Filter)replaceMissingValues);
            return newData;
        }
        catch (Exception e) {
            System.out.println(e);
            e.printStackTrace();
            return null;
        }
    }

    public static Properties prepareArrayData(String fileName, String num, boolean bootStrap, int numIter, int numClasses) {
        try {
            Useful.checkFile(fileName);
            boolean isBootstrapStr = bootStrap;
            String outFileName = "outExpression.arff";
            String numBins = num;
            ArrayList<String> binLabels = new ArrayList<String>();
            for (int i = 0; i < Integer.parseInt(numBins); ++i) {
                binLabels.add("state" + i);
            }
            PrepareArrayDataModule.transpose(fileName, fileName.substring(0, fileName.length() - 4) + "_transposed.csv");
            Instances data = WekaUtil.readInstancesCSV(fileName.substring(0, fileName.length() - 4) + "_transposed.csv");
            Instances discreteData = PrepareArrayDataModule.discretize(data, numBins);
            discreteData.setClassIndex(0);
            Instances discreteAndCompleteData = PrepareArrayDataModule.replaceMissingValues(discreteData);
            Instances renamedStatesData = RenameStates.renameStates(discreteAndCompleteData, binLabels);
            Properties props = new Properties();
            if (isBootstrapStr) {
                props.setProperty("bootStrap", "true");
                props.setProperty("numBootstrapIterations", Integer.toString(numIter));
                props.setProperty("numBins", numBins);
                props.setProperty("rootOutputFileName", "boot_");
                props.setProperty("seed", "1");
                props.setProperty("class", Integer.toString(numClasses));
                for (int i = 0; i < Integer.parseInt(numBins); ++i) {
                    props.setProperty("binLabel" + i, "state" + i);
                }
                BootstrapModule.bootstrap(props, renamedStatesData);
                WekaUtil.writeDataToArffFile(discreteAndCompleteData, outFileName);
                return props;
            }
            WekaUtil.writeDataToArffFile(discreteAndCompleteData, outFileName);
            props.setProperty("bootStrap", "false");
            return props;
        }
        catch (OutOfRangeException oore) {
            oore.printStackTrace();
            return null;
        }
        catch (NullArgumentException nae) {
            nae.printStackTrace();
            return null;
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            return null;
        }
    }

    public static void usage() {
        System.out.println("Usage: java PrepareArrayDataModule propertiesFileName\nExample: java PrepareArrayDataModule prepareArrayData.props");
        System.exit(0);
    }
}

