/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.bn;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.Expression;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextPane;
import org.tigr.microarray.mev.cluster.gui.impl.GUIFactory;
import org.tigr.microarray.mev.cluster.gui.impl.ViewerAdapter;
import org.tigr.microarray.mev.cluster.gui.impl.bn.CytoscapeWebstart;

public class LMBNViewer
extends ViewerAdapter {
    protected static final String SHOW_CYTO_WEBSTART = "webstart-cytoscape-cmd";
    protected JPopupMenu popup;
    private JComponent header;
    private JTextPane content;
    private JLabel label;
    private Vector<String> networkFiles;
    private ArrayList<String> badItems;

    public LMBNViewer(Vector files) {
        this.header = this.createHeader();
        this.content = this.createContent(files);
        this.setNetworkFiles(files);
        this.setMaxWidth(this.content, this.header);
        this.createJPopupMenu();
        this.content.addMouseListener(new EvtListener());
    }

    public LMBNViewer(ArrayList<String> anyList) {
        this.header = this.createHeader();
        this.content = this.createContent(anyList);
        this.setBadItems(anyList);
        this.setMaxWidth(this.content, this.header);
    }

    public LMBNViewer(JComponent content, JComponent header) {
        this.content = (JTextPane)content;
        this.header = header;
        this.setMaxWidth(content, header);
        this.createJPopupMenu();
    }

    @Override
    public JComponent getContentComponent() {
        return this.content;
    }

    @Override
    public JComponent getHeaderComponent() {
        return this.header;
    }

    public JPopupMenu getJPopupMenu() {
        return this.popup;
    }

    private JComponent createHeader() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBackground(Color.white);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.insets = new Insets(10, 0, 10, 0);
        return panel;
    }

    private JTextPane createContent(ArrayList<String> anyList) {
        JTextPane area = new JTextPane();
        area.setContentType("text/html");
        area.setEditable(false);
        area.setMargin(new Insets(0, 0, 0, 0));
        Font font = new Font("San-Serif", 0, 10);
        area.setFont(font);
        String text = "<html><body bgcolor='#ECE5B6' ><font face='sanserif' color='#000000'>";
        text = text + "<h2>Un Mappable Metwork Seed Entries</h2>";
        text = text + "<ul>";
        text = text + "<li type='1'><table border='0' bgcolor='#F88017' width='90%'>";
        text = text + "<tr bgcolor='#C9BE62'>";
        text = text + "<th>#Item</th>";
        text = text + "<th>Value</th>";
        text = text + "</tr>";
        for (int i = 0; i < anyList.size(); ++i) {
            if (i % 2 == 0) {
                text = text + "<tr bgcolor='#ECD872'>";
                text = text + "<td>" + i + "</td>";
                text = text + "<td>" + anyList.get(i) + "</td>";
                text = text + "</tr>";
                continue;
            }
            text = text + "<tr bgcolor='#FFE87C'>";
            text = text + "<td>" + i + "</td>";
            text = text + "<td>" + anyList.get(i) + "</td>";
            text = text + "</tr>";
        }
        text = text + "</table></li>";
        text = text + "</font></body></html>";
        area.setText(text);
        area.setCaretPosition(0);
        this.label = new JLabel(text);
        return area;
    }

    private JTextPane createContent(Vector files) {
        JTextPane area = new JTextPane();
        area.setContentType("text/html");
        area.setEditable(false);
        area.setMargin(new Insets(0, 0, 0, 0));
        Font font = new Font("San-Serif", 0, 10);
        area.setFont(font);
        String text = "<html><body bgcolor='#ECE5B6' ><font face='sanserif' color='#000000'>";
        text = text + "<h2>LM/BN Network Files</h2>";
        text = text + "<ul>";
        text = text + "<li type='1'><table border='0' bgcolor='#F88017' width='90%'>";
        text = text + "<tr bgcolor='#C9BE62'>";
        text = text + "<th>File Description</th>";
        text = text + "<th>File Location</th>";
        text = text + "</tr>";
        if (files.size() >= 1) {
            text = text + "<tr bgcolor='#FFE87C'>";
            text = text + "<td>Literature Mining Network File</td>";
            text = text + "<td>" + files.get(0) + "</td>";
            text = text + "</tr>";
        }
        if (files.size() >= 2) {
            text = text + "<tr bgcolor='#ECD872'>";
            text = text + "<td>BN File for Observed Data</td>";
            text = text + "<td>" + files.get(1) + "</td>";
            text = text + "</tr>";
        }
        if (files.size() >= 3) {
            text = text + "<tr bgcolor='#FFE87C'>";
            text = text + "<td>BN File from bootstrap Data with user chosen Conf. Threshold</td>";
            text = text + "<td>" + files.get(2) + "</td>";
            text = text + "</tr>";
        }
        text = text + "</table></li>";
        text = text + "</ul>";
        if (files.size() > 3) {
            text = text + "<h2>BN File from Bootstrap data</h2>";
            text = text + "<ul>";
            text = text + "<li type='1'><table border='0' bgcolor='#F88017' width='90%'>";
            text = text + "<tr bgcolor='#C9BE62'>";
            text = text + "<th>File Description</th>";
            text = text + "<th>File Location</th>";
            text = text + "</tr>";
            for (int i = 3; i < files.size(); ++i) {
                if (i % 2 == 0) {
                    text = text + "<tr bgcolor='#ECD872'>";
                    text = text + "<td>BN File from bootstrap Data with user chosen Conf. Threshold</td>";
                    text = text + "<td>" + files.get(i) + "</td>";
                    text = text + "</tr>";
                    continue;
                }
                text = text + "<tr bgcolor='#FFE87C'>";
                text = text + "<td>BN File from bootstrap Data with user chosen Conf. Threshold</td>";
                text = text + "<td>" + files.get(i) + "</td>";
                text = text + "</tr>";
            }
            text = text + "</table></li>";
        }
        text = text + "</font></body></html>";
        area.setText(text);
        area.setCaretPosition(0);
        this.label = new JLabel(text);
        return area;
    }

    private void setMaxWidth(JComponent content, JComponent header) {
        int c_width = content.getPreferredSize().width;
        int h_width = header.getPreferredSize().width;
        if (c_width > h_width) {
            header.setPreferredSize(new Dimension(c_width, header.getPreferredSize().height));
        } else {
            content.setPreferredSize(new Dimension(h_width, content.getPreferredSize().height));
        }
    }

    @Override
    public JComponent getRowHeaderComponent() {
        return null;
    }

    private void onWebstartCytoscape() {
        CytoscapeWebstart.onWebstartCytoscapeBN(this.getNetworkFiles());
    }

    private void createJPopupMenu() {
        this.popup = new JPopupMenu();
        JMenuItem menuItem = new JMenuItem("Webstart Cytoscape", GUIFactory.getIcon("new16.gif"));
        menuItem.setEnabled(true);
        menuItem.setActionCommand(SHOW_CYTO_WEBSTART);
        menuItem.addActionListener(new EvtListener());
        this.popup.add(menuItem);
    }

    protected JMenuItem getJMenuItem(String command) {
        Component[] components = this.popup.getComponents();
        for (int i = 0; i < components.length; ++i) {
            if (!(components[i] instanceof JMenuItem) || !((JMenuItem)components[i]).getActionCommand().equals(command)) continue;
            return (JMenuItem)components[i];
        }
        return null;
    }

    protected void setEnableMenuItem(String command, boolean enable) {
        JMenuItem item = this.getJMenuItem(command);
        if (item == null) {
            return;
        }
        item.setEnabled(enable);
    }

    public void setNetworkFiles(Vector files) {
        this.networkFiles = files;
    }

    public Vector getNetworkFiles() {
        return this.networkFiles;
    }

    public void setBadItems(ArrayList<String> anyList) {
        this.badItems = anyList;
    }

    public ArrayList<String> getBadItems() {
        return this.badItems;
    }

    @Override
    public Expression getExpression() {
        return new Expression(this, this.getClass(), "new", new Object[]{this.networkFiles});
    }

    private class EvtListener
    extends MouseAdapter
    implements ActionListener {
        private EvtListener() {
        }

        @Override
        public void mousePressed(MouseEvent me) {
            if (me.isPopupTrigger()) {
                LMBNViewer.this.popup.show(LMBNViewer.this.content, me.getX(), me.getY());
            }
        }

        @Override
        public void mouseReleased(MouseEvent me) {
            if (me.isPopupTrigger()) {
                LMBNViewer.this.popup.show(LMBNViewer.this.content, me.getX(), me.getY());
            }
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            if (ae.getActionCommand().equals(LMBNViewer.SHOW_CYTO_WEBSTART)) {
                LMBNViewer.this.onWebstartCytoscape();
            }
        }
    }
}

