/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.bn;

import java.io.FileNotFoundException;
import java.util.ArrayList;
import org.tigr.microarray.mev.cluster.gui.impl.bn.NullArgumentException;
import org.tigr.microarray.mev.cluster.gui.impl.bn.SimpleGeneEdge;
import org.tigr.microarray.mev.cluster.gui.impl.bn.Useful;
import org.tigr.microarray.mev.cluster.gui.impl.bn.UsefulInteractions;

public class GetUnionOfInters {
    public static ArrayList uniquelyMergeArrayLists(ArrayList al1, ArrayList al2) throws NullArgumentException {
        int i;
        if (al1 == null || al2 == null) {
            throw new NullArgumentException("At least one the arguments ArrayLists was null: al1=" + al1 + "al2=" + al2);
        }
        ArrayList<SimpleGeneEdge> toWrite = new ArrayList<SimpleGeneEdge>();
        SimpleGeneEdge sGE = null;
        for (i = 0; i < al1.size(); ++i) {
            sGE = (SimpleGeneEdge)al1.get(i);
            if (UsefulInteractions.containsEitherWay(toWrite, sGE)) continue;
            toWrite.add(sGE);
            toWrite.add(new SimpleGeneEdge(sGE.getTo(), sGE.getFrom(), sGE.getWeight()));
        }
        for (i = 0; i < al2.size(); ++i) {
            sGE = (SimpleGeneEdge)al2.get(i);
            if (UsefulInteractions.containsEitherWay(toWrite, sGE)) continue;
            toWrite.add(sGE);
            toWrite.add(new SimpleGeneEdge(sGE.getTo(), sGE.getFrom(), sGE.getWeight()));
        }
        if (toWrite.size() == 0) {
            return null;
        }
        return toWrite;
    }

    public static void test(String interFileName1, String interFileName2, String outUnionOfInterFileName) {
        try {
            Useful.checkFile(interFileName1);
            Useful.checkFile(interFileName2);
            ArrayList al1 = UsefulInteractions.readInteractionsWithWeights(interFileName1);
            ArrayList al2 = UsefulInteractions.readInteractionsWithWeights(interFileName2);
            UsefulInteractions.writeSifFileUndirWithWeights(GetUnionOfInters.uniquelyMergeArrayLists(al1, al2), outUnionOfInterFileName);
        }
        catch (FileNotFoundException fnfe) {
            System.out.println(fnfe);
        }
        catch (NullArgumentException nae) {
            System.out.println(nae);
        }
    }

    public static void usage() {
        System.out.println("Usage: java GetUnionOfInters interWithWeights1 interWithWeights2 outUnionInterWithWeights");
        System.exit(0);
    }

    public static void main(String[] argv) {
        if (argv.length != 3) {
            GetUnionOfInters.usage();
        }
        String interFileName1 = argv[0];
        String interFileName2 = argv[1];
        String outUnionOfInterFileName = argv[2];
        GetUnionOfInters.test(interFileName1, interFileName2, outUnionOfInterFileName);
    }
}

