/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.bn;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import org.tigr.microarray.mev.cluster.gui.IData;
import org.tigr.microarray.mev.cluster.gui.impl.bn.BNConstants;
import org.tigr.microarray.mev.cluster.gui.impl.bn.BifDOMBuilder;
import org.tigr.microarray.mev.cluster.gui.impl.bn.BifNode;
import org.tigr.microarray.mev.cluster.gui.impl.bn.NullArgumentException;
import org.tigr.microarray.mev.cluster.gui.impl.bn.SimpleGeneEdge;
import org.tigr.microarray.mev.cluster.gui.impl.bn.XGMMLGenerator;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class FromWekaToSif {
    public static void fromWekaBifToSif(String xmlBifStr, PrintWriter pw) throws SAXException, IOException {
        BifDOMBuilder bifDom = new BifDOMBuilder();
        ArrayList<BifNode> bifNodes = bifDom.build(new InputSource(new StringReader(xmlBifStr)));
        Hashtable<String, String> uniqueNodesIdMap = new Hashtable<String, String>();
        int nodesId = 1;
        for (int c = 0; c < bifNodes.size(); ++c) {
            BifNode _tmpBifNode = bifNodes.get(c);
            String labelTo = _tmpBifNode.getChild();
            if (!uniqueNodesIdMap.containsKey(labelTo)) {
                uniqueNodesIdMap.put(labelTo, String.valueOf(nodesId));
                ++nodesId;
            }
            for (int p = 0; p < _tmpBifNode.numParents(); ++p) {
                String labelFrom = _tmpBifNode.getParentAt(p);
                if (!uniqueNodesIdMap.containsKey(labelFrom)) {
                    uniqueNodesIdMap.put(labelFrom, String.valueOf(nodesId));
                    ++nodesId;
                }
                pw.println(labelFrom + " pd " + labelTo);
            }
        }
    }

    public static void fromWekaToSif(String evalStr, PrintWriter pw, boolean map) {
        String[] evalSubstrings = evalStr.split("\n");
        String s = null;
        boolean toProcess = false;
        for (int i = 0; i < evalSubstrings.length; ++i) {
            s = evalSubstrings[i];
            if ((s = s.trim()).startsWith("LogScore")) {
                toProcess = false;
            }
            if (toProcess) {
                FromWekaToSif.fromWekaToSifOneLine(s, pw);
            }
            if (!s.startsWith("Network structure")) continue;
            toProcess = true;
        }
    }

    public static void fromWekaToSifOneLine(String s, PrintWriter pw) {
        String from;
        if (s.endsWith(":")) {
            return;
        }
        int colon = s.indexOf("(");
        String to = s.substring(0, colon).trim();
        int startIndex = s.indexOf("): ") + 3;
        int index = 0;
        while (index != s.lastIndexOf(" ") && (index = s.indexOf(" ", startIndex + 1)) != -1) {
            from = s.substring(startIndex, index).trim();
            pw.println(from + " pd " + to);
            startIndex = index;
        }
        from = s.substring(startIndex, s.length()).trim();
        pw.println(from + " pd " + to);
    }

    public static void fromWekaToXgmml2(boolean dir, String evalStr, String fileName, String cptFile, boolean b, HashMap probeIndexAssocHash, IData data, String interactionType) throws NullArgumentException, IOException {
        if (probeIndexAssocHash == null) {
            throw new NullArgumentException("Given Probe-Index Hash was null!");
        }
        Hashtable<String, String> uniqueNodesWithId = new Hashtable<String, String>();
        Vector<String> edges = new Vector<String>();
        String xgmmlContent = "";
        String label = fileName.substring(fileName.lastIndexOf(BNConstants.SEP) + 1, fileName.lastIndexOf("."));
        xgmmlContent = XGMMLGenerator.createHeader(label, cptFile);
        String[] evalSubstrings = evalStr.split("\n");
        String s = null;
        boolean toProcess = false;
        Vector<String> nodes = new Vector<String>();
        for (int i = 0; i < evalSubstrings.length; ++i) {
            Vector<String> _tmpEdges;
            s = evalSubstrings[i];
            if ((s = s.trim()).startsWith("LogScore")) {
                toProcess = false;
            }
            if (toProcess && (_tmpEdges = FromWekaToSif.fromWekaToNodes(s)) != null && _tmpEdges.size() != 0) {
                edges.addAll(_tmpEdges);
                Iterator<String> _itr = _tmpEdges.iterator();
                while (_itr.hasNext()) {
                    String[] fromTo = _itr.next().split("-");
                    if (!nodes.contains(fromTo[0].trim())) {
                        nodes.add(fromTo[0].trim());
                    }
                    if (nodes.contains(fromTo[1].trim())) continue;
                    nodes.add(fromTo[1].trim());
                }
                int nodeId = nodes.size();
                Iterator _itr1 = nodes.iterator();
                while (_itr1.hasNext()) {
                    uniqueNodesWithId.put((String)_itr1.next(), String.valueOf(nodeId * -1));
                    --nodeId;
                }
                String _tmp = FromWekaToSif.getXgmmlNodesAndEdges(dir, edges, "-", uniqueNodesWithId, probeIndexAssocHash, data);
                if (_tmp != null) {
                    xgmmlContent = xgmmlContent + _tmp;
                }
            }
            if (!s.startsWith("Network structure")) continue;
            toProcess = true;
        }
        xgmmlContent = xgmmlContent + XGMMLGenerator.getFooter();
        XGMMLGenerator.writeFileXGMML(fileName, xgmmlContent);
    }

    public static void fromWekaBifToXgmml(boolean dir, String bifStr, String fileName, String cptFileName, HashMap probeIndexAssocHash, IData data) throws NullArgumentException, IOException, SAXException {
        BifDOMBuilder bifDom = new BifDOMBuilder();
        ArrayList<BifNode> bifNodes = bifDom.build(new InputSource(new StringReader(bifStr)));
        String xgmmlContent = "";
        String label = fileName.substring(fileName.lastIndexOf(BNConstants.SEP) + 1, fileName.lastIndexOf("."));
        xgmmlContent = XGMMLGenerator.createHeader(label, cptFileName);
        String xgmmlNodes = "";
        String xgmmlEdges = "";
        Hashtable<String, String> uniqueNodesIdMap = new Hashtable<String, String>();
        int nodesId = 1;
        for (int c = 0; c < bifNodes.size(); ++c) {
            BifNode _tmpBifNode = bifNodes.get(c);
            String labelTo = _tmpBifNode.getChild();
            if (!uniqueNodesIdMap.containsKey(labelTo)) {
                uniqueNodesIdMap.put(labelTo, String.valueOf(nodesId));
                ++nodesId;
                xgmmlNodes = xgmmlNodes + FromWekaToSif.getXgmmlNode(labelTo, uniqueNodesIdMap, probeIndexAssocHash, data);
            }
            for (int p = 0; p < _tmpBifNode.numParents(); ++p) {
                String labelFrom = _tmpBifNode.getParentAt(p);
                if (!uniqueNodesIdMap.containsKey(labelFrom)) {
                    uniqueNodesIdMap.put(labelFrom, String.valueOf(nodesId));
                    ++nodesId;
                    xgmmlNodes = xgmmlNodes + FromWekaToSif.getXgmmlNode(labelFrom, uniqueNodesIdMap, probeIndexAssocHash, data);
                }
                xgmmlEdges = xgmmlEdges + FromWekaToSif.getXgmmlEdge(dir, labelFrom, labelTo, uniqueNodesIdMap);
            }
        }
        xgmmlContent = xgmmlContent + xgmmlNodes;
        xgmmlContent = xgmmlContent + xgmmlEdges;
        xgmmlContent = xgmmlContent + XGMMLGenerator.getFooter();
        XGMMLGenerator.writeFileXGMML(fileName, xgmmlContent);
    }

    public static void fromWekaBifToXgmml(Hashtable edgesTable, int numItr, float confThreshold, String fileName, HashMap probeIndexAssocHash, IData data) throws NullArgumentException, IOException {
    }

    public static void fromWekaToXgmml(boolean dir, String evalStr, String fileName, String cptFileName, boolean b, HashMap probeIndexAssocHash, IData data, String interactionType) throws NullArgumentException, IOException {
        if (probeIndexAssocHash == null) {
            throw new NullArgumentException("Given Probe-Index Hash was null!");
        }
        Vector<String> edges = new Vector<String>();
        String xgmmlContent = "";
        String label = fileName.substring(fileName.lastIndexOf(BNConstants.SEP) + 1, fileName.lastIndexOf("."));
        xgmmlContent = XGMMLGenerator.createHeader(label, cptFileName);
        String[] evalSubstrings = evalStr.split("\n");
        String s = null;
        boolean toProcess = false;
        Vector nodes = new Vector();
        for (int i = 0; i < evalSubstrings.length; ++i) {
            Vector<String> _tmpEdges;
            s = evalSubstrings[i];
            if ((s = s.trim()).startsWith("LogScore")) {
                toProcess = false;
            }
            if (toProcess && (_tmpEdges = FromWekaToSif.fromWekaToNodes(s)) != null) {
                edges.addAll(_tmpEdges);
            }
            if (!s.startsWith("Network structure")) continue;
            toProcess = true;
        }
        Hashtable<String, String> uniqueNodesIdMap = new Hashtable<String, String>();
        Vector<String> nodeCreated = new Vector<String>();
        String xgmmlEdges = "";
        Iterator _itr1 = edges.iterator();
        int nodesId = 1;
        while (_itr1.hasNext()) {
            String[] _nodes = ((String)_itr1.next()).split("-");
            String labelFrom = _nodes[0].trim();
            String labelTo = _nodes[1].trim();
            if (!uniqueNodesIdMap.containsKey(labelFrom)) {
                uniqueNodesIdMap.put(labelFrom, String.valueOf(nodesId));
                ++nodesId;
            }
            if (!uniqueNodesIdMap.containsKey(labelTo)) {
                uniqueNodesIdMap.put(labelTo, String.valueOf(nodesId));
                ++nodesId;
            }
            if (!nodeCreated.contains(labelFrom)) {
                xgmmlContent = xgmmlContent + FromWekaToSif.getXgmmlNode(labelFrom, uniqueNodesIdMap, probeIndexAssocHash, data);
                nodeCreated.add(labelFrom);
            }
            if (!nodeCreated.contains(labelTo)) {
                xgmmlContent = xgmmlContent + FromWekaToSif.getXgmmlNode(labelTo, uniqueNodesIdMap, probeIndexAssocHash, data);
                nodeCreated.add(labelTo);
            }
            xgmmlEdges = xgmmlEdges + FromWekaToSif.getXgmmlEdge(dir, labelFrom, labelTo, uniqueNodesIdMap);
        }
        xgmmlContent = xgmmlContent + xgmmlEdges;
        xgmmlContent = xgmmlContent + XGMMLGenerator.getFooter();
        XGMMLGenerator.writeFileXGMML(fileName, xgmmlContent);
    }

    public static void fromWekaToXgmml(boolean dir, Hashtable edgesTable, String cptFileName, int numItr, float confThreshold, String fileName, HashMap probeIndexAssocHash, IData data, String interactionType) throws NullArgumentException, IOException {
        if (probeIndexAssocHash == null) {
            throw new NullArgumentException("Given Probe-Index Hash was null!");
        }
        Hashtable<String, String> uniqueNodesWithId = new Hashtable<String, String>();
        Vector<String> edges = new Vector<String>();
        Vector<String> nodes = new Vector<String>();
        String xgmmlContent = "";
        String label = fileName.substring(fileName.lastIndexOf(BNConstants.SEP) + 1, fileName.lastIndexOf("."));
        xgmmlContent = XGMMLGenerator.createHeader(label, cptFileName);
        Enumeration enumerate = edgesTable.keys();
        while (enumerate.hasMoreElements()) {
            String edge = (String)enumerate.nextElement();
            Integer count = (Integer)edgesTable.get(edge);
            float presence = count.floatValue() / (float)numItr;
            if (!(presence >= confThreshold)) continue;
            edges.add(edge);
            String[] fromTo = edge.split("pd");
            if (!nodes.contains(fromTo[0].trim())) {
                nodes.add(fromTo[0].trim());
            }
            if (nodes.contains(fromTo[1].trim())) continue;
            nodes.add(fromTo[1].trim());
        }
        int nodeId = nodes.size();
        Iterator _itr = nodes.iterator();
        while (_itr.hasNext()) {
            uniqueNodesWithId.put((String)_itr.next(), String.valueOf(nodeId * -1));
            --nodeId;
        }
        String _tmp = FromWekaToSif.getXgmmlNodesAndEdges(dir, edges, "pd", uniqueNodesWithId, probeIndexAssocHash, data);
        if (_tmp != null && !_tmp.equals("")) {
            xgmmlContent = xgmmlContent + _tmp;
        }
        xgmmlContent = xgmmlContent + XGMMLGenerator.getFooter();
        XGMMLGenerator.writeFileXGMML(fileName, xgmmlContent);
    }

    private static String getXgmmlNode(String nodelabel, Hashtable probeIdMap, HashMap probeIndexAssocHash, IData data) {
        String xgmmlNodeContent = "";
        String xgmmlEdgeContent = "";
        if (nodelabel.trim().equals("CLASS")) {
            xgmmlNodeContent = XGMMLGenerator.createClassNode(nodelabel, (String)probeIdMap.get(nodelabel), data);
            return xgmmlNodeContent;
        }
        String[] tmp = ((String)probeIndexAssocHash.get(nodelabel)).split("-");
        int probeInd = Integer.parseInt(tmp[0]);
        xgmmlNodeContent = XGMMLGenerator.createNode(nodelabel, (String)probeIdMap.get(nodelabel), data, probeInd);
        return xgmmlNodeContent;
    }

    private static String getXgmmlEdge(boolean dir, String labelFrom, String labelTo, Hashtable probeIdMap) {
        String xgmmlEdgeContent = "";
        xgmmlEdgeContent = xgmmlEdgeContent + XGMMLGenerator.createEdge(dir, labelFrom, labelTo, (String)probeIdMap.get(labelFrom), (String)probeIdMap.get(labelTo));
        return xgmmlEdgeContent;
    }

    private static String getXgmmlNodesAndEdges(boolean dir, Vector edges, String nodeConnector, Hashtable nodesWithId, HashMap probeIndexAssocHash, IData data) {
        String xgmmlNodeContent = "";
        String xgmmlEdgeContent = "";
        Vector<String> nodeCreated = new Vector<String>();
        int[] fromTo = new int[2];
        Enumeration myEnum = edges.elements();
        while (myEnum.hasMoreElements()) {
            String[] nodes = ((String)myEnum.nextElement()).split(nodeConnector);
            String labelFrom = nodes[0].trim();
            String labelTo = nodes[1].trim();
            String[] tmp = ((String)probeIndexAssocHash.get(labelFrom)).split("-");
            fromTo[0] = Integer.parseInt(tmp[0]);
            tmp = ((String)probeIndexAssocHash.get(labelTo)).split("-");
            fromTo[1] = Integer.parseInt(tmp[0]);
            String srcId = (String)nodesWithId.get(labelFrom);
            if (!nodeCreated.contains(labelFrom)) {
                xgmmlNodeContent = labelFrom.equals("CLASS") ? xgmmlNodeContent + XGMMLGenerator.createClassNode(labelFrom, srcId, data) : xgmmlNodeContent + XGMMLGenerator.createNode(labelFrom, srcId, data, fromTo[0]);
                nodeCreated.add(labelFrom);
            }
            String tgtId = (String)nodesWithId.get(labelTo);
            if (!nodeCreated.contains(labelTo)) {
                xgmmlNodeContent = labelTo.equals("CLASS") ? xgmmlNodeContent + XGMMLGenerator.createClassNode(labelTo, tgtId, data) : xgmmlNodeContent + XGMMLGenerator.createNode(labelTo, tgtId, data, fromTo[1]);
                nodeCreated.add(labelTo);
            }
            xgmmlEdgeContent = xgmmlEdgeContent + XGMMLGenerator.createEdge(dir, labelFrom, labelTo, srcId, tgtId);
        }
        xgmmlNodeContent = xgmmlNodeContent + xgmmlEdgeContent;
        return xgmmlNodeContent;
    }

    public static void fromSimpleGeneEdgeToXgmml(boolean dir, ArrayList<SimpleGeneEdge> inter, String fileName, HashMap probeIndexAssocHash, IData data) throws NullArgumentException, IOException {
        if (inter == null) {
            System.out.println("UsefulInteractions-writeSif");
            throw new NullArgumentException("Given inter was null!");
        }
        if (probeIndexAssocHash == null) {
            throw new NullArgumentException("Given Probe-Index Hash was null!");
        }
        Hashtable<String, String> uniqueNodesWithId = new Hashtable<String, String>();
        Vector<String> edges = new Vector<String>();
        Vector<String> nodes = new Vector<String>();
        SimpleGeneEdge sGE = null;
        String xgmmlContent = "";
        String label = fileName.substring(0, fileName.lastIndexOf("."));
        xgmmlContent = XGMMLGenerator.createHeader(label, "");
        for (int i = 0; i < inter.size(); ++i) {
            sGE = inter.get(i);
            String labelFrom = sGE.getFrom().trim();
            String labelTo = sGE.getTo().trim();
            edges.add(sGE.getEdgeAsString("pd"));
            if (!nodes.contains(labelFrom.trim())) {
                nodes.add(labelFrom.trim());
            }
            if (nodes.contains(labelTo.trim())) continue;
            nodes.add(labelTo.trim());
        }
        int nodeId = nodes.size();
        Iterator _itr = nodes.iterator();
        while (_itr.hasNext()) {
            uniqueNodesWithId.put((String)_itr.next(), String.valueOf(nodeId * -1));
            --nodeId;
        }
        String _tmp = FromWekaToSif.getXgmmlNodesAndEdges(dir, edges, "pd", uniqueNodesWithId, probeIndexAssocHash, data);
        if (_tmp != null && !_tmp.equals("")) {
            xgmmlContent = xgmmlContent + _tmp;
        }
        xgmmlContent = xgmmlContent + XGMMLGenerator.getFooter();
        XGMMLGenerator.writeFileXGMML(fileName, xgmmlContent);
    }

    private static Vector<String> fromWekaToNodes(String s) {
        String labelFrom;
        if (s.endsWith(":")) {
            return null;
        }
        Vector<String> edges = new Vector<String>();
        int colon = s.indexOf("(");
        String labelTo = s.substring(0, colon).trim();
        int startIndex = s.indexOf("): ") + 3;
        int index = 0;
        while (index != s.lastIndexOf(" ") && (index = s.indexOf(" ", startIndex + 1)) != -1) {
            labelFrom = s.substring(startIndex, index).trim();
            edges.add(labelFrom + "-" + labelTo);
            startIndex = index;
        }
        labelFrom = s.substring(startIndex, s.length()).trim();
        edges.add(labelFrom + "-" + labelTo);
        return edges;
    }
}

