/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.bn;

import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.PrintWriter;
import java.util.ArrayList;

public class FixStates {
    public static void fixStates(String inFileName, ArrayList binLabelsToLookFor, String extension) {
        try {
            FileReader fr = new FileReader(inFileName);
            LineNumberReader lnr = new LineNumberReader(fr);
            String s = null;
            FileOutputStream fos = new FileOutputStream(inFileName + extension);
            PrintWriter pw = new PrintWriter(fos, true);
            String binLabelsToLookForStr = "{";
            for (int i = 0; i < binLabelsToLookFor.size() - 1; ++i) {
                binLabelsToLookForStr = binLabelsToLookForStr + (String)binLabelsToLookFor.get(i) + ",";
            }
            binLabelsToLookForStr = binLabelsToLookForStr + (String)binLabelsToLookFor.get(binLabelsToLookFor.size() - 1) + "}";
            while ((s = lnr.readLine()) != null) {
                if ((s = s.trim()).startsWith("@attribute") && !s.startsWith("@attribute CLASS") && !s.endsWith(binLabelsToLookForStr)) {
                    s = s.substring(0, s.indexOf("{")) + " " + binLabelsToLookForStr;
                }
                pw.println(s);
            }
        }
        catch (IOException ioe) {
            System.out.println(ioe);
        }
    }

    public static void test(String inRootFileName, int numIterations, ArrayList binLabelsToLookFor) {
        for (int i = 0; i < numIterations; ++i) {
            FixStates.fixStates(inRootFileName + i, binLabelsToLookFor, ".arff");
        }
    }

    public static void usage() {
        System.out.println("Usage: java FixStates inArffRootFileName numIterations\nExample: java FixStates boot/myArffRootFileName 100");
        System.exit(0);
    }

    public static void main(String[] argv) {
        if (argv.length != 2) {
            FixStates.usage();
        }
        String inRootFileName = argv[0];
        int numIterations = Integer.parseInt(argv[1]);
        ArrayList<String> binLabelsToLookFor = new ArrayList<String>();
        binLabelsToLookFor.add("state1");
        binLabelsToLookFor.add("state2");
        binLabelsToLookFor.add("state3");
        FixStates.test(inRootFileName, numIterations, binLabelsToLookFor);
    }
}

