/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.bn;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import org.tigr.microarray.mev.cluster.gui.impl.bn.BNConstants;
import org.tigr.microarray.mev.cluster.gui.impl.bn.BNDownloadManager;

public class CytoscapeWebstart {
    public static Process runtimeProc;

    public static void onWebstartCytoscapeBN(Vector netFiles) {
        String codeBase = "";
        String libDir = "";
        String pluginsDir = "";
        Hashtable<String, String> cytoSettings = CytoscapeWebstart.getJNLPsettingsForCytoscape();
        codeBase = cytoSettings.get("codeBase");
        libDir = cytoSettings.get("libDir");
        pluginsDir = cytoSettings.get("pluginsDir");
        String jnlpLoc = CytoscapeWebstart.createDfciCytoscapeJNLP(codeBase, libDir, pluginsDir, netFiles, true);
        String filePath = (String)netFiles.get(0);
        int index = filePath.indexOf("results");
        String fileLoc = filePath.substring(0, index - 1);
        String jnlpURI = fileLoc + File.separator + "results" + File.separator + "mycyto.jnlp";
        try {
            BufferedWriter out = new BufferedWriter(new FileWriter(jnlpURI));
            out.write(jnlpLoc);
            out.close();
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(new JFrame(), "Error creating jnlp file", "Cytoscape will not launch", 0);
        }
        CytoscapeWebstart.startCytoscape(jnlpURI);
    }

    public static void onWebstartCytoscapeMINET(Vector netFiles) {
        String codeBase = "";
        String libDir = "";
        String pluginsDir = "";
        String MINET_URI = "minet.jnlp";
        Hashtable<String, String> cytoSettings = CytoscapeWebstart.getJNLPsettingsForCytoscape();
        codeBase = cytoSettings.get("codeBase");
        libDir = cytoSettings.get("libDir");
        pluginsDir = cytoSettings.get("pluginsDir");
        String jnlpLoc = CytoscapeWebstart.createDfciCytoscapeJNLP(codeBase, libDir, pluginsDir, netFiles, false);
        String filePath = (String)netFiles.get(0);
        int index = filePath.lastIndexOf("/");
        String fileLoc = filePath.substring(0, index);
        String jnlpURI = fileLoc + "/" + MINET_URI;
        try {
            BufferedWriter out = new BufferedWriter(new FileWriter(jnlpURI));
            out.write(jnlpLoc);
            out.close();
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(new JFrame(), "Error creating jnlp file", "Cytoscape will not launch", 0);
        }
        CytoscapeWebstart.startCytoscape(jnlpURI);
    }

    private static Hashtable<String, String> getJNLPsettingsForCytoscape() {
        Hashtable<String, String> cytoSets = new Hashtable<String, String>();
        String codeBase = "";
        String libDir = "";
        String pluginsDir = "";
        if (BNConstants.isSetCytoscapeParams()) {
            codeBase = BNConstants.getCodeBaseLocation();
            libDir = BNConstants.getLibDirLocation();
            pluginsDir = BNConstants.gePluginsDirLocation();
        } else {
            Hashtable<String, String> repInfo = BNDownloadManager.getRepositoryInfoCytoscape();
            codeBase = repInfo.get("cytoscape_webstart").trim();
            libDir = repInfo.get("cytoscape_lib_dir").trim();
            pluginsDir = repInfo.get("cytoscape_plugins_dir").trim();
        }
        if (codeBase == null || libDir == null || pluginsDir == null) {
            JOptionPane.showMessageDialog(new JFrame(), "Error reading properties file, will try with default values", "Cytoscape may not launch", 0);
            codeBase = "compbio.dfci.harvard.edu";
            libDir = "/webstart/cytoscape/lib/";
            pluginsDir = "/webstart/cytoscape/plugins/";
        }
        cytoSets.put("codeBase", codeBase);
        cytoSets.put("libDir", libDir);
        cytoSets.put("pluginsDir", pluginsDir);
        return cytoSets;
    }

    private static void startCytoscape(String jnlpURI) {
        String command = System.getProperty("java.home");
        command = System.getProperty("os.name").toLowerCase().contains("win") ? command + File.separator + "bin" + File.separator + "javaws \"" + jnlpURI + "\"" : command + File.separator + "bin" + File.separator + "javaws " + jnlpURI;
        try {
            runtimeProc = Runtime.getRuntime().exec(command);
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(new JFrame(), "Error launching Cytoscape", "Webstart Could not launch properly", 0);
            System.out.println("Failed to start Cytoscape!");
            e.printStackTrace();
        }
    }

    private static String createDfciCytoscapeJNLP(String codeBase, String libDir, String pluginsDir, Vector<String> files, boolean useBnPredict) {
        String xml = "";
        xml = "<?xml version='1.0' encoding='utf-8'?>";
        xml = xml + "<jnlp";
        xml = xml + "  codebase='http://" + codeBase + "'>";
        xml = xml + "  <information>";
        xml = xml + "    <title>Cytoscape 2.6 - MeV Bn Predict</title>";
        xml = xml + "    <vendor>DFCI (2009-04)</vendor>";
        xml = xml + "    <homepage href='docs/help.html'/>";
        xml = xml + "    <offline-allowed/>";
        xml = xml + "\t<icon href='http://gaggle.systemsbiology.net/images/icons/gaggle_icon.gif'/><icon kind='splash' href='http://gaggle.systemsbiology.net/images/icons/gaggle_splash.gif'/>";
        xml = xml + "  </information>";
        xml = xml + "  <security>";
        xml = xml + "      <all-permissions/>";
        xml = xml + "  </security>";
        xml = xml + "  <resources>";
        xml = xml + "\t<j2se version='1.5+' max-heap-size='1024M' />";
        xml = xml + "\t<jar href='" + libDir + "cytoscape.jar'/>";
        xml = xml + "\t<jar href='" + libDir + "FastInfoset.jar'/>";
        xml = xml + "\t<jar href='" + libDir + "activation.jar'/>";
        xml = xml + "\t<jar href='" + libDir + "biojava-1.4.jar'/>";
        xml = xml + "\t<jar href='" + libDir + "colt.jar'/>";
        xml = xml + "\t<jar href='" + libDir + "coltginy.jar'/>";
        xml = xml + "\t<jar href='" + libDir + "com-nerius-math-xform.jar'/>";
        xml = xml + "\t<jar href='" + libDir + "commons-cli-1.x-cytoscape-custom.jar'/>";
        xml = xml + "\t<jar href='" + libDir + "concurrent.jar'/>";
        xml = xml + "\t<jar href='" + libDir + "cytoscape-cruft-obo.jar'/>";
        xml = xml + "\t<jar href='" + libDir + "cytoscape-geom-rtree.jar'/>";
        xml = xml + "\t<jar href='" + libDir + "cytoscape-geom-spacial.jar'/>";
        xml = xml + "\t<jar href='" + libDir + "cytoscape-graph-dynamic.jar'/>";
        xml = xml + "\t<jar href='" + libDir + "cytoscape-graph-fixed.jar'/>";
        xml = xml + "\t<jar href='" + libDir + "cytoscape-render-export.jar'/>";
        xml = xml + "\t<jar href='" + libDir + "cytoscape-render-immed.jar'/>";
        xml = xml + "\t<jar href='" + libDir + "cytoscape-render-stateful.jar'/>";
        xml = xml + "\t<jar href='" + libDir + "cytoscape-task.jar'/>";
        xml = xml + "\t<jar href='" + libDir + "cytoscape-util-intr.jar'/>";
        xml = xml + "\t<jar href='" + libDir + "ding.jar'/>";
        xml = xml + "\t<jar href='" + libDir + "fing.jar'/>";
        xml = xml + "\t<jar href='" + libDir + "freehep-export-2.1.1.jar'/>";
        xml = xml + "\t<jar href='" + libDir + "freehep-graphics2d-2.1.1.jar'/>";
        xml = xml + "\t<jar href='" + libDir + "freehep-graphicsio-2.1.1.jar'/>";
        xml = xml + "\t<jar href='" + libDir + "freehep-graphicsio-java-2.1.1.jar'/>";
        xml = xml + "\t<jar href='" + libDir + "freehep-graphicsio-ps-2.1.1.jar'/>";
        xml = xml + "\t<jar href='" + libDir + "freehep-graphicsio-svg-2.1.1.jar'/>";
        xml = xml + "\t<jar href='" + libDir + "freehep-io-2.0.2.jar'/>";
        xml = xml + "\t<jar href='" + libDir + "freehep-jas-plotter-2.2.jar'/>";
        xml = xml + "\t<jar href='" + libDir + "freehep-swing-2.0.3.jar'/>";
        xml = xml + "\t<jar href='" + libDir + "freehep-util-2.0.2.jar'/>";
        xml = xml + "\t<jar href='" + libDir + "freehep-xml-2.1.1.jar'/>";
        xml = xml + "\t<jar href='" + libDir + "giny.jar'/>";
        xml = xml + "\t<jar href='" + libDir + "glf.jar'/>";
        xml = xml + "\t<jar href='" + libDir + "http.jar'/>";
        xml = xml + "\t<jar href='" + libDir + "i4jruntime.jar'/>";
        xml = xml + "\t<jar href='" + libDir + "itext-2.0.4.jar'/>";
        xml = xml + "\t<jar href='" + libDir + "jaxb-api.jar'/>";
        xml = xml + "\t<jar href='" + libDir + "jaxb-impl.jar'/>";
        xml = xml + "\t<jar href='" + libDir + "jaxws-api.jar'/>";
        xml = xml + "\t<jar href='" + libDir + "jaxws-rt.jar'/>";
        xml = xml + "\t<jar href='" + libDir + "jaxws-tools.jar'/>";
        xml = xml + "\t<jar href='" + libDir + "jdom-1.0.jar'/>";
        xml = xml + "\t<jar href='" + libDir + "jhall.jar'/>";
        xml = xml + "\t<jar href='" + libDir + "jnlp.jar'/>";
        xml = xml + "\t<jar href='" + libDir + "jsr173_1.0_api.jar'/>";
        xml = xml + "\t<jar href='" + libDir + "jsr181-api.jar'/>";
        xml = xml + "\t<jar href='" + libDir + "jsr250-api.jar'/>";
        xml = xml + "\t<jar href='" + libDir + "junit.jar'/>";
        xml = xml + "\t<jar href='" + libDir + "l2fprod-common-all.jar'/>";
        xml = xml + "\t<jar href='" + libDir + "looks-2.1.4.jar'/>";
        xml = xml + "\t<jar href='" + libDir + "phoebe.jar'/>";
        xml = xml + "\t<jar href='" + libDir + "piccolo.jar'/>";
        xml = xml + "\t<jar href='" + libDir + "resolver.jar'/>";
        xml = xml + "\t<jar href='" + libDir + "saaj-api.jar'/>";
        xml = xml + "\t<jar href='" + libDir + "saaj-impl.jar'/>";
        xml = xml + "\t<jar href='" + libDir + "sjsxp.jar'/>";
        xml = xml + "\t<jar href='" + libDir + "stax-ex.jar'/>";
        xml = xml + "\t<jar href='" + libDir + "streambuffer.jar'/>";
        xml = xml + "\t<jar href='" + libDir + "swing-layout-1.0.1.jar'/>";
        xml = xml + "\t<jar href='" + libDir + "swingx-2006_10_27.jar'/>";
        xml = xml + "\t<jar href='" + libDir + "tclib.jar'/>";
        xml = xml + "\t<jar href='" + libDir + "undo.support.jar'/>";
        xml = xml + "\t<jar href='" + libDir + "violinstrings-1.0.2.jar'/>";
        xml = xml + "\t<jar href='" + libDir + "wizard.jar'/>";
        xml = xml + "\t<jar href='" + libDir + "BrowserLauncher2-1_3.jar'/>";
        xml = xml + "\t<jar href='" + pluginsDir + "AutomaticLayout.jar'/>";
        if (useBnPredict) {
            xml = xml + "\t<jar href='" + pluginsDir + "CyGoose.jar'/>";
            xml = xml + "\t<jar href='" + pluginsDir + "bn_predict.jar'/>";
        }
        xml = xml + "\t<jar href='" + pluginsDir + "CytoscapeEditor.jar'/>";
        xml = xml + "\t<jar href='" + pluginsDir + "GraphMerge.jar'/>";
        xml = xml + "\t<jar href='" + pluginsDir + "ManualLayout.jar'/>";
        xml = xml + "\t<jar href='" + pluginsDir + "SBMLReader.jar'/>";
        xml = xml + "\t<jar href='" + pluginsDir + "TableImport.jar'/>";
        xml = xml + "\t<jar href='" + pluginsDir + "biopax.jar'/>";
        xml = xml + "\t<jar href='" + pluginsDir + "browser.jar'/>";
        xml = xml + "\t<jar href='" + pluginsDir + "cPath.jar'/>";
        xml = xml + "\t<jar href='" + pluginsDir + "cpath2.jar'/>";
        xml = xml + "\t<jar href='" + pluginsDir + "filter.jar'/>";
        xml = xml + "\t<jar href='" + pluginsDir + "filters.jar'/>";
        xml = xml + "\t<jar href='" + pluginsDir + "linkout.jar'/>";
        xml = xml + "\t<jar href='" + pluginsDir + "psi_mi.jar'/>";
        xml = xml + "\t<jar href='" + pluginsDir + "quick_find.jar'/>";
        xml = xml + "\t<jar href='" + pluginsDir + "yLayouts.jar'/>";
        xml = xml + " </resources>";
        xml = xml + "  <application-desc main-class='cytoscape.CyMain'>";
        xml = xml + "    <argument>-p</argument>";
        xml = xml + "    <argument>csplugins.layout.LayoutPlugin</argument>";
        xml = xml + "    <argument>-p</argument>";
        xml = xml + "    <argument>org.mskcc.biopax_plugin.plugin.BioPaxPlugIn</argument>";
        xml = xml + "    <argument>-p</argument>";
        xml = xml + "    <argument>browser.AttributeBrowserPlugin</argument>";
        xml = xml + "    <argument>-p</argument>";
        xml = xml + "    <argument>org.cytoscape.coreplugin.cpath.plugin.CPathPlugIn</argument>";
        xml = xml + "    <argument>-p</argument>";
        xml = xml + "    <argument>GraphMerge.GraphMerge</argument>";
        xml = xml + "    <argument>-p</argument>";
        xml = xml + "    <argument>linkout.LinkOutPlugin</argument>";
        xml = xml + "    <argument>-p</argument>";
        xml = xml + "    <argument>ManualLayout.ManualLayoutPlugin</argument>";
        xml = xml + "    <argument>-p</argument>";
        xml = xml + "    <argument>org.cytoscape.coreplugin.psi_mi.plugin.PsiMiPlugIn</argument>";
        xml = xml + "    <argument>-p</argument>";
        xml = xml + "    <argument>csplugins.quickfind.plugin.QuickFindPlugIn</argument>";
        xml = xml + "    <argument>-p</argument>";
        xml = xml + "    <argument>sbmlreader.SBMLReaderPlugin</argument>";
        xml = xml + "    <argument>-p</argument>";
        xml = xml + "    <argument>edu.ucsd.bioeng.coreplugin.tableImport.TableImportPlugin</argument>";
        xml = xml + "    <argument>-p</argument>";
        xml = xml + "    <argument>yfiles.YFilesLayoutPlugin</argument>";
        if (useBnPredict) {
            xml = xml + "    <argument>-p</argument>";
            xml = xml + "    <argument>org.systemsbiology.cytoscape.GagglePlugin</argument>";
            xml = xml + "    <argument>-p</argument>";
            xml = xml + "    <argument>plugin.bn_predict.BN_Predict</argument>";
        }
        for (int i = 0; i < files.size(); ++i) {
            xml = xml + "<argument>-N</argument>";
            xml = xml + "<argument>file:///" + files.get(i).replace("\\", "/").replace(" ", "%20") + "</argument>";
        }
        xml = xml + "  </application-desc>";
        xml = xml + "</jnlp>";
        return xml;
    }

    private static String createGaggleCytoscapeJNLP(String codeBase, String libDir, Vector<String> files) {
        String xml = "";
        xml = "<?xml version='1.0' encoding='utf-8'?>";
        xml = xml + "<jnlp";
        xml = xml + "  codebase='http://" + codeBase + "'>";
        xml = xml + "  <information>";
        xml = xml + "    <title>Cytoscape 2.6.0 - Blank Slate</title>";
        xml = xml + "    <vendor> ISB (2007-04)</vendor>";
        xml = xml + "    <homepage href='docs/help.html'/>";
        xml = xml + "    <offline-allowed/>";
        xml = xml + "\t<icon href='http://gaggle.systemsbiology.net/images/icons/gaggle_icon.gif'/><icon kind='splash' href='http://gaggle.systemsbiology.net/images/icons/gaggle_splash.gif'/>";
        xml = xml + "  </information>";
        xml = xml + "  <security>";
        xml = xml + "      <all-permissions/>";
        xml = xml + "  </security>";
        xml = xml + "  <resources>";
        xml = xml + "\t<j2se version='1.5+' max-heap-size='1024M' />";
        xml = xml + "\t<jar href='" + libDir + "cytoscape.jar'/>";
        xml = xml + "\t<jar href='" + libDir + "FastInfoset.jar'/>";
        xml = xml + "\t<jar href='" + libDir + "activation.jar'/>";
        xml = xml + "\t<jar href='" + libDir + "biojava-1.4.jar'/>";
        xml = xml + "\t<jar href='" + libDir + "colt.jar'/>";
        xml = xml + "\t<jar href='" + libDir + "coltginy.jar'/>";
        xml = xml + "\t<jar href='" + libDir + "com-nerius-math-xform.jar'/>";
        xml = xml + "\t<jar href='" + libDir + "commons-cli-1.x-cytoscape-custom.jar'/>";
        xml = xml + "\t<jar href='" + libDir + "concurrent.jar'/>";
        xml = xml + "\t<jar href='" + libDir + "cytoscape-cruft-obo.jar'/>";
        xml = xml + "\t<jar href='" + libDir + "cytoscape-geom-rtree.jar'/>";
        xml = xml + "\t<jar href='" + libDir + "cytoscape-geom-spacial.jar'/>";
        xml = xml + "\t<jar href='" + libDir + "cytoscape-graph-dynamic.jar'/>";
        xml = xml + "\t<jar href='" + libDir + "cytoscape-graph-fixed.jar'/>";
        xml = xml + "\t<jar href='" + libDir + "cytoscape-render-export.jar'/>";
        xml = xml + "\t<jar href='" + libDir + "cytoscape-render-immed.jar'/>";
        xml = xml + "\t<jar href='" + libDir + "cytoscape-render-stateful.jar'/>";
        xml = xml + "\t<jar href='" + libDir + "cytoscape-task.jar'/>";
        xml = xml + "\t<jar href='" + libDir + "cytoscape-util-intr.jar'/>";
        xml = xml + "\t<jar href='" + libDir + "ding.jar'/>";
        xml = xml + "\t<jar href='" + libDir + "fing.jar'/>";
        xml = xml + "\t<jar href='" + libDir + "freehep-export-2.1.1.jar'/>";
        xml = xml + "\t<jar href='" + libDir + "freehep-graphics2d-2.1.1.jar'/>";
        xml = xml + "\t<jar href='" + libDir + "freehep-graphicsio-2.1.1.jar'/>";
        xml = xml + "\t<jar href='" + libDir + "freehep-graphicsio-java-2.1.1.jar'/>";
        xml = xml + "\t<jar href='" + libDir + "freehep-graphicsio-ps-2.1.1.jar'/>";
        xml = xml + "\t<jar href='" + libDir + "freehep-graphicsio-svg-2.1.1.jar'/>";
        xml = xml + "\t<jar href='" + libDir + "freehep-io-2.0.2.jar'/>";
        xml = xml + "\t<jar href='" + libDir + "freehep-jas-plotter-2.2.jar'/>";
        xml = xml + "\t<jar href='" + libDir + "freehep-swing-2.0.3.jar'/>";
        xml = xml + "\t<jar href='" + libDir + "freehep-util-2.0.2.jar'/>";
        xml = xml + "\t<jar href='" + libDir + "freehep-xml-2.1.1.jar'/>";
        xml = xml + "\t<jar href='" + libDir + "giny.jar'/>";
        xml = xml + "\t<jar href='" + libDir + "glf.jar'/>";
        xml = xml + "\t<jar href='" + libDir + "http.jar'/>";
        xml = xml + "\t<jar href='" + libDir + "i4jruntime.jar'/>";
        xml = xml + "\t<jar href='" + libDir + "itext-2.0.4.jar'/>";
        xml = xml + "\t<jar href='" + libDir + "jaxb-api.jar'/>";
        xml = xml + "\t<jar href='" + libDir + "jaxb-impl.jar'/>";
        xml = xml + "\t<jar href='" + libDir + "jaxws-api.jar'/>";
        xml = xml + "\t<jar href='" + libDir + "jaxws-rt.jar'/>";
        xml = xml + "\t<jar href='" + libDir + "jaxws-tools.jar'/>";
        xml = xml + "\t<jar href='" + libDir + "jdom-1.0.jar'/>";
        xml = xml + "\t<jar href='" + libDir + "jhall.jar'/>";
        xml = xml + "\t<jar href='" + libDir + "jnlp.jar'/>";
        xml = xml + "\t<jar href='" + libDir + "jsr173_1.0_api.jar'/>";
        xml = xml + "\t<jar href='" + libDir + "jsr181-api.jar'/>";
        xml = xml + "\t<jar href='" + libDir + "jsr250-api.jar'/>";
        xml = xml + "\t<jar href='" + libDir + "junit.jar'/>";
        xml = xml + "\t<jar href='" + libDir + "l2fprod-common-all.jar'/>";
        xml = xml + "\t<jar href='" + libDir + "looks-2.1.4.jar'/>";
        xml = xml + "\t<jar href='" + libDir + "phoebe.jar'/>";
        xml = xml + "\t<jar href='" + libDir + "piccolo.jar'/>";
        xml = xml + "\t<jar href='" + libDir + "resolver.jar'/>";
        xml = xml + "\t<jar href='" + libDir + "saaj-api.jar'/>";
        xml = xml + "\t<jar href='" + libDir + "saaj-impl.jar'/>";
        xml = xml + "\t<jar href='" + libDir + "sjsxp.jar'/>";
        xml = xml + "\t<jar href='" + libDir + "stax-ex.jar'/>";
        xml = xml + "\t<jar href='" + libDir + "streambuffer.jar'/>";
        xml = xml + "\t<jar href='" + libDir + "swing-layout-1.0.1.jar'/>";
        xml = xml + "\t<jar href='" + libDir + "swingx-2006_10_27.jar'/>";
        xml = xml + "\t<jar href='" + libDir + "tclib.jar'/>";
        xml = xml + "\t<jar href='" + libDir + "undo.support.jar'/>";
        xml = xml + "\t<jar href='" + libDir + "violinstrings-1.0.2.jar'/>";
        xml = xml + "\t<jar href='" + libDir + "wizard.jar'/>";
        xml = xml + "\t<jar href='" + libDir + "BrowserLauncher2-1_3.jar'/>";
        xml = xml + "\t<jar href='" + libDir + "plugins/AutomaticLayout.jar'/>";
        xml = xml + "\t<jar href='" + libDir + "plugins/CyGoose.jar'/>";
        xml = xml + "\t<jar href='" + libDir + "plugins/CytoscapeEditor.jar'/>";
        xml = xml + "\t<jar href='" + libDir + "plugins/GraphMerge.jar'/>";
        xml = xml + "\t<jar href='" + libDir + "plugins/ManualLayout.jar'/>";
        xml = xml + "\t<jar href='" + libDir + "plugins/SBMLReader.jar'/>";
        xml = xml + "\t<jar href='" + libDir + "plugins/TableImport.jar'/>";
        xml = xml + "\t<jar href='" + libDir + "plugins/biopax.jar'/>";
        xml = xml + "\t<jar href='" + libDir + "plugins/browser.jar'/>";
        xml = xml + "\t<jar href='" + libDir + "plugins/cPath.jar'/>";
        xml = xml + "\t<jar href='" + libDir + "plugins/cpath2.jar'/>";
        xml = xml + "\t<jar href='" + libDir + "plugins/filter.jar'/>";
        xml = xml + "\t<jar href='" + libDir + "plugins/filters.jar'/>";
        xml = xml + "\t<jar href='" + libDir + "plugins/linkout.jar'/>";
        xml = xml + "\t<jar href='" + libDir + "plugins/psi_mi.jar'/>";
        xml = xml + "\t<jar href='" + libDir + "plugins/quick_find.jar'/>";
        xml = xml + "\t<jar href='" + libDir + "plugins/yLayouts.jar'/>";
        xml = xml + " </resources>";
        xml = xml + "  <application-desc main-class='cytoscape.CyMain'>";
        xml = xml + "    <argument>-p</argument>";
        xml = xml + "    <argument>csplugins.layout.LayoutPlugin</argument>";
        xml = xml + "    <argument>-p</argument>";
        xml = xml + "    <argument>org.mskcc.biopax_plugin.plugin.BioPaxPlugIn</argument>";
        xml = xml + "    <argument>-p</argument>";
        xml = xml + "    <argument>browser.AttributeBrowserPlugin</argument>";
        xml = xml + "    <argument>-p</argument>";
        xml = xml + "    <argument>org.cytoscape.coreplugin.cpath.plugin.CPathPlugIn</argument>";
        xml = xml + "    <argument>-p</argument>";
        xml = xml + "    <argument>cytoscape.editor.CytoscapeEditorPlugin</argument>";
        xml = xml + "    <argument>-p</argument>";
        xml = xml + "    <argument>filter.cytoscape.CsFilter</argument>";
        xml = xml + "    <argument>-p</argument>";
        xml = xml + "    <argument>cytoscape.filters.FilterPlugin</argument>";
        xml = xml + "    <argument>-p</argument>";
        xml = xml + "    <argument>GraphMerge.GraphMerge</argument>";
        xml = xml + "    <argument>-p</argument>";
        xml = xml + "    <argument>linkout.LinkOutPlugin</argument>";
        xml = xml + "    <argument>-p</argument>";
        xml = xml + "    <argument>ManualLayout.ManualLayoutPlugin</argument>";
        xml = xml + "    <argument>-p</argument>";
        xml = xml + "    <argument>org.cytoscape.coreplugin.psi_mi.plugin.PsiMiPlugIn</argument>";
        xml = xml + "    <argument>-p</argument>";
        xml = xml + "    <argument>csplugins.quickfind.plugin.QuickFindPlugIn</argument>";
        xml = xml + "    <argument>-p</argument>";
        xml = xml + "    <argument>sbmlreader.SBMLReaderPlugin</argument>";
        xml = xml + "    <argument>-p</argument>";
        xml = xml + "    <argument>edu.ucsd.bioeng.coreplugin.tableImport.TableImportPlugin</argument>";
        xml = xml + "    <argument>-p</argument>";
        xml = xml + "    <argument>yfiles.YFilesLayoutPlugin</argument>";
        xml = xml + "    <argument>-p</argument>";
        xml = xml + "    <argument>org.systemsbiology.cytoscape.GagglePlugin</argument>";
        for (int i = 0; i < files.size(); ++i) {
            xml = xml + "<argument>-N</argument>";
            xml = xml + "<argument>file:///" + files.get(i).replace("\\", "/") + "</argument>";
        }
        xml = xml + "  </application-desc>";
        xml = xml + "</jnlp>";
        return xml;
    }

    private static String createGaggleCytoscapeJNLP(String codeBase, Vector<String> files) {
        String xml = "";
        xml = "<?xml version='1.0' encoding='utf-8'?>";
        xml = xml + "<jnlp";
        xml = xml + "  codebase='http://gaggle.systemsbiology.net/2007-04/cy/blankSlate/cy2.6.0'>";
        xml = xml + "  <information>";
        xml = xml + "    <title>Cytoscape 2.6.0 - Blank Slate</title>";
        xml = xml + "    <vendor> ISB (2007-04)</vendor>";
        xml = xml + "    <homepage href='docs/help.html'/>";
        xml = xml + "    <offline-allowed/>";
        xml = xml + "\t<icon href='http://gaggle.systemsbiology.net/images/icons/gaggle_icon.gif'/><icon kind='splash' href='http://gaggle.systemsbiology.net/images/icons/gaggle_splash.gif'/>";
        xml = xml + "  </information>";
        xml = xml + "  <security>";
        xml = xml + "      <all-permissions/>";
        xml = xml + "  </security>";
        xml = xml + "  <resources>";
        xml = xml + "\t<j2se version='1.5+' max-heap-size='1024M' />";
        xml = xml + "\t<jar href='/2007-04/jars_cy2.6.0/cytoscape.jar'/>";
        xml = xml + "\t<jar href='/2007-04/jars_cy2.6.0/FastInfoset.jar'/>";
        xml = xml + "\t<jar href='/2007-04/jars_cy2.6.0/activation.jar'/>";
        xml = xml + "\t<jar href='/2007-04/jars_cy2.6.0/biojava-1.4.jar'/>";
        xml = xml + "\t<jar href='/2007-04/jars_cy2.6.0/colt.jar'/>";
        xml = xml + "\t<jar href='/2007-04/jars_cy2.6.0/coltginy.jar'/>";
        xml = xml + "\t<jar href='/2007-04/jars_cy2.6.0/com-nerius-math-xform.jar'/>";
        xml = xml + "\t<jar href='/2007-04/jars_cy2.6.0/commons-cli-1.x-cytoscape-custom.jar'/>";
        xml = xml + "\t<jar href='/2007-04/jars_cy2.6.0/concurrent.jar'/>";
        xml = xml + "\t<jar href='/2007-04/jars_cy2.6.0/cytoscape-cruft-obo.jar'/>";
        xml = xml + "\t<jar href='/2007-04/jars_cy2.6.0/cytoscape-geom-rtree.jar'/>";
        xml = xml + "\t<jar href='/2007-04/jars_cy2.6.0/cytoscape-geom-spacial.jar'/>";
        xml = xml + "\t<jar href='/2007-04/jars_cy2.6.0/cytoscape-graph-dynamic.jar'/>";
        xml = xml + "\t<jar href='/2007-04/jars_cy2.6.0/cytoscape-graph-fixed.jar'/>";
        xml = xml + "\t<jar href='/2007-04/jars_cy2.6.0/cytoscape-render-export.jar'/>";
        xml = xml + "\t<jar href='/2007-04/jars_cy2.6.0/cytoscape-render-immed.jar'/>";
        xml = xml + "\t<jar href='/2007-04/jars_cy2.6.0/cytoscape-render-stateful.jar'/>";
        xml = xml + "\t<jar href='/2007-04/jars_cy2.6.0/cytoscape-task.jar'/>";
        xml = xml + "\t<jar href='/2007-04/jars_cy2.6.0/cytoscape-util-intr.jar'/>";
        xml = xml + "\t<jar href='/2007-04/jars_cy2.6.0/ding.jar'/>";
        xml = xml + "\t<jar href='/2007-04/jars_cy2.6.0/fing.jar'/>";
        xml = xml + "\t<jar href='/2007-04/jars_cy2.6.0/freehep-export-2.1.1.jar'/>";
        xml = xml + "\t<jar href='/2007-04/jars_cy2.6.0/freehep-graphics2d-2.1.1.jar'/>";
        xml = xml + "\t<jar href='/2007-04/jars_cy2.6.0/freehep-graphicsio-2.1.1.jar'/>";
        xml = xml + "\t<jar href='/2007-04/jars_cy2.6.0/freehep-graphicsio-java-2.1.1.jar'/>";
        xml = xml + "\t<jar href='/2007-04/jars_cy2.6.0/freehep-graphicsio-ps-2.1.1.jar'/>";
        xml = xml + "\t<jar href='/2007-04/jars_cy2.6.0/freehep-graphicsio-svg-2.1.1.jar'/>";
        xml = xml + "\t<jar href='/2007-04/jars_cy2.6.0/freehep-io-2.0.2.jar'/>";
        xml = xml + "\t<jar href='/2007-04/jars_cy2.6.0/freehep-jas-plotter-2.2.jar'/>";
        xml = xml + "\t<jar href='/2007-04/jars_cy2.6.0/freehep-swing-2.0.3.jar'/>";
        xml = xml + "\t<jar href='/2007-04/jars_cy2.6.0/freehep-util-2.0.2.jar'/>";
        xml = xml + "\t<jar href='/2007-04/jars_cy2.6.0/freehep-xml-2.1.1.jar'/>";
        xml = xml + "\t<jar href='/2007-04/jars_cy2.6.0/giny.jar'/>";
        xml = xml + "\t<jar href='/2007-04/jars_cy2.6.0/glf.jar'/>";
        xml = xml + "\t<jar href='/2007-04/jars_cy2.6.0/http.jar'/>";
        xml = xml + "\t<jar href='/2007-04/jars_cy2.6.0/i4jruntime.jar'/>";
        xml = xml + "\t<jar href='/2007-04/jars_cy2.6.0/itext-2.0.4.jar'/>";
        xml = xml + "\t<jar href='/2007-04/jars_cy2.6.0/jaxb-api.jar'/>";
        xml = xml + "\t<jar href='/2007-04/jars_cy2.6.0/jaxb-impl.jar'/>";
        xml = xml + "\t<jar href='/2007-04/jars_cy2.6.0/jaxws-api.jar'/>";
        xml = xml + "\t<jar href='/2007-04/jars_cy2.6.0/jaxws-rt.jar'/>";
        xml = xml + "\t<jar href='/2007-04/jars_cy2.6.0/jaxws-tools.jar'/>";
        xml = xml + "\t<jar href='/2007-04/jars_cy2.6.0/jdom-1.0.jar'/>";
        xml = xml + "\t<jar href='/2007-04/jars_cy2.6.0/jhall.jar'/>";
        xml = xml + "\t<jar href='/2007-04/jars_cy2.6.0/jnlp.jar'/>";
        xml = xml + "\t<jar href='/2007-04/jars_cy2.6.0/jsr173_1.0_api.jar'/>";
        xml = xml + "\t<jar href='/2007-04/jars_cy2.6.0/jsr181-api.jar'/>";
        xml = xml + "\t<jar href='/2007-04/jars_cy2.6.0/jsr250-api.jar'/>";
        xml = xml + "\t<jar href='/2007-04/jars_cy2.6.0/junit.jar'/>";
        xml = xml + "\t<jar href='/2007-04/jars_cy2.6.0/l2fprod-common-all.jar'/>";
        xml = xml + "\t<jar href='/2007-04/jars_cy2.6.0/looks-2.1.4.jar'/>";
        xml = xml + "\t<jar href='/2007-04/jars_cy2.6.0/phoebe.jar'/>";
        xml = xml + "\t<jar href='/2007-04/jars_cy2.6.0/piccolo.jar'/>";
        xml = xml + "\t<jar href='/2007-04/jars_cy2.6.0/resolver.jar'/>";
        xml = xml + "\t<jar href='/2007-04/jars_cy2.6.0/saaj-api.jar'/>";
        xml = xml + "\t<jar href='/2007-04/jars_cy2.6.0/saaj-impl.jar'/>";
        xml = xml + "\t<jar href='/2007-04/jars_cy2.6.0/sjsxp.jar'/>";
        xml = xml + "\t<jar href='/2007-04/jars_cy2.6.0/stax-ex.jar'/>";
        xml = xml + "\t<jar href='/2007-04/jars_cy2.6.0/streambuffer.jar'/>";
        xml = xml + "\t<jar href='/2007-04/jars_cy2.6.0/swing-layout-1.0.1.jar'/>";
        xml = xml + "\t<jar href='/2007-04/jars_cy2.6.0/swingx-2006_10_27.jar'/>";
        xml = xml + "\t<jar href='/2007-04/jars_cy2.6.0/tclib.jar'/>";
        xml = xml + "\t<jar href='/2007-04/jars_cy2.6.0/undo.support.jar'/>";
        xml = xml + "\t<jar href='/2007-04/jars_cy2.6.0/violinstrings-1.0.2.jar'/>";
        xml = xml + "\t<jar href='/2007-04/jars_cy2.6.0/wizard.jar'/>";
        xml = xml + "\t<jar href='/2007-04/jars_cy2.6.0/plugins/AutomaticLayout.jar'/>";
        xml = xml + "\t<jar href='/2007-04/jars_cy2.6.0/plugins/CyGoose.jar'/>";
        xml = xml + "\t<jar href='/2007-04/jars_cy2.6.0/plugins/CytoscapeEditor.jar'/>";
        xml = xml + "\t<jar href='/2007-04/jars_cy2.6.0/plugins/GraphMerge.jar'/>";
        xml = xml + "\t<jar href='/2007-04/jars_cy2.6.0/plugins/ManualLayout.jar'/>";
        xml = xml + "\t<jar href='/2007-04/jars_cy2.6.0/plugins/SBMLReader.jar'/>";
        xml = xml + "\t<jar href='/2007-04/jars_cy2.6.0/plugins/TableImport.jar'/>";
        xml = xml + "\t<jar href='/2007-04/jars_cy2.6.0/plugins/biopax.jar'/>";
        xml = xml + "\t<jar href='/2007-04/jars_cy2.6.0/plugins/browser.jar'/>";
        xml = xml + "\t<jar href='/2007-04/jars_cy2.6.0/plugins/cPath.jar'/>";
        xml = xml + "\t<jar href='/2007-04/jars_cy2.6.0/plugins/cpath2.jar'/>";
        xml = xml + "\t<jar href='/2007-04/jars_cy2.6.0/plugins/filter.jar'/>";
        xml = xml + "\t<jar href='/2007-04/jars_cy2.6.0/plugins/filters.jar'/>";
        xml = xml + "\t<jar href='/2007-04/jars_cy2.6.0/plugins/linkout.jar'/>";
        xml = xml + "\t<jar href='/2007-04/jars_cy2.6.0/plugins/psi_mi.jar'/>";
        xml = xml + "\t<jar href='/2007-04/jars_cy2.6.0/plugins/quick_find.jar'/>";
        xml = xml + "\t<jar href='/2007-04/jars_cy2.6.0/plugins/yLayouts.jar'/>";
        xml = xml + " </resources>";
        xml = xml + "  <application-desc main-class='cytoscape.CyMain'>";
        xml = xml + "    <argument>-p</argument>";
        xml = xml + "    <argument>csplugins.layout.LayoutPlugin</argument>";
        xml = xml + "    <argument>-p</argument>";
        xml = xml + "    <argument>org.mskcc.biopax_plugin.plugin.BioPaxPlugIn</argument>";
        xml = xml + "    <argument>-p</argument>";
        xml = xml + "    <argument>browser.AttributeBrowserPlugin</argument>";
        xml = xml + "    <argument>-p</argument>";
        xml = xml + "    <argument>org.cytoscape.coreplugin.cpath.plugin.CPathPlugIn</argument>";
        xml = xml + "    <argument>-p</argument>";
        xml = xml + "    <argument>cytoscape.editor.CytoscapeEditorPlugin</argument>";
        xml = xml + "    <argument>-p</argument>";
        xml = xml + "    <argument>filter.cytoscape.CsFilter</argument>";
        xml = xml + "    <argument>-p</argument>";
        xml = xml + "    <argument>cytoscape.filters.FilterPlugin</argument>";
        xml = xml + "    <argument>-p</argument>";
        xml = xml + "    <argument>GraphMerge.GraphMerge</argument>";
        xml = xml + "    <argument>-p</argument>";
        xml = xml + "    <argument>linkout.LinkOutPlugin</argument>";
        xml = xml + "    <argument>-p</argument>";
        xml = xml + "    <argument>ManualLayout.ManualLayoutPlugin</argument>";
        xml = xml + "    <argument>-p</argument>";
        xml = xml + "    <argument>org.cytoscape.coreplugin.psi_mi.plugin.PsiMiPlugIn</argument>";
        xml = xml + "    <argument>-p</argument>";
        xml = xml + "    <argument>csplugins.quickfind.plugin.QuickFindPlugIn</argument>";
        xml = xml + "    <argument>-p</argument>";
        xml = xml + "    <argument>sbmlreader.SBMLReaderPlugin</argument>";
        xml = xml + "    <argument>-p</argument>";
        xml = xml + "    <argument>edu.ucsd.bioeng.coreplugin.tableImport.TableImportPlugin</argument>";
        xml = xml + "    <argument>-p</argument>";
        xml = xml + "    <argument>yfiles.YFilesLayoutPlugin</argument>";
        xml = xml + "    <argument>-p</argument>";
        xml = xml + "    <argument>org.systemsbiology.cytoscape.GagglePlugin</argument>";
        for (int i = 0; i < files.size(); ++i) {
            xml = xml + "<argument>-N</argument>";
            xml = xml + "<argument>file:///" + files.get(i).replace("\\", "/") + "</argument>";
        }
        xml = xml + "  </application-desc>";
        xml = xml + "</jnlp>";
        return xml;
    }

    private static String createWikiCytoscapeJNLP(String codeBase, Vector<String> files) {
        String xml = "";
        xml = "<?xml version='1.0' encoding='UTF-8'?>";
        xml = xml + "<jnlp codebase='http://www.wikipathways.org//wpi/bin/cytoscape/'>";
        xml = xml + "  <security>";
        xml = xml + "    <all-permissions />";
        xml = xml + "  </security>";
        xml = xml + "  <information>";
        xml = xml + "    <title>Cytoscape Webstart</title>";
        xml = xml + "    <vendor>Cytoscape Collaboration</vendor>";
        xml = xml + "    <homepage href='http://cytoscape.org' />";
        xml = xml + "    <offline-allowed />";
        xml = xml + "  </information>";
        xml = xml + "  <resources>";
        xml = xml + "    <j2se version='1.5+' max-heap-size='1024M' />";
        xml = xml + "    <!--All lib jars that cytoscape requires to run should be in this list-->";
        xml = xml + "    <jar href='cytoscape.jar' />";
        xml = xml + "    <jar href='lib/jnlp.jar' />";
        xml = xml + "    <jar href='lib/commons-cli-1.x-cytoscape-custom.jar' />";
        xml = xml + "    <jar href='lib/freehep-graphicsio-ps-2.0.jar' />";
        xml = xml + "    <jar href='lib/wizard.jar' />";
        xml = xml + "    <jar href='lib/piccolo.jar' />";
        xml = xml + "    <jar href='lib/freehep-graphicsio-pdf-2.0.jar' />";
        xml = xml + "    <jar href='lib/cytoscape-util-intr.jar' />";
        xml = xml + "    <jar href='lib/coltginy.jar' />";
        xml = xml + "    <jar href='lib/looks-2.1.4.jar' />";
        xml = xml + "    <jar href='lib/violinstrings-1.0.2.jar' />";
        xml = xml + "    <jar href='lib/biojava-1.4.jar' />";
        xml = xml + "    <jar href='lib/cytoscape-graph-dynamic.jar' />";
        xml = xml + "    <jar href='lib/jaxb-impl.jar' />";
        xml = xml + "    <jar href='lib/tclib.jar' />";
        xml = xml + "    <jar href='lib/freehep-graphicsio-svg-2.0.jar' />";
        xml = xml + "    <jar href='lib/colt.jar' />";
        xml = xml + "    <jar href='lib/freehep-swing-2.0.2.jar' />";
        xml = xml + "    <jar href='lib/cytoscape-render-export.jar' />";
        xml = xml + "    <jar href='lib/cytoscape-render-immed.jar' />";
        xml = xml + "    <jar href='lib/fing.jar' />";
        xml = xml + "    <jar href='lib/cytoscape-render-stateful.jar' />";
        xml = xml + "    <jar href='lib/cytoscape-geom-rtree.jar' />";
        xml = xml + "    <jar href='lib/junit.jar' />";
        xml = xml + "    <jar href='lib/freehep-xml-2.0.1.jar' />";
        xml = xml + "    <jar href='lib/ding.jar' />";
        xml = xml + "    <jar href='lib/freehep-export-2.0.3.jar' />";
        xml = xml + "    <jar href='lib/swingx-2006_10_27.jar' />";
        xml = xml + "    <jar href='lib/cytoscape-cruft-obo.jar' />";
        xml = xml + "    <jar href='lib/itext-2.0.4.jar' />";
        xml = xml + "    <jar href='lib/com-nerius-math-xform.jar' />";
        xml = xml + "    <jar href='lib/swing-layout-1.0.1.jar' />";
        xml = xml + "    <jar href='lib/undo.support.jar' />";
        xml = xml + "    <jar href='lib/giny.jar' />";
        xml = xml + "    <jar href='lib/jsr173_1.0_api.jar' />";
        xml = xml + "    <jar href='lib/activation.jar' />";
        xml = xml + "    <jar href='lib/cytoscape-task.jar' />";
        xml = xml + "    <jar href='lib/jhall.jar' />";
        xml = xml + "    <jar href='lib/jdom-1.0.jar' />";
        xml = xml + "    <jar href='lib/jaxb-api.jar' />";
        xml = xml + "    <jar href='lib/freehep-graphics2d-2.0.jar' />";
        xml = xml + "    <jar href='lib/freehep-graphicsio-swf-2.0.jar' />";
        xml = xml + "    <jar href='lib/cytoscape-geom-spacial.jar' />";
        xml = xml + "    <jar href='lib/freehep-graphicsio-emf-2.0.jar' />";
        xml = xml + "    <jar href='lib/freehep-util-2.0.1.jar' />";
        xml = xml + "    <jar href='lib/freehep-io-2.0.1.jar' />";
        xml = xml + "    <jar href='lib/phoebe.jar' />";
        xml = xml + "    <jar href='lib/cytoscape-graph-fixed.jar' />";
        xml = xml + "    <jar href='lib/concurrent.jar' />";
        xml = xml + "    <jar href='lib/glf.jar' />";
        xml = xml + "    <jar href='lib/freehep-graphicsio-2.0.jar' />";
        xml = xml + "    <jar href='lib/l2fprod-common-all.jar' />";
        xml = xml + "    <!--These are the plugins you wish to load, edit as necessary.-->";
        xml = xml + "    <jar href='plugins/ManualLayout.jar' />";
        xml = xml + "    <jar href='plugins/SBMLReader.jar' />";
        xml = xml + "    <jar href='plugins/psi_mi.jar' />";
        xml = xml + "    <jar href='plugins/TableImport.jar' />";
        xml = xml + "    <jar href='plugins/exesto.jar' />";
        xml = xml + "    <jar href='plugins/linkout.jar' />";
        xml = xml + "    <jar href='plugins/CytoscapeEditor.jar' />";
        xml = xml + "    <jar href='plugins/GraphMerge.jar' />";
        xml = xml + "    <jar href='plugins/yLayouts.jar' />";
        xml = xml + "    <jar href='plugins/quick_find.jar' />";
        xml = xml + "    <jar href='plugins/cPath.jar' />";
        xml = xml + "    <jar href='plugins/browser.jar' />";
        xml = xml + "    <jar href='plugins/filter.jar' />";
        xml = xml + "    <jar href='plugins/AutomaticLayout.jar' />";
        xml = xml + "    <jar href='plugins/biopax.jar' />";
        xml = xml + "    <jar href='plugins/filters.jar' />";
        xml = xml + "    <jar href='plugins/gpml.jar' />";
        xml = xml + "    <jar href='plugins/NamedSelection.jar' />";
        xml = xml + "    <jar href='plugins/BubbleRouter.jar' />";
        xml = xml + "  </resources>";
        xml = xml + "  <!--This starts-up Cytoscape, specify your plugins to load, and other command line arguments.  Plugins not specified here will not be loaded.-->";
        xml = xml + "  <application-desc main-class='cytoscape.CyMain'>";
        xml = xml + "    <argument>-p</argument>";
        xml = xml + "    <argument>ManualLayout.ManualLayoutPlugin</argument>";
        xml = xml + "    <argument>-p</argument>";
        xml = xml + "    <argument>sbmlreader.SBMLReaderPlugin</argument>";
        xml = xml + "    <argument>-p</argument>";
        xml = xml + "    <argument>org.cytoscape.coreplugin.psi_mi.plugin.PsiMiPlugIn</argument>";
        xml = xml + "    <argument>-p</argument>";
        xml = xml + "    <argument>edu.ucsd.bioeng.coreplugin.tableImport.TableImportPlugin</argument>";
        xml = xml + "    <argument>-p</argument>";
        xml = xml + "    <argument>linkout.LinkOutPlugin</argument>";
        xml = xml + "    <argument>-p</argument>";
        xml = xml + "    <argument>cytoscape.editor.CytoscapeEditorPlugin</argument>";
        xml = xml + "    <argument>-p</argument>";
        xml = xml + "    <argument>GraphMerge.GraphMerge</argument>";
        xml = xml + "    <argument>-p</argument>";
        xml = xml + "    <argument>yfiles.YFilesLayoutPlugin</argument>";
        xml = xml + "    <argument>-p</argument>";
        xml = xml + "    <argument>csplugins.quickfind.plugin.QuickFindPlugIn</argument>";
        xml = xml + "    <argument>-p</argument>";
        xml = xml + "    <argument>org.cytoscape.coreplugin.cpath.plugin.CPathPlugIn</argument>";
        xml = xml + "    <argument>-p</argument>";
        xml = xml + "    <argument>browser.AttributeBrowserPlugin</argument>";
        xml = xml + "    <argument>-p</argument>";
        xml = xml + "    <argument>filter.cytoscape.CsFilter</argument>";
        xml = xml + "    <argument>-p</argument>";
        xml = xml + "    <argument>csplugins.layout.LayoutPlugin</argument>";
        xml = xml + "    <argument>-p</argument>";
        xml = xml + "    <argument>org.mskcc.biopax_plugin.plugin.BioPaxPlugIn</argument>";
        xml = xml + "    <argument>-p</argument>";
        xml = xml + "    <argument>cytoscape.filters.FilterPlugin</argument>";
        xml = xml + "    <argument>-p</argument>";
        xml = xml + "    <argument>gpml.GpmlPlugin</argument>";
        xml = xml + "    <argument>-p</argument>";
        xml = xml + "    <argument>namedSelection.NamedSelection</argument>";
        xml = xml + "    <argument>-p</argument>";
        xml = xml + "    <argument>cytoscape.bubbleRouter.BubbleRouterPlugin</argument>";
        for (int i = 0; i < files.size(); ++i) {
            xml = xml + "<argument>-N</argument>";
            xml = xml + "<argument>file:///" + files.get(i).replace("\\", "/") + "</argument>";
        }
        xml = xml + "    <argument>-V</argument>";
        xml = xml + "    <argument>file:///C:/cscie75/Projects/MeV/MeV_SVN/plugins/vizmap.props</argument>";
        xml = xml + "  </application-desc>";
        xml = xml + "</jnlp>";
        return xml;
    }

    private static String createSunCytoscapeJNLP(String codeBase, Vector<String> files) {
        String xml = "";
        xml = "<?xml version='1.0' encoding='UTF-8'?>";
        xml = xml + "<!-- Cytoscape 2.4 -->";
        xml = xml + "<jnlp codebase='http://www.cytoscape.org/tut/webstart'>";
        xml = xml + "<security>";
        xml = xml + "    <all-permissions />";
        xml = xml + "  </security>";
        xml = xml + "  <information>";
        xml = xml + "    <title>Cytoscape v2.4 Webstart</title>";
        xml = xml + "    <vendor>Cytoscape Collaboration</vendor>";
        xml = xml + "    <homepage href='http://cytoscape.org' />";
        xml = xml + "    <offline-allowed />";
        xml = xml + "  </information>";
        xml = xml + "  <resources>";
        xml = xml + "    <j2se version='1.5+' max-heap-size='1024M' />";
        xml = xml + "    <!--All lib jars that cytoscape requires to run should be in this list-->";
        xml = xml + "    <jar href='cytoscape.jar' />";
        xml = xml + "    <jar href='lib/activation.jar' />";
        xml = xml + "    <jar href='lib/biojava-1.4.jar' />";
        xml = xml + "    <jar href='lib/colt.jar' />";
        xml = xml + "    <jar href='lib/coltginy.jar' />";
        xml = xml + "    <jar href='lib/com-nerius-math-xform.jar' />";
        xml = xml + "    <jar href='lib/commons-cli-1.x-cytoscape-custom.jar' />";
        xml = xml + "    <jar href='lib/concurrent.jar' />";
        xml = xml + "    <jar href='lib/cytoscape-cruft-obo.jar' />";
        xml = xml + "    <jar href='lib/cytoscape-geom-rtree.jar' />";
        xml = xml + "    <jar href='lib/cytoscape-geom-spacial.jar' />";
        xml = xml + "    <jar href='lib/cytoscape-graph-dynamic.jar' />";
        xml = xml + "    <jar href='lib/cytoscape-graph-fixed.jar' />";
        xml = xml + "    <jar href='lib/cytoscape-render-export.jar' />";
        xml = xml + "    <jar href='lib/cytoscape-render-immed.jar' />";
        xml = xml + "    <jar href='lib/cytoscape-render-stateful.jar' />";
        xml = xml + "    <jar href='lib/cytoscape-task.jar' />";
        xml = xml + "    <jar href='lib/cytoscape-util-intr.jar' />";
        xml = xml + "    <jar href='lib/ding.jar' />";
        xml = xml + "    <jar href='lib/fing.jar' />";
        xml = xml + "    <jar href='lib/freehep-base.jar' />";
        xml = xml + "    <jar href='lib/freehep-graphics2d.jar' />";
        xml = xml + "    <jar href='lib/freehep-graphicsio-gif.jar' />";
        xml = xml + "    <jar href='lib/freehep-graphicsio-pdf.jar' />";
        xml = xml + "    <jar href='lib/freehep-graphicsio-ps.jar' />";
        xml = xml + "    <jar href='lib/freehep-graphicsio-svg.jar' />";
        xml = xml + "    <jar href='lib/freehep-graphicsio-swf.jar' />";
        xml = xml + "    <jar href='lib/freehep-graphicsio.jar' />";
        xml = xml + "    <jar href='lib/giny.jar' />";
        xml = xml + "    <jar href='lib/glf.jar' />";
        xml = xml + "    <jar href='lib/jaxb-api.jar' />";
        xml = xml + "    <jar href='lib/jaxb-impl.jar' />";
        xml = xml + "    <jar href='lib/jdom.jar' />";
        xml = xml + "    <jar href='lib/jhall.jar' />";
        xml = xml + "    <jar href='lib/jnlp.jar' />";
        xml = xml + "    <jar href='lib/jsr173_1.0_api.jar' />";
        xml = xml + "    <jar href='lib/junit.jar' />";
        xml = xml + "    <jar href='lib/looks-1.1.3.jar' />";
        xml = xml + "    <jar href='lib/phoebe.jar' />";
        xml = xml + "    <jar href='lib/piccolo.jar' />";
        xml = xml + "    <jar href='lib/piccolox.jar' />";
        xml = xml + "    <jar href='lib/swing-layout-1.0.1.jar' />";
        xml = xml + "    <jar href='lib/tclib.jar' />";
        xml = xml + "    <jar href='lib/violinstrings-1.0.2.jar' />";
        xml = xml + "    <jar href='lib/wizard.jar' />";
        xml = xml + "    <jar href='lib/xercesImpl.jar' />";
        xml = xml + "    <!--These are the plugins you wish to load, edit as necessary.-->";
        xml = xml + "    <jar href='plugins/AutomaticLayout.jar' />";
        xml = xml + "    <jar href='plugins/biopax.jar' />";
        xml = xml + "    <jar href='plugins/browser.jar' />";
        xml = xml + "    <jar href='plugins/cPath.jar' />";
        xml = xml + "    <jar href='plugins/CytoscapeEditor.jar' />";
        xml = xml + "    <jar href='plugins/exesto.jar' />";
        xml = xml + "    <jar href='plugins/filter.jar' />";
        xml = xml + "    <jar href='plugins/GraphMerge.jar' />";
        xml = xml + "    <jar href='plugins/linkout.jar' />";
        xml = xml + "    <jar href='plugins/ManualLayout.jar' />";
        xml = xml + "    <jar href='plugins/psi_mi.jar' />";
        xml = xml + "    <jar href='plugins/quick_find.jar' />";
        xml = xml + "    <jar href='plugins/SBMLReader.jar' />";
        xml = xml + "    <jar href='plugins/TableImport.jar' />";
        xml = xml + "    <jar href='plugins/yeast-context.jar' />";
        xml = xml + "    <jar href='plugins/yLayouts.jar' />";
        xml = xml + "  </resources>";
        xml = xml + "  <!--This starts-up Cytoscape, specify your plugins to load, and other command line arguments.  Plugins not specified here will not be loaded.-->";
        xml = xml + "  <application-desc main-class='cytoscape.CyMain'>";
        xml = xml + "    <argument>-p</argument>";
        xml = xml + "    <argument>csplugins.layout.LayoutPlugin</argument>";
        xml = xml + "    <argument>-p</argument>";
        xml = xml + "    <argument>org.mskcc.biopax_plugin.plugin.BioPaxPlugIn</argument>";
        xml = xml + "    <argument>-p</argument>";
        xml = xml + "    <argument>browser.AttributeBrowserPlugin</argument>";
        xml = xml + "    <argument>-p</argument>";
        xml = xml + "    <argument>org.cytoscape.coreplugin.cpath.plugin.CPathPlugIn</argument>";
        xml = xml + "    <argument>-p</argument>";
        xml = xml + "    <argument>cytoscape.editor.CytoscapeEditorPlugin</argument>";
        xml = xml + "    <argument>-p</argument>";
        xml = xml + "    <argument>filter.cytoscape.CsFilter</argument>";
        xml = xml + "    <argument>-p</argument>";
        xml = xml + "    <argument>GraphMerge.GraphMerge</argument>";
        xml = xml + "    <argument>-p</argument>";
        xml = xml + "    <argument>linkout.LinkOutPlugin</argument>";
        xml = xml + "    <argument>-p</argument>";
        xml = xml + "    <argument>ManualLayout.ManualLayoutPlugin</argument>";
        xml = xml + "    <argument>-p</argument>";
        xml = xml + "    <argument>org.cytoscape.coreplugin.psi_mi.plugin.PsiMiPlugIn</argument>";
        xml = xml + "    <argument>-p</argument>";
        xml = xml + "    <argument>csplugins.quickfind.plugin.QuickFindPlugIn</argument>";
        xml = xml + "    <argument>-p</argument>";
        xml = xml + "    <argument>sbmlreader.SBMLReaderPlugin</argument>";
        xml = xml + "    <argument>-p</argument>";
        xml = xml + "    <argument>edu.ucsd.bioeng.coreplugin.tableImport.TableImportPlugin</argument>";
        xml = xml + "    <argument>-p</argument>";
        xml = xml + "    <argument>yfiles.YFilesLayoutPlugin</argument>";
        xml = xml + "    <argument>-V</argument>";
        xml = xml + "    <argument>file:///C:/cscie75/Projects/MeV/MeV_SVN/plugins/vizmap.props</argument>";
        for (int i = 0; i < files.size(); ++i) {
            xml = xml + "<argument>-N</argument>";
            xml = xml + "<argument>file:///" + files.get(i).replace("\\", "/") + "</argument>";
        }
        xml = xml + "  </application-desc>";
        xml = xml + "</jnlp>";
        return xml;
    }
}

