/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.bn;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Properties;
import org.tigr.microarray.mev.cluster.gui.impl.bn.BNConstants;
import org.tigr.microarray.mev.cluster.gui.impl.bn.Bootstrap;
import org.tigr.microarray.mev.cluster.gui.impl.bn.FixStates;
import org.tigr.microarray.mev.cluster.gui.impl.bn.NullArgumentException;
import org.tigr.microarray.mev.cluster.gui.impl.bn.Useful;
import org.tigr.microarray.mev.cluster.gui.impl.bn.WekaUtil;
import weka.core.Instances;

public class BootstrapModule {
    public static void bootstrap(String propsFileName) {
        try {
            Properties props = new Properties();
            props.load(new FileInputStream(propsFileName));
            String inArffExpressionFileName = props.getProperty("inArffExpressionFileName", null);
            Useful.checkFile(inArffExpressionFileName);
            Instances instances = WekaUtil.readInstancesArff(inArffExpressionFileName);
            BootstrapModule.bootstrap(props, instances);
        }
        catch (NullArgumentException nae) {
            System.out.println(nae);
            nae.printStackTrace();
        }
        catch (IOException ioe) {
            System.out.println(ioe);
            ioe.printStackTrace();
        }
    }

    public static void bootstrap(Properties props, Instances instances) throws NullArgumentException {
        if (props == null || instances == null) {
            throw new NullArgumentException("At least one of properties or instances is null\nproperties=" + props + "\ninstances=" + instances);
        }
        String sep = System.getProperty("file.separator");
        String path = System.getProperty("user.dir");
        path = BNConstants.getBaseFileLocation() + BNConstants.SEP + "tmp" + BNConstants.SEP;
        int numBootstrapIterations = Integer.parseInt(props.getProperty("numBootstrapIterations", "100"));
        int numBins = Integer.parseInt(props.getProperty("numBins", "3"));
        ArrayList<String> binLabels = new ArrayList<String>();
        for (int i = 0; i < numBins; ++i) {
            binLabels.add(props.getProperty("binLabel" + i, "state" + (i + 1)));
        }
        String rootOutFileName = props.getProperty("rootOutputFileName", "boot_");
        long seed = Integer.parseInt(props.getProperty("seed", "1"));
        WekaUtil.writeDataToCSVFile(instances, path + "instances.csv");
        Bootstrap.createDataSets(path + "instances.csv", rootOutFileName, numBootstrapIterations, seed);
        Instances[] bootstraps = new Instances[numBootstrapIterations];
        File f = null;
        for (int i = 0; i < numBootstrapIterations; ++i) {
            bootstraps[i] = WekaUtil.readInstancesCSV(rootOutFileName + i);
            f = new File(rootOutFileName + i);
            f.delete();
            WekaUtil.writeDataToArffFile(bootstraps[i], rootOutFileName + i);
            FixStates.fixStates(path + rootOutFileName + i, binLabels, ".arff");
        }
    }

    public static void usage() {
        System.out.println("Usage: java BootstrapModule propertiesFileName\nExample: java BootstrapModule bootstrap.props");
        System.exit(0);
    }

    public static void main(String[] argv) {
        if (argv.length != 1) {
            BootstrapModule.usage();
        }
        String propsFileName = argv[0];
        BootstrapModule.bootstrap(propsFileName);
    }
}

