/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.bn;

import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.PrintWriter;
import java.util.Random;
import java.util.Vector;

public class Bootstrap {
    public static int MAX_ITERATIONS = 500;

    public static String[][] readDataSet(String dataSetFileName) {
        String[][] dataSet = new String[MAX_ITERATIONS][MAX_ITERATIONS];
        for (int i = 0; i < MAX_ITERATIONS; ++i) {
            for (int j = 0; j < MAX_ITERATIONS; ++j) {
                dataSet[i][j] = null;
            }
        }
        int trueSizeX = 0;
        try {
            FileReader fr = new FileReader(dataSetFileName);
            LineNumberReader lnr = new LineNumberReader(fr);
            String s = null;
            int count = 0;
            while ((s = lnr.readLine()) != null) {
                s = s.trim();
                dataSet[count] = s.split(",");
                trueSizeX = dataSet[count].length;
                ++count;
            }
            String[][] result = new String[count][trueSizeX];
            for (int i = 0; i < count; ++i) {
                for (int j = 0; j < trueSizeX; ++j) {
                    result[i][j] = dataSet[i][j];
                }
            }
            return result;
        }
        catch (IOException ioe) {
            System.out.println(ioe);
            return null;
        }
    }

    public static void printDataSet(PrintWriter pw, String[][] dataSet) {
        for (int i = 0; i < dataSet.length; ++i) {
            for (int j = 0; j < dataSet[i].length - 1; ++j) {
                pw.print(dataSet[i][j] + ",");
            }
            pw.print(dataSet[i][dataSet[i].length - 1]);
            pw.println();
        }
    }

    public static void createDataSets(String origDataSetFileName, String rootOutFileName, int numIterations, long seed) {
        try {
            int i;
            String[][] origDataSet = Bootstrap.readDataSet(origDataSetFileName);
            String[][] dataSet_i = null;
            FileOutputStream fos = null;
            PrintWriter pw = null;
            Random rand = new Random(seed);
            Vector<String> classes = new Vector<String>();
            for (int i2 = 1; i2 < origDataSet.length; ++i2) {
                if (classes.contains(origDataSet[i2][0])) continue;
                classes.add(origDataSet[i2][0]);
            }
            int[] classSizes = new int[classes.size()];
            for (i = 0; i < classSizes.length; ++i) {
                classSizes[i] = 0;
            }
            for (i = 1; i < origDataSet.length; ++i) {
                int index = classes.indexOf(origDataSet[i][0]);
                if (index == -1) {
                    System.out.println("Class Mismatch - createDataSets()");
                    continue;
                }
                classSizes[index] = classSizes[index] + 1;
            }
            for (i = 0; i < numIterations; ++i) {
                fos = new FileOutputStream(rootOutFileName + i);
                pw = new PrintWriter(fos, true);
                dataSet_i = Bootstrap.reSampleDataSet(rand, origDataSet, classes, classSizes);
                Bootstrap.printDataSet(pw, dataSet_i);
                fos.close();
                pw.close();
            }
        }
        catch (IOException ioe) {
            System.out.println(ioe);
        }
    }

    public static String[][] reSampleDataSet(Random rand, String[][] origDataSet, Vector classes, int[] clsSizes) {
        String[][] dataSet = new String[origDataSet.length][origDataSet[0].length];
        int randomNumber = 0;
        for (int k = 0; k < dataSet[0].length; ++k) {
            dataSet[0][k] = origDataSet[0][k];
        }
        if (clsSizes.length == 1) {
            for (int i = 1; i < dataSet.length; ++i) {
                randomNumber = rand.nextInt(origDataSet.length - 1);
                ++randomNumber;
                for (int j = 0; j < dataSet[1].length; ++j) {
                    dataSet[i][j] = origDataSet[randomNumber][j];
                }
            }
        } else {
            int dataSize = 1;
            int[] classSizes = new int[clsSizes.length];
            for (int i = 0; i < clsSizes.length; ++i) {
                classSizes[i] = clsSizes[i];
            }
            while (dataSize < dataSet.length) {
                int ind;
                randomNumber = rand.nextInt(origDataSet.length - 1);
                if ((ind = classes.indexOf(origDataSet[++randomNumber][0])) == -1) {
                    System.out.println(origDataSet[randomNumber][0] + " not found");
                }
                if (classSizes[ind] == 0) continue;
                for (int j = 0; j < dataSet[1].length; ++j) {
                    dataSet[dataSize][j] = origDataSet[randomNumber][j];
                }
                ++dataSize;
                classSizes[ind] = classSizes[ind] - 1;
            }
        }
        return dataSet;
    }

    public static void usage() {
        System.out.println("Usage: java Bootstrap dataCSVFileName rootOutFileName numBootstrapIterations seed\nExample: java Bootstrap data.csv bootstrap/boot 100 1");
        System.exit(0);
    }

    public static void main(String[] argv) {
        if (argv.length != 4) {
            Bootstrap.usage();
        }
        String origDataSetFileName = argv[0];
        String rootOutFileName = argv[1];
        int numBootstrapIterations = Integer.parseInt(argv[2]);
        long seed = Integer.parseInt(argv[3]);
        Bootstrap.createDataSets(origDataSetFileName, rootOutFileName, numBootstrapIterations, seed);
    }
}

